<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Approval_atasan extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/pengaturan/Approval_atasan_m');
    }

    public function list_data(){
        $id_group_m = $this->input->get('id_group_m');

        $list = $this->Approval_atasan_m->get_datatables($id_group_m);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_karyawan . "<br><b>" . $field->nik_karyawan . "</b>";
            $row[] = $field->nama_atasan . "<br><b>" . $field->nik_atasan . "</b>";

            if($this->fungsi->cek_adm_satu_grup() == false){
                $row[] = $field->nama_group . "<br><b>" . $field->kode_group . "</b>";
            }
            
            $row[] = $this->_flag_badge($field->approval);
            
            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_karyawan) . '" class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_karyawan) . '" class="btn_delete fa fa-trash" onclick="form_delete(this)"></i></a>';
            $row[] = $btn_edit. '&nbsp&nbsp'. $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Approval_atasan_m->count_all($id_group_m),
            "recordsFiltered" => $this->Approval_atasan_m->count_filtered($id_group_m),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Approval_atasan_m->getDataById($id);
		}

		$this->load->view('sales_activity/pengaturan/approval_atasan/form',$data);
    }

    public function save(){
        $id = $this->input->post('id');

        $data = array( 
            'id_karyawan' => $this->input->post('id_karyawan'),
            'approval'    => $this->input->post('approval'),
            'id_atasan'   => $this->input->post('id_atasan'),
            'id_group_m'  => $this->input->post('id_group_m'),
            'id_company'  => $this->id_company,
        );

        $this->Approval_atasan_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Approval_atasan_m->delete($id);
    }

    public function cek_maximal_sales(){
        $max_sales         = $this->Approval_atasan_m->get_max_sales();
        $active_sales      = $this->Approval_atasan_m->get_active_sales();
        $sales_other_group = $this->Approval_atasan_m->get_sales_other_group();

        $result = [];
        if(($active_sales + $sales_other_group) < $max_sales){
            $result = [ 
                "tambah_sales"      => true,
                "max_sales"         => $max_sales,
                "active_sales"      => $active_sales,
                "sales_other_group" => $sales_other_group
            ];
        }else{
            $result = [ 
                "tambah_sales"      => false,
                "max_sales"         => $max_sales,
                "active_sales"      => $active_sales,
                "sales_other_group" => $sales_other_group
            ];
        }
        
        echo json_encode($result);
    }

    private function _flag_badge($flag = "0"){
        if($flag == "1"){
            $badge = '<div class="badge badge-success">' . 'Ya' . '</div>';
        }else{
            $badge = '<div class="badge badge-danger">' . 'Tidak' . '</div>';
        }

        return $badge;
    }

    public function dropdown_atasan($id_group = "")
    {
        $search = $this->input->get("q");

        // Check
        $c_kary_admin    = $this->Approval_atasan_m->check_karyawan_admin($id_group);
        $c_kary_approver = $this->Approval_atasan_m->check_karyawan_approver($id_group);

        $this->db->select('data_karyawan.id_karyawan, data_karyawan.nik, data_karyawan.nama_lengkap');
        $this->db->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan.id_jabatan');
        $this->db->where('data_karyawan.id_company', $this->id_company);
        $this->db->where_in('data_karyawan.status', ['1', '2', '3', '4']);
        $this->db->where_not_in('master_jabatan.level_user', ['1', '6']);

        if(count($c_kary_admin) > 0 || count($c_kary_approver) > 0){
            $this->db->where_not_in('data_karyawan.id_karyawan', array_merge($c_kary_admin, $c_kary_approver));
        }

        if(!empty($search)){
            $this->db->group_start();
            $this->db->like('data_karyawan.nama_lengkap', $search);
            $this->db->or_like('data_karyawan.nik', $search);
            $this->db->group_end();
            $this->db->order_by('data_karyawan.nama_lengkap', 'ASC');
        }

        $result = $this->db->get('data_karyawan')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id' => $rows->id_karyawan, 'text' => $rows->nik . " - " . $rows->nama_lengkap];
        }
        echo json_encode($json);
    }
}