<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laporan_aktivitas extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Laporan_aktivitas_m');
    }

	public function index(){
		$data['judul'] = $this->lang->line('menu_laporan_aktivitas');
		$data['aktif'] = 'aktivitas';
        $data['tgl_mulai'] = "01-".date("m-Y");
        $data['tgl_selesai'] = date("d-m-Y");
        $data['level_user'] = $this->level_user;
		$data['multi_cabang'] = $this->multi_cabang;
		$data['multi_departemen'] = $this->multi_departemen;
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('laporan_aktivitas/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

    public function data_tabel($tgl_mulai=0, $tgl_selesai=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0){
        $this->load->model('Pengaturan_shift_m');
		$data['tgl_mulai']         = $tgl_mulai;
		$data['tgl_selesai']       = $tgl_selesai;
		$data['id_karyawan']       = $id_karyawan;
		$data['id_cabang']         = $id_cabang;
		$data['id_departemen']     = $id_departemen;
		$data['m_jam_kerja_libur'] = json_encode(["6", "7"]);
		$data['m_libur_nasional']  = json_encode($this->Pengaturan_shift_m->m_libur_nasional(Y_m_d($tgl_mulai), Y_m_d($tgl_selesai)));
        $this->load->view('laporan_aktivitas/data_tabel', $data, false);
    }

    public function data_maps($tgl_mulai=0, $tgl_selesai=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0){
        $data['tgl_mulai']      = $tgl_mulai;
        $data['tgl_selesai']    = $tgl_selesai;
        $data['id_karyawan']    = $id_karyawan;
        $data['id_cabang']      = $id_cabang;
        $data['id_departemen']  = $id_departemen;
        $this->load->view('laporan_aktivitas/data_maps', $data, false);
    }

    public function lokasi_aktivitas($tgl_mulai=0, $tgl_selesai=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0){
        $lokasi_aktivitas = $this->Laporan_aktivitas_m->lokasiAktivitas($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen);
        $marker = [];
        $no = 0;
        foreach($lokasi_aktivitas as $row){
            $no++;

            $marker[] = array("index" => $no,
                                "lat" => $row->latitude,
                                "long" => $row->longitude,
                                "title" => $row->nama_karyawan.", ".date_format(date_create($row->waktu),'d-m-Y H:i:s')." ".$this->fungsi->_gmt($row->gmt).", ".$row->keterangan);
        }

        echo json_encode($marker);
    }

	public function list_data(){

        $tgl_mulai     = $this->input->get('tgl_mulai');
        $tgl_selesai   = $this->input->get('tgl_selesai');
        $id_karyawan   = $this->input->get('id_karyawan');
        $id_cabang     = $this->input->get('id_cabang');
        $id_departemen = $this->input->get('id_departemen');

        $tgl_mulai = date_format(date_create($tgl_mulai),"Y-m-d");
        $tgl_selesai = date_format(date_create($tgl_selesai),"Y-m-d");

		$list = $this->Laporan_aktivitas_m->get_datatables($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen);
		$data = array();
		$no = $_GET['start'];

		foreach ($list as $field) {
			$no++;
			$row = array();

            $tgl_aktivitas = indo_date($field->waktu, "l").'<br>'.date_format(date_create($field->waktu),"d-m-Y");
            $jam_aktivitas = date_format(date_create($field->waktu),"H:i:s")." ".$this->fungsi->_gmt($field->gmt);

            $foto = $this->config->item('base_image') . 'image?_t=photo&_d=' . $field->image;

			$row[] = $no;
            $row[] = $tgl_aktivitas."<br><span class='font-size-xsmall font-weight-bold'>".$jam_aktivitas."</span>";
            $row[] = $field->nama_lengkap."<br><span class='font-size-xsmall font-weight-bold'>".$field->nik."</span>";
            $row[] = '<a href="javascript:;" id="'.md5($field->id_aktivitas).'" class="btn_detail">'.$field->latitude.", ".$field->longitude.'</a>';
			$row[] = $field->keterangan;
            $row[] = '<a href="'.$foto.'" data-lightbox="selesai-'.$no.'"><img src="'.$foto.'" width="100px" height="100px"></a>';

            if ($this->level_user == '1') {
                $row[] = '<a href="javascript:;" id="'.md5($field->id_aktivitas).'" class="btn_detail" title="DETAIL"><i class="fa fa-info-circle text-primary"></i></a>&nbsp;
                    <a href="#" class="text-danger" title="DELETE">
                            <i id="'.md5($field->id_aktivitas).'" class="btn_delete fa fa-trash"></i>
                    </a>';
            }else{
                $row[] = '<a href="javascript:;" id="'.md5($field->id_aktivitas).'" class="btn_detail" title="DETAIL"><i class="fa fa-info-circle text-primary"></i></a>';
            }

			$data[] = $row;
		}

			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Laporan_aktivitas_m->count_all($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen),
							"recordsFiltered" => $this->Laporan_aktivitas_m->count_filtered($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen),
							"data"            => $data);

        $output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

    public function rekap_aktifitas(){

        $tgl_mulai     = $this->input->get('tgl_mulai');
        $tgl_selesai   = $this->input->get('tgl_selesai');
        $id_karyawan   = $this->input->get('id_karyawan');
        $id_cabang     = $this->input->get('id_cabang');
        $id_departemen = $this->input->get('id_departemen');

        $tgl_mulai = date_format(date_create($tgl_mulai),"Y-m-d");
        $tgl_selesai = date_format(date_create($tgl_selesai),"Y-m-d");

		$list = $this->Laporan_aktivitas_m->get_datatables($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen, $rekap=true);
		$data = array();
		$no = $_GET['start'];

		foreach ($list as $field) {
			$no++;
			$row = array();

			$row[] = $no;
            $row[] = $field->nama_lengkap."<br><span class='font-size-xsmall font-weight-bold'>".$field->nik."</span>";
            $row[] = $field->kode_cabang." - ".$field->nama_cabang;
            $row[] = $field->kode_departemen." - ".$field->nama_departemen;
			$row[] = $field->jml_aktivitas;

			$data[] = $row;
		}

			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Laporan_aktivitas_m->count_all($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen, $rekap=true),
							"recordsFiltered" => $this->Laporan_aktivitas_m->count_filtered($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen, $rekap=true),
							"data"            => $data);

        $output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function detail($id){
        $data['judul'] = 'Detail';
        $data['aktif'] = 'aktivitas';

        $where = array('id_company' => $this->id_company);
        $query = $this->db->select('id_company, nama')->get_where('master_company', $where)->row();
        $data['company'] = $query->nama;
        $data['id_company'] = $query->id_company;

        $coords = $this->db->select("data_aktivitas.waktu,
                                    data_aktivitas.latitude,
                                    data_aktivitas.longitude,
                                    data_aktivitas.keterangan,
                                    data_aktivitas.lokasi,
                                    data_aktivitas.image,
                                    data_karyawan.nik,
                                    data_karyawan.nama_lengkap,
                                    master_jabatan.nama AS nama_jabatan,
                                    master_cabang.nama AS nama_cabang,
                                    master_departemen.nama AS nama_departemen")
                            ->from("data_aktivitas")
                            ->join("data_karyawan", "data_karyawan.id_karyawan = data_aktivitas.id_karyawan", "left")
                            ->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan")
                            ->join("master_cabang", "master_cabang.id_cabang = data_karyawan.id_cabang")
                            ->join("master_departemen", "master_departemen.id_departemen = data_karyawan.id_departemen","left")
                            ->where("md5(id_aktivitas)", $id)
                            ->get()
                            ->row();
        $data['nama_karyawan'] = $coords->nik." - ".$coords->nama_lengkap;
        $data['jabatan'] = $coords->nama_jabatan.", ".$coords->nama_cabang.", ".$coords->nama_departemen;

        $data['waktu'] = date_format(date_create($coords->waktu),"d-m-Y H:i:s");
        $data['keterangan'] = $coords->keterangan;
        $data['foto_aktivitas'] = $this->config->item('base_image').'image?_t=image&_d='.$coords->image;

        $data['lat'] = $coords->latitude;
        $data['long'] = $coords->longitude;
        $data['title'] = $coords->lokasi;
        $data['index'] = 1;
        echo json_encode($data);
    }


    public function download_excel($tgl_mulai=0, $tgl_selesai=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0){
        $this->load->helper('excel');

        $data["tgl_mulai"] = $tgl_mulai;
        $data["tgl_selesai"] = $tgl_selesai;

        if($id_karyawan == "0" && $id_cabang == "0" && $id_departemen == "0"){
            $filename = $this->lang->line('laporan_aktivitas_for_download'). " ". $this->lang->line('semua_cabang');
        }else{
            $filename = $this->lang->line('laporan_aktivitas_for_download');
        }

        if($id_karyawan != "0"){
            $nama_karyawan = $this->db->select("nama_lengkap")
                                    ->from("data_karyawan")
                                    ->where("id_karyawan",$id_karyawan)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama_lengkap");
            $filename .= " ".$nama_karyawan;
        }

        if($id_cabang != "0"){
            $nama_cabang = $this->db->select("nama")
                                    ->from("master_cabang")
                                    ->where("id_cabang",$id_cabang)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama");

            $filename .= " " .$this->lang->line('cabang_for_download'). " ".$nama_cabang;
        }

        if($id_departemen != "0"){
            $nama_departemen = $this->db->select("nama")
                                    ->from("master_departemen")
                                    ->where("id_departemen",$id_departemen)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama");

            $filename .= " " .$this->lang->line('departemen_for_download'). " ".$nama_departemen;
        }
        $data['is_excel'] = true;
        $data["title"] = strtoupper($filename);
        $data['tanggal_mulai'] 		= $tgl_mulai;
		$data['tanggal_selesai'] 	= $tgl_selesai;

        $tgl_mulai      = date('Y-m-d', strtotime($tgl_mulai));
		$tgl_selesai   = date('Y-m-d', strtotime($tgl_selesai));
        $data["data"] = $this->Laporan_aktivitas_m->download($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen);

        $sb_view = $this->load->view('laporan_aktivitas/download_excel', $data, true);

        // echo $sb_view;
        // die();
        $parameter = [
            'data'          => $data['data'],
            'periode_awal'  => $tgl_mulai,
            'periode_akhir' => $tgl_selesai,
            'id_cabang'     => $id_cabang,
            'awal'          => 'A',
            'akhir'         => 'I',
            'header'        => 8,
            'jenis'         => 'laporan_aktivitas'
        ];

        $row = baris_highlight_libur($parameter);
        
        $c_length = 8;
        $param = [
            'download' => true,
            'cLength'    => $c_length,
            'file_name'    => strtoupper(str_replace("/","_",$filename)),
            'paper_size'	=> 'A4',
            'font-size'		=> 9,
            'pagebreak'		=> true,
            'page_margin'	=> ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'	=> 'potrait',
            'header'    => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],

                '4' => ['weight' => 'bold'],
                '5' => ['weight' => 'bold'],
                '6' => ['weight' => 'bold'],
            ],
            'thead'        => ['7'],
            'tbody'        => [
                'start' => '7',
                'height'	=> 13,
                'jarak_footer'	=> 2,
                'wrap' => ['A','B','C', 'D','E','F','G','H','I'],
                'column' => [
                    'A'    => ['width' => 3, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 21, 'align' => 'center', 'valign' => 'middle'],
                    'C'    => ['width' => 20, 'align' => 'left', 'valign' => 'middle'],
                    'D'    => ['width' => 15, 'align' => 'left', 'valign' => 'middle', 'format'=>'text'],
                    'E'    => ['width' => 15, 'align' => 'left', 'valign' => 'middle', 'format'=>'text'],
                    'F'    => ['width' => 7,'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 11,'align' => 'left', 'valign' => 'top'],
                    'H'    => ['width' => 11,'align' => 'left', 'valign' => 'top'],
                    'I'    => ['width' => 11,'align' => 'left', 'valign' => 'top'],
                ],
                'row' => $row
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
    }

    public function delete(){
        $id = $this->input->post("id_aktivitas");
        $this->Laporan_aktivitas_m->delete($id);
    }
}
