<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>Dashboard Support</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    
    <!-- Select2 -->
    <link href="<?= base_url('assets/plugins/select2/css/select2.min.css')?>" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2-bootstrap-theme/0.1.0-beta.10/select2-bootstrap.min.css">
    
    <!-- Custom styles for this template -->
    <style>
    body {
	  font-size: .875rem;
	}

	.feather {
	  width: 16px;
	  height: 16px;
	  vertical-align: text-bottom;
	}

	/*
	 * Sidebar
	 */

	.sidebar {
	  position: fixed;
	  top: 0;
	  bottom: 0;
	  left: 0;
	  z-index: 100; /* Behind the navbar */
	  padding: 0;
	  box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
	}

	.sidebar-sticky {
	  position: -webkit-sticky;
	  position: sticky;
	  top: 48px; /* Height of navbar */
	  height: calc(100vh - 48px);
	  padding-top: .5rem;
	  overflow-x: hidden;
	  overflow-y: auto; /* Scrollable contents if viewport is shorter than content. */
	}

	.sidebar .nav-link {
	  font-weight: 500;
	  color: #333;
	}

	.sidebar .nav-link .feather {
	  margin-right: 4px;
	  color: #999;
	}

	.sidebar .nav-link.active {
	  color: #007bff;
	}

	.sidebar .nav-link:hover .feather,
	.sidebar .nav-link.active .feather {
	  color: inherit;
	}

	.sidebar-heading {
	  font-size: .75rem;
	  text-transform: uppercase;
	}

	/*
	 * Navbar
	 */

	.navbar-brand {
	  padding-top: .75rem;
	  padding-bottom: .75rem;
	  font-size: 1rem;
	  background-color: rgba(0, 0, 0, .25);
	  box-shadow: inset -1px 0 0 rgba(0, 0, 0, .25);
	}

	.navbar .form-control {
	  padding: .75rem 1rem;
	  border-width: 0;
	  border-radius: 0;
	}

	.form-control-dark {
	  color: #fff;
	  background-color: rgba(255, 255, 255, .1);
	  border-color: rgba(255, 255, 255, .1);
	}

	.form-control-dark:focus {
	  border-color: transparent;
	  box-shadow: 0 0 0 3px rgba(255, 255, 255, .25);
	}

	/*
	 * Utilities
	 */

	.border-top { border-top: 1px solid #e5e5e5; }
	.border-bottom { border-bottom: 1px solid #e5e5e5; }

    </style>
  </head>

  <body>
    <nav class="navbar navbar-dark sticky-top bg-dark flex-md-nowrap p-0">
      <a class="navbar-brand col-sm-3 col-md-2 mr-0" href="#">Support</a>
      <ul class="navbar-nav px-3">
        <li class="nav-item text-nowrap">
          <a class="nav-link" href="<?= site_url('support/logout') ?>">Sign out</a>
        </li>
      </ul>
    </nav>

    <div class="container-fluid">
      <div class="row">
        <nav class="col-md-2 d-none d-md-block bg-light sidebar">
          <div class="sidebar-sticky">
            <ul class="nav flex-column">
              <li class="nav-item">
                <a class="nav-link active" href="#">
                  <span data-feather="home"></span>
                  Create User Admin <span class="sr-only">(current)</span>
                </a>
              </li>
            </ul>
          </div>
        </nav>

        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 pt-3 px-4">
          <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
            <h1 class="h2">Create User Admin</h1>
          </div>
          
          <div class="container">  
			  <div class="alert alert-danger alert-dismissible fade show" role="alert" style="display:none">
				  <span id="message"></span>
				  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				  </button>
				</div>
			<form>
			  <div class="row mb-3">
				  <div class="col-6">
					<select id="id_company" name="id_company" class="select2" style="width: 100%;"></select>
				  </div>
			  </div>
			  <div class="row">
				  <div class="col-sm-6">
					<div class="card">
					  <div class="card-body">
						<h5 class="card-title">Detail Company</h5>
						<table class="table">
						  <tbody>
							<tr>
							  <th scope="row">Id</th>
							  <td id="detail_id_company">-</td>
							</tr>
							<tr>
							  <th scope="row">Nama</th>
							  <td id="nama_company">-</td>
							</tr>
							<tr>
							  <th scope="row">Deskripsi</th>
							  <td id="desc_company">-</td>
							</tr>
							<tr>
							  <th scope="row">Alamat</th>
							  <td id="alamat_company">-</td>
							</tr>
							<tr>
							  <th scope="row">Paket</th>
							  <td id="paket">-</td>
							</tr>
						  </tbody>
						</table>
					  </div>
					</div>
				  </div>
				  <div class="col-sm-6">
					<div class="card">
					  <div class="card-body">
						<h5 class="card-title">Detail Customer</h5>
						<table class="table">
						  <tbody>
							<tr>
							  <th scope="row">Nama</th>
							  <td id="nama_customer">-</td>
							</tr>
							<tr>
							  <th scope="row">Nomor Telepon</th>
							  <td id="no_telp">-</td>
							</tr>
							<tr>
							  <th scope="row">Email</th>
							  <td id="email">-</td>
							</tr>
							<tr>
							  <th scope="row">Alamat</th>
							  <td id="alamat_customer">-</td>
							</tr>
							<tr>
							  <th scope="row">Provinsi</th>
							  <td id="provinsi">-</td>
							</tr>
							<tr>
							  <th scope="row">Kota</th>
							  <td id="kota">-</td>
							</tr>
						  </tbody>
						</table>
					  </div>
					</div>
				  </div>
			  </div>
			  <a id="create" class="btn btn-primary" href="#">Create User Admin</a>
			</form>
          </div>
        </main>
      </div>
    </div>

    <!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
	<!-- Select2 -->
    <script src="<?php echo base_url('assets/plugins/select2/js/select2.full.min.js') ?>"></script>
    <script>
    $(function() {
		$('#id_company').select2({
			theme: 'bootstrap',
            placeholder: 'Nama Company/Nama Customer/Nomor Telepon/Email',
            allowClear: true,
            ajax: {
                url: '<?= site_url("support/select2_company")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return{
                        results: data
                    };
                },
                cache: false
            },
			minLength: 3
        });
        
        $('#id_company').change(function() {
			$.get('<?= site_url("support/detail_company") ?>', {id_company : $(this).val()}, function(data) {
				$('#detail_id_company').html(data.id_company);
				$('#nama_company').html(data.nama_company);
				$('#desc_company').html(data.desc_company);
				$('#alamat_company').html(data.alamat_company);
				$('#paket').html(data.paket);
				$('#nama_customer').html(data.nama_customer);
				$('#no_telp').html(data.no_telp);
				$('#email').html(data.email);
				$('#alamat_customer').html(data.alamat_customer);
				$('#provinsi').html(data.provinsi);
				$('#kota').html(data.kota);
			}, 'json');
		});
		
		$('#create').click(function() {
			var danger_class = $('.alert').hasClass('alert-danger');
			var success_class = $('.alert').hasClass('alert-success');
			var id_company = $('#id_company').val();
			
			if(id_company == null) {
				if(success_class == true) {
					$('.alert').removeClass('alert-success').addClass('alert-danger');
				}
				$('.alert').show();
				$('#message').html('Company belum dipilih');
			} else {
				$.get('<?= site_url("support/save"); ?>', 
					{id_company : $('#id_company').val()}, 
					function(data) {
						if(data.status == true) {
							if(danger_class == true) {
								$('.alert').removeClass('alert-danger').addClass('alert-success');
							}
						} else {
							if(success_class == true) {
								$('.alert').removeClass('alert-success').addClass('alert-danger');
							}
						}
						
						$('.alert').show();
						$('#message').html(data.message);
					}, 'json');
			}
		});
	});
    </script>
  </body>
</html>
