<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id" class="form-control" value="<?= ((isset($data)) ? md5($data->id_karyawan) : '') ?>">

    <?php
        if(isset($data)){
            $disabled = 'disabled';
        }else{
            $disabled = '';
        }
    ?>
    <div class="form-group">
        <label><?= $this->lang->line('nama_karyawan'); ?> <span class="text-danger">*</span></label>
        <select class="form-control" id="id_karyawan" style="width: 100%" <?= $disabled ?>>
            <?php echo '<option value="' . $data->id_karyawan . '" selected>' . $data->nik_karyawan . ' - ' . $data->nama_karyawan . '</option>' ?>;
        </select>
    </div>

    <div class="form-group mt-1">
        <label><?= $this->lang->line('perlu_approval') ?>  <span class="text-danger">*</span></label>
        <div class="row custom-radio-blue">
            <div class="col-md-6">
                <section class="light">
                    <label id="label">
                        <input type="radio" name="approval" value="0" <?= (empty($data->approval) ? "checked" : "") ?> onclick="onclick_approval(this)">
                        <span class="design"></span>
                        <span><?= $this->lang->line('tidak') ?></span>
                    </label>
                </section>
            </div>
            <div class="col-md-6">
                <section class="light">
                    <label id="label">
                        <input type="radio" name="approval" value="1" <?= ((isset($data) && $data->approval == "1") ? "checked" : "") ?> onclick="onclick_approval(this)">
                        <span class="design"></span>
                        <span><?= $this->lang->line('ya') ?></span>
                    </label>
                </section>
            </div>
        </div>
    </div>
    
    <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
        <div class="form-group">
            <label><?= $this->lang->line('area_group_product'); ?> <span class="text-danger">*</span></label>
            <select class="form-control" id="id_group_m" style="width: 100%" onchange="onchange_dropdown_group()">
                <?php echo '<option value="' . $data->id_group_m . '" selected>' . $data->kode_group . ' - ' . $data->nama_group . '</option>' ?>;
            </select>
        </div>
    <?php endif; ?>

    <?php
        if($data->approval == "1"){
            $hidden = '';
        }else{
            $hidden = 'style="display:none"';
        }
    ?>
    <div id="div_dropdown_atasan" class="form-group mt-1" <?= $hidden ?> >
        <label><?= $this->lang->line('nama_atasan'); ?>  <span class="text-danger">*</span></label>
        <select class="form-control" id="id_atasan" style="width: 100%">
            <?php echo '<option value="' . $data->id_atasan . '" selected>' . $data->nik_atasan . ' - ' . $data->nama_atasan . '</option>' ?>;
        </select>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none" onclick="new_input(this)"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button class="btn_save ladda-button" data-style="expand-left" onclick="save(this)"></button>
        </div>
    </div><!-- ./row -->
</div>

<script>
    $(document).ready(function() {
        dropdown_karyawan();
        dropdown_atasan();
        dropdown_group();
    });

    function onclick_approval(e){
        var value = $(e).val();
        if(value == 1){
            $('#form_input #div_dropdown_atasan').show();
        }else{
            $('#form_input #div_dropdown_atasan').hide();
            $("#form_input #id_atasan").select2("val", "0");
        }
    }

    function dropdown_karyawan(){
        $("#form_input #id_karyawan").select2({
            placeholder: "<?= $this->lang->line('pilih_karyawan'); ?>",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan.aktif.sales.activity") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function dropdown_group(){
        $("#form_input #id_group_m").select2({
            placeholder: "Pilih Group/Area",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.master.dropdown.group.area") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_dropdown_group(){
        $("#id_atasan").val('').trigger('change');
        dropdown_atasan();
    }

    function dropdown_atasan(){
        $("#id_atasan").select2({
            placeholder: "<?= $this->lang->line('pilih_atasan'); ?>",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.pengaturan.approval.atasan.dropdown.atasan") ?>' + '/' + $("#form_input #id_group_m").val(),
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
</script>
