<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"><?= $title ?></h3>
</div>
<div id="form_input" class="card-body">
    <div class="table-responsive">
        <table id="list_data" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center" rowspan="2">NO</th>
                    <th class="text-left text-uppercase" rowspan="2"><?= $this->lang->line('nama_karyawan') ?></th>
                    <th class="text-center text-uppercase" rowspan="2"><?= $this->lang->line('cabang') ?><br><?= $this->lang->line('departemen') ?></th>
                    <th class="text-center text-uppercase" colspan="2">Absensi <?= $this->lang->line('masuk') ?></th>
                    <th class="text-center text-uppercase" colspan="2">Absensi <?= $this->lang->line('pulang') ?></th>
                </tr>
            <tr>
                <!-- <th class="text-center text-uppercase"><?= $this->lang->line('departemen') ?></th> -->
                <th class="text-left text-uppercase"><?= $this->lang->line('foto') ?></th>
                <th class="text-center text-uppercase">Informasi</th>
                <th class="text-left text-uppercase"><?= $this->lang->line('foto') ?></th>
                <th class="text-center text-uppercase">Informasi</th>
            </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">
    $(function() {

        list_data = $('#list_data').DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': false,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else : ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {

                "url": "<?= $url ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(1)', nRow).css({
                    'text-align': 'left',
                    'width': '200px'
                });
                $('td:eq(2)', nRow).css({
                    'text-align': 'center',
                    'width': '200px'
                });
                $('td:eq(3)', nRow).css({
                    'text-align': 'left',
                    'width': '100px'
                });
                $('td:eq(4)', nRow).css({
                    'text-align': 'center',
                });
                $('td:eq(5)', nRow).css({
                    'text-align': 'left',
                    'width': '100px'
                });
                $('td:eq(6)', nRow).css({
                    'text-align': 'center'
                });
            }

        });
    });
</script>
