<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Kanban_m extends CI_Model
{
    /**
     * get data list kanban
     * dapat filter berdasarkan tahun dan bulan / id_pipeline_main
     *
     * @param string $tahun
     * @param string $bulan
     * @param string $id_pipeline_main
     * @param boolean $exclude_last_record =>
     * jika false, maka data log terakhir yang ditampilkan
     * jika true, maka data log ke-2 dari terakhir yang ditampilkan
     * @return void
     */
    public function get_data_list_kanban($tahun = '', $bulan = '', $group, $pelanggan, $sales, $id_pipeline_main = '', $exclude_last_record = false): array
    {
        if ($id_pipeline_main) {
            $this->db->where('main.id_pipeline_main', $id_pipeline_main);
        } else {
            if ($sales !== 'all') {
                $this->db->where('main.id_company', $this->id_company);
                $this->db->where('main.id_karyawan', $sales);
            } else {
                if ($this->is_sales_admin === false && $this->level_user !== '1') {
                    if ($this->is_sales_atasan === true) {
                        $get_bawahan = $this->get_data_bawahan($this->id_karyawan);
                        $list = array_column($get_bawahan, 'id_karyawan');
                        if ($this->is_sales === true) {
                            $list[] = $this->id_karyawan;
                        }
                        $this->db->where('main.id_company', $this->id_company);
                        $this->db->where_in('main.id_karyawan', $list);
                    } else {
                        $this->db->where('main.id_company', $this->id_company);
                        $this->db->where('main.id_karyawan', $this->id_karyawan);
                    }
                }
            }
            $this->db->where('main.tahun = "' . $tahun . '"');
            $this->db->where('main.bulan = "' . $bulan . '"');
            if ($group !== 'all') {
                $this->db->group_start()
                    ->where('main.id_group_m', $group)
                    ->or_where('main.id_group_m', '')
                    ->group_end();
            } else {
                if (!in_array($this->sales_admin_group, ["all", ""])) {
                    $group_ids = explode(',', $this->sales_admin_group);
                    $this->db->group_start()
                        ->where_in('main.id_group_m', $group_ids)
                        ->or_where('main.id_group_m', '')
                        ->group_end();
                }
            }
            if ($pelanggan !== 'all') {
                $this->db->where('main.id_pelanggan', $pelanggan);
            }
        }
        $list_main = $this->db->select('
                main.id_pipeline_main,
                main.title,
                main.id_karyawan,
                main.tahun,
                main.bulan,
                main.id_tahapan_m,
                main.id_pindah_bulan,
                main.id_pelanggan,
                main.nama_lead_source,
                main.status,
                main.user_input,
                main.tgl_update,
                main.tgl_input,
                group.id_group_m as id_group,
                group.kode as kode_group,
                group.nama as nama_group,
                IF(pelanggan.id_pelanggan IS NOT NULL, pelanggan.nama_perusahaan, "") as nama_perusahaan,
                pelanggan.alamat,
                j_perusahaan.nama as nama_jenis_perusahaan,
                main.pic_nama,
                main.pic_email,
                main.pic_telp,
                prov.nama as provinsi,
                kota.nama as kota,
                kec.nama as kecamatan,
                kel.nama as kelurahan,
                sales.nama_lengkap as sales_nama,
                sales.nik as sales_nik,
                SUM(IF(id_pipeline_layanan IS NOT NULL, 1, 0)) AS layanan,
                SUM(IF(id_pipeline_layanan IS NOT NULL, harga_total, 0)) AS harga
            ')
            ->from('sales_pipeline_main main')
            ->join('sales_group_m group', 'group.id_group_m = main.id_group_m', 'left')
            ->join('data_karyawan sales', 'sales.id_karyawan = main.id_karyawan', 'left')
            ->join('sales_pelanggan pelanggan', 'pelanggan.id_pelanggan = main.id_pelanggan', 'left')
            ->join('sales_jenis_perusahaan_m j_perusahaan', 'j_perusahaan.id_jenis_perusahaan_m = pelanggan.id_jenis_perusahaan_m', 'left')
            ->join('master_provinsi prov', 'prov.id_prov = pelanggan.id_provinsi')
            ->join('master_kota kota', 'kota.id_kota = pelanggan.id_kota')
            ->join('master_kecamatan kec', 'kec.id_kecamatan = pelanggan.id_kecamatan', 'left')
            ->join('master_kelurahan kel', 'kel.id_kelurahan = pelanggan.id_kelurahan', 'left')
            ->join('sales_pipeline_layanan layanan', 'layanan.id_pipeline_main = main.id_pipeline_main', 'left')
            ->where('main.status != "tolak"')
            ->order_by('main.tgl_update', 'desc')
            ->group_by('main.id_pipeline_main')
            ->get();

        $data_main = array_column($list_main->result_array(), 'id_pipeline_main');
        
        $data = [];
        if ($list_main->num_rows() > 0) {
            $list_log = $this->db->select('
                    id_pipeline_main_log,
                    id_pipeline_main,
                    tahapan_sebelum_id,
                    tahapan_sebelum_nm,
                    tahapan_sesudah_id,
                    tahapan_sesudah_nm,
                    kategori
                ')
                ->from('sales_pipeline_main_log')
                ->where('id_company', $this->id_company)
                ->where_in('id_pipeline_main', $data_main)
                ->order_by('id_pipeline_main desc, tgl_input desc')
                ->get()
                ->result();

            $data_log = [];
            $last_id  = '';
            if ($exclude_last_record) unset($list_log[0]);
            foreach ($list_log as $log) {
                if ($log->id_pipeline_main != $last_id) {
                    $data_log[$log->id_pipeline_main] = [
                        'id_pipeline_main_log' => $log->id_pipeline_main_log,
                        'tahapan_sebelum_id'   => $log->tahapan_sebelum_id,
                        'tahapan_sebelum_nm'   => $log->tahapan_sebelum_nm,
                        'tahapan_sesudah_id'   => $log->tahapan_sesudah_id,
                        'tahapan_sesudah_nm'   => $log->tahapan_sesudah_nm,
                        'kategori'             => $log->kategori
                    ];
                    $last_id = $log->id_pipeline_main;
                }
            }

            foreach ($list_main->result() as $value) {
                $data[$value->id_tahapan_m][] = [
                    'id_pipeline_main'      => $value->id_pipeline_main,
                    'id_karyawan'           => $value->id_karyawan,
                    'title'                 => $value->title,
                    'tahun'                 => $value->tahun,
                    'bulan'                 => $value->bulan,
                    'id_tahapan_m'          => $value->id_tahapan_m,
                    'id_pindah_bulan'       => $value->id_pindah_bulan,
                    'id_pipeline_main_log'  => $data_log[$value->id_pipeline_main]['id_pipeline_main_log'],
                    'tahapan_sebelum_id'    => $data_log[$value->id_pipeline_main]['tahapan_sebelum_id'],
                    'tahapan_sebelum_nm'    => $data_log[$value->id_pipeline_main]['tahapan_sebelum_nm'],
                    'tahapan_sesudah_id'    => $data_log[$value->id_pipeline_main]['tahapan_sesudah_id'],
                    'tahapan_sesudah_nm'    => $data_log[$value->id_pipeline_main]['tahapan_sesudah_nm'],
                    'kategori'              => $data_log[$value->id_pipeline_main]['kategori'],
                    'id_pelanggan'          => $value->id_pelanggan,
                    'nama_lead_source'      => $value->nama_lead_source,
                    'status'                => $value->status,
                    'user_input'            => $value->user_input,
                    'tgl_update'            => $value->tgl_update,
                    'id_group'              => $value->id_group,
                    'kode_group'            => $value->kode_group,
                    'nama_group'            => $value->nama_group,
                    'nama_perusahaan'       => $value->nama_perusahaan,
                    'alamat'                => $value->alamat,
                    'nama_jenis_perusahaan' => $value->nama_jenis_perusahaan,
                    'pic_nama'              => $value->pic_nama,
                    'pic_email'             => $value->pic_email,
                    'pic_telp'              => $value->pic_telp,
                    'provinsi'              => $value->provinsi,
                    'kota'                  => $value->kota,
                    'kecamatan'             => $value->kecamatan,
                    'kelurahan'             => $value->kelurahan,
                    'sales_nama'            => $value->sales_nama,
                    'sales_nik'             => $value->sales_nik,
                    'layanan'               => $value->layanan,
                    'harga'                 => $value->harga
                ];
            }
        }

        return $data;
    }
    public function get_data_tahapan()
    {
        return $this->db->select('
                id_tahapan_m,
                jenis,
                nama,
                warna,
                warna_text
            ')
            ->from('sales_tahapan_m')
            ->where('id_company', $this->id_company)
            ->order_by('no_urut', 'asc')
            ->get()
            ->result();
    }

    public function get_data_tahapan_trx($tahun, $bulan, $id_tahapan_m = '')
    {
        $this->db->where('tahun = "' . $tahun . '"');
        $this->db->where('bulan = "' . $bulan . '"');
        if ($id_tahapan_m) {
            $this->db->where('id_tahapan_m', $id_tahapan_m);
        }
        $this->db->where('id_company', $this->id_company);

        return $this->db->select('
                id_tahapan_m,
                jenis,
                nama,
                warna,
                warna_text,
                no_urut
            ')
            ->from('sales_tahapan_trx')
            ->order_by('no_urut', 'asc')
            ->get()
            ->result();
    }

    public function get_realisasi_sales($id_karyawan, $tahun, $bulan, $id_group, $jenis = 'wont')
    {
        $get_realisasi = $this->db->select('
                SUM(IF(layanan.harga_total IS NOT NULL, layanan.harga_total, 0)) as nominal_realisasi
            ')
            ->from('sales_pipeline_main main')
            ->join('sales_tahapan_trx trx', 'trx.id_tahapan_m = main.id_tahapan_m and trx.tahun = main.tahun and trx.bulan = main.bulan and trx.id_company = main.id_company')
            ->join('sales_pipeline_layanan layanan', 'layanan.id_pipeline_main = main.id_pipeline_main', 'left')
            ->where('main.id_company', $this->id_company)
            ->where('main.id_karyawan', $id_karyawan)
            ->where("main.tahun = '$tahun'")
            ->where("main.bulan = '$bulan'")
            ->where('main.id_group_m', $id_group)
            ->where('main.status', 'approve')
            ->where('trx.jenis', $jenis)
            ->group_by('main.id_karyawan,main.id_pipeline_main')
            ->get_compiled_select();

        return $this->db->select('
                COUNT(*) as jumlah_po,
                SUM(nominal_realisasi) as nominal_realisasi
            ')
            ->from("($get_realisasi) as realisasi")
            ->get()
            ->row();
    }

    public function get_data_bawahan($id): array
    {
        return $this->db->select('id_karyawan')
            ->from('sales_approver')
            ->where('id_company', $this->id_company)
            ->where('id_atasan', $id)
            ->get()
            ->result_array();
    }

    public function check_task_exist($tahun = '', $bulan = ''): bool
    {
        $task_exist = $this->db->select('trx.id_tahapan_m')
            ->from('sales_tahapan_trx trx')
            ->join('sales_tahapan_m master', 'master.id_tahapan_m = trx.id_tahapan_m')
            ->where('trx.tahun = "' . ($tahun ?: date('Y')) . '"')
            ->where('trx.bulan = "' . ($bulan ?: date('m')) . '"')
            ->where('trx.id_company', $this->id_company)
            ->limit(1)
            ->get()
            ->num_rows();
        if ($task_exist > 0) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * add new incoming stage
     *
     * @param string|array $data_pelanggan
     * @param array $data_pipeline_main
     * @param array $data_pipeline_log
     * @param array $data_pipeline_layanan
     * @param array $data_pipeline_trx
     * @param int $id_pelanggan_update
     * @return void
     */
    public function save($data_pelanggan, $data_pipeline_main, $data_pipeline_main_log, $data_pipeline_layanan, $data_pipeline_trx, $id_pelanggan_update)
    {
        $this->db->trans_begin();

        try {
            // Insert data tahapan trx jika pertama insert pada pipeline main
            $this->insert_tahapan_trx_if_not_exists();

            // Insert or update data pelanggan
            $this->insert_or_update_pelanggan($data_pelanggan, $data_pipeline_main, $id_pelanggan_update);

            // Insert data pipeline main
            $this->db->insert('sales_pipeline_main', $data_pipeline_main);

            // Insert data pipeline main log
            $this->db->insert('sales_pipeline_main_log', $data_pipeline_main_log);

            // Insert data pipeline layanan
            $this->db->insert_batch('sales_pipeline_layanan', $data_pipeline_layanan);

            // Insert data pipeline trx if approval is skipped
            if ($this->is_sales_skip_approval === true) {
                $this->db->insert('sales_pipeline_trx', $data_pipeline_trx);
            }

            $this->db->trans_commit();
            return __response_save(true);
        } catch (Exception $e) {
            $this->db->trans_rollback();
            // log_message('error', $e->getMessage());
            return __response_save(false);
        }
    }

    private function insert_tahapan_trx_if_not_exists()
    {
        $task_exist = $this->check_task_exist();
        if (!$task_exist) {
            $query = '
                INSERT INTO
                    sales_tahapan_trx (tahun, bulan, id_tahapan_m, jenis, nama, warna, no_urut, id_company, user_input)
                SELECT
                    ?, ?, id_tahapan_m, jenis, nama, warna, no_urut, id_company, ?
                FROM
                    sales_tahapan_m
                WHERE
                    id_company = ?
            ';
            $this->db->query($query, [date('Y'), date('m'), $this->nik_karyawan . ' - ' . $this->nm_karyawan, $this->id_company]);
        }
    }

    private function insert_or_update_pelanggan($data_pelanggan, &$data_pipeline_main, $id_pelanggan_update)
    {
        if (!empty($id_pelanggan_update)) {
            // Action Update
            $data_pipeline_main['id_pelanggan'] = $id_pelanggan_update;
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_pelanggan', $id_pelanggan_update);
            $this->db->update('sales_pelanggan', $data_pelanggan);
        } else {
            // Action Insert
            $data_pipeline_main['id_pelanggan'] = $data_pelanggan['id_pelanggan'];
            $this->db->insert('sales_pelanggan', $data_pelanggan);
        }
    }

    /**
     * Fungsi delete pipeline untuk hapus data task
     *
     * @param string $id => id_pipeline_main
     * @param string $kategori => kategori pindah bulan (move untuk pindah bulan)
     * @return void
     */
    public function delete_pipeline($id, $kategori = 'new')
    {
        $this->db->trans_begin();

        // pipeline main
        $this->db->delete('sales_pipeline_main', ['id_pipeline_main' => $id]);

        // pipeline main log
        $this->db->delete('sales_pipeline_main_log', ['id_pipeline_main' => $id]);

        // pipeline trx
        if ($kategori === 'move') {
            $this->db->delete('sales_pipeline_trx', ['id_pipeline_main' => $id]);
        }

        // layanan
        $this->db->delete('sales_pipeline_layanan', ['id_pipeline_main' => $id]);

        // aktivitas
        $this->db->delete('sales_pipeline_activity', ['id_pipeline_main' => $id]);

        // tahapan trx
        $task_exist = $this->check_task_exist();
        if (!$task_exist) {
            $this->db->delete('sales_tahapan_trx', ['tahun' => date('Y'), 'bulan' => date('m'), 'id_company' => $this->id_company]);
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_delete(false);
        } else {
            $this->db->trans_commit();
            return __response_delete(true);
        }
    }

    /**
     * Fungsi update pipeline untuk batalkan pengajuan
     * dan pindah stage
     *
     * @param string|array $data => id_pipeline_main / data array untuk update
     * @param string $for => insert / update
     * @return void
     */
    public function update_pipeline($data, $for = '')
    {
        $this->db->trans_begin();

        if (is_string($data)) {
            $id = $data;

            $data_log = $this->db->select('
                    id_pipeline_main_log,
                    tahapan_sesudah_id,
                    status,
                    user_input,
                    tgl_input
                ')
                ->from('sales_pipeline_main_log')
                ->where('id_company', $this->id_company)
                ->where('id_pipeline_main', $id)
                ->order_by('tgl_input desc')
                ->limit(2)
                ->get();

            if ($data_log->num_rows() < 2) {
                return __response_update(false);
            }

            $list_log = $data_log->result_array();

            $data_update = [
                'status'       => $list_log[1]['status'],
                'id_tahapan_m' => $list_log[1]['tahapan_sesudah_id'],
                'user_update'  => $list_log[1]['user_input'],
                'tgl_update'   => $list_log[1]['tgl_input']
            ];
            $this->db->update('sales_pipeline_main', $data_update, ['id_pipeline_main' => $id]);

            $this->db->delete('sales_pipeline_main_log', ['id_pipeline_main_log' => $list_log[0]['id_pipeline_main_log']]);
        } else {
            $this->db->update('sales_pipeline_main', $data['main'], $data['where_main']);

            if ($for == 'insert') {
                $this->db->insert('sales_pipeline_main_log', $data['log']);
            } else {
                $this->db->update('sales_pipeline_main_log', $data['log'], $data['where_log']);
            }

            // tanpa approval
            if ($this->is_sales_skip_approval === true) {
                $this->db->where('id_company', $this->id_company);
                $this->db->where('id_karyawan', $this->id_karyawan);
                $this->db->where('tahun', $data['where_trx']['tahun']);
                $this->db->where('bulan', $data['where_trx']['bulan']);
                $this->db->where('id_pipeline_main', $data['where_trx']['id_pipeline_main']);
                $this->db->where('no_urut_tahapan > ' . $data['trx']['where_delete']);
                $this->db->delete('sales_pipeline_trx');

                if ($data['trx']['for'] === 'update') {
                    $data['where_trx']['id_tahapan'] = $data['trx']['where_update'];
                    $this->db->update('sales_pipeline_trx', $data['trx']['data'], $data['where_trx']);
                    unset($data['where_trx']['id_tahapan']);
                } elseif ($data['trx']['for'] === 'insert') {
                    $this->db->insert('sales_pipeline_trx', $data['trx']['data']);
                }

                if ($data['tahapan_jenis'] == 'wont') {
                    $this->db->update('sales_pelanggan', $data['pelanggan']['update'], $data['pelanggan']['where']);
                    if ($data['target_personil_for'] == 'update') {
                        $data['where_trx']['id_group_m'] = $data['target_personil_r']['id_group_m'];
                        unset($data['target_personil_r']['id_group_m']);
                        unset($data['where_trx']['id_pipeline_main']);
                        $this->db->update('sales_target_personil_r', $data['target_personil_r'], $data['where_trx']);
                    } elseif ($data['target_personil_for'] == 'insert') {
                        $this->db->insert('sales_target_personil_r', $data['target_personil_r']);
                        if ($data['target_personil_p']) $this->db->insert('sales_target_personil_p', $data['target_personil_p']);
                    }
                }
            }
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            return __response_update(true);
        }
    }

    public function update_pindah_bulan($id_pipeline, $tahun_sebelum = '', $bulan_sebelum = '', $id_karyawan = '')
    {
        $this->db->trans_begin();

        // insert data tahapan trx jika pertama insert pada pipeline main
        $task_exist = $this->check_task_exist();
        if (!$task_exist) {
            $this->db->query('
                INSERT INTO
                    sales_tahapan_trx (tahun, bulan, id_tahapan_m, jenis, nama, warna, no_urut, id_company, user_input)
                SELECT
                    "' . date('Y') . '", "' . date('m') . '", id_tahapan_m, jenis, nama, warna, no_urut, id_company, "' . $this->nik_karyawan . ' - ' . $this->nm_karyawan . '"
                FROM
                    sales_tahapan_m
                WHERE
                    id_company = "' . $this->id_company . '"
            ');
        }

        $new_id_pipeline = $this->fungsi->getNextId('sales_pipeline_main', 'id_pipeline_main', $this->id_company, 5);
        $status = 'pengajuan';
        if ($this->is_sales_skip_approval === true || $this->is_sales_atasan === true || $this->is_sales_admin === true || $this->level_user === '1') {
            $status = 'approve';
        }
        // insert data pipeline_main
        $sales_group = $this->get_sales_group($id_karyawan ?: $this->id_karyawan);
        $this->db->query('
            INSERT INTO
                sales_pipeline_main (id_pipeline_main, id_karyawan, tahun, bulan, id_lead_m, nama_lead_source, id_tahapan_m, id_pelanggan, pic_nama, pic_email, pic_telp, status, title, keterangan, id_pindah_bulan, id_group_m, id_company, tgl_input, user_input)
            SELECT
                "' . $new_id_pipeline . '",
                ' . ((!$id_karyawan) ? 'clone.id_karyawan' : '"' . $id_karyawan . '"') . ',
                "' . date('Y') . '",
                "' . date('m') . '",
                clone.id_lead_m,
                clone.nama_lead_source,
                clone.id_tahapan_m,
                clone.id_pelanggan,
                clone.pic_nama,
                clone.pic_email,
                clone.pic_telp,
                "' . $status . '",
                clone.title,
                clone.keterangan,
                clone.id_pipeline_main,
                CASE
                    WHEN clone.id_group_m != ""
                    THEN clone.id_group_m
                    ELSE "' . $sales_group->id_group_m . '"
                END as id_group_m,
                clone.id_company,
                clone.tgl_input, "' . $this->nik_karyawan . ' - ' . $this->nm_karyawan . '"
            FROM
                sales_pipeline_main clone
            WHERE
                clone.id_pipeline_main = "' . $id_pipeline . '"
        ');

        // insert data pipeline_main_log
        $main_log                  = $this->db->get_where('sales_pipeline_main_log', ['id_pipeline_main' => $id_pipeline])->result();
        $next_id_pipeline_main_log = $this->fungsi->getNextId('sales_pipeline_main_log', 'id_pipeline_main_log', $this->id_company, 5);
        $data_main_log             = [];
        $tahapan_sesudah_id        = '';
        $tahapan_sesudah_nm        = '';
        foreach ($main_log as $log) {
            $data_main_log[] = [
                'id_pipeline_main_log' => $next_id_pipeline_main_log,
                'id_pipeline_main'     => $new_id_pipeline,
                'tahapan_sebelum_id'   => $log->tahapan_sebelum_id,
                'tahapan_sebelum_nm'   => $log->tahapan_sebelum_nm,
                'tahapan_sesudah_id'   => $log->tahapan_sesudah_id,
                'tahapan_sesudah_nm'   => $log->tahapan_sesudah_nm,
                'status'               => $log->status,
                'kategori'             => 'move',
                'keterangan'           => $log->keterangan,
                'id_company'           => $log->id_company,
                'user_input'           => $log->user_input,
                'tgl_input'            => $log->tgl_input,
                'user_approve'         => $log->user_approve,
                'tgl_approve'          => $log->tgl_approve
            ];

            $tahapan_sesudah_id = $log->tahapan_sesudah_id;
            $tahapan_sesudah_nm = $log->tahapan_sesudah_nm;

            $last_id = substr($next_id_pipeline_main_log, -5);
            $next_id_pipeline_main_log = $this->id_company . date('Ym') . sprintf("%05d", ($last_id + 1));
        }
        $data_main_log[] = [
            'id_pipeline_main_log' => $next_id_pipeline_main_log,
            'id_pipeline_main'     => $new_id_pipeline,
            'tahapan_sebelum_id'   => $tahapan_sesudah_id,
            'tahapan_sebelum_nm'   => $tahapan_sesudah_nm,
            'tahapan_sesudah_id'   => $tahapan_sesudah_id,
            'tahapan_sesudah_nm'   => $tahapan_sesudah_nm,
            'status'               => $status,
            'kategori'             => 'move',
            'keterangan'           => 'Move,' . trim(indo_date(strtotime($tahun_sebelum . '-' . $bulan_sebelum . '-01'), 'F')) . ',' . trim(indo_date(time(), 'F')),
            'id_company'           => $this->id_company,
            'user_input'           => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
            'tgl_input'            => date('Y-m-d H:i:s'),
            'user_approve'         => '',
            'tgl_approve'          => date('Y-m-d H:i:s')
        ];
        if (count($data_main_log) > 0) {
            $this->db->insert_batch('sales_pipeline_main_log', $data_main_log);
        }

        // insert data layanan
        $layanan                  = $this->db->get_where('sales_pipeline_layanan', ['id_pipeline_main' => $id_pipeline])->result();
        $next_id_pipeline_layanan = $this->fungsi->getNextId('sales_pipeline_layanan', 'id_pipeline_layanan', $this->id_company, 5);
        $data_layanan             = [];
        foreach ($layanan as $value) {
            $data_layanan[] = [
                'id_pipeline_layanan' => $next_id_pipeline_layanan,
                'id_pipeline_main'    => $new_id_pipeline,
                'id_product_m'        => $value->id_product_m,
                'harga'               => $value->harga,
                'jumlah'              => $value->jumlah,
                'diskon'              => $value->diskon,
                'harga_total'         => $value->harga_total,
                'id_company'          => $value->id_company,
                'user_input'          => $value->user_input
            ];

            $last_id = substr($next_id_pipeline_layanan, -5);
            $next_id_pipeline_layanan = $this->id_company . date('Ym') . sprintf("%05d", ($last_id + 1));
        }
        if (count($data_layanan) > 0) {
            $this->db->insert_batch('sales_pipeline_layanan', $data_layanan);
        }

        // insert data aktivitas
        $this->db->query('
            INSERT INTO
                sales_pipeline_activity (
                    `id_pipeline_main`,
                    `id_pipeline_main_log`,
                    `id_pelanggan`,
                    `id_karyawan`,
                    `tgl_activity`,
                    `jam_activity`,
                    `jenis_activity`,
                    `keterangan`,
                    `poin`,
                    `flag_lokasi`,
                    `flag_upload_foto`,
                    `lat`,
                    `long`,
                    `path_foto`,
                    `status`,
                    `kategori`,
                    `id_company`,
                    `user_input`,
                    `tgl_input`,
                    `user_approve`,
                    `tgl_approve`
                )
            SELECT
                "' . $new_id_pipeline . '",
                `clone`.`id_pipeline_main_log`,
                `clone`.`id_pelanggan`,
                `clone`.`id_karyawan`,
                `clone`.`tgl_activity`,
                `clone`.`jam_activity`,
                `clone`.`jenis_activity`,
                `clone`.`keterangan`,
                `clone`.`poin`,
                `clone`.`flag_lokasi`,
                `clone`.`flag_upload_foto`,
                `clone`.`lat`,
                `clone`.`long`,
                `clone`.`path_foto`,
                `clone`.`status`,
                "move",
                `clone`.`id_company`,
                `clone`.`user_input`,
                `clone`.`tgl_input`,
                `clone`.`user_approve`,
                `clone`.`tgl_approve`
            FROM
                sales_pipeline_activity clone
            WHERE
                `clone`.`id_company` = "' . $this->id_company . '"
                AND `clone`.`id_pipeline_main` = "' . $id_pipeline . '"
        ');

        // tanpa approval
        if ($this->is_sales_skip_approval === true || $this->is_sales_atasan === true || $this->is_sales_admin === true || $this->level_user === '1') {
            // insert data pipeline_trx
            if ($id_karyawan) $karyawan = $this->db->get_where('data_karyawan', ['id_karyawan' => $id_karyawan])->row();
            $pipeline_trx         = $this->db->get_where('sales_pipeline_trx', ['id_company' => $this->id_company, 'id_pipeline_main' => $id_pipeline])->result();
            $next_id_pipeline_trx = $this->fungsi->getNextId('sales_pipeline_trx', 'id_pipeline_trx', $this->id_company, 5);
            $data_trx             = [];
            foreach ($pipeline_trx as $value) {
                $data_trx[] = [
                    'id_pipeline_trx'       => $next_id_pipeline_trx,
                    'id_pipeline_main'      => $new_id_pipeline,
                    'id_karyawan'           => $id_karyawan ?: $value->id_karyawan,
                    'nik'                   => $id_karyawan ? $karyawan->nik : $value->nik,
                    'nama_karyawan'         => $id_karyawan ? $karyawan->nama_lengkap : $value->nama_karyawan,
                    'tahun'                 => date('Y'),
                    'bulan'                 => date('m'),
                    'id_tahapan'            => $value->id_tahapan,
                    'jenis_tahapan'         => $value->jenis_tahapan,
                    'nama_tahapan'          => $value->nama_tahapan,
                    'warna_tahapan'         => $value->warna_tahapan,
                    'warna_text_tahapan'    => $value->warna_text_tahapan,
                    'no_urut_tahapan'       => $value->no_urut_tahapan,
                    'nominal_layanan'       => $value->nominal_layanan,
                    'jumlah_layanan'        => $value->jumlah_layanan,
                    'id_pelanggan'          => $value->id_pelanggan,
                    'nama_perusahaan'       => $value->nama_perusahaan,
                    'provinsi'              => $value->provinsi,
                    'kota'                  => $value->kota,
                    'kecamatan'             => $value->kecamatan,
                    'kelurahan'             => $value->kelurahan,
                    'alamat'                => $value->alamat,
                    'nama_jenis_perusahaan' => $value->nama_jenis_perusahaan,
                    'nama_lead_source'      => $value->nama_lead_source,
                    'title'                 => $value->title,
                    'id_group_m'            => $value->id_group_m ? $value->id_group_m : ($sales_group->id_group_m ?: ''),
                    'nama_group'            => $value->id_group_m ? $value->nama_group : ($sales_group ? $sales_group->kode . ' - ' . $sales_group->nama : ''),
                    'tgl_incoming'          => $value->tgl_incoming,
                    'id_company'            => $value->id_company,
                    'user_approve'          => $value->user_approve,
                    'tgl_approve'           => $value->tgl_approve,
                ];

                $last_id = substr($next_id_pipeline_trx, -5);
                $next_id_pipeline_trx = $this->id_company . date('Ym') . sprintf("%05d", ($last_id + 1));
            }
            if (count($data_trx) > 0) {
                $this->db->insert_batch('sales_pipeline_trx', $data_trx);
            }
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            return __response_update(true);
        }
    }

    public function get_data_existing_trx($id_karyawan, $tahun, $bulan, $id_pipeline_main = '', $id_tahapan_m = '')
    {
        $this->db->where('id_karyawan', $id_karyawan)
            ->where('tahun', $tahun)
            ->where('bulan', $bulan)
            ->where('id_company', $this->id_company);

        if ($id_pipeline_main != '') $this->db->where('id_pipeline_main', $id_pipeline_main);
        if ($id_tahapan_m != '') $this->db->where('id_tahapan', $id_tahapan_m);

        return $this->db->get('sales_pipeline_trx')->result();
    }

    public function get_detail_layanan($id, $id_layanan = '')
    {
        if ($id_layanan != '') {
            $this->db->where('layanan.id_pipeline_layanan', $id_layanan);
        } else {
            $this->db->where('layanan.id_pipeline_main', $id);
        }

        return $this->db->select('
                layanan.id_pipeline_layanan,
                layanan.id_pipeline_main,
                layanan.id_product_m,
                layanan.harga,
                layanan.jumlah,
                layanan.diskon,
                layanan.harga_total,
                product.harga as harga_product,
                product.nama as nama_product
            ')
            ->from('sales_pipeline_layanan layanan')
            ->join('sales_product_m product', 'product.id_product_m = layanan.id_product_m')
            ->where('layanan.id_company', $this->id_company)
            ->get();
    }

    public function get_sales_group($id_karyawan)
    {
        return $this->db->select('
                group.id_group_m,
                group.kode,
                group.nama
            ')
            ->from('sales_approver sales')
            ->join('sales_group_m group', 'group.id_group_m = sales.id_group_m')
            ->where('sales.id_karyawan', $id_karyawan)
            ->get()
            ->row();
    }
}
