<?php
/*
|--------------------------------------------------
| example new params
|--------------------------------------------------
| $params = array("type"=>"replace",
|                 "message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode sudah digunakan</font>',
|                 "new_params" => array("id_karyawan" => 124242,
|                                         "id_cabang" => 12313));
*/

function __response($response, $output)
{
    foreach ($output as $key => $value) {
        $response[$key] = $value;
    }

    return $response;
}


function __response_save($save = false, $params = null)
{
    $ci = &get_instance();
    $ci->load->helper('language');
    $siteLang = $ci->session->userdata('site_lang');
    if ($siteLang) {
        $ci->lang->load(array('error_message'), $siteLang);
    } else {
        $ci->lang->load(array('error_message'), 'indonesia');
    }

    if ($save) {

        $type    = "save";
        $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>' . $ci->lang->line('success_save') . '</font>';

        if ($params !== null) {
            if (isset($params['type']) && !empty($params['type'])) {
                $type = $params['type'];
            }

            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => true,
            'type' => $type,
            'message' => $message
        );
    } else {

        $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $ci->lang->line('failed_save') . '</font>';

        if ($params !== null) {
            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => false,
            'message' => $message
        );
    }

    $response = $ci->MY_response;
    foreach ($output as $key => $value) {
        $response[$key] = $value;
    }

    if ($params !== null && isset($params['new_params'])) {
        $response = array_merge($response, $params['new_params']);
    }

    echo json_encode($response);
}

function __response_update($update = false, $params = null)
{
    $ci = &get_instance();
    $ci->load->helper('language');
    $siteLang = $ci->session->userdata('site_lang');
    if ($siteLang) {
        $ci->lang->load(array('error_message'), $siteLang);
    } else {
        $ci->lang->load(array('error_message'), 'indonesia');
    }

    if ($update) {
        $type    = "update";
        $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>' . $ci->lang->line('success_update') . '</font>';

        if ($params !== null) {
            if (isset($params['type']) && !empty($params['type'])) {
                $type = $params['type'];
            }

            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => true,
            'type' => $type,
            'message' => $message
        );
    } else {
        $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $ci->lang->line('failed_update') . '</font>';

        if ($params !== null) {
            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => false,
            'message' => $message
        );
    }

    $response = $ci->MY_response;
    foreach ($output as $key => $value) {
        $response[$key] = $value;
    }

    if ($params !== null && isset($params['new_params'])) {
        $response = array_merge($response, $params['new_params']);
    }

    echo json_encode($response);
}

function __response_delete($delete = false, $params = null)
{
    $ci = &get_instance();
    $ci->load->helper('language');
    $siteLang = $ci->session->userdata('site_lang');
    if ($siteLang) {
        $ci->lang->load(array('error_message'), $siteLang);
    } else {
        $ci->lang->load(array('error_message'), 'indonesia');
    }

    if ($delete) {
        $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>' . $ci->lang->line('success_delete') . '</font>';
        if ($params !== null) {
            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => true,
            'message' => $message
        );
    } else {
        $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $ci->lang->line('failed_delete') . '</font>';
        if ($params !== null) {
            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }
        $output = array(
            'success' => false,
            'message' => $message
        );
    }

    $response = $ci->MY_response;
    foreach ($output as $key => $value) {
        $response[$key] = $value;
    }

    echo json_encode($response);
}

function __response_duplicate()
{
    $ci = &get_instance();
    $ci->load->helper('language');
    $siteLang = $ci->session->userdata('site_lang');
    if ($siteLang) {
        $ci->lang->load(array('error_message'), $siteLang);
    } else {
        $ci->lang->load(array('error_message'), 'indonesia');
    }

    $output = array(
        'success' => false,
        'message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $ci->lang->line('error_duplicate') . '</font>'
    );

    $response = $ci->MY_response;
    foreach ($output as $key => $value) {
        $response[$key] = $value;
    }

    echo json_encode($response);
}

function __response_update_reimburse($update, $flag, $message = "")
{
    $ci = &get_instance();
    $ci->load->helper('language');
    $siteLang = $ci->session->userdata('site_lang');
    if ($siteLang) {
        $ci->lang->load(array('error_message'), $siteLang);
    } else {
        $ci->lang->load(array('error_message'), 'indonesia');
    }

    if ($flag == '3') {
        $message = '<font color="#ff0000"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $ci->lang->line('tolak_update_reimburse') . '</font>';
    } elseif ($flag == '4') {
        $message = '<font color="#fd7f00"><i class="fa fa-pencil-square-o">&nbsp;</i>' . $ci->lang->line('revisi_update_reimburse') . '</font>';
    }

    if ($update) {
        $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>' . $ci->lang->line('success_update_reimburse') . '</font>';
        $output = array(
            'success' => true,
            'message' => $message
        );
    } else {
        if (empty($message)) {
            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $ci->lang->line('failed_update_reimburse') . '</font>';
        }

        $output = array(
            'success' => false,
            'message' => $message
        );
    }

    $response = $ci->MY_response;
    foreach ($output as $key => $value) {
        $response[$key] = $value;
    }

    echo json_encode($response);
}

function __response_revisi($approve = false, $params = null)
{
    $ci = &get_instance();
    $ci->load->helper('language');
    $siteLang = $ci->session->userdata('site_lang');
    if ($siteLang) {
        $ci->lang->load(array('error_message'), $siteLang);
    } else {
        $ci->lang->load(array('error_message'), 'indonesia');
    }

    if ($approve) {
        $type    = "revisi";
        $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>' . $ci->lang->line('success_revisi_reimburse') . '</font>';

        if ($params !== null) {
            if (isset($params['type']) && !empty($params['type'])) {
                $type = $params['type'];
            }

            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => true,
            'type' => $type,
            'message' => $message
        );
    } else {
        $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $ci->lang->line('failed_revisi_reimburse') . '</font>';

        if ($params !== null) {
            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => false,
            'message' => $message
        );
    }

    $response = $ci->MY_response;
    foreach ($output as $key => $value) {
        $response[$key] = $value;
    }

    if ($params !== null && isset($params['new_params'])) {
        $response = array_merge($response, $params['new_params']);
    }

    echo json_encode($response);
}

function __response_approve($approve = false, $params = null)
{
    $ci = &get_instance();
    $ci->load->helper('language');
    $siteLang = $ci->session->userdata('site_lang');
    if ($siteLang) {
        $ci->lang->load(array('error_message'), $siteLang);
    } else {
        $ci->lang->load(array('error_message'), 'indonesia');
    }

    if ($approve) {
        $type    = "approve";
        $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>' . $ci->lang->line('success_approve_reimburse') . '</font>';

        if ($params !== null) {
            if (isset($params['type']) && !empty($params['type'])) {
                $type = $params['type'];
            }

            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => true,
            'type' => $type,
            'message' => $message
        );
    } else {
        $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $ci->lang->line('failed_approve_reimburse') . '</font>';

        if ($params !== null) {
            if (isset($params['message']) && !empty($params['message'])) {
                $message = $params['message'];
            }
        }

        $output = array(
            'success' => false,
            'message' => $message
        );
    }

    $response = $ci->MY_response;
    foreach ($output as $key => $value) {
        $response[$key] = $value;
    }

    if ($params !== null && isset($params['new_params'])) {
        $response = array_merge($response, $params['new_params']);
    }

    echo json_encode($response);
}
