<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends MY_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->model('kpi/admin/laporan/Home_m');
        $this->load->helper('kpi/kpi_helper');
    }

    public function index(){
        $this->load->view('kpi/admin/laporan/index');
    }

    public function view_home(){
        $this->load->view('kpi/admin/laporan/view_home');
    }

    public function list_data() {
        $list = $this->Home_m->get_datatables();
		$data = array();
		$no   = $_GET['start'];
		foreach ($list as $field) {
            $no++;
			$row = array();

            $row[] = $no;
            $row[] = $field->nama_lengkap."<br>".$field->nik;
            $row[] = $field->jabatan;
            $row[] = indo_date($field->tgl_pengajuan);
            $row[] = $this->_status($field->status);
            $row[] = $this->_skor($field);

            $id    = md5($field->id_karyawan.$field->tahun.$field->bulan);
            $row[] = '<a href="javascript:void(0)" class="text-primary" title="Detail"> 
						<i id="' . $id . '" class="btn_detail fa fa-info-circle js-menu__open" data-menu="#drawer" onclick="test_slide(this)"></i>
					</a>';

			$data[] = $row;
		}
        
        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Home_m->count_all(),
            "recordsFiltered" => $this->Home_m->count_filtered(),
            "data"            => $data
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    public function download_all($periode) {
        $data['periode'] = indo_date($periode."-01", "F Y");
        $data['data']    = $this->Home_m->download($periode);
        $output          = true;
        $sb_view = $this->load->view('kpi/admin/laporan/download_all', $data, $output);
        
        $param = [
            'file_name'  => "KPI ".$data['periode'],
            'paper_size' => 'A4',
            'cLength'    => 5,
            'header' => [
                '1' => ['merge' => true],
                '2' => ['merge' => true],
            ],
            'thead' => [ 3 ],
            'tbody' => [
                'start'  => 3,
                'wrap' => [ 'B' ],
                'column' => [
                    'A' => [ 'width' => 8, 'valign' => 'center' ],
                    'B' => [ 'width' => 40, 'align' => 'left', 'valign' => 'center' ],
                    'C' => [ 'width' => 28, 'valign' => 'center' ],
                    'D' => [ 'width' => 23, 'align' => 'center', 'valign' => 'middle' ],
                    'E' => [ 'width' => 23, 'align' => 'center', 'valign' => 'middle' ],
                    'F' => [ 'width' => 23, 'align' => 'center', 'valign' => 'middle' ],
                ],
                'runFunction' => [ 'highlightStatusKpi' => 'E' ]
            ],
            'download' => true

        ];

        $this->load->library('PHPExcel/Excel');
        
		if ($output) {
			$this->excel->generateExcel($sb_view, $param);
		} 
		exit;
    }

    private function _status($id) {
        if($id == "5") {
            return "<span class='badge badge-custom-warning' style='font-size: 100%; font-family: Poppins SemiBold;'>Draft Target</span>";
        } elseif($id == "6") {
            return "<span class='badge badge-custom-success' style='font-size: 100%; font-family: Poppins SemiBold;'>Publish Target</span>";
        } elseif($id == "7") {
            return "<span class='badge badge-custom-warning' style='font-size: 100%; font-family: Poppins SemiBold;'>Draft Actual</span>";
        } elseif($id == "1") {
            return "<span class='badge badge-custom-primary' style='font-size: 100%; font-family: Poppins SemiBold;'>Diajukan</span>";
        } elseif($id == "8") {
            return "<span class='badge badge-custom-warning' style='font-size: 100%; font-family: Poppins SemiBold;'>Draft Approval</span>";
        } elseif($id == "4") {
            return "<span class='badge badge-custom-success' style='font-size: 100%; font-family: Poppins SemiBold;'>Approved</span>";
        } elseif($id == "9") {
            return "<span class='badge badge-custom-ungu' style='font-size: 100%; font-family: Poppins SemiBold;'>Diterima</span>";
        }
    }

    private function _skor($data) {
        if($data->skor_predikat == null) {
            return "-";
        } else {
            return "$data->skor_predikat - $data->remark";
        }
    }
}