<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pengaturan_lembur extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Pengaturan_lembur_m');
    }

	public function index(){
		$data['judul'] = 'Pengaturan Approval Lembur';
		$data['aktif'] = 'pengaturan_lembur';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pengaturan/pengaturan_lembur/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$id_company = $this->id_company;
		$data['id'] = $id_company;
		if(!in_array($this->level_user, array("1","4"))) {
			$id_cabang = $this->id_cabang;
			$this->db->where("id_cabang", $id_cabang);
		}

		$this->db->select("id_cabang")
				->from("p_approval_lembur")
				->where("id_company",$id_company)
				->group_by("id_cabang")
				->order_by("id_cabang ASC");

		$data['data'] = $this->db->get()->result();
		
		$this->load->view('pengaturan/pengaturan_lembur/list_data', $data);
	}

	public function save(){
		$id = $this->input->post('id_cabang');
		$company = $this->id_company;

		$jumlah_level = $this->input->post("jumlah_level");
		
		for ($i = 1; $i <= $jumlah_level; $i++) {
			$level = $this->input->post('level_'.$id.'_'.$i.'-[]');
			$level_user = $this->input->post('level_user_'.$id.'_'.$i);
			$id_lembur = $this->input->post('id_'.$id.'_'.$i);

			if ($level == "" || $level == null) {
				$respons = array('success'=>false,
								'message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gagal, semua data harus diisi</font>');
				echo json_encode($respons);
				exit;
			}

			$data_approv = implode(',', $level);

			$nextIdLembur = $this->fungsi->getNextId('p_approval_lembur','id',$company,3);

			$data3 = array('id_cabang' => $id,
                        'level_user' => $level_user,
                        'level_approval' => $data_approv,
                        'id_company' => $company);

			$this->db->where(array('id'=>$id_lembur, 'id_company'=>$_SESSION['id_company']));
			$update = $this->db->update('p_approval_lembur', $data3);
		}

		return  __response_update($update);
	}

	public function delete(){
		$id = $this->input->post("id");
		$this->Pengaturan_lembur_m->delete($id);
	}

}
