<style type="text/css">
    .lightbox .lb-outerContainer {
        position: relative;
        /* Sangat penting untuk membuat absolute positioning bekerja */
        /* Pastikan tidak ada overflow: hidden; di sini yang bisa menyembunyikan ikon */
    }

    .lightbox .lb-dataContainer .lb-closeContainer {
        position: absolute;
        top: 10px;
        right: 500px;
        bottom: auto;
        z-index: 9999;
    }
</style>
<script type="text/javascript">
    var m_jam_kerja_libur = <?= $m_jam_kerja_libur ?>;
    var m_libur_nasional = <?= $m_libur_nasional ?>;
    $(function () {

        $(document).on('click', '.btn_detail', function () {
            var id_aktivitas = $(this).attr("id");
            $('#modal_detail_aktivitas').modal('show');

            for (var i = 0; i < markers.length; i++) {
                markers[i].setMap(null);
            }

            markers = []; // Reset the markers array
            lat_longs_map = []; // Reset the lat_longs_map array
            beaches = []; // Reset the beaches array

            $.get("<?= route("laporan.aktivitas.detail") ?>" + "/" + id_aktivitas, function (data) {

                // SET MAPS
                arr = [];
                arr.push(data.lat);
                arr.push(data.long);
                arr.push(data.title);
                arr.push(data.index);
                beaches.push(arr);

                setMarkers(beaches);
                fitMapToBounds_map();

                // SET DETAIL AKTIVITAS
                $("#nama_karyawan").text(data.nama_karyawan);
                $("#jabatan").text(data.jabatan);
                $("#waktu").text(data.waktu);
                $("#keterangan").text(data.keterangan);
                $("#foto_aktivitas").attr("src", data.foto_aktivitas);
            }, "json");

        });
    });

    var map;
    var lat_longs_map = new Array();
    var markers = []; // Create a marker array to hold your markers
    var beaches = [];
    var mapCentre;

    function setMarkers(locations) {
        for (var i = 0; i < locations.length; i++) {
            var beach = locations[i];
            var myLatLng = new google.maps.LatLng(beach[0], beach[1]);
            var marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
                animation: google.maps.Animation.DROP,
                title: beach[2],
                zIndex: beach[3]
            });

            // Push marker to markers array
            markers.push(marker);

            // Push marker to lat_longs_map array
            lat_longs_map.push(marker.getPosition());

        }
    }

    function initialize() {
        var varcenter = new google.maps.LatLng(-0.4183772, 117.4237542);
        var varZoom = 5.4;
        var mapOptions = {
            zoom: varZoom,
            center: varcenter,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        }
        map = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);

        setMarkers(beaches);
        fitMapToBounds_map();
    }

    function fitMapToBounds_map() {
        var bounds = new google.maps.LatLngBounds();

        if (lat_longs_map.length > 0) {
            for (var i = 0; i < lat_longs_map.length; i++) {
                bounds.extend(lat_longs_map[i]);
            }
            map.fitBounds(bounds);
            map.setZoom(18)
        }
    }
    initialize();

    function set_background_libur(data, row) {
        var temp = data.split("<br>");
        var tanggal = temp[1];
        var week_of_day = moment(tanggal, "DD-MM-YYYY").format("E");
        var y_m_d = moment(tanggal, "DD-MM-YYYY").format("YYYY-MM-DD");

        if (m_jam_kerja_libur.includes(week_of_day) || m_libur_nasional.includes(y_m_d)) {
            $(row).css('background-color', '#e3e4e5');
        }
    }
</script>
<div class="row mt-1">
    <div class="col-md-12">
        <div class="table-responsive">
            <div class="btn-group float-md-right ml-1" style="z-index:1;">
                <button type="button" id="btn_download" class="btn btn-primary" tglmulai="<?= $tgl_mulai ?>" tglselesai="<?= $tgl_selesai ?>" idkaryawan="0" idcabang="0" iddepartemen="0">
                    <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?></button>
            </div>
            <table id="list_data" class="table table-striped" style="width:100%">
                <thead>
                    <tr class="bg-tr">
                        <th class="text-center">NO</th>
                        <th class="text-center text-uppercase"><?= $this->lang->line('tgl'); ?></th>
                        <th class="text-center text-uppercase"><?= $this->lang->line('nama'); ?></th>
                        <th class="text-center">LATITUDE LONGITUDE</th>
                        <th class="text-center text-uppercase"><?= $this->lang->line('keterangan'); ?></th>
                        <th class="text-center text-uppercase"><?= $this->lang->line('foto'); ?></th>
                        <th class="text-center text-uppercase"><?= $this->lang->line('aksi'); ?></th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>


<!-- START TAMPIL MODAL -->
<div id="modal_detail_aktivitas" class="modal fade in" data-keyboard="false" data-backdrop="static" aria-hidden="true">
    <div class="modal-dialog" style="max-width: 80%;">
        <div id="tampil_form" class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"><?= $this->lang->line('detail_aktivitas'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <div class="col-md-6">
                        <label><?= $this->lang->line('nama'); ?></label>
                        <h5 id="nama_karyawan"></h5>
                    </div>
                    <div class="col-md-6">
                        <label><?= $this->lang->line('waktu'); ?></label>
                        <h5 id="waktu"></h5>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-6">
                        <label><?= $this->lang->line('jabatan'); ?>, <?= $this->lang->line('cabang'); ?>, <?= $this->lang->line('departemen'); ?></label>
                        <h5 id="jabatan"></h5>
                    </div>
                    <div class="col-md-6">
                        <label><?= $this->lang->line('keterangan'); ?></label>
                        <h5 id="keterangan"></h5>
                    </div>
                </div>
                <hr>
                <div class="row mt-2">
                    <div class="col-md-6 text-center thumbnail">
                        <h5 class="text-uppercase"><?= $this->lang->line('lokasi_aktivitas'); ?></h5>
                        <div id="map_canvas" style="width:100%; height:350px;"></div>
                    </div>
                    <div class="col-md-6 text-center thumbnail">
                        <h5 class="text-uppercase"><?= $this->lang->line('foto_aktivitas'); ?></h5>
                        <img id="foto_aktivitas" class="portrait" style="max-height:350px">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-close"></i> <?= $this->lang->line('button_form_tutup'); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            'scrollCollapse': true,
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Keterangan'
                                            <?php else: ?> 'searchPlaceholder': 'Description'
                                            <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('laporan.aktivitas.listdata') ?>",
                "type": "GET",
                "data": {
                    "tgl_mulai": '<?= $tgl_mulai ?>',
                    "tgl_selesai": '<?= $tgl_selesai ?>',
                    "id_karyawan": '<?= $id_karyawan ?>',
                    "id_cabang": '<?= $id_cabang ?>',
                    "id_departemen": '<?= $id_departemen ?>'
                },
                "complete": function (data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [
                { "aTargets": [0], "bSortable": false },
                { "aTargets": [3], "bSortable": false },
                { "aTargets": [5], "bSortable": false },
                { "aTargets": [-1], "bSortable": false }
            ],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({ 'text-align': 'center', 'width': '10px' });
                $('td:eq(1)', nRow).css({ 'text-align': 'left', 'width': '100px' });
                $('td:eq(2)', nRow).css({ 'text-align': 'left', 'width': '200px' });
                $('td:eq(3)', nRow).css({ 'text-align': 'center', 'width': '200px' });
                $('td:eq(5)', nRow).css({ 'text-align': 'center', 'width': '100px' });
                $('td:eq(6)', nRow).css({ 'text-align': 'center', 'width': '50px' });
                set_background_libur(aData[1], nRow);
            }

        });
    })
</script>