<?php foreach ($pendidikan as $key) {
    $data_sebelumnya = $this->riwayat_pendidikan_m->getDataById(md5($key->id_riwayat_pendidikan)); ?>
    <div class="card card-rounded card-abu">
        <div class="card-header">
            <h4 class="card-title" id="heading-labels">
                <i class="fa fa-user-o"></i> <?= ucwords(keterangan_action($this->lang->line('data_pendidikan'), $key->action)) . ' ' . $key->jenjang ?>
            </h4>
        </div>
        <div class="card-body">
            <?= pengajuan($key->status_pengajuan, $key->ket_revisi) ?>
            <div class="row form-detail-karyawan">
                <div class="col-md-12">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('nama_sekolah') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->nama_sekolah) ? $key->nama_sekolah : "-" ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->nama_sekolah, $key->nama_sekolah, $key->action); ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('jenjang_pendidikan') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->jenjang) ? $key->jenjang : "-" ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->jenjang, $key->jenjang, $key->action); ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('jurusan') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->jurusan) ? $key->jurusan : "-" ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->jurusan, $key->jurusan, $key->action); ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('tahun_masuk') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->tahun_masuk) ? $key->tahun_masuk : "-" ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->tahun_masuk, $key->tahun_masuk, $key->action); ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('tahun_lulus') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->tahun_lulus) ? $key->tahun_lulus : "-" ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->tahun_lulus, $key->tahun_lulus, $key->action); ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('lulusan_asal') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->lulusan_asal) ? $key->lulusan_asal : "-" ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->lulusan_asal, $key->lulusan_asal, $key->action); ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('gelar') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->gelar) ? $key->gelar : "-" ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->gelar, $key->gelar, $key->action); ?>
                    </fieldset>
                </div>
                <div class="col-md-12">
                    <p>
                        <?= $this->lang->line('lampiran') ?>
                    </p>
                    <div class="row">
                        <div class="col-lg-4 col-md-4">
                            <div class="card">
                                <div class="card-body p-0" align="center">
                                    <?php
                                    $ijazah = $this->config->item('base_image') . 'imagebiodata?_t=file&_d=' . $key->ijazah;
                                    ?>

                                    <a href="<?= $ijazah ?>" target="_blank"><img src="<?= $ijazah ?>" width="200px" height="auto"></a>
                                    <p class="mt-1 text-center">
                                        <?= $this->lang->line('ijazah') ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <div class="card">
                                <div class="card-body p-0" align="center">
                                    <?php
                                    $transkrip = $this->config->item('base_image') . 'imagebiodata?_t=file&_d=' . $key->transkrip;
                                    ?>
                                    <a href="<?= $transkrip ?>" target="_blank"><img src="<?= $transkrip ?>" width="200px" height="auto"></a>
                                    <p class="mt-1 text-center">
                                        <?= $this->lang->line('transkrip_nilai') ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if ($key->status_pengajuan == '1') { ?>
            <div class="card-footer">
                <div class="col-12">
                    <div class="row">
                        <div class="col-md-7 text-left">
                        </div>
                        <div class="col-md-5 text-right">
                            <button class="btn btn-success btn-min-width" onclick="form_approve('<?= $key->id_riwayat_pendidikan ?>');"><i class="fa fa-check"></i> <?= $this->lang->line('button_form_approve') ?></button>
                            <button class="btn btn-secondary btn-min-width" onclick="form_revisi('<?= $key->id_riwayat_pendidikan ?>');"><i class="fa fa-undo"></i> <?= $this->lang->line('button_form_revisi') ?></button>
                        </div>
                    </div>
                </div>
            </div>
        <?php } elseif ($key->status_pengajuan == '4') { ?>
            <div class="card-footer">
                <div class="col-12">
                    <div class="row">
                        <div class="col-md-7 text-left">
                        </div>
                        <div class="col-md-5 text-right">
                            <button class="btn btn-danger btn-min-width" onclick="form_hapus('<?= $key->id_riwayat_pendidikan ?>');"><i class="fa fa-check"></i> <?= $this->lang->line('button_form_hapus') ?></button>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php } ?>
