<script type="text/javascript">
    $(document).ready(function() {
        $('#list_datatables').DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            <?php if ($this->code_lang == 'id') {
                echo "
                'language': {
                    'url': '" . base_url("assets/plugins/datatables/dataTables-language-id.json") . "',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan'
                },";
            }; ?> "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('master.karyawan.pengalamankerja.listdatatables') . '/' . $id_karyawan_md5 ?>",
                "type": "POST",
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0],
                    "bSortable": false
                },
                {
                    "aTargets": [4],
                    "bSortable": false
                }
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center'
                });
                $('td:eq(4)', nRow).css({
                    'text-align': 'center'
                });

                $('td:eq(0)', nRow).css({
                    'width': '10px'
                });
                $('td:eq(4)', nRow).css({
                    'width': '100px'
                });
            }

        });

        // $(document).on("click",".btn_tambah_pengalaman",function(){
        $('.btn_tambah_pengalaman').click(function() {
            $('#tampil_form').load("<?= site_url('master/karyawan/pengalaman-kerja/form/tambah/' . $id_karyawan_md5) ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= strtoupper($this->lang->line('title_form_tambah_data')) ?>");
                $(".btn_save_pengalaman").addClass("btn_save_pengalaman btn btn-primary");
                $(".btn_save_pengalaman").append('<i class="fa fa-save"></i> ');
                $(".btn_save_pengalaman").append('<?= strtoupper($this->lang->line('button_form_simpan')) ?>');
                $("#btn_new_input").hide();
                simpan_data();
            });
        });
    });

    function list_data() {
        $("#list_data").load("<?= route('master.karyawan.pengalamankerja.listdata') . '/' . $id_karyawan_md5 ?>");
    }

    function modal_edit(id_karyawan = null, id_pengalaman_kerja = null) {
        $('#tampil_form').load("<?= route('master.karyawan.pengalamankerja.form.edit') ?>" + "/" + id_karyawan + "/" + id_pengalaman_kerja, function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= strtoupper($this->lang->line('title_form_edit_data')) ?>");
            $(".btn_save_pengalaman").addClass("btn_save_pengalaman btn btn-warning");
            $(".btn_save_pengalaman").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_save_pengalaman").append('<?= strtoupper($this->lang->line('button_form_perbarui')) ?>');
            $("#btn_new_input").hide();
            simpan_data();
        });
    };

    function modal_detail(id = null) {
        $('#tampil_form').load("<?= route('master.karyawan.pengalamankerja.form.detail') ?>" + "/" + id, function() {
            $("#modal_form .card-body").show();
            $("#modal_form .card-footer").show();
            $('#modal_form').modal('show');
            $(".title").text("Detail");
            $(".btn_save_pengalaman").append('<i class="fa fa-close"></i> ');
            $(".btn_save_pengalaman").append('<?= strtoupper($this->lang->line('button_form_kembali')) ?>');
            $(".btn_save_pengalaman").attr("data-dismiss", "modal");
            $(".btn_save_pengalaman").removeClass("btn_save_pengalaman").addClass("btn_kembali_pengalaman btn btn-secondary");
        });
    };

    function modal_delete(id = null) {
        $('#tampil_form').load("<?= route('master.karyawan.pengalamankerja.form.detail') ?>" + "/" + id, function() {
            $('#modal_form').modal('show');
            $(".title").text("Apakah Anda ingin menghapus data ini?");
            $('#form_input input[type=text]').prop("disabled", true);
            $('#form_input input[type=date]').prop("disabled", true);
            $('#id_prov, #id_kota').prop("disabled", true);
            $(".btn_save_pengalaman").append('<i class="fa fa-trash"></i> ');
            $(".btn_save_pengalaman").append('<?= strtoupper($this->lang->line('button_form_hapus')) ?>');
            $(".btn_save_pengalaman").removeClass("btn_save_pengalaman").addClass("btn_hapus_pengalaman btn btn-danger");
            hapus_data();
        });
    }

    function btn_new_input() {
        // btn new input
        $('#btn_new_input').click(function() {
            var file = $('#form_input #file').dropify();
            file = file.data('dropify');
            file.resetPreview();
            file.clearElement();

            $('#form_input input[type=file]').prop("disabled", false);
            $("#form_input input[type=file]").val('');

            $('#form_input input[type=text]').prop("disabled", false);
            $("#form_input input[type=text]").val('');
            $("#form_input select").select2('enable');
            $('#form_input select').select2('val', '0');

            $('.btn_save_pengalaman').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });
    };

    function simpan_data() {
        $('.btn_save_pengalaman').click(function(e) {
            e.preventDefault();
            $('#message').html("");

            var loading = Ladda.create(this);
            if ($("#nama_perusahaan").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_perusahaan') ?></font>");
                $("#nama_perusahaan").focus();
                return false;
            } else if ($("#jenis_perusahaan").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jenis_perusahaan') ?></font>");
                $('#jenis_perusahaan').focus();
                return false;
            } else if ($("#alamat_perusahaan").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_alamat_perusahaan') ?></font>");
                $('#alamat_perusahaan').focus();
                return false;
            } else if ($("#tgl_masuk").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_masuk') ?></font>");
                $('#tgl_masuk').focus();
                return false;
            } else if ($("#tgl_keluar").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_keluar') ?></font>");
                $('#tgl_keluar').focus();
                return false;
            } else if ($("#id_prov").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_provinsi') ?></font>");
                $('#id_prov').focus();
                return false;
            } else if ($("#id_kota").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_kota') ?></font>");
                $('#id_kota').focus();
                return false;
            } else if ($("#jabatan_terakhir").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jabatan_terakhir') ?></font>");
                $('#jabatan_terakhir').focus();
                return false;
            }

            loading.start();

            var param = new FormData();
            param.append('nama_perusahaan', $("#nama_perusahaan").val());
            param.append('jenis_perusahaan', $("#jenis_perusahaan").val());
            param.append('jabatan_terakhir', $("#jabatan_terakhir").val());
            param.append('tgl_masuk', $("#tgl_masuk").val());
            param.append('tgl_keluar', $("#tgl_keluar").val());
            param.append('alamat_perusahaan', $("#alamat_perusahaan").val());
            param.append('provinsi', $("#id_prov").val());
            param.append('kota', $("#id_kota").val());
            param.append('alasan_berhenti', $("#alasan_berhenti").val());
            param.append('file', $('#file').prop('files')[0]);
            param.append('file_lama', $("#file_lama").val());
            param.append('id_riwayat_pekerjaan', $("#id_riwayat_pekerjaan").val());
            param.append('id_karyawan', $("#id_karyawan").val());

            $.ajax({
                type: 'POST',
                url: "<?= site_url('master/karyawan/pengalaman-kerja/save') ?>",
                data: param,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                cache: false,
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save_pengalaman').hide();
                            $('#btn_new_input').show();
                            btn_new_input();
                        } else {
                            $("#form_input #file_lama").val(result.file);
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    }

    function hapus_data() {
        $('.btn_hapus_pengalaman').click(function() {
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?= route('master.karyawan.pengalamankerja.delete') ?>",
                data: 'id_riwayat_pekerjaan=' + $("#form_input #id_riwayat_pekerjaan").val(),
                dataType: 'JSON',
                success: function(result) {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
                },
                error: function() {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    }

    function dropdown_prov() {
        $('#id_prov').select2({
            dropdownParent: $('#modal_form'),
            placeholder: '<?= $this->lang->line('pilih_provinsi') ?>',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.provinsi")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        }).on('change', function(e) {
            $('#id_kota').val("");
            dropdown_kota();
        });
    }

    function dropdown_kota() {
        $('#id_kota').select2({
            dropdownParent: $('#modal_form'),
            placeholder: '<?= $this->lang->line('pilih_kota') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.kota") . "/" ?>' + $('#id_prov').val(),
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }
</script>
<?php if ($this->session->userdata('level_user') == 1) {
    echo $tab . "<br>";
} ?>
<div class="row">
    <div class="col-md-12 text-right">
        <button type="button" class="btn_tambah_pengalaman btn btn-biru btn-min-width mb-1" id="tambah_pengalaman">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_pengalaman_kerja') ?>
        </button>
    </div>
</div>
<div class="row">
    <div class="col-md-12 table-responsive">
        <table id="list_datatables" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center">NO</th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('nama_perusahaan') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('jenis_perusahaan') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('jabatan_terakhir') ?></th>
                    <th class="text-center"><?= $this->lang->line('aksi') ?></th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
