<script type="text/javascript">
    $(document).ready(function () {
        $(".download").click(function () {
            var jenis = $(this).attr('id');
            window.location.href = "<?= route('laporan.absensi.download') . '?periode_awal=' . $periode_awal . '&periode_akhir=' . $periode_akhir . '&hadir=' . $hadir . '&terlambat=' . $terlambat . '&pc=' . $pc . '&tap=' . $tap . '&alpa=' . $alpa . '&sakit=' . $sakit . '&izin=' . $izin . '&cuti=' . $cuti . '&libur=' . $libur . '&id_karyawan=' . $id_karyawan . '&id_cabang=' . $id_cabang . '&id_departemen=' . $id_departemen ?>" + "&jenis=" + jenis;
        });
    });
</script>
<div class="table-responsive">
    <div class="btn-group pull-right" style="z-index:1;">
        <?php
        if (in_array($this->level_user, array('3', '7'))) { ?>
            <button type="button" class="btn btn-primary download" id="pdf" aria-haspopup="true" aria-expanded="false">
                <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
            </button>
        <?php } else { ?>
            <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
            </button>
            <div class="dropdown-menu">
                <a id="excel" class="dropdown-item download"><i class="fa fa-file-excel-o"></i> Excel</a>
                <a id="pdf" class="dropdown-item download"><i class="fa fa-file-pdf-o"></i> PDF</a>
            </div>
        <?php } ?>
    </div>
    <table id="list_data" class="table table-striped" style="width:100%">
        <thead>
            <tr>
                <th class="text-center no-sort" rowspan="2">NO</th>
                <th class="text-center no-sort" rowspan="2"><?= strtoupper($this->lang->line('tgl')); ?></th>
                <th class="text-center no-sort" rowspan="2"><?= strtoupper($this->lang->line('nama')); ?></th>
                <th class="text-center no-sort"><?= strtoupper($this->lang->line('cabang')); ?></th>
                <th class="text-center no-sort" rowspan="2"><?= strtoupper($this->lang->line('kode')); ?></th>
                <th class="text-center no-sort" rowspan="2"><?= strtoupper($this->lang->line('absen_masuk')); ?></th>
                <th class="text-center no-sort" rowspan="2"><?= strtoupper($this->lang->line('absen_pulang')); ?></th>
                <th class="text-center no-sort" rowspan="2"><?= strtoupper($this->lang->line('istirahat_mulai')); ?></th>
                <th class="text-center no-sort" rowspan="2"><?= strtoupper($this->lang->line('istirahat_selesai')); ?></th>
                <?php if ($this->level_user == 1) { ?>
                    <th class="text-center no-sort" rowspan="2"><?= strtoupper($this->lang->line('aksi')); ?></th>
                <?php } ?>
            </tr>
            <tr>
                <th class="text-center no-sort"><?= strtoupper($this->lang->line('departemen')); ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script type="text/javascript">

    var m_jam_kerja_libur = <?= $m_jam_kerja_libur ?>;
    var m_libur_nasional = <?= $m_libur_nasional ?>;

    $(function () {
        table = $('#list_data').DataTable({
            'searching': false,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                        <?php else: ?> 'searchPlaceholder': 'Code/Name'
                        <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('laporan.absensi.data.list') . '?periode_awal=' . $periode_awal . '&periode_akhir=' . $periode_akhir . '&hadir=' . $hadir . '&terlambat=' . $terlambat . '&pc=' . $pc . '&tap=' . $tap . '&alpa=' . $alpa . '&sakit=' . $sakit . '&izin=' . $izin . '&cuti=' . $cuti . '&libur=' . $libur . '&id_karyawan=' . $id_karyawan . '&id_cabang=' . $id_cabang . '&id_departemen=' . $id_departemen ?>",
                "type": "GET",
            },
            "aoColumnDefs": [{
                'bSortable': false,
                'aTargets': ['no-sort']
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({ 'width': '10px', 'text-align': 'center', 'vertical-align': 'top' });
                $('td:eq(1)', nRow).css({ 'width': '100px', 'text-align': 'center', 'vertical-align': 'top' });
                $('td:eq(2)', nRow).css({ 'text-align': 'left', 'vertical-align': 'top' });
                $('td:eq(3)', nRow).css({ 'width': '200px', 'text-align': 'left', 'vertical-align': 'top' });
                $('td:eq(4)', nRow).css({ 'width': '120px', 'text-align': 'center', 'vertical-align': 'top' });
                $('td:eq(5)', nRow).css({ 'width': '120px', 'text-align': 'center', 'vertical-align': 'top' });
                $('td:eq(6)', nRow).css({ 'width': '120px', 'text-align': 'center', 'vertical-align': 'top' });
                $('td:eq(7)', nRow).css({ 'width': '120px', 'text-align': 'center', 'vertical-align': 'top' });
                $('td:eq(8)', nRow).css({ 'width': '120px', 'text-align': 'center', 'vertical-align': 'top' });
                <?php if ($this->level_user == 1) { ?>
                    $('td:eq(-1)', nRow).css({ 'width': '10px', 'text-align': 'center' });
                <?php } ?>
                set_background_libur(aData[1], nRow);
            },
        });
    });

    function set_background_libur(data, row) {
        var temp = data.split("<br>");
        var tanggal = temp[1];
        var week_of_day = moment(tanggal, "DD-MM-YYYY").format("E");
        var y_m_d = moment(tanggal, "DD-MM-YYYY").format("YYYY-MM-DD");

        if (m_jam_kerja_libur.includes(week_of_day) || m_libur_nasional.includes(y_m_d)) {
            $(row).css('background-color', '<?= $this->config->item("warna_background_libur") ?>');
        }
    }
</script>