<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pengalaman_kerja_m extends CI_Model {
    var $table = 'riwayat_pekerjaan';

    function get_datatables($id_karyawan){
        $this->_get_datatables_query($id_karyawan);
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($id_karyawan = null){
        $this->_get_datatables_query($id_karyawan);
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all($id_karyawan){
        $this->db->select("id_riwayat_pekerjaan")->from($this->table);
        if ($id_karyawan != '') {
            $this->db->where("MD5(id_karyawan)", $id_karyawan);
        }
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($id_karyawan = null){
        $this->db->select("id_riwayat_pekerjaan,nama_perusahaan,jenis_perusahaan,jabatan")
                ->from($this->table);
        if ($id_karyawan != '') {
            $this->db->where("MD5(id_karyawan)", $id_karyawan);
        }
        $column_search = array('nama_perusahaan','jenis_perusahaan','jabatan');
        $i = 0;
    
        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST
    
                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }
    
                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        $column_order = array('','nama_perusahaan','jenis_perusahaan','jabatan');
    
        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else{
            $order_by = array("id_riwayat_pekerjaan"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id_riwayat_pekerjaan=null){
        $select = $this->db->select("riwayat_pekerjaan.id_riwayat_pekerjaan,
                                        riwayat_pekerjaan.id_karyawan,
                                        riwayat_pekerjaan.nama_perusahaan,
                                        riwayat_pekerjaan.jenis_perusahaan,
                                        riwayat_pekerjaan.jabatan,
                                        master_kota.id_kota,
                                        master_kota.nama AS kota,
                                        master_provinsi.id_prov,
                                        master_provinsi.nama AS provinsi,
                                        riwayat_pekerjaan.alamat_perusahaan,
                                        riwayat_pekerjaan.tgl_masuk,
                                        riwayat_pekerjaan.tgl_keluar,
                                        riwayat_pekerjaan.alasan_berhenti,
                                        riwayat_pekerjaan.file")
                            ->from("riwayat_pekerjaan")
                            ->join("master_provinsi","master_provinsi.id_prov = riwayat_pekerjaan.provinsi","left")
                            ->join("master_kota","master_kota.id_kota = riwayat_pekerjaan.kota","left")
                            ->where("MD5(riwayat_pekerjaan.id_riwayat_pekerjaan)",$id_riwayat_pekerjaan)
                            ->get();
        return $select->row();
    }

    public function save($data,$id = null){ 
        $id_company = $this->session->userdata('id_company');      
        if($id != null){
            if($data['file'] == ""){
                $predir_file = $this->db->select("file")
                                        ->from($this->table)
                                        ->where("md5(id_riwayat_pekerjaan)",$id)
                                        ->where("id_company",$id_company)
                                        ->get()
                                        ->row("file");
            }

            $this->db->where(array('md5(id_riwayat_pekerjaan)'=>$id));
            $update = $this->db->update('riwayat_pekerjaan',$data);
            if($update){
                if($data['file'] == ""){
                    $this->fungsi->delete_fileupload($predir_file);
                }
            }

            $new_params["new_params"] = ["file"=>$data["file"]];
            return __response_update($update, $new_params);
        }else{
            
            $nextId = $this->fungsi->getNextId('riwayat_pekerjaan','id_riwayat_pekerjaan',$id_company,4);
            $id_pendidikan = array('id_riwayat_pekerjaan' => $nextId);
            $save = $this->db->insert('riwayat_pekerjaan', array_merge($data, $id_pendidikan));
            return __response_save($save);
        }
        
    }

    public function delete($id=null){
        $id_company = $this->session->userdata('id_company');

        $predir_file = $this->db->select("file")
                                ->from($this->table)
                                ->where("md5(id_riwayat_pekerjaan)",$id)
                                ->where("id_company",$id_company)
                                ->get()
                                ->row("file");

        $this->db->where('md5(id_riwayat_pekerjaan)',$id);
        $this->db->where("id_company",$id_company);
        $delete =$this->db->delete($this->table);
        if($delete){
            $this->fungsi->delete_fileupload($predir_file);
            return __response_delete(true);
        }else{
            return __response_delete(false);
        }
    }

}