<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Home extends MY_Controller
{
    public function index(){
        $data['judul'] = 'Report';
        $this->load->view('sales_activity/report/index', $data);
    }

    public function tabs($tabs = null)
    {   
        switch ($tabs) {
            case "data_sales" :  // Pipeline
                $this->load->view('sales_activity/report/data_sales/home');
                break;
            case "realisasi_nominal" :
                $this->load->view('sales_activity/report/realisasi_nominal/home');
                break;
            case "realisasi_won" :
                $this->load->view('sales_activity/report/realisasi_won/home');
                break;
            case "realisasi_poin" :
                $this->load->view('sales_activity/report/realisasi_poin/index');
                break;
            case "aktivitas" :
                $this->load->view('sales_activity/report/aktivitas/home');
                break;
            default:
                echo $this->lang->line('data_tidak_ditemukan');
        }
    }

    public function list_sales()
    {
        $search = $this->input->get("q");

        $check_sa = $this->fungsi->check_atasan_get_bawahan_sa();
        if($check_sa['is_atasan'] == true){
            $this->db->where_in('data_karyawan.id_karyawan', $check_sa['list_bawahan']);
        }

        $this->db->select('data_karyawan.id_karyawan, data_karyawan.nik, data_karyawan.nama_lengkap');
        $this->db->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan.id_jabatan');
        $this->db->where('data_karyawan.id_company', $this->id_company);
        $this->db->where('data_karyawan.flag_sales', '1');
        $this->db->where_in('data_karyawan.status', ['1', '2', '3', '4']);
        $this->db->where_not_in('master_jabatan.level_user', ['1', '6']);

        $this->db->group_start();
        $this->db->like('data_karyawan.nama_lengkap', $search);
        $this->db->or_like('data_karyawan.nik', $search);
        $this->db->group_end();
        $this->db->order_by('data_karyawan.nama_lengkap', 'ASC');

        $result = $this->db->get('data_karyawan')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id' => $rows->id_karyawan, 'text' => $rows->nik . " - " . $rows->nama_lengkap];
        }
        echo json_encode($json);
    }
}
