<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Target_poin extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/pengaturan/Target_poin_m');
    }

    public function list_data(){
        $id_group_m = $this->input->get('id_group_m');
        $list       = $this->Target_poin_m->get_datatables($id_group_m);

        $data    = array();
        $no      = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";

            if($this->fungsi->cek_adm_satu_grup() == false){
                $row[] = $field->nama_group . "<br><b>" . $field->kode_group . "</b>";
            }

            # ID
            $id = $field->id_karyawan.$field->id_company;

            # JUMLAH POIN VALUE & EDIT
            $edit_poin = '<div id="' . MD5($id) . '" class="input-group jumlah_poin_edit pr-3 pl-3" style="display:none">
                                <input type="number" id="jumlah_poin_input" name="poin" class="form-control text-center" min="0" value="' . ($field->poin == "-" ? "0" : $field->poin) . '">
                            </div>';
            
            $val_poin = '<div id="' . MD5($id) . '" class="jumlah_poin_value">
                                <span>' . (!empty($field->poin) ? $field->poin : '0') . '</span>
                            </div>';

            $row[] = '<div class="jumlah_poin_div">' . $edit_poin . $val_poin . '</div>';

            # BUTTON ACTION
            $btn_action = ' <div class="div_action">
                                <a class="btn_edit"
                                    id="' . MD5($id) . '" 
                                    href="javascript:void(0)" 
                                    title="EDIT"
                                    onclick="edit(this)"
                                > 
                                        <i  class="fa fa-edit (alias) text-warning"></i>
                                </a>
                                <a class="btn_save mr-1"
                                    id="' . MD5($id) . '" 
                                    data-status = "'.$field->action.'"
                                    data-id-karyawan = "'.$field->id_karyawan.'"
                                    href="javascript:void(0)"
                                    title="SAVE"
                                    style="display:none"
                                    onclick="simpan(this)"
                                > 
                                        <i  class="fa fa-save (alias) text-primary"></i>
                                </a>
                                <a class="btn_batal"
                                    id="' . MD5($id) . '" 
                                    href="javascript:void(0)" 
                                    title="BATAL"
                                    style="display:none"
                                    onclick="batal(this)"
                                > 
                                        <i  class="fa fa-close (alias) text-warning"></i>
                                </a>
                        </div>';

            $row[] = $btn_action;

            $data[] = $row;
        }

        $output = array(
            "draw"                  => $_GET['draw'],
            "recordsTotal"          => $this->Target_poin_m->count_all($id_group_m),
            "recordsFiltered"       => $this->Target_poin_m->count_filtered($id_group_m),
            "data"                  => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function save(){
        $id          = $this->input->post('id');
        $status      = $this->input->post('status');
        $id_karyawan = $this->input->post('id_karyawan');
        $poin        = preg_replace('/[^0-9]/', '', $this->input->post('jumlahPoin'));

        $data = array(  'id_karyawan' => $id_karyawan,
                        'poin'       => $poin,
                        'id_company' => $this->id_company);

        $this->Target_poin_m->save($data, $id, $status);
    }
}