<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Lead_source extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/master/Lead_source_m');
    }

    public function list_data(){
        $list = $this->Lead_source_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();

            $row[] = '<span class="sort" style="cursor:-webkit-grab; cursor:grab;" title="Tarik keatas / kebawah" data-key="' . $field->id_lead_m . '">
                        <i class="fa fa-sort"></i>&nbsp&nbsp'. $no.
                    '</span>';

            $row[] = htmlspecialchars($field->nama);

            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_lead_m) . '" class="btn_edit_m_lead fa fa-edit (alias) "> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_lead_m) . '" class="btn_delete_m_lead fa fa-trash"></i></a>';
            $row[] = $btn_edit. '&nbsp'. $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Lead_source_m->count_all(),
            "recordsFiltered" => $this->Lead_source_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Lead_source_m->getDataById($id);
		}
		$this->load->view('sales_activity/master/lead_source/form',$data);
    }

    public function save(){
        $id = $this->input->post('id_lead_m');

        $data = array('nama'            => $this->input->post('nama'),
                    'id_company'        => $this->id_company);

        $this->Lead_source_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Lead_source_m->delete($id);
    }

    public function update_order(){
        $order = $this->input->post('order');

        $data = array();
        foreach ($order as $key) {
            $data[] = [
                'concat(id_lead_m,id_company)' => $key['id_lead_m'] . $this->id_company,
                'no_urut' => $key['no_urut']
            ];
        }
        $this->Lead_source_m->update_order($data);
    }
}