<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends MY_Controller {

	function __construct()
	{
		parent::__construct();
        $this->load->model('kpi/user/team/home_m');
	}

    public function index()
    {
        $this->load->view('kpi/user/team/home');
    }

    public function list_data() {
        $this->load->helper('kpi/kpi');

		$periode = periodeTarget();
		$list    = $this->home_m->get_datatables($periode);
		$data    = array();
		$no      = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nama_lengkap."<br>".$field->nik;
			$row[] = $field->jabatan;
			$row[] = periode($field->tahun, $field->bulan);
			$row[] = statusTarget($field->status);
			$row[] = $this->aksi($periode, $field);

			$data[] = $row;
		}

		$output = array(
			"draw"            => $_GET['draw'],
			"recordsTotal"    => $this->home_m->count_all($periode),
			"recordsFiltered" => $this->home_m->count_filtered($periode),
			"data"            => $data,
            "validasiPeriode" => validasiPeriodeInput($periode)
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

	private function aksi($periode, $data) {
        if($periode['isPeriodeInput']) {
            if($data->status == '') {
                if($data->bobot_aspek_kinerja == null) {
                    return "<div class='badge badge-danger'><i class='fa fa-exclamation-triangle'></i>&nbsp;&nbsp;Bobot aspek kinerja belum diset oleh admin</div>";
                } else {
                    return "<a id='".$data->id_karyawan.'-'.$periode['tahun'].$periode['bulan']."' class='set_planning btn_detail_team'><i class='fa fa-paper-plane-o'></i> Set Planning</a>";
                }
            } else {
                $id = md5($data->id_karyawan.$data->tahun.$data->bulan);
                if($data->status == '5') {
                    return "<a id='$id' class='draft btn_detail_team'><i class='fa fa-pencil-square-o'></i> edit</a>";
                } else {
                    return "<a id='$id' class='text-primary btn_detail_team'><i class='fa fa-info-circle'></i></a>";
                }
            }
        } else {
            if($data->status != '') {
                $id = md5($data->id_karyawan.$data->tahun.$data->bulan);
                return "<a id='$id' class='text-primary btn_detail_team'><i class='fa fa-info-circle'></i></a>";
            } else {
                return '';
            }
        }
    }
}