<script type="text/javascript">
    function target(e) {
        const name = e.value;

        if (name == "all") {
            $(".select-dropdown-cabang").hide();
            $(".select-dropdown-departemen").hide();
            $(".select-dropdown-karyawan").hide();
        }
        if (name == "cabang") {
            $(".select-dropdown-cabang").show();
            $(".select-dropdown-departemen").hide();
            $(".select-dropdown-karyawan").hide();

            $("#select-target-cabang-1").val(null).trigger("change");
            $("#select-target-cabang-1").select2({
                placeholder: '<?= $this->lang->line('semua_cabang') ?>',
                allowClear: true,
                ajax: {
                    url: '<?= route("dropdown.cabang") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        }
        if (name == "departemen") {
            $(".select-dropdown-cabang").hide();
            $(".select-dropdown-departemen").show();
            $(".select-dropdown-karyawan").hide();

            $("#select-target-cabang-2").val(null).trigger("change");
            $("#select-target-cabang-2").select2({
                placeholder: '<?= $this->lang->line('semua_cabang') ?>',
                allowClear: true,
                ajax: {
                    url: '<?= route("dropdown.cabang") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                }
            }).change(function() {
                let cabang = $("#select-target-cabang-2").val();
                $("#select-target-departemen").val(null).trigger("change");
                $(".select-dropdown label[for=select-target-departemen]").show();
                $("#select-target-departemen").select2({
                    placeholder: '<?= $this->lang->line('semua_departemen') ?>',
                    allowClear: true,
                    ajax: {
                        url: '<?= route("dropdown.departemen.by.cabang", ["cabang" => "'+cabang+'"]) ?>',
                        dataType: 'json',
                        delay: 250,
                        processResults: function(data) {
                            return {
                                results: data
                            };
                        },
                        cache: false
                    }
                });
            });
        }
        if (name == "karyawan") {
            $(".select-dropdown-cabang").hide();
            $(".select-dropdown-departemen").hide();
            $(".select-dropdown-karyawan").show();

            $("#select-target-karyawan").val(null).trigger("change");
            $("#select-target-karyawan").select2({
                placeholder: '<?= $this->lang->line('semua_karyawan') ?>',
                allowClear: true,
                ajax: {
                    url: '<?= route("dropdown.karyawan.aktif.skor") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        }
    }
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_tambah" class="card-body" disabled>
    <input type="hidden" id="jenis" class="form-control" disabled>
    <div class="form-group">
        <label for="saldo"></label>
        <input type="number" id="saldo" class="form-control" min="1" oninput="validity.valid||(value='')" step="1">
    </div>

    <div class="form-group mt-2">
        <label for="keterangan"><?= $this->lang->line('keterangan') ?> <span class="text-danger">*</span></label>
        <textarea type="text" name="keterangan" id="keterangan" class="form-control" rows="5"></textarea>
    </div>

    <div class="form-group mt-2">
        <label>Target</label>
        <div class="row">
            <div class="col-md-3">
                <input type="radio" name="target" id="target-all" value="all" onclick="target(this)" checked=true>
                <label for="target-all"><?= $this->lang->line('semua_karyawan') ?></label>
            </div>
            <div class="col-md-3">
                <input type="radio" name="target" id="target-cabang" value="cabang" onclick="target(this)">
                <label for="target-cabang"><?= $this->lang->line('cabang') ?></label>
            </div>
            <div class="col-md-3">
                <input type="radio" name="target" id="target-departemen" value="departemen" onclick="target(this)">
                <label for="target-departemen"><?= $this->lang->line('departemen') ?></label>
            </div>
            <div class="col-md-3">
                <input type="radio" name="target" id="target-karyawan" value="karyawan" onclick="target(this)">
                <label for="target-karyawan"><?= $this->lang->line('spesifik_karyawan') ?></label>
            </div>
        </div>
    </div>

    <div class="form-group mt-2 select-dropdown">
        <div class="select-dropdown-cabang" style="display:none">
            <label for="select-target-cabang-1"><?= $this->lang->line('cabang') ?> <span class='text-danger'>*</span></label>
            <select name="select-target-cabang-1" id="select-target-cabang-1" multiple style="width:100%;"></select>
        </div>
        <div class="select-dropdown-departemen" style="display:none">
            <label for="select-target-cabang-2"><?= $this->lang->line('cabang') ?> <span class='text-danger'>*</span></label>
            <select name="select-target-cabang-2" id="select-target-cabang-2" style="width:100%;"></select>
            <label class="mt-1" for="select-target-departemen" style="display:none">Departemen <span class='text-danger'>*</span></label>
            <select name="select-target-departemen" id="select-target-departemen" multiple style="width:100%; display:none"></select>
        </div>
        <div class="select-dropdown-karyawan" style="display:none">
            <label for="select-target-karyawan"><?= $this->lang->line('karyawan') ?> <span class='text-danger'>*</span></label>
            <select name="select-target-karyawan" id="select-target-karyawan" multiple style="width:100%;"></select>
        </div>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none"><?= $this->lang->line('button_form_submit_lainnya') ?></button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
