<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                        <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                                            'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                                            'searchPlaceholder': 'NIK/Nama Karyawan'
                                        <?php else : ?> 'searchPlaceholder': 'ID/Employee Name'
                                        <?php endif; ?>
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                    "url": "<?= route('pengaturan.kepaladepartemen.data') ?>",
                                    "type": "GET",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                        <?php
                                            if (in_array($this->session->userdata('level_user'), array("1","5"))) {
                                        ?>
                                                { "aTargets": [4], "bSortable": false }

                                        <?php }?>
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(0)', nRow).css({'width':'10px'});

                            <?php
                                if (in_array($this->session->userdata('level_user'), array("1","5"))) {
                            ?>

                                    $('td:eq(4)', nRow).css({'text-align':'center'});
                                    $('td:eq(4)', nRow).css({'width':'30px'});

                            <?php }?>
                    }
        
        });

        $(document).on('click','.btn_edit',function(){
            $('#tampil_form').load("<?= route('pengaturan.kepaladepartemen.form.edit') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_perbarui') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);
            
            loading.start();
            var id_karyawan = $("#id_karyawan").val();
            var id_cabang = $("#id_cabang").val();
            var arr = [];

            $.each($('#departemen option:selected'), function(i, v){
                if($(this).attr('locked') != 'locked'){
                    var id_departemen   = $(this).val();
                    arr.push({
                        cabang: id_cabang,
                        departemen:id_departemen
                    });
                }
            });
        
            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.kepaladepartemen.update') ?>",
                data: {id_karyawan:id_karyawan,
                        data_departemen:arr},
                dataType:'JSON',
                success: function(result) {
                    if(result.success == true){
                        if(result.type == 'save'){
                            $("#karyawan, #cabang, #departemen").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
        
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Pengaturan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left"><?= strtoupper($this->lang->line('nama_karyawan')); ?></th>
                            <th class="text-left"><?= strtoupper($this->lang->line('cabang')); ?></th>
                            <th class="text-left"><?= strtoupper($this->lang->line('departemen')); ?></th>
                             <?php
                                if(in_array($this->session->userdata('level_user'), array("1","5"))) {
                            ?>
                                    <th class="text-center"><?= $this->lang->line('aksi'); ?></th>
                            <?php
                                }
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


