<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Realisasi_nominal_m extends CI_Model
{
    var $table = 'data_karyawan';

    function get_datatables($tahun="", $id_group="all", $id_karyawan="all"){
        $this->_get_datatables_query($tahun, $id_group, $id_karyawan);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
        }

    function count_filtered($tahun="", $id_group="all", $id_karyawan="all"){
        $this->_get_datatables_query($tahun, $id_group, $id_karyawan);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($tahun="", $id_group="all", $id_karyawan="all"){
        $this->_get_datatables_query($tahun, $id_group, $id_karyawan);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($tahun="", $id_group="all", $id_karyawan="all"){
        $check_sa        = $this->fungsi->check_atasan_get_bawahan_sa();
        $id_karyawan_arr = $this->_get_id_karyawan_union($tahun, $id_group);
        $id_karyawan_arr = !empty($id_karyawan_arr) ? $id_karyawan_arr : [""];

        $this->db->select('
                    karyawan.id_karyawan,
                    karyawan.nik,
                    karyawan.nama_lengkap
                ')
                ->from('data_karyawan AS karyawan')
                ->where('karyawan.id_company', $this->id_company);
        if($id_karyawan != "all"){
            $this->db->where('karyawan.id_karyawan', $id_karyawan);
        }else{
            if($check_sa['is_atasan'] == true){
                $this->db->where_in('karyawan.id_karyawan', $check_sa['list_bawahan']);
            }else{
                $this->db->where_in('karyawan.id_karyawan', $id_karyawan_arr);
            }
        }

        $column_search = array('karyawan.nama_lengkap');
        $i = 0;
        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

            if ($i === 0) { // looping awal
                $this->db->group_start();
                $this->db->like($item, $_GET['search']['value']);
            } else {
                $this->db->or_like($item, $_GET['search']['value']);
            }

            if (count($column_search) - 1 == $i) {
                $this->db->group_end();
            }
        }
        $i++;
        }

        // $column_order = array('', '');
        if (isset($_GET['order'])) {
            // $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("karyawan.nama_lengkap" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function get_target_personil($tahun="", $id_group="all", $id_karyawan="all"){

        $check_sa        = $this->fungsi->check_atasan_get_bawahan_sa();
        $id_karyawan_arr = $this->_get_id_karyawan_union($tahun, $id_group);
        $id_karyawan_arr = !empty($id_karyawan_arr) ? $id_karyawan_arr : [""];

        $this->db->select('id_karyawan,
                            tahun,
                            bulan,
                            nominal_target,
                            nominal_realisasi,
                            CONCAT(id_karyawan,tahun,bulan,id_company) AS key_target
                        ')
                ->from('sales_target_personil_r')
                ->where('id_company', $this->id_company);

        if($id_karyawan != "all"){
            $this->db->where('id_karyawan', $id_karyawan);
        }else{
            if($check_sa['is_atasan'] == true){
                $this->db->where_in('id_karyawan', $check_sa['list_bawahan']);
            }else{
                $this->db->where_in('id_karyawan', $id_karyawan_arr);
            }
        }
        $this->db->where('tahun', $tahun);

        $query = $this->db->get()->result_array();

        return $query;
    }

    public function get_target_tahunan_bulanan($tahun = "", $id_group="all"){   
        // GET TARGET TAHUNAN
        $this->db->select("tahun,
                            bulan,
                            SUM(nominal) as nominal");
        $this->db->from('sales_target_tahunan_p');
        $this->db->where("tahun", $tahun);

        if($id_group != 'all'){
            $this->db->where("id_group_m", $id_group);
        }
        
        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        $this->db->where("id_company", $this->id_company);
        $this->db->group_by("bulan");
        $this->db->order_by('bulan ASC');
        $target_tahunan = $this->db->get()->result_array();

        // GET TARGET KUARTAL
        $this->db->select("tahun,
                            bulan,
                            SUM(nominal) as nominal");
        $this->db->from('sales_target_kuartal_p');
        $this->db->where("tahun", $tahun);
        
        if($id_group != 'all'){
            $this->db->where("id_group_m", $id_group);
        }
        
        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        $this->db->where("id_company", $this->id_company);
        $this->db->group_by("bulan");
        $this->db->order_by('bulan ASC');
        $target_kuartal = $this->db->get()->result_array();

        // GET TARGET BULANAN
        $this->db->select("tahun,
                            bulan,
                            SUM(nominal) as nominal");
        $this->db->from('sales_target_bulanan_p');
        $this->db->where("tahun", $tahun);
        
        if($id_group != 'all'){
            $this->db->where("id_group_m", $id_group);
        }
        
        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('id_group_m', explode(',', $this->sales_admin_group));
            }
        }
        
        $this->db->where("id_company", $this->id_company);
        $this->db->group_by("bulan");
        $this->db->order_by('bulan ASC');
        $target_bulanan = $this->db->get()->result_array();

        // OLAH ARRAY
        $data = array();
        for ($i=1; $i <= 12; $i++) {
            $res_tahunan              = array_search(sprintf("%02d", $i), array_column($target_tahunan, 'bulan'));
            $res_tahunan              = ($res_tahunan !== false) ? $target_tahunan[$res_tahunan] : null;
            $data[sprintf("%02d", $i)]['tahunan'] = !empty($res_tahunan['nominal']) ? $res_tahunan['nominal'] : '0';

            $res_kuartal              = array_search(sprintf("%02d", $i), array_column($target_kuartal, 'bulan'));
            $res_kuartal              = ($res_kuartal !== false) ? $target_kuartal[$res_kuartal] : null;
            $data[sprintf("%02d", $i)]['kuartal'] = !empty($res_kuartal['nominal']) ? $res_kuartal['nominal'] : '0';

            $res_bulanan              = array_search(sprintf("%02d", $i), array_column($target_bulanan, 'bulan'));
            $res_bulanan              = ($res_bulanan !== false) ? $target_bulanan[$res_bulanan] : null;
            $data[sprintf("%02d", $i)]['bulanan'] = !empty($res_bulanan['nominal']) ? $res_bulanan['nominal'] : '0';
        }

        return $data;
    }

    private function _get_kode_nama_group(){
        $query = $this->db->select("id_group_m")
                        ->from("sales_group_m")
                        ->where("id_company", $this->id_company)
                        ->where_in('id_group_m', explode(',', $this->sales_admin_group))
                        ->get()
                        ->result();

        $data = [];
        foreach($query AS $rows){
            $data[] = $rows->nama_group;
        }

        return $data;
    }

    public function dropdown_nama_group($tahun="", $search=""){
        $where_group = "";
        if($this->is_sales_admin == TRUE && !in_array($this->sales_admin_group, ["all", ""])){
            $where_group = " AND g.id_group_m IN ('".str_replace(",","','",$this->sales_admin_group)."')";
        }

        $binding[] = $tahun;

        if(!empty($tahun) && $tahun < date('Y')){

            if(!empty($search)){
                $binding[] = "%".$search."%";
                $where_search = " AND g.nama_group LIKE ? ";
            }else{
                $where_search = " ";
            }

            $sql = "SELECT g.id_group_m,
                            g.nama_group
                    FROM sales_pipeline_trx AS g
                    WHERE g.id_company = '" . $this->id_company . "'
                    AND g.id_group_m != ''
                    AND g.nama_group != ''
                    AND g.tahun = ?
                    ".$where_group."
                    ".$where_search."
                    GROUP BY g.id_group_m
                    ORDER BY g.nama_group ASC";
        }else{

            if(!empty($search)){
                $binding[] = "%".$search."%";
                $where_search = " WHERE combined.nama_group LIKE ? ";
            }else{
                $where_search = " ";
            }

            $sql = "SELECT * FROM (
                        SELECT g.id_group_m,
                                CONCAT(g.kode, ' - ',g.nama) AS nama_group
                        FROM sales_group_m AS g
                        WHERE g.id_company = '" . $this->id_company . "'
                        ".$where_group."

                        UNION ALL

                        SELECT g.id_group_m,
                                g.nama_group
                        FROM sales_pipeline_trx AS g
                        WHERE g.id_company = '" . $this->id_company . "'
                        AND g.tahun = ?
                        AND g.id_group_m != ''
                        AND g.nama_group != ''
                        ".$where_group."
                        GROUP BY g.id_group_m
                    ) AS combined
                    ".$where_search."
                    GROUP BY combined.id_group_m
                    ORDER BY combined.nama_group ASC
                ";
        }

        $result = $this->db->query($sql, $binding)->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id' => $rows->id_group_m, 'text' => $rows->nama_group, 'nm-group'=>$rows->nama_group];
        }
        echo json_encode($json);
    }

    public function dropdown_karyawan($tahun="", $id_group="all", $search=""){
        $check_sa = $this->fungsi->check_atasan_get_bawahan_sa();
        if($check_sa['is_atasan'] == true){
            $this->db->where_in('data_karyawan.id_karyawan', $check_sa['list_bawahan']);
        }

        if($id_group == 'all'){
            if($this->is_sales_admin == TRUE && !in_array($this->sales_admin_group, ["all", ""])){
                $where_group = " AND sgm.id_group_m IN ('".str_replace(",","','",$this->sales_admin_group)."')";
            }else{
                $where_group = " ";
            }
        }else{
            $where_group = " AND sgm.id_group_m = ? ";
            $binding[]   = $id_group;
            $binding[]   = $id_group;

        }
        $binding[] = $tahun;

        if(!empty($search)){
            $where_search = " WHERE (combined.nik LIKE ? OR combined.nm_karyawan LIKE ?) ";
            $binding[] = "%".$search."%";
            $binding[] = "%".$search."%";
        }

        $sql = "SELECT combined.id_karyawan,
                            combined.nik,
                            combined.nm_karyawan
                    FROM (
                            SELECT dk.id_karyawan,
                                    dk.nik,
                                    dk.nama_lengkap as nm_karyawan
                            FROM sales_approver as sa
                            JOIN data_karyawan as dk on dk.id_karyawan = sa.id_karyawan
                            JOIN sales_group_m as sgm on sgm.id_group_m = sa.id_group_m
                            WHERE sa.id_company = '".$this->id_company."'
                            ".$where_group."
                            AND sa.status = '1'

                            UNION ALL

                            SELECT sgm.id_karyawan,
                                    sgm.nik,
                                    sgm.nama_karyawan as nm_karyawan
                            FROM sales_target_personil_r as sgm
                            WHERE sgm.id_company = '".$this->id_company."'
                            ".$where_group."
                            AND sgm.tahun = ?
                            GROUP BY sgm.id_karyawan
                        ) AS combined
                    ".$where_search."
                    GROUP BY combined.id_karyawan
                    ORDER BY combined.nm_karyawan ASC";

        $result = $this->db->query($sql, $binding)->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id' => $rows->id_karyawan,
                        'text'        => $rows->nik." - ".$rows->nm_karyawan,
                        'nm-karyawan' => $rows->nik." - ".$rows->nm_karyawan];
        }
        echo json_encode($json);
    }

    private function _get_id_karyawan_union($tahun="", $id_group="all"){
        if($id_group == 'all'){

            if($this->is_sales_admin == TRUE && !in_array($this->sales_admin_group, ["all", ""])){
                $where_group = " AND sales.id_group_m IN ('".str_replace(",","','",$this->sales_admin_group)."') ";
            }else{
                $where_group = " ";
            }
        }else{
            $where_group = " AND sales.id_group_m = ? ";

            if(!empty($tahun) && $tahun < date('Y')){
                $binding[] = $id_group;
            }else{
                $binding[] = $id_group;
                $binding[] = $id_group;
            }
        }
        $binding[] = $tahun;

        if(!empty($tahun) && $tahun < date('Y')){
            $sql = "SELECT id_karyawan
                    FROM sales_target_personil_r AS sales
                    WHERE id_company = '".$this->id_company."'
                    ".$where_group."
                    AND tahun = ?
                    GROUP BY id_karyawan";
        }else{
            $sql = "SELECT id_karyawan
                            FROM (
                                    SELECT id_karyawan
                                    FROM sales_approver AS sales
                                    WHERE id_company = '".$this->id_company."'
                                    AND status = '1'
                                    ".$where_group."

                                    UNION ALL

                                    SELECT id_karyawan
                                    FROM sales_target_personil_r AS sales
                                    WHERE id_company = '".$this->id_company."'
                                    ".$where_group."
                                    AND tahun = ?
                                    GROUP BY id_karyawan
                                ) AS combined
                        GROUP BY combined.id_karyawan";
        }

        $query = $this->db->query($sql,$binding)->result();

        $data = array();
        foreach ($query as $value) {
            $data[] = $value->id_karyawan;
        }

        return $data;
    }


}