<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Kinerja_m extends CI_Model {
    var $table = 'kpi_object_m';

    public function __construct(){
		parent::__construct();
	}

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->db->select("id_object_m")->from($this->table);
        $this->db->where('id_company',$this->id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("id_object_m, nm_object, no_urut")->from($this->table);
        $this->db->where('id_company',$this->id_company);

        $column_search = array('');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("no_urut"=>"ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->query("SELECT id_object_m,
                                            nm_object,
                                            no_urut
                                    FROM $this->table
                                    WHERE MD5(id_object_m) = '$id'
                                    AND id_company = '".$this->id_company."'")->row();
        return $select;
    }

    public function save($data){
        $no_urut = $this->db->query("SELECT max(no_urut)+1 as no_urut FROM $this->table WHERE id_company = '$this->id_company' ")->row()->no_urut;
        $data['no_urut'] = $no_urut;

        $nextId = $this->fungsi->getNextId($this->table,'id_object_m',$this->id_company,5);
        $data['id_object_m'] = $nextId;
        $save = $this->db->insert($this->table, $data);
        return __response_save($save);
    }

    public function update($data,$id)
    {
        $this->db->where(array('md5(id_object_m)'=>$id, 'id_company'=>$this->id_company));
        $update = $this->db->update($this->table,$data);
        $this->logger->create_log('master_kpi_objek', 'edit', $this->db->last_query());
        return  __response_update($update);
    }

    public function delete($id=null){

        $this->db->where(array('md5(id_object_m)'=>$id, 'id_company'=>$this->id_company));
        $delete =$this->db->delete($this->table);
        $this->logger->create_log('master_kpi_objek', 'delete', $this->db->last_query());
        return  __response_delete($delete);
    }

    public function update_order($data)
    {
        $this->db->trans_start();

        $this->db->update_batch($this->table, $data, 'id_object_m');
        $this->logger->create_log('master_kpi_objek', 'edit', $this->db->last_query());

        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            return __response_update(true);
        }
    }

    public function check_data_aspek_kinerja(){
        $cek_data = $this->db->select('id_object_m')
                                    ->from($this->table)
                                    ->where('id_company', $this->id_company)
                                    ->get()
                                    ->row()
                                    ->id_object_m;

        if(empty($cek_data)){
            $data = array();

            $data[] = array(
                'id_object_m' => $this->id_company. date('Ym'). '001',
                'nm_object'   => 'Financial',
                'no_urut'     => '1',
                'id_company'  => $this->id_company,
                'tgl_input'   => date("Y-m-d H:i:s"),
                'user_input'  => $this->nik_karyawan. " - ". $this->nm_karyawan
            );
            $data[] = array(
                'id_object_m' => $this->id_company. date('Ym'). '002',
                'nm_object'   => 'Internal Process',
                'no_urut'     => '2',
                'id_company'  => $this->id_company,
                'tgl_input'   => date("Y-m-d H:i:s"),
                'user_input'  => $this->nik_karyawan. " - ". $this->nm_karyawan
            );
            $data[] = array(
                'id_object_m' => $this->id_company. date('Ym'). '003',
                'nm_object'   => 'Customer',
                'no_urut'     => '3',
                'id_company'  => $this->id_company,
                'tgl_input'   => date("Y-m-d H:i:s"),
                'user_input'  => $this->nik_karyawan. " - ". $this->nm_karyawan
            );
            $data[] = array(
                'id_object_m' => $this->id_company. date('Ym'). '004',
                'nm_object'   => 'Learning & Growth',
                'no_urut'     => '4',
                'id_company'  => $this->id_company,
                'tgl_input'   => date("Y-m-d H:i:s"),
                'user_input'  => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            $this->db->trans_start();
            $this->db->insert_batch($this->table, $data);
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        }
    }
}