<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rekap_reimburse extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Rekap_reimburse_m');
        $this->load->model('Db_model');
    }

	public function index(){
		$data['judul'] = 'Rekap Reimburse Departemen';
		$data['aktif'] = 'reimburse_departemen';
		$data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('rekap_reimburse/main_departemen', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function rekap_departemen($id_cabang, $id_departemen, $tgl_mulai, $tgl_selesai){
		$data['list_data']      = $this->Rekap_reimburse_m->data_reimburse($id_cabang, $id_departemen, $id_karyawan="all", $tgl_mulai, $tgl_selesai);
		$data['id_cabang']      = $id_cabang;
		$data['id_departemen']  = $id_departemen;
		$data['tgl_mulai']      = $tgl_mulai;
		$data['tgl_selesai']    = $tgl_selesai;
		$this->load->view('rekap_reimburse/list_departemen', $data, false);
    }

    public function main_karyawan(){
        $data['judul'] = 'Rekap Reimburse Karyawan';
        $data['aktif'] = 'reimburse_karyawan';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('rekap_reimburse/main_karyawan', $data, true);
        $this->load->view('main_template', $data, false);
    }

	public function rekap_karyawan($id_karyawan, $tgl_mulai, $tgl_selesai){
        $data['list_data']  = $this->Rekap_reimburse_m->data_reimburse($id_cabang="all", $id_departemen="all", $id_karyawan, $tgl_mulai, $tgl_selesai);
        $data['karyawan']   = $karyawan;
        $data['awal']       = $tgl_mulai;
        $data['akhir']      = $tgl_selesai;
        $this->load->view('rekap_reimburse/list_karyawan', $data, false);
    }

    public function dropdown_karyawan(){
        $search = $this->input->get("q");
        $this->Rekap_reimburse_m->dropdown_karyawan($search);
    }

    private function _nm_cabang($id_cabang=null){
        $this->db->select("nama");
        $this->db->from("master_cabang");
        $this->db->where("id_cabang", $id_cabang);
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get();
        return $query->row()->nama;
    }

    private function _nm_departemen($id_departemen=null){
        $this->db->select("nama");
        $this->db->from("master_departemen");
        $this->db->where("id_departemen", $id_departemen);
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get();
        return $query->row()->nama;
    }

    private function _nm_karyawan($id_karyawan=null){
        $this->db->select("nama_lengkap");
        $this->db->from("data_karyawan");
        $this->db->where("id_departemen", $id_karyawan);
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get();
        return $query->row()->nama_lengkap;
    }

    public function download_pdf($id_cabang='all', $id_departemen='all', $id_karyawan='all', $tgl_awal='', $tgl_akhir=''){

        $title = "";
        if($id_karyawan == "-"){
            $nm_cabang = $this->_nm_cabang($id_cabang);
            $title .= "Cabang ".$nm_cabang;
            if($id_departemen == 'all'){
                $title .= " SEMUA DEPARTEMEN";
            }else{
                $nm_departemen = $this->_nm_departemen($id_departemen);
                $title .= " DEPARTEMEN ".$nm_departemen;
            }
        }else{
            if($id_karyawan == 'all'){
                $title .= " SEMUA KARYAWAN";
            }else{
                $nm_karyawan = $this->_nm_karyawan($id_karyawan);
                $title .= $nm_karyawan;
            }
        }


        $title = strtoupper($title);
        $data["title"]      = $title;
        $data["tgl_awal"]   = date_format(date_create($tgl_awal),"d-m-Y");
        $data["tgl_akhir"]  = date_format(date_create($tgl_awal),"d-m-Y");

        $file_name =  "LAPORAN_APPROVAL_REIMBURSE_".str_replace(" ","_",$title)."_".$data["tgl_awal"]."_SD_".$data["tgl_akhir"];


        $data['list_data']   = $this->Rekap_reimburse_m->data_export_reimburse($id_cabang, $id_departemen, $id_karyawan, $tgl_awal, $tgl_akhir);
        $this->logger->create_log('report_data', 'export', $this->db->last_query());

        $html = $this->load->view('rekap_reimburse/download_pdf', $data, true);
        $html = preg_replace('/>\s+</', '><', $html); //bug dompdf
        $this->load->add_package_path(APPPATH . 'third_party/dompdf/');
        require_once(APPPATH . "third_party/dompdf/dompdf_config.inc.php");
        $name   = $file_name;
        $dompdf = new DOMPDF();
        $dompdf->set_paper('A4', 'landscape');
        $dompdf->load_html($html);
        $dompdf->render();
        $dompdf->stream($name, array("Attachment" => false));
        echo $html;
    }

}
