/*
SQLyog Professional v13.1.1 (64 bit)
MySQL - 10.4.6-MariaDB : Database - absenku_master_custom
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`absenku_master_custom` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `absenku_master_custom`;

/*Table structure for table `absensi_masuk` */

DROP TABLE IF EXISTS `absensi_masuk`;

CREATE TABLE `absensi_masuk` (
  `id_absensi_masuk` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + YYYYMM + 5 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL,
  `jenis_absen` enum('reguler','shift','libur','cuti','izin','sakit') NOT NULL DEFAULT 'reguler',
  `jam_kerja` time NOT NULL,
  `jam_absen` datetime DEFAULT NULL,
  `terlambat` int(4) NOT NULL DEFAULT 0,
  `kode_absen` varchar(255) NOT NULL DEFAULT '',
  `ket_kode` varchar(255) NOT NULL DEFAULT '',
  `lokasi_absen` varchar(255) NOT NULL DEFAULT '',
  `timezone` varchar(255) NOT NULL DEFAULT '',
  `gmt` varchar(6) NOT NULL DEFAULT '',
  `latitude` varchar(30) NOT NULL DEFAULT '',
  `longitude` varchar(30) NOT NULL DEFAULT '',
  `keterangan` varchar(255) NOT NULL DEFAULT '',
  `foto` varchar(255) NOT NULL DEFAULT '',
  `cron_status` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_absensi_masuk`),
  KEY `KEY` (`id_company`,`tgl_absen`,`id_karyawan`,`kode_absen`,`jenis_absen`),
  KEY `Filter_2` (`jenis_absen`,`tgl_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `absensi_masuk` */

insert  into `absensi_masuk`(`id_absensi_masuk`,`id_karyawan`,`tgl_absen`,`jenis_absen`,`jam_kerja`,`jam_absen`,`terlambat`,`kode_absen`,`ket_kode`,`lokasi_absen`,`timezone`,`gmt`,`latitude`,`longitude`,`keterangan`,`foto`,`cron_status`,`id_company`,`tgl_input`) values 
('D23110120231100001','D2311013','2023-11-01','sakit','00:00:00','0000-00-00 00:00:00',0,'S','Sakit','','','','','','','','0','D231101','2023-11-02 15:51:37');

/*Table structure for table `absensi_pulang` */

DROP TABLE IF EXISTS `absensi_pulang`;

CREATE TABLE `absensi_pulang` (
  `id_absensi_pulang` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_masuk` varchar(50) NOT NULL DEFAULT '0' COMMENT 'absensi_masuk',
  `tgl_absen` date NOT NULL,
  `jam_kerja` time NOT NULL,
  `jam_absen` datetime NOT NULL,
  `pulang_cepat` int(4) NOT NULL COMMENT 'menit',
  `keterangan` text NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_absensi_pulang`,`id_karyawan`,`id_masuk`,`tgl_absen`,`id_company`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_masuk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `absensi_pulang` */

/*Table structure for table `captcha` */

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `captcha_id` bigint(13) unsigned NOT NULL AUTO_INCREMENT,
  `captcha_time` int(10) unsigned NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `word` varchar(20) NOT NULL,
  PRIMARY KEY (`captcha_id`),
  KEY `word` (`word`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;

/*Data for the table `captcha` */

/*Table structure for table `ci_sessions` */

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `ci_sessions` */

/*Table structure for table `dashboard_rekap_detail` */

DROP TABLE IF EXISTS `dashboard_rekap_detail`;

CREATE TABLE `dashboard_rekap_detail` (
  `id_company` int(9) NOT NULL,
  `minggu` enum('1','2','3','4','5','6') NOT NULL DEFAULT '1',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `rata2` tinyint(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`minggu`,`tgl_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `dashboard_rekap_detail` */

/*Table structure for table `dashboard_rekap_detail_dibwh_50` */

DROP TABLE IF EXISTS `dashboard_rekap_detail_dibwh_50`;

CREATE TABLE `dashboard_rekap_detail_dibwh_50` (
  `id_company` int(9) NOT NULL,
  `periode` char(7) NOT NULL,
  `id_paket` tinyint(4) NOT NULL,
  PRIMARY KEY (`id_company`,`periode`,`id_paket`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `dashboard_rekap_detail_dibwh_50` */

/*Table structure for table `dashboard_rekap_paket` */

DROP TABLE IF EXISTS `dashboard_rekap_paket`;

CREATE TABLE `dashboard_rekap_paket` (
  `id_paket` tinyint(4) NOT NULL,
  `periode` char(7) NOT NULL,
  `filter_persen` enum('100','50') NOT NULL DEFAULT '100',
  `total` tinyint(3) unsigned DEFAULT 0,
  PRIMARY KEY (`id_paket`,`periode`,`filter_persen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `dashboard_rekap_paket` */

/*Table structure for table `data_aktivitas` */

DROP TABLE IF EXISTS `data_aktivitas`;

CREATE TABLE `data_aktivitas` (
  `id_aktivitas` varchar(50) NOT NULL COMMENT 'id_company + yyyymmdd + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL,
  `keterangan` varchar(250) NOT NULL,
  `lokasi` varchar(225) NOT NULL,
  `timezone` varchar(150) NOT NULL,
  `gmt` varchar(10) NOT NULL,
  `latitude` varchar(50) NOT NULL,
  `longitude` varchar(50) NOT NULL,
  `image` varchar(225) NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_aktivitas`),
  KEY `data_aktifitas` (`id_aktivitas`,`id_karyawan`,`lokasi`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_aktivitas` */

/*Table structure for table `data_berita` */

DROP TABLE IF EXISTS `data_berita`;

CREATE TABLE `data_berita` (
  `id_berita` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit urutan angka',
  `judul` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `creator` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `gambar` varchar(255) NOT NULL,
  `posting` enum('0','1') NOT NULL DEFAULT '0',
  `tgl_posting` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `id_company` int(11) NOT NULL DEFAULT 1,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_berita`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_berita` */

/*Table structure for table `data_comment_berita` */

DROP TABLE IF EXISTS `data_comment_berita`;

CREATE TABLE `data_comment_berita` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `id_berita` int(11) NOT NULL,
  `sender` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL,
  `content` text NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id_comment`),
  KEY `data_comment_berita` (`id_comment`,`id_berita`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_comment_berita` */

/*Table structure for table `data_comment_pengumuman` */

DROP TABLE IF EXISTS `data_comment_pengumuman`;

CREATE TABLE `data_comment_pengumuman` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `id_pengumuman` int(11) NOT NULL,
  `sender` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL,
  `content` text NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id_comment`),
  KEY `data_comment_pengumuman` (`id_comment`,`id_pengumuman`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_comment_pengumuman` */

/*Table structure for table `data_fingerprint` */

DROP TABLE IF EXISTS `data_fingerprint`;

CREATE TABLE `data_fingerprint` (
  `uid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `role` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `divisi` varchar(100) NOT NULL,
  `device_id` int(11) NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`uid`),
  KEY `device_id` (`device_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_fingerprint` */

/*Table structure for table `data_fingerscanner` */

DROP TABLE IF EXISTS `data_fingerscanner`;

CREATE TABLE `data_fingerscanner` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `port` varchar(10) NOT NULL,
  `last_row` datetime NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_fingerscanner` */

/*Table structure for table `data_izin` */

DROP TABLE IF EXISTS `data_izin`;

CREATE TABLE `data_izin` (
  `id_izin` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `tgl_pengajuan` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_mulai_izin` date NOT NULL,
  `tgl_selesai_izin` date NOT NULL,
  `jml_izin` int(11) NOT NULL DEFAULT 0,
  `kode_izin` varchar(10) NOT NULL,
  `nama_izin` varchar(255) NOT NULL,
  `jenis_izin` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=tidak mengurangi cuti tahunan, 1=mengurangi cuti tahunan',
  `ket_izin` text NOT NULL,
  `approval_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `file` text NOT NULL COMMENT 'full url',
  `status` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui',
  `user_spv` varchar(255) NOT NULL,
  `user_kedep` varchar(255) NOT NULL,
  `user_kacab` varchar(255) NOT NULL,
  `user_direksi` varchar(255) NOT NULL,
  `user_hrd` varchar(255) NOT NULL,
  `tgl_apv_spv` datetime DEFAULT NULL,
  `tgl_apv_kedep` datetime DEFAULT NULL,
  `tgl_apv_kacab` datetime DEFAULT NULL,
  `tgl_apv_direksi` datetime DEFAULT NULL,
  `tgl_apv_hrd` datetime DEFAULT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_izin`) USING BTREE,
  KEY `KEY` (`id_company`,`id_karyawan`,`tgl_pengajuan`,`tgl_mulai_izin`,`tgl_selesai_izin`,`jenis_izin`,`approval_spv`,`approval_kedep`,`approval_kacab`,`approval_hrd`,`approval_direksi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_izin` */

insert  into `data_izin`(`id_izin`,`id_karyawan`,`id_cabang`,`id_departemen`,`tgl_pengajuan`,`tgl_mulai_izin`,`tgl_selesai_izin`,`jml_izin`,`kode_izin`,`nama_izin`,`jenis_izin`,`flag`,`ket_izin`,`approval_spv`,`approval_kedep`,`approval_kacab`,`approval_direksi`,`approval_hrd`,`file`,`status`,`user_spv`,`user_kedep`,`user_kacab`,`user_direksi`,`user_hrd`,`tgl_apv_spv`,`tgl_apv_kedep`,`tgl_apv_kacab`,`tgl_apv_direksi`,`tgl_apv_hrd`,`id_company`,`tgl_input`,`tgl_update`) values 
('D2311012023110001','D2311013','D231101001','D231101202210001','2023-11-02 15:51:19','2023-11-01','2023-11-01',1,'S','Sakit','sakit','0','ere','4','4','0','0','4','D231101/izin/-8b83f210-5370-452a-81f4-06554648a92a.jpg','4','','','','','D231101001',NULL,NULL,NULL,NULL,'2023-11-02 15:51:19','D231101','2023-11-02 15:51:19','2023-11-02 15:51:19');

/*Table structure for table `data_karyawan` */

DROP TABLE IF EXISTS `data_karyawan`;

CREATE TABLE `data_karyawan` (
  `id_karyawan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `nik` varchar(100) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL,
  `gelar_depan` varchar(50) NOT NULL,
  `gelar_belakang` varchar(50) NOT NULL,
  `no_ktp` varchar(20) NOT NULL,
  `npwp` varchar(20) NOT NULL DEFAULT '',
  `jenis_kelamin` enum('L','P') NOT NULL COMMENT 'L:laki-laki; perempuan',
  `golongan_darah` varchar(20) NOT NULL,
  `agama` varchar(50) NOT NULL,
  `tempat_lahir` varchar(50) NOT NULL,
  `tgl_lahir` date NOT NULL DEFAULT '0000-00-00',
  `alamat_domisili` varchar(255) NOT NULL,
  `rt` varchar(10) NOT NULL,
  `rw` varchar(10) NOT NULL,
  `id_kel` varchar(11) NOT NULL,
  `id_kec` varchar(11) NOT NULL,
  `id_kab` varchar(11) NOT NULL,
  `id_prov` varchar(11) NOT NULL,
  `kode_pos` varchar(20) NOT NULL,
  `telepon` varchar(15) NOT NULL,
  `email` varchar(50) NOT NULL,
  `tgl_aktif_bekerja` date DEFAULT '0000-00-00',
  `join_date` date NOT NULL DEFAULT '0000-00-00',
  `tgl_berhenti_bekerja` date DEFAULT '0000-00-00',
  `id_departemen` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_jabatan` varchar(50) NOT NULL,
  `supervisi` varchar(50) DEFAULT NULL,
  `jatah_cuti` int(11) NOT NULL DEFAULT 12,
  `pendidikan_terakhir` varchar(50) DEFAULT NULL,
  `grade` int(11) NOT NULL,
  `status` enum('1','2','3','4','5','6','7') NOT NULL COMMENT '1=Kontrak(Aktif); 2=Tetap(Aktif) 3=Izin Belajar(Aktif), 4=Tugas Belajar(Aktif Tidak Wajib Absen), 5=Resign, 6=Dikeluarkan (PHK), 7=Pensiun',
  `lock_lokasi` enum('0','1') NOT NULL DEFAULT '1',
  `id_lokasi` varchar(225) NOT NULL,
  `foto` varchar(255) NOT NULL,
  `no_bpjs_kes` char(13) NOT NULL DEFAULT '',
  `no_bpjs_tk` char(11) NOT NULL DEFAULT '',
  `status_perkawinan` enum('Belum Kawin','Kawin','Cerai Hidup','Cerai Mati') NOT NULL DEFAULT 'Belum Kawin',
  `jml_anak` tinyint(1) NOT NULL DEFAULT 0,
  `tanggungan` varchar(5) NOT NULL DEFAULT '' COMMENT 'relasi tabel ptkp',
  `bank_atas_nama` varchar(100) NOT NULL DEFAULT '',
  `bank_rek` varchar(30) NOT NULL DEFAULT '',
  `bank_nama` varchar(30) NOT NULL DEFAULT '',
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_karyawan`),
  KEY `KEY` (`jenis_kelamin`,`id_departemen`,`id_cabang`,`id_jabatan`,`id_company`,`lock_lokasi`,`id_lokasi`,`id_karyawan`,`nik`,`nama_lengkap`,`id_kel`,`id_kec`,`id_kab`,`id_prov`,`tgl_berhenti_bekerja`,`supervisi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_karyawan` */

insert  into `data_karyawan`(`id_karyawan`,`nik`,`nama_lengkap`,`gelar_depan`,`gelar_belakang`,`no_ktp`,`npwp`,`jenis_kelamin`,`golongan_darah`,`agama`,`tempat_lahir`,`tgl_lahir`,`alamat_domisili`,`rt`,`rw`,`id_kel`,`id_kec`,`id_kab`,`id_prov`,`kode_pos`,`telepon`,`email`,`tgl_aktif_bekerja`,`join_date`,`tgl_berhenti_bekerja`,`id_departemen`,`id_cabang`,`id_jabatan`,`supervisi`,`jatah_cuti`,`pendidikan_terakhir`,`grade`,`status`,`lock_lokasi`,`id_lokasi`,`foto`,`no_bpjs_kes`,`no_bpjs_tk`,`status_perkawinan`,`jml_anak`,`tanggungan`,`bank_atas_nama`,`bank_rek`,`bank_nama`,`id_company`,`tgl_input`,`tgl_update`) values 
('C231101001','1','ADMIN HRGA','','','','','L','','Kristen','','2020-10-08','','','','','','','','','','karyawan@gmail.com','2021-08-23','0000-00-00',NULL,'','C231101001','C231101001','',8,NULL,0,'2','1','37180','','','','Belum Kawin',0,'','','','','C231101','2022-10-04 15:09:01','2023-11-01 14:28:37'),
('C2311012','2','Example HOD','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-01','0000-00-00','1970-01-01','C231101202210001','C231101001','C231101202210002',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','C231101','2022-10-04 16:26:21','2023-11-01 14:28:37'),
('C2311013','3','Example Staff','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-02','0000-00-00','2022-12-31','C231101202210001','C231101001','C231101202210001',NULL,0,NULL,0,'1','1','','','','','Belum Kawin',0,'','','','','C231101','2022-10-04 16:26:21','2023-11-01 14:28:37'),
('C2311014','4','Example Direksi','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-03','0000-00-00','1970-01-01','','C231101001','C231101202210005',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','C231101','2022-10-04 16:26:21','2023-11-01 14:28:37'),
('C2311015','5','Example Kacab','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-04','0000-00-00','1970-01-01','','C231101001','C231101202210003',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','C231101','2022-10-04 16:26:21','2023-11-01 14:28:37'),
('C2311016','6','Admin Finance','','','','','P','','','','1970-01-01','','','','','','','','','','','2022-01-05','0000-00-00','1970-01-01','','C231101001','C231101202210004',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','C231101','2022-10-04 16:26:21','2023-11-01 14:28:37'),
('C2311017','7','Example Supervisi','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-06','0000-00-00','1970-01-01','C231101202210001','C231101001','C231101202210006',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','C231101','2022-10-04 16:26:21','2023-11-01 14:28:37'),
('D231101001','1','ADMIN HRGA','','','','','L','','Kristen','','2020-10-08','','','','','','','','','','karyawan@gmail.com','2021-08-23','0000-00-00',NULL,'','D231101001','D231101001','',8,NULL,0,'2','1','37180','','','','Belum Kawin',0,'','','','','D231101','2022-10-04 15:08:00','2023-11-01 14:28:37'),
('D2311012','2','Example HOD','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-01','0000-00-00','1970-01-01','D231101202210001','D231101001','D231101002',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','D231101','2022-10-04 16:22:31','2023-11-01 14:28:37'),
('D2311013','3','Example Staff','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-02','0000-00-00','2022-12-31','D231101202210001','D231101001','D231101003',NULL,0,NULL,0,'1','1','','','','','Belum Kawin',0,'','','','','D231101','2022-10-04 16:22:31','2023-11-01 14:28:37'),
('D2311014','4','Example Direksi','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-03','0000-00-00','1970-01-01','','D231101001','D231101004',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','D231101','2022-10-04 16:22:31','2023-11-01 14:28:37'),
('D2311015','5','Example Kacab','','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-04','0000-00-00','1970-01-01','','D231101001','D231101005',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','D231101','2022-10-04 16:22:31','2023-11-01 14:28:37'),
('D2311016','6','Admin Finance','','','','','P','','','','1970-01-01','','','','','','','','','','','2022-01-05','0000-00-00','1970-01-01','','D231101001','D231101006',NULL,0,NULL,0,'2','1','','','','','Belum Kawin',0,'','','','','D231101','2022-10-04 16:13:41','2023-11-01 14:28:37'),
('D2311017','7','Example Supervisi','','','','','L','','Islam','','1970-01-01','','','','','','','','','','','2022-01-06','2023-11-01','1970-01-01','D231101202210001','D231101001','D231101007','',0,'',0,'2','1','','D231101/karyawan/D2311017/profil/7-21609269-b666-47fb-b84e-2bf10dfc655c.jpg','','','Belum Kawin',0,'','','','','D231101','2022-10-04 16:22:31','2023-11-02 15:38:39');

/*Table structure for table `data_karyawan_temp` */

DROP TABLE IF EXISTS `data_karyawan_temp`;

CREATE TABLE `data_karyawan_temp` (
  `id_temp` varchar(50) NOT NULL,
  `id_user` int(11) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_karyawan` varchar(100) NOT NULL,
  `nik` varchar(50) DEFAULT NULL,
  `nama_lengkap` varchar(50) NOT NULL,
  `gelar_belakang` varchar(50) DEFAULT NULL,
  `gelar_depan` varchar(50) DEFAULT NULL,
  `no_ktp` varchar(50) DEFAULT NULL,
  `jenis_kelamin` varchar(1) DEFAULT NULL,
  `golongan_darah` varchar(20) DEFAULT NULL,
  `agama` varchar(50) DEFAULT NULL,
  `tempat_lahir` varchar(50) DEFAULT NULL,
  `tgl_lahir` date DEFAULT NULL,
  `alamat_domisili` varchar(255) DEFAULT NULL,
  `telepon` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `tgl_aktif_bekerja` date DEFAULT NULL,
  `tgl_berhenti_bekerja` date DEFAULT NULL,
  `id_departemen` varchar(50) DEFAULT NULL,
  `id_cabang` varchar(50) DEFAULT NULL,
  `id_jabatan` varchar(50) DEFAULT NULL,
  `supervisi` varchar(50) DEFAULT NULL,
  `jatah_cuti` int(11) DEFAULT NULL,
  `pendidikan_terakhir` varchar(50) DEFAULT NULL,
  `status` smallint(6) DEFAULT NULL,
  `lock_lokasi` int(11) NOT NULL DEFAULT 0,
  `id_lokasi` varchar(255) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(200) DEFAULT NULL,
  `id_company` varchar(50) DEFAULT NULL,
  `flag` enum('1','2') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid',
  `user_input` varchar(100) NOT NULL,
  PRIMARY KEY (`id_temp`),
  KEY `id` (`id_karyawan`),
  KEY `id_2` (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_karyawan_temp` */

/*Table structure for table `data_kelengkapan_file` */

DROP TABLE IF EXISTS `data_kelengkapan_file`;

CREATE TABLE `data_kelengkapan_file` (
  `id_kelengkapan_file` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_dokumen` text NOT NULL,
  `file` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tanggal_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tanggal_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_kelengkapan_file`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_kelengkapan_file` */

insert  into `data_kelengkapan_file`(`id_kelengkapan_file`,`id_karyawan`,`nama_dokumen`,`file`,`id_company`,`tanggal_input`,`tanggal_update`) values 
('D2311012023110001','D2311017','asa','D231101/karyawan/D2311017/kelengkapan-file/065f2c53-55c6-462e-9cb1-be53c49786f2.png','D231101','2023-11-02 15:33:40','0000-00-00 00:00:00');

/*Table structure for table `data_keluarga` */

DROP TABLE IF EXISTS `data_keluarga`;

CREATE TABLE `data_keluarga` (
  `id_keluarga` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama` varchar(250) NOT NULL,
  `tempat_lahir` varchar(250) NOT NULL,
  `tanggal_lahir` date NOT NULL,
  `jenis_kelamin` enum('L','P') DEFAULT NULL,
  `agama` varchar(50) DEFAULT NULL,
  `telepon` varchar(15) NOT NULL,
  `pekerjaan` varchar(100) NOT NULL,
  `hub_keluarga` varchar(100) DEFAULT NULL,
  `status_perkawinan` varchar(100) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `no_bpjs` int(11) NOT NULL,
  `pendidikan_terakhir` varchar(20) NOT NULL,
  `tanggal_perkawinan` date NOT NULL,
  `status` varchar(100) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_keluarga`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_keluarga` */

/*Table structure for table `data_lokasi_kantor` */

DROP TABLE IF EXISTS `data_lokasi_kantor`;

CREATE TABLE `data_lokasi_kantor` (
  `id_lokasi_kantor` varchar(25) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `nama_kantor` varchar(250) NOT NULL,
  `lat_asli` varchar(250) NOT NULL,
  `lat_min` varchar(250) NOT NULL,
  `lat_max` varchar(250) NOT NULL,
  `long_asli` varchar(250) NOT NULL,
  `long_min` varchar(250) NOT NULL,
  `long_max` varchar(250) NOT NULL,
  `jarak` int(11) NOT NULL,
  `id_cabang` varchar(25) NOT NULL,
  `id_company` varchar(25) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = pusat; 1 = cabang',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_lokasi_kantor`),
  KEY `data_lok_kantor` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_lokasi_kantor` */

insert  into `data_lokasi_kantor`(`id_lokasi_kantor`,`nama_kantor`,`lat_asli`,`lat_min`,`lat_max`,`long_asli`,`long_min`,`long_max`,`jarak`,`id_cabang`,`id_company`,`flag`,`tgl_input`) values 
('C231101202210001','Absenku','-7.076522668502462','-7.0774219901084','-7.0756233468965','110.4165194866117','110.41742571138','110.41561326184',100,'C231101001','C231101','1','2022-10-04 15:31:41'),
('D231101202210001','Absenku','-7.076511864418034','-7.077411186024','-7.0756125428121','110.41648492006428','110.41739114482','110.41557869531',100,'D231101001','D231101','1','2022-10-04 15:45:56');

/*Table structure for table `data_marketing` */

DROP TABLE IF EXISTS `data_marketing`;

CREATE TABLE `data_marketing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `urutan` enum('ya','tidak') NOT NULL DEFAULT 'tidak' COMMENT 'Ya : marketing terakhir yang mendapatkan jatah calon pelanggan, tidak : belum mendapat jatah calon pelanggan',
  `status` enum('aktif','nonaktif') DEFAULT 'aktif' COMMENT 'aktif: marketing aktif; nonaktif: marketing tidak aktif',
  `email` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

/*Data for the table `data_marketing` */

/*Table structure for table `data_pengumuman` */

DROP TABLE IF EXISTS `data_pengumuman`;

CREATE TABLE `data_pengumuman` (
  `id_pengumuman` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `target` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1: Semua Karyawan, 2:Per Cabang: 3: Per Departemen, 4: Per Karyawan',
  `target_id` text NOT NULL,
  `id_cabang` varchar(255) NOT NULL,
  `judul` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `creator` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `posting` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:Belum Posting, 1:Sudah diposting',
  `tgl_posting` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_pengumuman`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_pengumuman` */

/*Table structure for table `data_sertifikat` */

DROP TABLE IF EXISTS `data_sertifikat`;

CREATE TABLE `data_sertifikat` (
  `id_sertifikat` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sertifikat` varchar(255) NOT NULL,
  `penyelenggara` varchar(255) NOT NULL,
  `tgl_berlaku` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `deskripsi` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_sertifikat`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_sertifikat` */

insert  into `data_sertifikat`(`id_sertifikat`,`id_karyawan`,`nama_sertifikat`,`penyelenggara`,`tgl_berlaku`,`tgl_berakhir`,`deskripsi`,`file`,`id_company`,`tgl_input`) values 
('D2311012023110001','D2311017','xcx','xcxc','2023-11-02','2023-11-02','asas','D231101/karyawan/D2311017/sertifikat/ac6b36a0-017d-4a70-925d-634ae5cf6a86.png','D231101','2023-11-02 15:33:21');

/*Table structure for table `data_shift_karyawan` */

DROP TABLE IF EXISTS `data_shift_karyawan`;

CREATE TABLE `data_shift_karyawan` (
  `id_shift_karyawan` varchar(100) NOT NULL,
  `tanggal` date NOT NULL,
  `id_karyawan` varchar(255) NOT NULL,
  `id_master_shift` varchar(50) NOT NULL,
  `id_cabang` varchar(50) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `id_departemen` varchar(50) DEFAULT NULL,
  `user_input` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_shift_karyawan`),
  KEY `data_shift_karyawan` (`id_master_shift`,`id_karyawan`,`tanggal`,`id_company`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_shift_karyawan` */

/*Table structure for table `data_shift_karyawan_temp` */

DROP TABLE IF EXISTS `data_shift_karyawan_temp`;

CREATE TABLE `data_shift_karyawan_temp` (
  `id` varchar(255) NOT NULL,
  `tanggal` date NOT NULL,
  `id_karyawan` varchar(255) NOT NULL,
  `id_master_shift` varchar(50) NOT NULL,
  `flag` enum('1','2','3','4') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid, 3=tgl shift kadaluarsa, 4=data berhasil di simpan',
  `user_input` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `data_shift_karyawan` (`id_master_shift`,`id_karyawan`,`tanggal`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_shift_karyawan_temp` */

/*Table structure for table `file_izin` */

DROP TABLE IF EXISTS `file_izin`;

CREATE TABLE `file_izin` (
  `id_izin` varchar(50) DEFAULT NULL,
  `file` text DEFAULT NULL COMMENT 'full url',
  `id_company` varchar(20) DEFAULT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `file_izin` */

insert  into `file_izin`(`id_izin`,`file`,`id_company`,`tgl_input`,`tgl_update`) values 
('D2311012023110001','D231101/izin/-8b83f210-5370-452a-81f4-06554648a92a.jpg','D231101','2023-11-02 15:51:19','2023-11-02 15:51:19');

/*Table structure for table `h_cuti` */

DROP TABLE IF EXISTS `h_cuti`;

CREATE TABLE `h_cuti` (
  `tahun` varchar(4) NOT NULL,
  `id_karyawan` varchar(255) NOT NULL,
  `nama_karyawan` varchar(100) NOT NULL,
  `jml_cuti` int(3) NOT NULL,
  `kode_reset` varchar(255) NOT NULL DEFAULT '1',
  `user_reset` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `h_cuti` */

/*Table structure for table `harga_per_user_m` */

DROP TABLE IF EXISTS `harga_per_user_m`;

CREATE TABLE `harga_per_user_m` (
  `min` smallint(5) unsigned NOT NULL,
  `max` smallint(5) unsigned NOT NULL,
  `harga` smallint(5) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `harga_per_user_m` */

/*Table structure for table `hari` */

DROP TABLE IF EXISTS `hari`;

CREATE TABLE `hari` (
  `id` int(11) NOT NULL,
  `nama` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hari` */

insert  into `hari`(`id`,`nama`) values 
(7,'Minggu'),
(1,'Senin'),
(2,'Selasa'),
(3,'Rabu'),
(4,'Kamis'),
(5,'Jumat'),
(6,'Sabtu');

/*Table structure for table `history_jabatan` */

DROP TABLE IF EXISTS `history_jabatan`;

CREATE TABLE `history_jabatan` (
  `id_history_jabatan` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` varchar(11) NOT NULL,
  `id_jabatan` int(11) NOT NULL,
  `id_divisi` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `id_company` int(11) NOT NULL,
  PRIMARY KEY (`id_history_jabatan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `history_jabatan` */

/*Table structure for table `holidays` */

DROP TABLE IF EXISTS `holidays`;

CREATE TABLE `holidays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `keterangan` varchar(255) NOT NULL,
  `id_company` int(11) NOT NULL,
  `color` varchar(11) DEFAULT '#8A2BE2',
  PRIMARY KEY (`id`),
  KEY `holidays` (`tanggal`,`id_company`)
) ENGINE=InnoDB AUTO_INCREMENT=16912 DEFAULT CHARSET=latin1;

/*Data for the table `holidays` */

/*Table structure for table `informasi_gaji` */

DROP TABLE IF EXISTS `informasi_gaji`;

CREATE TABLE `informasi_gaji` (
  `id` varchar(50) NOT NULL,
  `periode` varchar(8) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(150) NOT NULL,
  `kode_cabang` varchar(10) NOT NULL,
  `nama_cabang` varchar(150) NOT NULL,
  `kode_departemen` varchar(10) NOT NULL,
  `nama_departemen` varchar(150) NOT NULL,
  `kode_jabatan` varchar(10) NOT NULL,
  `nama_jabatan` varchar(150) NOT NULL,
  `gaji_pokok` int(11) NOT NULL DEFAULT 0,
  `t_jabatan` int(11) NOT NULL DEFAULT 0,
  `t_transport` int(11) NOT NULL DEFAULT 0,
  `t_makan` int(11) NOT NULL DEFAULT 0,
  `t_istri` int(11) NOT NULL DEFAULT 0,
  `t_anak` int(11) NOT NULL DEFAULT 0,
  `lembur` int(11) NOT NULL DEFAULT 0,
  `komisi` int(11) NOT NULL DEFAULT 0,
  `t_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0,
  `ttl_penerimaan` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `tbp_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tbp` int(11) NOT NULL DEFAULT 0,
  `p_absensi` int(11) NOT NULL DEFAULT 0,
  `p_keterlambatan` int(11) NOT NULL DEFAULT 0,
  `p_koperasi` int(11) NOT NULL DEFAULT 0,
  `p_asuransi_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` int(11) NOT NULL DEFAULT 0,
  `gaji_diterima` int(11) NOT NULL DEFAULT 0,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_input` varchar(50) NOT NULL,
  `publish` enum('0','1') NOT NULL DEFAULT '0',
  `tgl_publish` datetime DEFAULT NULL,
  `user_publish` varchar(50) DEFAULT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `informasi_gaji` */

/*Table structure for table `informasi_gaji_temp` */

DROP TABLE IF EXISTS `informasi_gaji_temp`;

CREATE TABLE `informasi_gaji_temp` (
  `id` varchar(50) NOT NULL,
  `periode` varchar(8) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(150) NOT NULL,
  `kode_cabang` varchar(10) NOT NULL,
  `nama_cabang` varchar(150) NOT NULL,
  `kode_departemen` varchar(10) NOT NULL,
  `nama_departemen` varchar(150) NOT NULL,
  `kode_jabatan` varchar(10) NOT NULL,
  `nama_jabatan` varchar(150) NOT NULL,
  `gaji_pokok` int(11) NOT NULL DEFAULT 0,
  `t_jabatan` int(11) NOT NULL DEFAULT 0,
  `t_transport` int(11) NOT NULL DEFAULT 0,
  `t_makan` int(11) NOT NULL DEFAULT 0,
  `t_istri` int(11) NOT NULL DEFAULT 0,
  `t_anak` int(11) NOT NULL DEFAULT 0,
  `lembur` int(11) NOT NULL DEFAULT 0,
  `komisi` int(11) NOT NULL DEFAULT 0,
  `t_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0,
  `ttl_penerimaan` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `tbp_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tbp` int(11) NOT NULL DEFAULT 0,
  `p_absensi` int(11) NOT NULL DEFAULT 0,
  `p_keterlambatan` int(11) NOT NULL DEFAULT 0,
  `p_koperasi` int(11) NOT NULL DEFAULT 0,
  `p_asuransi_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` int(11) NOT NULL DEFAULT 0,
  `gaji_diterima` int(11) NOT NULL DEFAULT 0,
  `flag` enum('1','2','3') NOT NULL DEFAULT '2' COMMENT '1: Data Valid, 2: Data tidak lengkap, 3:Data sudah ada',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_input` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `informasi_gaji_temp` */

/*Table structure for table `istirahat_mulai` */

DROP TABLE IF EXISTS `istirahat_mulai`;

CREATE TABLE `istirahat_mulai` (
  `id_istmulai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_absensi_masuk` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_istmulai`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_absensi_masuk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `istirahat_mulai` */

/*Table structure for table `istirahat_selesai` */

DROP TABLE IF EXISTS `istirahat_selesai`;

CREATE TABLE `istirahat_selesai` (
  `id_istselesai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_absensi_masuk` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_istselesai`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_absensi_masuk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `istirahat_selesai` */

/*Table structure for table `jam_kerja` */

DROP TABLE IF EXISTS `jam_kerja`;

CREATE TABLE `jam_kerja` (
  `id_jam_kerja` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `libur` int(11) NOT NULL DEFAULT 0 COMMENT '0=masuk; 1=libur',
  `hari` int(11) NOT NULL COMMENT '1=senin; 7=minggu',
  `masuk` time NOT NULL,
  `pulang` time NOT NULL,
  `start_absen_masuk` time NOT NULL,
  `batas_absen_pulang` time NOT NULL,
  `fleksitime` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:true; 1:false',
  `min_masuk` time NOT NULL DEFAULT '00:00:00',
  `max_masuk` time NOT NULL DEFAULT '00:00:00',
  `jml_jamkerja` smallint(2) NOT NULL DEFAULT 8,
  `id_cabang` varchar(20) NOT NULL,
  `id_company` varchar(20) NOT NULL,
  PRIMARY KEY (`id_jam_kerja`),
  KEY `jadwal_kerja` (`hari`,`id_company`,`id_cabang`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `jam_kerja` */

insert  into `jam_kerja`(`id_jam_kerja`,`libur`,`hari`,`masuk`,`pulang`,`start_absen_masuk`,`batas_absen_pulang`,`fleksitime`,`min_masuk`,`max_masuk`,`jml_jamkerja`,`id_cabang`,`id_company`) values 
('C231101001',0,1,'08:00:00','17:00:00','00:00:00','23:59:00','0','00:00:00','00:00:00',8,'C231101001','C231101'),
('C231101002',0,2,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C231101001','C231101'),
('C231101003',0,3,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C231101001','C231101'),
('C231101004',0,4,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C231101001','C231101'),
('C231101005',0,5,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C231101001','C231101'),
('C231101006',0,6,'00:08:00','00:14:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C231101001','C231101'),
('C231101007',1,7,'08:00:00','17:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',8,'C231101001','C231101'),
('D231101001',0,1,'08:00:00','17:00:00','00:00:00','23:59:00','0','00:00:00','00:00:00',8,'D231101001','D231101'),
('D231101002',0,2,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D231101001','D231101'),
('D231101003',0,3,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D231101001','D231101'),
('D231101004',0,4,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D231101001','D231101'),
('D231101005',0,5,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D231101001','D231101'),
('D231101006',0,6,'00:08:00','00:14:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D231101001','D231101'),
('D231101007',1,7,'08:00:00','17:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',8,'D231101001','D231101');

/*Table structure for table `jenis_pelanggan` */

DROP TABLE IF EXISTS `jenis_pelanggan`;

CREATE TABLE `jenis_pelanggan` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `jenis_pelanggan` */

/*Table structure for table `karir_pekerjaan` */

DROP TABLE IF EXISTS `karir_pekerjaan`;

CREATE TABLE `karir_pekerjaan` (
  `id_karir_pekerjaan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `nomor_surat_keputusan` varchar(250) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `kode_jabatan` varchar(50) NOT NULL,
  `nama_jabatan` varchar(255) NOT NULL,
  `kode_cabang` varchar(50) NOT NULL,
  `nama_cabang` varchar(255) NOT NULL,
  `kode_departemen` varchar(50) NOT NULL,
  `nama_departemen` varchar(255) NOT NULL,
  `tgl_mulai` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `status` enum('1','2','3','') NOT NULL COMMENT '1: Kontrak; 2: Tetap; 3: Promosi',
  `keterangan_status` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `karir_pekerjaan` */

/*Table structure for table `kep_departemen` */

DROP TABLE IF EXISTS `kep_departemen`;

CREATE TABLE `kep_departemen` (
  `id_kep_departemen` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_kep_departemen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `kep_departemen` */

/*Table structure for table `lembur_mulai` */

DROP TABLE IF EXISTS `lembur_mulai`;

CREATE TABLE `lembur_mulai` (
  `id_lemmulai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(150) NOT NULL,
  `gmt` varchar(100) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(255) NOT NULL,
  `approve` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=Pengajuan Lembur, 2=Ditolak, 3=Disetujui',
  `status` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `user_spv` varchar(255) NOT NULL,
  `user_kedep` varchar(255) DEFAULT NULL,
  `user_kacab` varchar(255) DEFAULT NULL,
  `user_hrd` varchar(255) DEFAULT NULL,
  `user_direksi` varchar(255) DEFAULT NULL,
  `tgl_apv_spv` datetime DEFAULT NULL,
  `tgl_apv_kedep` datetime DEFAULT NULL,
  `tgl_apv_kacab` datetime DEFAULT NULL,
  `tgl_apv_hrd` datetime DEFAULT NULL,
  `tgl_apv_direksi` datetime DEFAULT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lemmulai`,`user_spv`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`approve`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `lembur_mulai` */

/*Table structure for table `lembur_selesai` */

DROP TABLE IF EXISTS `lembur_selesai`;

CREATE TABLE `lembur_selesai` (
  `id_lemselesai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_lemmulai` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(250) NOT NULL,
  `timezone` varchar(150) NOT NULL,
  `gmt` varchar(100) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lemselesai`),
  KEY `lembur_selesai` (`id_karyawan`,`tgl_absen`,`id_company`,`id_lemmulai`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `lembur_selesai` */

/*Table structure for table `log_aktivitas` */

DROP TABLE IF EXISTS `log_aktivitas`;

CREATE TABLE `log_aktivitas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL DEFAULT current_timestamp(),
  `modul` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `query` text NOT NULL,
  `id_company` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36536 DEFAULT CHARSET=latin1;

/*Data for the table `log_aktivitas` */

/*Table structure for table `log_notifikasi` */

DROP TABLE IF EXISTS `log_notifikasi`;

CREATE TABLE `log_notifikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `waktu` datetime NOT NULL,
  `modul` varchar(50) NOT NULL,
  `query` text NOT NULL,
  `id_karyawan` varchar(20) NOT NULL,
  `status` int(11) NOT NULL,
  `id_company` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `log_notifikasi` (`id`,`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `log_notifikasi` */

/*Table structure for table `log_notifikasi_trial` */

DROP TABLE IF EXISTS `log_notifikasi_trial`;

CREATE TABLE `log_notifikasi_trial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` int(9) NOT NULL COMMENT 'master_company.id_company',
  `id_paket` varchar(2) NOT NULL DEFAULT '2',
  `nama_company` varchar(100) NOT NULL COMMENT 'master_company.nama',
  `nama_customer` varchar(100) NOT NULL COMMENT 'master_customer.nama',
  `email` varchar(100) NOT NULL COMMENT 'master_customer.email',
  `telepon` varchar(50) NOT NULL COMMENT 'master_customer.telp',
  `feedback` enum('-','extend','positif','negatif') NOT NULL DEFAULT '-',
  `feedback_hplus8` enum('-','extend','positif','negatif') DEFAULT '-',
  `catatan` varchar(300) DEFAULT '-',
  `waktu` datetime NOT NULL COMMENT 'YYYY-mm-dd HH:ii:ss',
  `waktu_hplus8` date DEFAULT NULL,
  `id_wablas` char(50) NOT NULL COMMENT 'id dari hasil pengirima pesan pada API wablas',
  `id_wablas_hplus8` char(50) DEFAULT NULL,
  `status` enum('-','0','1','2','3','4','5') NOT NULL DEFAULT '-' COMMENT '-: belum ada action, 0: gagal terkirim ke dewa, 1: terkirim ke dewa, 2: sent(centang 1), 3: delivered(centang 2), 4: read(centang 2 biru), 5: failed',
  `status_hplus8` enum('-','0','1','2','3','4','5') NOT NULL DEFAULT '-' COMMENT '-: belum ada action, 0: gagal terkirim ke dewa, 1: terkirim ke dewa, 2: sent(centang 1), 3: delivered(centang 2), 4: read(centang 2 biru), 5: failed',
  `tanggal_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7117 DEFAULT CHARSET=latin1 COMMENT='menyimpan list perusahaan pengguna paket absenku trial yang sudah dikirim notifikasi wablas h-2 masa layanan berakhir';

/*Data for the table `log_notifikasi_trial` */

/*Table structure for table `log_otp` */

DROP TABLE IF EXISTS `log_otp`;

CREATE TABLE `log_otp` (
  `message_id` varchar(20) NOT NULL,
  `device_id` varchar(40) NOT NULL,
  `phone_number` varchar(15) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `response` text DEFAULT NULL,
  `tgl_input` datetime NOT NULL DEFAULT current_timestamp(),
  `last_row` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`message_id`,`status`,`tgl_input`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `log_otp` */

/*Table structure for table `m_pengaduan` */

DROP TABLE IF EXISTS `m_pengaduan`;

CREATE TABLE `m_pengaduan` (
  `id_pengaduan` int(11) NOT NULL AUTO_INCREMENT,
  `id_kategori` int(11) NOT NULL,
  `id_topik` int(11) NOT NULL,
  `id_wali` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `date` datetime NOT NULL,
  `id_company` int(11) DEFAULT 1,
  `flag` enum('0','1') NOT NULL DEFAULT '1' COMMENT '0 = karyawan; 1 = admin',
  `cek` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = belum di buka; 1 = sudah di buka',
  PRIMARY KEY (`id_pengaduan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `m_pengaduan` */

/*Table structure for table `m_version` */

DROP TABLE IF EXISTS `m_version`;

CREATE TABLE `m_version` (
  `current_version` varchar(10) NOT NULL,
  `descr` text NOT NULL,
  `cons_apps` enum('1','0') DEFAULT NULL COMMENT '0:skip update; 1: wajib update',
  KEY `current_version` (`current_version`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `m_version` */

/*Table structure for table `master_cabang` */

DROP TABLE IF EXISTS `master_cabang`;

CREATE TABLE `master_cabang` (
  `id_cabang` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `kode` varchar(50) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `flag` enum('1','2') NOT NULL DEFAULT '1' COMMENT '1 = pusat, 2 = cabang',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_cabang`),
  KEY `id` (`id_company`,`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_cabang` */

insert  into `master_cabang`(`id_cabang`,`kode`,`nama`,`flag`,`id_company`,`tgl_input`) values 
('C231101001','PST','PUSAT','1','C231101','2022-10-04 15:03:28'),
('D231101001','PST','PUSAT','1','D231101','2022-10-04 15:03:08');

/*Table structure for table `master_company` */

DROP TABLE IF EXISTS `master_company`;

CREATE TABLE `master_company` (
  `id_company` varchar(50) NOT NULL COMMENT 'tahun + 5 digit nomor urut',
  `nama` varchar(100) NOT NULL,
  `deskripsi` text NOT NULL,
  `alamat` varchar(255) NOT NULL,
  `url_logo` varchar(255) NOT NULL,
  `url_icon` varchar(255) NOT NULL,
  `themes` int(11) NOT NULL,
  `id_customer` int(11) NOT NULL,
  `id_tb_paket` int(11) NOT NULL DEFAULT 5,
  `zona_waktu` int(11) NOT NULL DEFAULT 1,
  `flag` int(11) NOT NULL DEFAULT 0 COMMENT '0:Tidak Aktif, 1;Aktif',
  `payroll` int(11) NOT NULL DEFAULT 0,
  `flag1` enum('0','1') NOT NULL DEFAULT '0',
  `id_induk` bigint(20) unsigned DEFAULT NULL,
  `custom_jumlah_karyawan` int(11) NOT NULL DEFAULT 0,
  `lock_device` enum('0','1') NOT NULL DEFAULT '0',
  `lock_lokasi` enum('0','1') NOT NULL DEFAULT '1',
  `lock_facerecognition` enum('0','1') NOT NULL DEFAULT '0',
  `jenis_perusahaan` tinyint(4) NOT NULL COMMENT '1 = Perusahaan;\r\n2 = Hotel;\r\n3 = Warnet/Game Center;\r\n4 = Sekolah / Perguruan Tinggi;\r\n5 = Dinas / Pemerintahan;\r\n6 = Personal;\r\n7 = Lainnya;',
  `npwp` varchar(20) NOT NULL,
  `jenis_registrasi` enum('generik','custom') NOT NULL DEFAULT 'generik',
  `skema_pembayaran` enum('reguler','bayar_langsung','bonus_+1','per_user') NOT NULL DEFAULT 'reguler',
  `source` varchar(255) DEFAULT NULL,
  `landingpage` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `id_marketing` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_company`),
  KEY `KEY` (`nama`,`id_tb_paket`,`id_customer`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_company` */

insert  into `master_company`(`id_company`,`nama`,`deskripsi`,`alamat`,`url_logo`,`url_icon`,`themes`,`id_customer`,`id_tb_paket`,`zona_waktu`,`flag`,`payroll`,`flag1`,`id_induk`,`custom_jumlah_karyawan`,`lock_device`,`lock_lokasi`,`lock_facerecognition`,`jenis_perusahaan`,`npwp`,`jenis_registrasi`,`skema_pembayaran`,`source`,`landingpage`,`url`,`id_marketing`) values 
('C231101','Custom','Custom','Karangrejo, Banyumanik, Semarang','21866/logo-perusahaan/21866-c62e68f1-3d76-4d91-b39f-0a17496a3ade.jpg','',0,1,202108007,1,1,0,'0',NULL,0,'0','0','0',7,'','custom','reguler',NULL,NULL,NULL,NULL),
('D231101','Developer','Developer Aplikasi Online Masa Kini','Karangrejo, Banyumanik, Semarang','21866/logo-perusahaan/21866-c62e68f1-3d76-4d91-b39f-0a17496a3ade.jpg','',0,2,202108007,1,1,0,'0',NULL,0,'0','0','0',7,'','custom','reguler',NULL,NULL,NULL,NULL);

/*Table structure for table `master_customer` */

DROP TABLE IF EXISTS `master_customer`;

CREATE TABLE `master_customer` (
  `id_customer` varchar(15) NOT NULL COMMENT 'tahun + 5 digit nomor urut',
  `nama` varchar(100) NOT NULL,
  `propinsi` varchar(255) DEFAULT NULL,
  `kota` varchar(255) DEFAULT NULL,
  `alamat` varchar(255) NOT NULL,
  `tgl_lahir` date NOT NULL,
  `email` varchar(100) NOT NULL,
  `telp` varchar(50) NOT NULL,
  `jml_kry_regist` mediumint(5) NOT NULL DEFAULT 0 COMMENT 'jumlah karyawan dalam perusahaan saat isi form registrasi',
  `id_tujuan` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'relasi tabel tujuan_menggunakan',
  `login` int(11) NOT NULL DEFAULT 1,
  `hash` varchar(11) NOT NULL,
  PRIMARY KEY (`id_customer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_customer` */

insert  into `master_customer`(`id_customer`,`nama`,`propinsi`,`kota`,`alamat`,`tgl_lahir`,`email`,`telp`,`jml_kry_regist`,`id_tujuan`,`login`,`hash`) values 
('1','karyawan','33','3374','Semarang','2018-01-01','karyawan@gmail.com','08123999321',0,0,1,'PJ05SM'),
('2','karyawan','33','3374','Semarang','2018-01-01','karyawan@gmail.com','08123999321',0,0,1,'PJ05SM');

/*Table structure for table `master_departemen` */

DROP TABLE IF EXISTS `master_departemen`;

CREATE TABLE `master_departemen` (
  `id_departemen` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 3 digit number',
  `kode` varchar(50) NOT NULL,
  `nama` varchar(225) NOT NULL,
  `jenis` enum('HR','Finance','','') DEFAULT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_departemen`),
  KEY `KEY` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_departemen` */

insert  into `master_departemen`(`id_departemen`,`kode`,`nama`,`jenis`,`id_company`,`tgl_input`) values 
('C231101202210001','MKT','Marketing',NULL,'C231101','2022-10-04 15:27:36'),
('D231101202210001','MKT','Marketing',NULL,'D231101','2022-10-04 15:44:17');

/*Table structure for table `master_grade` */

DROP TABLE IF EXISTS `master_grade`;

CREATE TABLE `master_grade` (
  `id_grade` int(11) NOT NULL AUTO_INCREMENT,
  `grade` varchar(100) DEFAULT NULL,
  `gaji` varchar(9) DEFAULT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id_grade`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_grade` */

/*Table structure for table `master_jabatan` */

DROP TABLE IF EXISTS `master_jabatan`;

CREATE TABLE `master_jabatan` (
  `id_jabatan` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `kode_jabatan` varchar(15) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `level_user` smallint(2) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_jabatan`),
  KEY `indexy` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_jabatan` */

insert  into `master_jabatan`(`id_jabatan`,`kode_jabatan`,`nama`,`level_user`,`id_company`,`tgl_input`) values 
('C231101001','ADM-HRD','ADMIN HRGA',1,'C231101','2022-10-04 15:06:45'),
('C231101202210001','STF','Staff',3,'C231101','2022-10-04 15:27:55'),
('C231101202210002','HOD','Kepala Departemen',2,'C231101','2022-10-04 15:28:15'),
('C231101202210003','KACAB','Kepala Cabang',5,'C231101','2022-10-04 15:28:27'),
('C231101202210004','ADM-FIN','Finance',6,'C231101','2022-10-04 15:28:58'),
('C231101202210005','DIR','Direksi',4,'C231101','2022-10-04 15:29:10'),
('C231101202210006','SPV','Supervisi',7,'C231101','2022-10-04 15:29:32'),
('D231101001','ADM-HRD','ADMIN HRGA',1,'D231101','2022-10-04 15:05:35'),
('D231101002','HOD','Kepala Departemen',2,'D231101','2022-10-04 15:05:43'),
('D231101003','STF','Pegawai',3,'D231101','2022-10-04 15:05:50'),
('D231101004','DIR','Direksi',4,'D231101','2022-10-04 15:06:01'),
('D231101005','KACAB','kepala Cabang',5,'D231101','2022-10-04 15:06:11'),
('D231101006','ADM-FIN','ADMIN FINANCE',6,'D231101','2022-10-04 15:06:20'),
('D231101007','SPV','Supervisi',7,'D231101','2022-10-04 15:06:27');

/*Table structure for table `master_jenis_izin` */

DROP TABLE IF EXISTS `master_jenis_izin`;

CREATE TABLE `master_jenis_izin` (
  `id_jenis_izin` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `kode_izin` varchar(5) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis_izin` enum('sakit','izin','cuti') NOT NULL DEFAULT 'cuti',
  `max_izin` varchar(3) NOT NULL COMMENT 'satuan hari',
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0; tidak mengurangi cuti tahunan, 1; mengurangi cuti tahunan',
  `id_company` varchar(9) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_jenis_izin`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_jenis_izin` */

insert  into `master_jenis_izin`(`id_jenis_izin`,`kode_izin`,`nama`,`jenis_izin`,`max_izin`,`flag`,`id_company`,`tgl_input`) values 
('C231101202210001','C','Cuti','cuti','3','1','C231101','2022-10-04 15:34:41'),
('C231101202210002','S','Sakit','sakit','','0','C231101','2022-10-04 15:35:03'),
('C231101202210003','I','Izin','izin','','0','C231101','2022-10-04 15:35:18'),
('D231101202210001','C','Cuti','cuti','3','1','D231101','2022-10-04 15:46:31'),
('D231101202210002','S','Sakit','sakit','','0','D231101','2022-10-04 15:46:48'),
('D231101202210003','I','Izin','izin','','0','D231101','2022-10-04 15:47:07');

/*Table structure for table `master_kecamatan` */

DROP TABLE IF EXISTS `master_kecamatan`;

CREATE TABLE `master_kecamatan` (
  `id_kecamatan` int(6) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_kota` int(4) DEFAULT NULL,
  PRIMARY KEY (`id_kecamatan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_kecamatan` */

/*Table structure for table `master_kelurahan` */

DROP TABLE IF EXISTS `master_kelurahan`;

CREATE TABLE `master_kelurahan` (
  `id_kelurahan` varchar(10) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_kecamatan` int(6) DEFAULT NULL,
  PRIMARY KEY (`id_kelurahan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_kelurahan` */

/*Table structure for table `master_komponen_paket` */

DROP TABLE IF EXISTS `master_komponen_paket`;

CREATE TABLE `master_komponen_paket` (
  `id_komponen_paket` varchar(50) NOT NULL COMMENT 'id_company + 5 digit nomor urut',
  `kode_komponen` varchar(50) NOT NULL,
  `nama_komponen` varchar(255) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:tidak aktfi; 1:aktif',
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_komponen_paket`),
  KEY `KEY` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_komponen_paket` */

/*Table structure for table `master_kota` */

DROP TABLE IF EXISTS `master_kota`;

CREATE TABLE `master_kota` (
  `id_kota` int(4) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_prov` int(2) DEFAULT NULL,
  PRIMARY KEY (`id_kota`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_kota` */

/*Table structure for table `master_paket` */

DROP TABLE IF EXISTS `master_paket`;

CREATE TABLE `master_paket` (
  `id_paket` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `tarif` float NOT NULL,
  `komponen_web` varchar(255) NOT NULL COMMENT '1= Master Cabang, 2= Master Departemen, 3= Master jabatan, 4= Master lokasi, 5= Shift (master shift dan jadwal shift), 6= Izin (master izin, p aproval izin, laporan izin), 7= Lembur (master lembur, p aproval lembur, laporan lembur), 8= Aktivitas, 9= Informasi Gaji, 10= Reimbursement, 11= Payroll',
  `komponen_mobile` varchar(255) NOT NULL COMMENT '1=izin, 2=lembur, 3=shift, 4=remburse, 5=info gaji, 6=aktivitas, 7=berita, 8=payroll',
  `max_karyawan` int(11) NOT NULL DEFAULT 0,
  `max_cabang` varchar(250) NOT NULL DEFAULT '-',
  `urutan` tinyint(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_paket`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

/*Data for the table `master_paket` */

/*Table structure for table `master_plan` */

DROP TABLE IF EXISTS `master_plan`;

CREATE TABLE `master_plan` (
  `id_plan` int(11) NOT NULL AUTO_INCREMENT,
  `id_customer` int(11) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial; 3=lunas/aktif; 4=request aktivasi; 5=perpanjangan;\r\n6=request upgrade;',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan',
  `max_cabang` varchar(10) NOT NULL DEFAULT '~',
  `max_karyawan` varchar(10) NOT NULL DEFAULT '~',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_plan`),
  KEY `master_plan` (`id_company`,`id_customer`,`tgl_daftar`)
) ENGINE=InnoDB AUTO_INCREMENT=95199 DEFAULT CHARSET=latin1;

/*Data for the table `master_plan` */

insert  into `master_plan`(`id_plan`,`id_customer`,`status`,`tgl_aktif`,`tgl_berakhir`,`tgl_daftar`,`masa_layanan`,`max_cabang`,`max_karyawan`,`id_company`,`tgl_input`) values 
(1,1,2,'2020-10-08','2023-11-30','2020-10-08',2,'~','30','C231101','2022-10-04 14:57:06'),
(2,2,2,'2020-10-08','2023-11-30','2020-10-08',2,'~','30','D231101','2022-10-04 15:00:41');

/*Table structure for table `master_plan_temp` */

DROP TABLE IF EXISTS `master_plan_temp`;

CREATE TABLE `master_plan_temp` (
  `id_plan_temp` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` int(11) DEFAULT NULL,
  `id_transaksi` varchar(20) DEFAULT NULL,
  `id_plan` tinyint(4) DEFAULT NULL COMMENT 'id plan temp',
  `tgl_aktif` date DEFAULT NULL,
  `tgl_berakhir` date DEFAULT NULL,
  `masa_layanan` smallint(6) DEFAULT NULL,
  `jumlah_tambahan` smallint(1) DEFAULT NULL,
  PRIMARY KEY (`id_plan_temp`)
) ENGINE=InnoDB AUTO_INCREMENT=2573 DEFAULT CHARSET=latin1;

/*Data for the table `master_plan_temp` */

/*Table structure for table `master_provinsi` */

DROP TABLE IF EXISTS `master_provinsi`;

CREATE TABLE `master_provinsi` (
  `id_prov` int(2) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id_prov`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_provinsi` */

/*Table structure for table `master_shift` */

DROP TABLE IF EXISTS `master_shift`;

CREATE TABLE `master_shift` (
  `id_master_shift` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 2 digit nomor urut',
  `kode_shift` varchar(50) NOT NULL,
  `nama_shift` varchar(20) NOT NULL,
  `jam_masuk` time NOT NULL,
  `jam_pulang` time NOT NULL,
  `flag_jam_pulang` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=hari yang sama, 1=lewat hari',
  `start_absen_masuk` time DEFAULT NULL,
  `batas_absen_pulang` time DEFAULT NULL,
  `flag_batas_absen_pulang` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=hari yang sama, 1=lewat hari',
  `libur` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=Masuk Kerja; 1=Libur',
  `id_cabang` varchar(20) NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_master_shift`),
  KEY `KEY` (`kode_shift`,`id_company`,`jam_masuk`,`id_cabang`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_shift` */

insert  into `master_shift`(`id_master_shift`,`kode_shift`,`nama_shift`,`jam_masuk`,`jam_pulang`,`flag_jam_pulang`,`start_absen_masuk`,`batas_absen_pulang`,`flag_batas_absen_pulang`,`libur`,`id_cabang`,`id_company`,`tgl_input`) values 
('C231101202210001','SS','Shift Siang','13:00:00','21:00:00','0','12:00:00','22:00:00','0','0','C231101001','C231101','2022-10-04 15:40:20'),
('D231101202210001','SS','Shift Siang','13:00:00','21:00:00','0','12:00:00','22:00:00','0','0','D231101001','D231101','2022-10-04 15:48:11');

/*Table structure for table `migrations` */

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `migrations` */

/*Table structure for table `monev_aktif` */

DROP TABLE IF EXISTS `monev_aktif`;

CREATE TABLE `monev_aktif` (
  `id_plan` int(11) NOT NULL,
  `id_customer` int(11) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial; 3=lunas/aktif; 4=request aktivasi; 5=perpanjangan',
  `flag` enum('0','1') NOT NULL DEFAULT '1' COMMENT '1=ON, 0=OFF',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `id_company` bigint(20) NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `monev_aktif` */

/*Table structure for table `mutasi_karyawan` */

DROP TABLE IF EXISTS `mutasi_karyawan`;

CREATE TABLE `mutasi_karyawan` (
  `id_mutasi` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` int(11) DEFAULT NULL,
  `tgl_mutasi` date DEFAULT NULL,
  `dari_departemen` varchar(225) DEFAULT NULL,
  `dari_jabatan` varchar(225) DEFAULT NULL,
  `ke_departemen` varchar(225) DEFAULT NULL,
  `ke_jabatan` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id_mutasi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `mutasi_karyawan` */

/*Table structure for table `nonaktif` */

DROP TABLE IF EXISTS `nonaktif`;

CREATE TABLE `nonaktif` (
  `nik` varchar(9) DEFAULT NULL,
  `status` enum('7') NOT NULL DEFAULT '7',
  `id_company` int(5) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `nonaktif` */

/*Table structure for table `otp` */

DROP TABLE IF EXISTS `otp`;

CREATE TABLE `otp` (
  `telepon` varchar(15) NOT NULL,
  `waktu` int(11) NOT NULL,
  `kode_otp` mediumint(9) NOT NULL,
  PRIMARY KEY (`telepon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `otp` */

/*Table structure for table `p_adm_reimbursement` */

DROP TABLE IF EXISTS `p_adm_reimbursement`;

CREATE TABLE `p_adm_reimbursement` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_adm_reimbursement` */

/*Table structure for table `p_approval_izin` */

DROP TABLE IF EXISTS `p_approval_izin`;

CREATE TABLE `p_approval_izin` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_approval_izin` */

insert  into `p_approval_izin`(`id`,`id_cabang`,`level_user`,`level_approval`,`id_company`,`tgl_input`) values 
('C231101001','C231101001','3','7,2,1','C231101','2022-10-04 15:49:59'),
('C231101002','C231101001','7','2,1','C231101','2022-10-04 15:50:18'),
('C231101003','C231101001','2','5,4','C231101','2022-10-04 15:48:38'),
('C231101004','C231101001','5','4','C231101','2022-10-04 15:48:44'),
('D231101001','D231101001','3','7,2,1','D231101','2022-10-04 15:48:25'),
('D231101002','D231101001','7','2,1','D231101','2022-10-04 15:50:18'),
('D231101003','D231101001','2','5,4','D231101','2022-10-04 15:48:38'),
('D231101004','D231101001','5','4','D231101','2022-10-04 15:48:44');

/*Table structure for table `p_approval_lembur` */

DROP TABLE IF EXISTS `p_approval_lembur`;

CREATE TABLE `p_approval_lembur` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `KEY` (`id_cabang`,`level_user`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_approval_lembur` */

insert  into `p_approval_lembur`(`id`,`id_cabang`,`level_user`,`level_approval`,`id_company`,`tgl_input`) values 
('C231101001','C231101001','3','2','C231101','2022-10-04 15:53:15'),
('C231101002','C231101001','7','2','C231101','2022-10-04 15:53:38'),
('C231101003','C231101001','2','5','C231101','2022-10-04 15:53:58'),
('C231101004','C231101001','5','4','C231101','2022-10-04 15:54:16'),
('D231101001','D231101001','3','2','D231101','2022-10-04 15:53:15'),
('D231101002','D231101001','7','2','D231101','2022-10-04 15:53:38'),
('D231101003','D231101001','2','5','D231101','2022-10-04 15:53:58'),
('D231101004','D231101001','5','4','D231101','2022-10-04 15:54:16');

/*Table structure for table `p_approval_reimbursement` */

DROP TABLE IF EXISTS `p_approval_reimbursement`;

CREATE TABLE `p_approval_reimbursement` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_approval_reimbursement` */

/*Table structure for table `p_atasan` */

DROP TABLE IF EXISTS `p_atasan`;

CREATE TABLE `p_atasan` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_jabatan` varchar(50) NOT NULL,
  `atasan` varchar(50) NOT NULL COMMENT 'Atasan adalah id jabatan yg levelnya sama dengan id_jabatan',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_atasan` */

/*Table structure for table `p_jenis_klien` */

DROP TABLE IF EXISTS `p_jenis_klien`;

CREATE TABLE `p_jenis_klien` (
  `id_jenis_klien` varchar(11) NOT NULL,
  `nama_jenis_klien` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_jenis_klien` */

/*Table structure for table `p_kacab` */

DROP TABLE IF EXISTS `p_kacab`;

CREATE TABLE `p_kacab` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=cabang tambahan, 1=cabang utama',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_kacab` */

insert  into `p_kacab`(`id`,`id_karyawan`,`id_cabang`,`flag`,`id_company`,`tgl_input`,`tgl_update`) values 
('C231101202210001','C2311015','C231101001','1','C231101','2022-10-04 16:26:21','2022-10-04 16:26:21'),
('D231101202210001','D2311015','D231101001','1','D231101','2022-10-04 16:22:31','2022-10-04 16:22:31');

/*Table structure for table `p_kedep` */

DROP TABLE IF EXISTS `p_kedep`;

CREATE TABLE `p_kedep` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=departemen tambahan, 1= departemen utama',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_karyawan` (`id_karyawan`,`id_departemen`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_kedep` */

insert  into `p_kedep`(`id`,`id_karyawan`,`id_cabang`,`id_departemen`,`flag`,`id_company`,`tgl_input`,`tgl_update`) values 
('C231101202210001','C2311012','C231101001','C231101202210001','1','C231101','2022-10-04 16:26:21','2022-10-04 16:26:21'),
('D231101202210001','D2311012','D231101001','D231101202210001','1','D231101','2022-10-04 16:22:31','2022-10-04 16:22:31');

/*Table structure for table `p_notification` */

DROP TABLE IF EXISTS `p_notification`;

CREATE TABLE `p_notification` (
  `id_notification` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `notif_hrd` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0= tidak dapat notif, 1=dapat notif',
  `notif_finance` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0= tidak dapat notif, 1=dapat notif',
  `id_company` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_notification`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_notification` */

/*Table structure for table `payroll_bpjs_kes_comp_p` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_comp_p`;

CREATE TABLE `payroll_bpjs_kes_comp_p` (
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `flag` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_perus` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '4.00',
  `pot_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `pot_tambahan_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_bpjs_kes_comp_p` */

/*Table structure for table `payroll_bpjs_kes_config` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_config`;

CREATE TABLE `payroll_bpjs_kes_config` (
  `tunj_perus` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '4.00',
  `pot_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `pot_tambahan_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_bpjs_kes_config` */

/*Table structure for table `payroll_bpjs_kes_m` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_m`;

CREATE TABLE `payroll_bpjs_kes_m` (
  `id_karyawan` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0',
  `jml_anak` tinyint(2) NOT NULL DEFAULT 0,
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '4.00',
  `tunj_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `pot_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_bpjs_kes_m` */

/*Table structure for table `payroll_bpjs_kes_temp` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_temp`;

CREATE TABLE `payroll_bpjs_kes_temp` (
  `id_karyawan` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0',
  `jml_anak` tinyint(2) NOT NULL DEFAULT 0,
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '4.00',
  `tunj_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `pot_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'id karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `flag_import` enum('1','2','3','4') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid, 3=data sudah ada, 4=data berhasil di simpan',
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_bpjs_kes_temp` */

/*Table structure for table `payroll_bpjs_kes_trx` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_trx`;

CREATE TABLE `payroll_bpjs_kes_trx` (
  `id_karyawan` varchar(50) NOT NULL,
  `periode` varchar(7) NOT NULL DEFAULT '',
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_perus_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_kry_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_bpjs_kes_trx` */

/*Table structure for table `payroll_bpjs_komp_gaji_trx` */

DROP TABLE IF EXISTS `payroll_bpjs_komp_gaji_trx`;

CREATE TABLE `payroll_bpjs_komp_gaji_trx` (
  `id_karyawan` varchar(50) NOT NULL,
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `tipe` enum('gapok','tunj_tetap') NOT NULL DEFAULT 'gapok',
  `nm_komponen` varchar(255) NOT NULL DEFAULT '',
  `nominal` int(11) NOT NULL DEFAULT 0,
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`periode`,`id_company`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_bpjs_komp_gaji_trx` */

/*Table structure for table `payroll_bpjs_tk_comp_p` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_comp_p`;

CREATE TABLE `payroll_bpjs_tk_comp_p` (
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tunj_jht_perus` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry` decimal(3,2) NOT NULL DEFAULT 0.00,
  `flag_jht` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkk` decimal(3,2) NOT NULL DEFAULT 0.00,
  `flag_jkk` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jp_perus` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry` decimal(3,2) NOT NULL DEFAULT 0.00,
  `flag_jp` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkm` decimal(3,2) NOT NULL DEFAULT 0.00,
  `flag_jkm` enum('0','1') NOT NULL DEFAULT '0',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_bpjs_tk_comp_p` */

/*Table structure for table `payroll_bpjs_tk_config` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_config`;

CREATE TABLE `payroll_bpjs_tk_config` (
  `tunj_jht_perus` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 3.70',
  `pot_jht_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 2.00',
  `tunj_jkk` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 0.24',
  `tunj_jp_perus` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 2.00',
  `pot_jp_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 1.00',
  `tunj_jkm` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 3.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_bpjs_tk_config` */

/*Table structure for table `payroll_bpjs_tk_m` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_m`;

CREATE TABLE `payroll_bpjs_tk_m` (
  `id_karyawan` varchar(50) NOT NULL,
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_jht_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jht_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jht` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkk_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkk_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jkk` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jp_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jp_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jp` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkm_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkm_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jkm` enum('0','1') NOT NULL DEFAULT '0',
  `ttl_pot_karyawan` decimal(9,2) NOT NULL DEFAULT 0.00,
  `ttl_tunj_dibiayai_perus` decimal(9,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_bpjs_tk_m` */

/*Table structure for table `payroll_bpjs_tk_temp` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_temp`;

CREATE TABLE `payroll_bpjs_tk_temp` (
  `id_karyawan` varchar(50) NOT NULL,
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_jht_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jht_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jht` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkk_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkk_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jkk` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jp_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jp_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jp` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkm_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkm_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jkm` enum('0','1') NOT NULL DEFAULT '0',
  `ttl_pot_karyawan` decimal(9,2) NOT NULL DEFAULT 0.00,
  `ttl_tunj_dibiayai_perus` decimal(9,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'id karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_bpjs_tk_temp` */

/*Table structure for table `payroll_bpjs_tk_trx` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_trx`;

CREATE TABLE `payroll_bpjs_tk_trx` (
  `id_karyawan` varchar(50) NOT NULL,
  `periode` varchar(7) NOT NULL DEFAULT '' COMMENT 'format yyyy-mm',
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_jht_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jht_perus_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `flag_jht` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkk_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkk_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `flag_jkk` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jp_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jp_perus_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `flag_jp` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkm_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkm_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `flag_jkm` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_bpjs_tk_trx` */

/*Table structure for table `payroll_gaji_trx` */

DROP TABLE IF EXISTS `payroll_gaji_trx`;

CREATE TABLE `payroll_gaji_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_jabatan` varchar(20) NOT NULL DEFAULT '',
  `kd_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nm_jabatan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kd_cabang` varchar(50) NOT NULL DEFAULT '',
  `nm_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kd_departemen` varchar(50) NOT NULL DEFAULT '',
  `nm_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `tgl_mulai` date NOT NULL DEFAULT '0000-00-00',
  `tgl_selesai` date NOT NULL DEFAULT '0000-00-00',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `tunj_tetap_ttl` int(11) NOT NULL DEFAULT 0,
  `tunj_tdk_tetap_ttl` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0 COMMENT 'tunj tetap+tunj tdk tetap',
  `lembur_menit` int(11) NOT NULL DEFAULT 0,
  `lembur_per_jam` int(11) NOT NULL DEFAULT 0,
  `lembur_rp` int(11) NOT NULL DEFAULT 0,
  `pot_tetap_ttl` int(11) NOT NULL DEFAULT 0,
  `pot_tdk_tetap_ttl` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_pc` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_t` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_a` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_tap` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_mak` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_actual` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_acc` int(11) NOT NULL DEFAULT 0,
  `tunj_bpjs_kes` decimal(11,0) NOT NULL DEFAULT 0,
  `pot_bpjs_kes` decimal(11,2) NOT NULL DEFAULT 0.00,
  `tunj_bpjs_tk` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_bpjs_tk` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_pph21` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` decimal(13,2) NOT NULL DEFAULT 0.00,
  `ttl_tunj_dibiayai_perus` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT 'tunj bpjs kes+tunj bpjs tk',
  `thp` decimal(13,2) NOT NULL DEFAULT 0.00,
  `bank_rek` varchar(30) NOT NULL DEFAULT '',
  `bank_nama` varchar(30) NOT NULL DEFAULT '',
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `tanggungan` varchar(5) NOT NULL DEFAULT '' COMMENT 'relasi tabel ptkp',
  `npwp` varchar(20) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_flag` enum('0','1') NOT NULL DEFAULT '0',
  `publish_user` varchar(150) NOT NULL DEFAULT '',
  `publish_sch` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_tgl` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_gaji_trx` */

/*Table structure for table `payroll_gapok_log` */

DROP TABLE IF EXISTS `payroll_gapok_log`;

CREATE TABLE `payroll_gapok_log` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `action` enum('tambah','edit','hapus') NOT NULL DEFAULT 'tambah',
  `nominal_lama` int(11) NOT NULL DEFAULT 0,
  `nominal_baru` int(11) NOT NULL DEFAULT 0,
  `user_input` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_company`,`id_karyawan`,`tgl_input`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_gapok_log` */

/*Table structure for table `payroll_gapok_m` */

DROP TABLE IF EXISTS `payroll_gapok_m`;

CREATE TABLE `payroll_gapok_m` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nominal` int(11) NOT NULL DEFAULT 0,
  `lembur_per_jam` int(11) NOT NULL DEFAULT 0,
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_gapok_m` */

/*Table structure for table `payroll_gapok_m_temp` */

DROP TABLE IF EXISTS `payroll_gapok_m_temp`;

CREATE TABLE `payroll_gapok_m_temp` (
  `id_karyawan` varchar(255) NOT NULL,
  `id_cabang` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `lembur_per_jam` int(11) NOT NULL DEFAULT 0,
  `nominal` int(11) NOT NULL DEFAULT 0,
  `flag` enum('1','2','3','4') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid, 3=data sudah ada, 4=data berhasil di simpan',
  `user_input` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_gapok_m_temp` */

/*Table structure for table `payroll_komponen_m` */

DROP TABLE IF EXISTS `payroll_komponen_m`;

CREATE TABLE `payroll_komponen_m` (
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan' COMMENT '1:pendapatan; 2: potongan',
  `nm_komponen` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL,
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_komponen_m` */

insert  into `payroll_komponen_m`(`id_item`,`jenis_komponen`,`jenis_master`,`nm_komponen`,`flag_persentase_gapok`,`gapok_persen`,`flag_bpjs`,`flag_pph21`,`flag_pot_absensi`,`no_urut`,`id_company`,`user_input`,`tgl_input`,`user_update`,`tgl_update`) values 
('D23110120231100001','tetap','pendapatan','Tujangan transport','0',0.00,'0','0','0',1,'D231101','1 - ADMIN HRGA','2023-11-02 15:21:08','','0000-00-00 00:00:00'),
('D23110120231100002','tidak tetap','pendapatan','Insentif','0',0.00,'0','0','0',1,'D231101','1 - ADMIN HRGA','2023-11-02 15:29:32','','0000-00-00 00:00:00');

/*Table structure for table `payroll_komponen_trx` */

DROP TABLE IF EXISTS `payroll_komponen_trx`;

CREATE TABLE `payroll_komponen_trx` (
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `periode` varchar(7) NOT NULL DEFAULT '0000-00',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan' COMMENT '1:pendapatan; 2: potongan',
  `nm_komponen` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL,
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_item`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_komponen_trx` */

/*Table structure for table `payroll_pot_absensi_p` */

DROP TABLE IF EXISTS `payroll_pot_absensi_p`;

CREATE TABLE `payroll_pot_absensi_p` (
  `jenis` enum('terlambat','pc','tap','alpa') NOT NULL DEFAULT 'terlambat',
  `flag_aktif` enum('0','1') NOT NULL DEFAULT '0',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `persentase` decimal(4,2) NOT NULL DEFAULT 0.00,
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `menit` int(11) NOT NULL DEFAULT 0,
  `kelipatan` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`jenis`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pot_absensi_p` */

insert  into `payroll_pot_absensi_p`(`jenis`,`flag_aktif`,`flag_persentase_gapok`,`persentase`,`nominal_potongan`,`menit`,`kelipatan`,`id_company`,`user_input`,`tgl_input`,`user_update`,`tgl_update`) values 
('terlambat','0','0',0.00,0,0,'0','C231101','','2023-11-02 15:07:25','','0000-00-00 00:00:00'),
('terlambat','0','0',0.00,0,0,'0','D231101','','2023-11-02 15:07:32','','0000-00-00 00:00:00'),
('pc','0','0',0.00,0,0,'0','C231101','','2023-11-02 15:07:25','','0000-00-00 00:00:00'),
('pc','0','0',0.00,0,0,'0','D231101','','2023-11-02 15:07:32','','0000-00-00 00:00:00'),
('tap','0','0',0.00,0,0,'0','C231101','','2023-11-02 15:07:25','','0000-00-00 00:00:00'),
('tap','0','0',0.00,0,0,'0','D231101','','2023-11-02 15:07:32','','0000-00-00 00:00:00'),
('alpa','0','0',0.00,0,0,'0','C231101','','2023-11-02 15:07:25','','0000-00-00 00:00:00'),
('alpa','0','0',0.00,0,0,'0','D231101','','2023-11-02 15:07:32','','0000-00-00 00:00:00');

/*Table structure for table `payroll_pot_absensi_trx` */

DROP TABLE IF EXISTS `payroll_pot_absensi_trx`;

CREATE TABLE `payroll_pot_absensi_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL,
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jenis_absen` varchar(10) NOT NULL DEFAULT '',
  `kode_absen` varchar(50) NOT NULL DEFAULT '',
  `t_nominal` int(11) NOT NULL DEFAULT 0,
  `t_menit_p` int(11) NOT NULL DEFAULT 0,
  `t_kelipatan_p` enum('0','1') NOT NULL DEFAULT '0',
  `t_menit` int(11) NOT NULL DEFAULT 0,
  `t_ttl` int(11) NOT NULL DEFAULT 0,
  `pc_nominal` int(11) NOT NULL DEFAULT 0,
  `pc_menit_p` int(11) NOT NULL DEFAULT 0,
  `pc_kelipatan_p` enum('0','1') NOT NULL DEFAULT '0',
  `pc_menit` int(11) NOT NULL DEFAULT 0,
  `pc_ttl` int(11) NOT NULL DEFAULT 0,
  `tap_nominal` int(11) NOT NULL DEFAULT 0,
  `tap_ttl` int(11) NOT NULL DEFAULT 0,
  `alpa_nominal` int(11) NOT NULL DEFAULT 0,
  `alpa_ttl` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`tgl_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pot_absensi_trx` */

/*Table structure for table `payroll_pot_tdk_tetap_m` */

DROP TABLE IF EXISTS `payroll_pot_tdk_tetap_m`;

CREATE TABLE `payroll_pot_tdk_tetap_m` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company+yymm+5digit nomor urut',
  `periode` varchar(7) NOT NULL DEFAULT '0000-00',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `flag_gaji` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pot_tdk_tetap_m` */

/*Table structure for table `payroll_pot_tdk_tetap_temp` */

DROP TABLE IF EXISTS `payroll_pot_tdk_tetap_temp`;

CREATE TABLE `payroll_pot_tdk_tetap_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `bulan` varchar(7) NOT NULL,
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`bulan`,`nm_potongan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pot_tdk_tetap_temp` */

/*Table structure for table `payroll_pot_tdk_tetap_trx` */

DROP TABLE IF EXISTS `payroll_pot_tdk_tetap_trx`;

CREATE TABLE `payroll_pot_tdk_tetap_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company+yymm+5digit nomor urut',
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `no_urut` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pot_tdk_tetap_trx` */

/*Table structure for table `payroll_pot_tetap_m` */

DROP TABLE IF EXISTS `payroll_pot_tetap_m`;

CREATE TABLE `payroll_pot_tetap_m` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company+yymm+5digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan',
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL,
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pot_tetap_m` */

/*Table structure for table `payroll_pot_tetap_temp` */

DROP TABLE IF EXISTS `payroll_pot_tetap_temp`;

CREATE TABLE `payroll_pot_tetap_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`nm_potongan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pot_tetap_temp` */

/*Table structure for table `payroll_pot_tetap_trx` */

DROP TABLE IF EXISTS `payroll_pot_tetap_trx`;

CREATE TABLE `payroll_pot_tetap_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL,
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pot_tetap_trx` */

/*Table structure for table `payroll_pph21_p` */

DROP TABLE IF EXISTS `payroll_pph21_p`;

CREATE TABLE `payroll_pph21_p` (
  `jenis` enum('gross','net') NOT NULL DEFAULT 'net' COMMENT 'gross dikurangkan gaji; nett tidak dikurangkan gaji',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pph21_p` */

insert  into `payroll_pph21_p`(`jenis`,`id_company`,`user_input`,`tgl_input`,`user_update`,`tgl_update`) values 
('gross','C231101','','2023-11-02 15:07:25','','0000-00-00 00:00:00'),
('gross','D231101','','2023-11-02 15:07:32','','0000-00-00 00:00:00');

/*Table structure for table `payroll_pph21_trx` */

DROP TABLE IF EXISTS `payroll_pph21_trx`;

CREATE TABLE `payroll_pph21_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(50) NOT NULL DEFAULT '',
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `npwp` varchar(20) NOT NULL DEFAULT '',
  `tanggungan` varchar(10) NOT NULL DEFAULT '',
  `local_expat` varchar(10) NOT NULL DEFAULT '',
  `mulai_kerja_bulan` varchar(2) NOT NULL DEFAULT '0',
  `akhir_kerja_bulan` varchar(2) NOT NULL DEFAULT '0',
  `id_jabatan` varchar(20) NOT NULL DEFAULT '',
  `kd_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nm_jabatan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kd_cabang` varchar(50) NOT NULL DEFAULT '',
  `nm_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kd_departemen` varchar(50) NOT NULL DEFAULT '',
  `nm_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0 COMMENT '9',
  `tunj_pph` int(11) NOT NULL DEFAULT 0 COMMENT '10',
  `tunj_lain` int(11) NOT NULL DEFAULT 0 COMMENT '11 : tunjangan tetap dan tidak tetap yg flag 1',
  `honorarium` int(11) NOT NULL DEFAULT 0 COMMENT '12',
  `premi_asuransi` int(11) NOT NULL DEFAULT 0 COMMENT '13 : tunjangan bpjs kesehatan + iuran jkk + iuran jkm + premi lainnya',
  `natura` int(11) NOT NULL DEFAULT 0 COMMENT '14',
  `peng_bruto_ttl` int(11) NOT NULL DEFAULT 0 COMMENT '15: jumlah 9 s/d 14',
  `bonus_thr` int(11) NOT NULL DEFAULT 0 COMMENT '16',
  `ttl_bruto_bonus` int(11) NOT NULL DEFAULT 0 COMMENT '17: jumlah 15 s/d 16',
  `pot_jabatan_atas_peng_bruto` int(11) NOT NULL DEFAULT 0 COMMENT '18',
  `pot_jabatan_atas_ttl_bruto_bonus` int(11) NOT NULL DEFAULT 0 COMMENT '19',
  `pot_iuran_pensiun_tht` int(11) NOT NULL DEFAULT 0 COMMENT '20',
  `ttl_potongan` int(11) NOT NULL DEFAULT 0 COMMENT '21',
  `jml_ph_neto_disetahunkan` int(11) NOT NULL DEFAULT 0 COMMENT '22',
  `ptkp` int(11) NOT NULL DEFAULT 0 COMMENT '23',
  `pkp_5` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp 60jt',
  `pkp_15` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp 60jt s/d 250jt',
  `pkp_25` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp 250jt s/d 500jt',
  `pkp_30` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp 500jt s/d 5m',
  `pkp_35` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp diatas 5m',
  `ttl_pkp_disetahunkan` int(11) NOT NULL DEFAULT 0 COMMENT '24',
  `pph21_dtp` int(11) NOT NULL DEFAULT 0 COMMENT '25',
  `pph21_non_dtp` int(11) NOT NULL DEFAULT 0 COMMENT '26',
  `jenis_pph` enum('net','gross') NOT NULL DEFAULT 'net',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_pph21_trx` */

/*Table structure for table `payroll_tunj_tdk_tetap_m` */

DROP TABLE IF EXISTS `payroll_tunj_tdk_tetap_m`;

CREATE TABLE `payroll_tunj_tdk_tetap_m` (
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `periode` varchar(7) NOT NULL DEFAULT '0000-00',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `flag_gaji` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_tunj_tdk_tetap_m` */

/*Table structure for table `payroll_tunj_tdk_tetap_temp` */

DROP TABLE IF EXISTS `payroll_tunj_tdk_tetap_temp`;

CREATE TABLE `payroll_tunj_tdk_tetap_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `bulan` varchar(7) NOT NULL,
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`bulan`,`nm_tunjangan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_tunj_tdk_tetap_temp` */

/*Table structure for table `payroll_tunj_tdk_tetap_trx` */

DROP TABLE IF EXISTS `payroll_tunj_tdk_tetap_trx`;

CREATE TABLE `payroll_tunj_tdk_tetap_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL,
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `no_urut` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_tunj_tdk_tetap_trx` */

/*Table structure for table `payroll_tunj_tetap_m` */

DROP TABLE IF EXISTS `payroll_tunj_tetap_m`;

CREATE TABLE `payroll_tunj_tetap_m` (
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL,
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_tunj_tetap_m` */

insert  into `payroll_tunj_tetap_m`(`id_item`,`no_urut`,`jenis_komponen`,`jenis_master`,`id_karyawan`,`nm_tunjangan`,`flag_persentase_gapok`,`gapok_persen`,`gapok_rp`,`nominal_tunjangan`,`flag_bpjs`,`flag_pph21`,`flag_pot_absensi`,`id_company`,`user_input`,`tgl_input`,`user_update`,`tgl_update`) values 
('D23110120231100001',0,'tetap','pendapatan','D2311012','Tujangan transport','0',0.00,0,0,'0','0','0','D231101','1 - ADMIN HRGA','2023-11-02 15:21:08','','0000-00-00 00:00:00'),
('D23110120231100001',0,'tetap','pendapatan','D2311013','Tujangan transport','0',0.00,0,0,'0','0','0','D231101','1 - ADMIN HRGA','2023-11-02 15:21:08','','0000-00-00 00:00:00'),
('D23110120231100001',0,'tetap','pendapatan','D2311014','Tujangan transport','0',0.00,0,0,'0','0','0','D231101','1 - ADMIN HRGA','2023-11-02 15:21:08','','0000-00-00 00:00:00'),
('D23110120231100001',0,'tetap','pendapatan','D2311015','Tujangan transport','0',0.00,0,0,'0','0','0','D231101','1 - ADMIN HRGA','2023-11-02 15:21:08','','0000-00-00 00:00:00'),
('D23110120231100001',0,'tetap','pendapatan','D2311017','Tujangan transport','0',0.00,0,0,'0','0','0','D231101','1 - ADMIN HRGA','2023-11-02 15:21:08','','0000-00-00 00:00:00');

/*Table structure for table `payroll_tunj_tetap_temp` */

DROP TABLE IF EXISTS `payroll_tunj_tetap_temp`;

CREATE TABLE `payroll_tunj_tetap_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`nm_tunjangan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_tunj_tetap_temp` */

/*Table structure for table `payroll_tunj_tetap_trx` */

DROP TABLE IF EXISTS `payroll_tunj_tetap_trx`;

CREATE TABLE `payroll_tunj_tetap_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL,
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `no_urut` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `payroll_tunj_tetap_trx` */

/*Table structure for table `ptkp` */

DROP TABLE IF EXISTS `ptkp`;

CREATE TABLE `ptkp` (
  `kode` varchar(5) NOT NULL,
  `keterangan` varchar(70) NOT NULL,
  `nominal` int(11) NOT NULL DEFAULT 0,
  `no_urut` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `ptkp` */

/*Table structure for table `r_absensi` */

DROP TABLE IF EXISTS `r_absensi`;

CREATE TABLE `r_absensi` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(255) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kode_cabang` varchar(20) NOT NULL DEFAULT '',
  `nama_cabang` varchar(255) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kode_departemen` varchar(50) NOT NULL DEFAULT '',
  `nama_departemen` varchar(255) NOT NULL DEFAULT '',
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `kode_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nama_jabatan` varchar(255) NOT NULL DEFAULT '',
  `supervisi` varchar(50) NOT NULL DEFAULT '',
  `nama_supervisi` varchar(255) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jenis_absen` varchar(20) NOT NULL DEFAULT '' COMMENT 'reguler; shift; libur; izin(Sakit, cuti), alpha',
  `kode_absensi` varchar(255) NOT NULL DEFAULT '',
  `ket_kode` varchar(255) NOT NULL DEFAULT '',
  `jam_masuk_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_masuk` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `terlambat` int(4) NOT NULL DEFAULT 0,
  `lokasi_masuk` varchar(255) NOT NULL DEFAULT '',
  `timezone_masuk` varchar(255) NOT NULL DEFAULT '',
  `gmt_masuk` varchar(6) NOT NULL DEFAULT '',
  `lat_masuk` varchar(30) NOT NULL DEFAULT '',
  `long_masuk` varchar(30) NOT NULL DEFAULT '',
  `ket_absen_masuk` varchar(100) NOT NULL DEFAULT '',
  `foto_masuk` varchar(255) NOT NULL DEFAULT '',
  `absen_ist_mulai` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lokasi_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `timezone_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `gmt_ist_mulai` varchar(6) NOT NULL DEFAULT '',
  `lat_ist_mulai` varchar(30) NOT NULL DEFAULT '',
  `long_ist_mulai` varchar(30) NOT NULL DEFAULT '',
  `ket_ist_mulai` varchar(100) NOT NULL DEFAULT '',
  `foto_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `absen_ist_selesai` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lokasi_ist_selesai` varchar(255) NOT NULL DEFAULT '',
  `timezone_ist_selesai` varchar(255) NOT NULL DEFAULT '',
  `gmt_ist_selesai` varchar(6) NOT NULL DEFAULT '',
  `lat_ist_selesai` varchar(30) NOT NULL DEFAULT '',
  `long_ist_selesai` varchar(30) NOT NULL DEFAULT '',
  `ket_ist_selesai` varchar(100) NOT NULL DEFAULT '',
  `foto_ist_selesai` varchar(100) NOT NULL DEFAULT '',
  `jam_pulang_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_pulang` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pulang_cepat` int(4) NOT NULL DEFAULT 0,
  `lokasi_pulang` varchar(255) NOT NULL DEFAULT '',
  `timezone_pulang` varchar(255) NOT NULL DEFAULT '',
  `gmt_pulang` varchar(255) NOT NULL DEFAULT '',
  `lat_pulang` varchar(30) NOT NULL DEFAULT '',
  `long_pulang` varchar(30) NOT NULL DEFAULT '',
  `ket_absen_pulang` varchar(100) NOT NULL DEFAULT '',
  `foto_absen_pulang` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_karyawan`,`tgl_absen`,`id_company`),
  KEY `filter 1` (`id_company`,`tgl_absen`),
  KEY `filter 2` (`id_company`,`tgl_absen`,`id_karyawan`),
  KEY `filter 3` (`id_company`,`tgl_absen`,`id_cabang`),
  KEY `filter 4` (`id_company`,`tgl_absen`,`id_cabang`,`id_departemen`),
  KEY `filter 5` (`tgl_absen`,`jenis_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `r_absensi` */

insert  into `r_absensi`(`id_karyawan`,`nik`,`nama_karyawan`,`id_cabang`,`kode_cabang`,`nama_cabang`,`id_departemen`,`kode_departemen`,`nama_departemen`,`id_jabatan`,`kode_jabatan`,`nama_jabatan`,`supervisi`,`nama_supervisi`,`tgl_absen`,`jenis_absen`,`kode_absensi`,`ket_kode`,`jam_masuk_kerja`,`absen_masuk`,`terlambat`,`lokasi_masuk`,`timezone_masuk`,`gmt_masuk`,`lat_masuk`,`long_masuk`,`ket_absen_masuk`,`foto_masuk`,`absen_ist_mulai`,`lokasi_ist_mulai`,`timezone_ist_mulai`,`gmt_ist_mulai`,`lat_ist_mulai`,`long_ist_mulai`,`ket_ist_mulai`,`foto_ist_mulai`,`absen_ist_selesai`,`lokasi_ist_selesai`,`timezone_ist_selesai`,`gmt_ist_selesai`,`lat_ist_selesai`,`long_ist_selesai`,`ket_ist_selesai`,`foto_ist_selesai`,`jam_pulang_kerja`,`absen_pulang`,`pulang_cepat`,`lokasi_pulang`,`timezone_pulang`,`gmt_pulang`,`lat_pulang`,`long_pulang`,`ket_absen_pulang`,`foto_absen_pulang`,`id_company`,`tgl_input`,`tgl_update`) values 
('D2311013','3','Example Staff','D231101001','PST','PUSAT','D231101202210001','MKT','Marketing','D231101003','STF','Pegawai','','','2023-11-01','sakit','S','Sakit','00:00:00','0000-00-00 00:00:00',0,'','','','','','','','0000-00-00 00:00:00','','','','','','','','0000-00-00 00:00:00','','','','','','','','00:00:00','0000-00-00 00:00:00',0,'','','','','','','','D231101','2023-11-02 15:51:37','2023-11-02 15:51:37');

/*Table structure for table `r_lembur` */

DROP TABLE IF EXISTS `r_lembur`;

CREATE TABLE `r_lembur` (
  `id_lembur` varchar(50) NOT NULL,
  `tgl_lembur` date NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(250) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `nama_cabang` varchar(250) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `nama_departemen` varchar(250) NOT NULL,
  `id_jabatan` varchar(50) NOT NULL,
  `nama_jabatan` varchar(250) NOT NULL,
  `ttl_lembur` varchar(50) NOT NULL DEFAULT '0',
  `lembur_mulai` datetime NOT NULL,
  `lok_mulai` varchar(225) DEFAULT NULL,
  `timezone_mulai` varchar(150) DEFAULT NULL,
  `gmt_mulai` varchar(225) DEFAULT NULL,
  `lat_mulai` varchar(50) NOT NULL,
  `long_mulai` varchar(50) NOT NULL,
  `ket_mulai` varchar(225) NOT NULL,
  `foto_mulai` varchar(225) DEFAULT NULL,
  `lembur_selesai` datetime NOT NULL,
  `lok_selesai` varchar(225) DEFAULT NULL,
  `timezone_selesai` varchar(150) DEFAULT NULL,
  `gmt_selesai` varchar(100) DEFAULT NULL,
  `lat_selesai` varchar(50) NOT NULL,
  `long_selesai` varchar(50) NOT NULL,
  `ket_selesai` varchar(225) NOT NULL,
  `foto_selesai` varchar(225) NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lembur`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `r_lembur` */

/*Table structure for table `r_login_mobile` */

DROP TABLE IF EXISTS `r_login_mobile`;

CREATE TABLE `r_login_mobile` (
  `id_karyawan` varchar(50) NOT NULL,
  `nama_karyawan` varchar(100) NOT NULL,
  `emulator` enum('false','true') NOT NULL DEFAULT 'false',
  `os` varchar(100) NOT NULL,
  `versi_os` varchar(100) NOT NULL,
  `base_os` varchar(100) NOT NULL,
  `brand` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL,
  `token_fcm` varchar(200) NOT NULL,
  `device_id` varchar(100) NOT NULL,
  `tgl_login` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_company` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `r_login_mobile` */

/*Table structure for table `r_plan` */

DROP TABLE IF EXISTS `r_plan`;

CREATE TABLE `r_plan` (
  `id_plan` int(11) NOT NULL AUTO_INCREMENT,
  `id_customer` int(11) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial; 3=lunas/aktif; 4=request aktivasi; 5=perpanjangan; 6=Layanan Berakhir',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan',
  `max_cabang` varchar(10) NOT NULL DEFAULT '~',
  `max_karyawan` varchar(10) NOT NULL DEFAULT '~',
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id_plan`),
  KEY `master_plan` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `r_plan` */

/*Table structure for table `referal` */

DROP TABLE IF EXISTS `referal`;

CREATE TABLE `referal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` int(11) NOT NULL,
  `nama_company_referal` varchar(100) NOT NULL,
  `email_referal` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `referal` */

/*Table structure for table `reimbursement_akun` */

DROP TABLE IF EXISTS `reimbursement_akun`;

CREATE TABLE `reimbursement_akun` (
  `id_akun` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `kode_akun` varchar(20) NOT NULL,
  `nama_akun` varchar(150) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `user_input` varchar(100) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL,
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_akun`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_akun` */

/*Table structure for table `reimbursement_data` */

DROP TABLE IF EXISTS `reimbursement_data`;

CREATE TABLE `reimbursement_data` (
  `id` varchar(50) CHARACTER SET latin1 NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_pengajuan_reimbursement` varchar(50) CHARACTER SET latin1 NOT NULL,
  `id_karyawan` varchar(100) CHARACTER SET latin1 NOT NULL,
  `id_jenis_reimbursement` varchar(50) CHARACTER SET latin1 NOT NULL,
  `nominal` int(11) NOT NULL,
  `nominal_disetujui` int(11) NOT NULL,
  `keterangan` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `tgl_bukti` date NOT NULL,
  `file` text CHARACTER SET latin1 DEFAULT NULL COMMENT 'uploads/reimbursement/id_company/id_karyawan/yyyymm/nama_file',
  `kode_akun` varchar(100) NOT NULL COMMENT 'kode-nama',
  `apv_spv` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_kedep` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_kacab` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_direksi` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_finance` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `ket_apv_spv` varchar(255) NOT NULL DEFAULT '',
  `ket_apv_kedep` varchar(255) NOT NULL DEFAULT '',
  `ket_apv_kacab` varchar(255) NOT NULL DEFAULT '',
  `ket_apv_direksi` varchar(255) NOT NULL DEFAULT '',
  `ket_apv_finance` varchar(255) NOT NULL DEFAULT '' COMMENT 'finance = adm reimbursment',
  `ket_rev_spv` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_rev_kedep` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_rev_kacab` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_rev_direksi` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_rev_finance` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_tolak_spv` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ket_tolak_kedep` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ket_tolak_kacab` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ket_tolak_direksi` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ket_tolak_finance` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `user_spv` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `user_kedep` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `user_kacab` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `user_direksi` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `user_finance` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `tgl_apv_spv` datetime NOT NULL,
  `tgl_apv_kedep` datetime NOT NULL,
  `tgl_apv_kacab` datetime NOT NULL,
  `tgl_apv_direksi` datetime NOT NULL,
  `tgl_apv_finance` datetime NOT NULL,
  `id_company` varchar(50) CHARACTER SET latin1 NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

/*Data for the table `reimbursement_data` */

/*Table structure for table `reimbursement_jenis` */

DROP TABLE IF EXISTS `reimbursement_jenis`;

CREATE TABLE `reimbursement_jenis` (
  `id_jenis_reimbursement` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `kode_plafon` varchar(20) NOT NULL,
  `jenis_plafon` varchar(150) NOT NULL,
  `max_nominal_plafon` float NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id_jenis_reimbursement`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_jenis` */

/*Table structure for table `reimbursement_pengajuan` */

DROP TABLE IF EXISTS `reimbursement_pengajuan`;

CREATE TABLE `reimbursement_pengajuan` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `no_pengajuan` varchar(50) NOT NULL COMMENT 'yyyymm + 4 digit nomor urut',
  `tgl_pengajuan` datetime NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `keterangan` varchar(255) NOT NULL,
  `status` enum('1','2','3','4','5') NOT NULL COMMENT '1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_spv` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_kedep` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_kacab` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_direksi` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_finance` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `user_spv` varchar(50) DEFAULT NULL,
  `user_kedep` varchar(50) DEFAULT NULL,
  `user_kacab` varchar(50) DEFAULT NULL,
  `user_direksi` varchar(50) DEFAULT NULL,
  `user_finance` varchar(50) DEFAULT NULL,
  `tgl_apv_spv` datetime DEFAULT NULL,
  `tgl_apv_kedep` datetime DEFAULT NULL,
  `tgl_apv_kacab` datetime DEFAULT NULL,
  `tgl_apv_direksi` datetime DEFAULT NULL,
  `tgl_apv_finance` datetime DEFAULT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_pengajuan` */

/*Table structure for table `reimbursement_temp` */

DROP TABLE IF EXISTS `reimbursement_temp`;

CREATE TABLE `reimbursement_temp` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(100) NOT NULL,
  `id_jenis_reimbursement` varchar(50) NOT NULL,
  `nominal` int(11) NOT NULL,
  `keterangan` text NOT NULL,
  `tgl_bukti` date NOT NULL,
  `file` text NOT NULL,
  `id_company` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_temp` */

/*Table structure for table `reset_password` */

DROP TABLE IF EXISTS `reset_password`;

CREATE TABLE `reset_password` (
  `id_reset` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `aktif` int(11) NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id_reset`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reset_password` */

/*Table structure for table `riwayat_pekerjaan` */

DROP TABLE IF EXISTS `riwayat_pekerjaan`;

CREATE TABLE `riwayat_pekerjaan` (
  `id_riwayat_pekerjaan` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `nama_perusahaan` varchar(250) NOT NULL,
  `jenis_perusahaan` varchar(250) NOT NULL,
  `jabatan` varchar(250) NOT NULL,
  `kota` varchar(150) NOT NULL,
  `provinsi` varchar(150) NOT NULL,
  `alamat_perusahaan` text NOT NULL,
  `tgl_masuk` date NOT NULL,
  `tgl_keluar` date NOT NULL,
  `alasan_berhenti` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `riwayat_pekerjaan` */

insert  into `riwayat_pekerjaan`(`id_riwayat_pekerjaan`,`id_karyawan`,`id_company`,`nama_perusahaan`,`jenis_perusahaan`,`jabatan`,`kota`,`provinsi`,`alamat_perusahaan`,`tgl_masuk`,`tgl_keluar`,`alasan_berhenti`,`file`,`tgl_input`) values 
('D2311012023110001','D2311017','D231101','c','c','c','null','null','c','2023-11-01','2023-11-01','c','D231101/karyawan/D2311017/pengalaman-pekerjaan/fe940a53-4c20-46d9-b339-cddc5a090523.jpg','2023-11-02 15:31:44');

/*Table structure for table `riwayat_pendidikan` */

DROP TABLE IF EXISTS `riwayat_pendidikan`;

CREATE TABLE `riwayat_pendidikan` (
  `id_riwayat_pendidikan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sekolah` varchar(150) NOT NULL,
  `jenjang` varchar(50) NOT NULL,
  `jurusan` varchar(150) NOT NULL,
  `lulusan_asal` varchar(100) NOT NULL,
  `gelar` varchar(50) NOT NULL,
  `tahun_masuk` varchar(4) NOT NULL,
  `tahun_lulus` varchar(4) NOT NULL,
  `ijazah` varchar(250) NOT NULL,
  `transkrip` varchar(250) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_riwayat_pendidikan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `riwayat_pendidikan` */

insert  into `riwayat_pendidikan`(`id_riwayat_pendidikan`,`id_karyawan`,`nama_sekolah`,`jenjang`,`jurusan`,`lulusan_asal`,`gelar`,`tahun_masuk`,`tahun_lulus`,`ijazah`,`transkrip`,`id_company`,`tgl_input`) values 
('D2311012023110001','D2311017','w','SD/MI','w','Dalam Negeri','w','2014','2018','D231101/karyawan/D2311017/riwayat-pendidikan/ijazah-SD-MI-d6824106-b009-4960-9699-740d09df2dc1.png','D231101/karyawan/D2311017/riwayat-pendidikan/transkrip-SD-MI-3b611eb5-23b4-498d-b289-83facefe5242.jpg','D231101','2023-11-02 15:31:15');

/*Table structure for table `shift_p` */

DROP TABLE IF EXISTS `shift_p`;

CREATE TABLE `shift_p` (
  `aktif` enum('0','1') NOT NULL DEFAULT '1',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `shift_p` */

/*Table structure for table `shift_p_approval` */

DROP TABLE IF EXISTS `shift_p_approval`;

CREATE TABLE `shift_p_approval` (
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `shift_p_approval` */

/*Table structure for table `shift_pengajuan` */

DROP TABLE IF EXISTS `shift_pengajuan`;

CREATE TABLE `shift_pengajuan` (
  `no_pengajuan` varchar(100) NOT NULL DEFAULT '' COMMENT 'TK+yy+mm+5digit nomor urut',
  `id_karyawan` varchar(100) NOT NULL DEFAULT '',
  `status` enum('0','1','2','3','4') NOT NULL DEFAULT '0' COMMENT '1:pengajuan; 2:dibatalkan; 3:ditolak; 4:disetujui',
  `tgl_pengajuan` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `apv_teman` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `user_teman` varchar(50) NOT NULL DEFAULT '',
  `user_spv` varchar(50) NOT NULL DEFAULT '',
  `user_kedep` varchar(50) NOT NULL DEFAULT '',
  `user_kacab` varchar(50) NOT NULL DEFAULT '',
  `user_direksi` varchar(50) NOT NULL DEFAULT '',
  `user_hrd` varchar(50) NOT NULL DEFAULT '',
  `tgl_apv_teman` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kedep` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_spv` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kacab` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_direksi` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_hrd` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`no_pengajuan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `shift_pengajuan` */

/*Table structure for table `shift_pengajuan_item` */

DROP TABLE IF EXISTS `shift_pengajuan_item`;

CREATE TABLE `shift_pengajuan_item` (
  `id_pengajuan` varchar(100) NOT NULL COMMENT 'id_company+yy+mm+5_digit_nomor_urut',
  `no_pengajuan` varchar(100) NOT NULL DEFAULT '' COMMENT 'TK+yy+mm+5digit nomor urut',
  `id_karyawan` varchar(100) NOT NULL DEFAULT '',
  `id_karyawan_tukar` varchar(100) NOT NULL DEFAULT '',
  `tgl_shift` date NOT NULL DEFAULT '0000-00-00',
  `kd_shift_awal` varchar(50) NOT NULL DEFAULT '',
  `nm_shift_awal` varchar(50) NOT NULL DEFAULT '',
  `masuk_awal` time NOT NULL DEFAULT '00:00:00',
  `pulang_awal` time NOT NULL DEFAULT '00:00:00',
  `kd_shift_baru` varchar(50) NOT NULL DEFAULT '',
  `nm_shift_baru` varchar(50) NOT NULL DEFAULT '',
  `masuk_baru` time NOT NULL DEFAULT '00:00:00',
  `pulang_baru` time NOT NULL DEFAULT '00:00:00',
  `keterangan` varchar(100) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id_pengajuan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `shift_pengajuan_item` */

/*Table structure for table `slip_gaji` */

DROP TABLE IF EXISTS `slip_gaji`;

CREATE TABLE `slip_gaji` (
  `id_slip` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nama` varchar(50) NOT NULL,
  `jabatan` varchar(50) NOT NULL,
  `no_rekening` varchar(50) NOT NULL,
  `gaji_pokok` varchar(50) NOT NULL DEFAULT '0',
  `tunj_jab` varchar(50) NOT NULL DEFAULT '0',
  `tunj_ops` varchar(50) NOT NULL DEFAULT '0',
  `thp` varchar(50) NOT NULL DEFAULT '0',
  `tunj_transport` varchar(50) NOT NULL DEFAULT '0',
  `uang_makan` varchar(50) NOT NULL DEFAULT '0',
  `total_gaji` varchar(50) NOT NULL DEFAULT '0',
  `lain_lain` varchar(50) NOT NULL DEFAULT '0',
  `tunj_istri` varchar(50) NOT NULL DEFAULT '0',
  `tunj_anak` varchar(50) NOT NULL DEFAULT '0',
  `komisi` varchar(50) NOT NULL DEFAULT '0',
  `lembur` varchar(50) NOT NULL DEFAULT '0',
  `cashbon` varchar(50) NOT NULL DEFAULT '0',
  `koperasi` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ketenagakerjaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_kesehatan` varchar(50) NOT NULL DEFAULT '0',
  `iuran_koperasi` varchar(50) NOT NULL DEFAULT '0',
  `absensi` varchar(50) NOT NULL DEFAULT '0',
  `kekurangan_sebelumnya` varchar(50) NOT NULL DEFAULT '0',
  `gaji_bersih` varchar(50) NOT NULL DEFAULT '0',
  `nik` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_tk_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ks_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `axa` varchar(50) NOT NULL DEFAULT '0',
  `pot_asuransi` varchar(20) NOT NULL DEFAULT '0' COMMENT 'personal',
  `email` varchar(100) DEFAULT NULL,
  `nikx` varchar(100) DEFAULT NULL,
  `kirim` tinyint(4) NOT NULL DEFAULT 0,
  `id_company` int(11) NOT NULL DEFAULT 1,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_slip`),
  KEY `slip_gaji` (`tanggal`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `slip_gaji` */

/*Table structure for table `slip_gaji_temp` */

DROP TABLE IF EXISTS `slip_gaji_temp`;

CREATE TABLE `slip_gaji_temp` (
  `id_slip_temp` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `flag` int(11) NOT NULL DEFAULT 0,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tanggal` date NOT NULL,
  `nama` varchar(50) NOT NULL,
  `jabatan` varchar(50) NOT NULL,
  `no_rekening` varchar(50) NOT NULL,
  `gaji_pokok` varchar(50) NOT NULL DEFAULT '0',
  `tunj_jab` varchar(50) NOT NULL DEFAULT '0',
  `tunj_ops` varchar(50) NOT NULL DEFAULT '0',
  `thp` varchar(50) NOT NULL DEFAULT '0',
  `tunj_transport` varchar(50) NOT NULL DEFAULT '0',
  `uang_makan` varchar(50) NOT NULL DEFAULT '0',
  `total_gaji` varchar(50) NOT NULL DEFAULT '0',
  `lain_lain` varchar(50) NOT NULL DEFAULT '0',
  `tunj_istri` varchar(50) NOT NULL DEFAULT '0',
  `tunj_anak` varchar(50) NOT NULL DEFAULT '0',
  `komisi` varchar(50) NOT NULL DEFAULT '0',
  `lembur` varchar(50) NOT NULL DEFAULT '0',
  `cashbon` varchar(50) NOT NULL DEFAULT '0',
  `koperasi` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ketenagakerjaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_kesehatan` varchar(50) NOT NULL DEFAULT '0',
  `iuran_koperasi` varchar(50) NOT NULL DEFAULT '0',
  `absensi` varchar(50) NOT NULL DEFAULT '0',
  `kekurangan_sebelumnya` varchar(50) NOT NULL DEFAULT '0',
  `gaji_bersih` varchar(50) NOT NULL DEFAULT '0',
  `nik` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_tk_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ks_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `axa` varchar(50) NOT NULL DEFAULT '0',
  `pot_asuransi` varchar(50) NOT NULL DEFAULT '0',
  `email` varchar(100) NOT NULL DEFAULT '0',
  `kirim` tinyint(4) NOT NULL DEFAULT 0,
  `id_company` int(11) NOT NULL,
  `nikx` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_slip_temp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `slip_gaji_temp` */

/*Table structure for table `status_karyawan` */

DROP TABLE IF EXISTS `status_karyawan`;

CREATE TABLE `status_karyawan` (
  `id_status` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(250) NOT NULL,
  PRIMARY KEY (`id_status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `status_karyawan` */

/*Table structure for table `tabel_bantuan_update` */

DROP TABLE IF EXISTS `tabel_bantuan_update`;

CREATE TABLE `tabel_bantuan_update` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kode_cabang` varchar(50) NOT NULL DEFAULT '',
  `nama_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kode_departemen` varchar(50) NOT NULL DEFAULT '',
  `nama_departemen` varchar(50) NOT NULL DEFAULT '',
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `kode_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nama_jabatan` varchar(50) NOT NULL DEFAULT '',
  `supervisi` varchar(50) NOT NULL DEFAULT '',
  `nama_supervisi` varchar(50) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jenis_absen` varchar(50) NOT NULL DEFAULT '',
  `kode_absensi` varchar(50) NOT NULL DEFAULT '',
  `ket_kode` varchar(50) NOT NULL DEFAULT '',
  `jam_masuk_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_masuk` time NOT NULL DEFAULT '00:00:00',
  `jam_pulang_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_pulang` time NOT NULL DEFAULT '00:00:00',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_karyawan`,`tgl_absen`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tabel_bantuan_update` */

/*Table structure for table `tb_history` */

DROP TABLE IF EXISTS `tb_history`;

CREATE TABLE `tb_history` (
  `id_history` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` int(11) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `tgl_request` datetime DEFAULT NULL,
  `tgl_approval_marketing` datetime DEFAULT NULL,
  `tgl_approval_support` datetime DEFAULT NULL,
  `id_paket` int(11) DEFAULT NULL,
  `id_paket_lama` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_history`)
) ENGINE=InnoDB AUTO_INCREMENT=41046 DEFAULT CHARSET=latin1;

/*Data for the table `tb_history` */

/*Table structure for table `tb_invoice` */

DROP TABLE IF EXISTS `tb_invoice`;

CREATE TABLE `tb_invoice` (
  `id_invoice` int(11) NOT NULL AUTO_INCREMENT,
  `tgl_invoice` datetime DEFAULT NULL,
  `tgl_jatuh_tempo` datetime DEFAULT NULL,
  `total` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `tgl_bayar` datetime DEFAULT NULL,
  `gateway` varchar(255) DEFAULT NULL,
  `id_order` varchar(20) DEFAULT NULL COMMENT 'relasi dengan id_transaksi pada tabel tb_transaksi',
  PRIMARY KEY (`id_invoice`),
  KEY `id_order` (`id_order`)
) ENGINE=InnoDB AUTO_INCREMENT=7533 DEFAULT CHARSET=latin1;

/*Data for the table `tb_invoice` */

/*Table structure for table `tb_paket` */

DROP TABLE IF EXISTS `tb_paket`;

CREATE TABLE `tb_paket` (
  `id_tb_paket` int(11) NOT NULL,
  `id_paket` int(11) DEFAULT NULL,
  `nama` varchar(100) NOT NULL,
  `tarif` float NOT NULL,
  `komponen_web` longtext NOT NULL COMMENT '1= Master Cabang, 2= Master Departemen, 3= Master jabatan, 4= Master lokasi, 5= Shift (master shift dan jadwal shift), 6= Izin (master izin, p aproval izin, laporan izin), 7= Lembur (master lembur, p aproval lembur, laporan lembur), 8= Aktivitas, 9= Informasi Gaji, 10= Reimbursement, 11= Payroll',
  `komponen_mobile` varchar(255) NOT NULL COMMENT '1=izin, 2=lembur, 3=shift, 4=remburse, 5=info gaji, 6=aktivitas, 7=berita, 8=payroll',
  `max_karyawan` int(11) NOT NULL DEFAULT 0,
  `max_cabang` varchar(250) NOT NULL DEFAULT '-',
  `id_company` varchar(255) NOT NULL,
  PRIMARY KEY (`id_tb_paket`),
  KEY `idx_idpaket` (`id_paket`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tb_paket` */

insert  into `tb_paket`(`id_tb_paket`,`id_paket`,`nama`,`tarif`,`komponen_web`,`komponen_mobile`,`max_karyawan`,`max_cabang`,`id_company`) values 
(202108007,13,'Absenku Custom',0,'1-1-1-1-1-1-1-1-1-1-0','1-1-1-0-1-1-1',30,'-','');

/*Table structure for table `tb_paket_bkp` */

DROP TABLE IF EXISTS `tb_paket_bkp`;

CREATE TABLE `tb_paket_bkp` (
  `id_tb_paket` int(11) NOT NULL,
  `id_paket` int(11) DEFAULT NULL,
  `nama` varchar(100) NOT NULL,
  `tarif` float NOT NULL,
  `komponen_web` longtext NOT NULL COMMENT '1= Master Cabang, 2= Master Departemen, 3= Master jabatan, 4= Master lokasi, 5= Shift (master shift dan jadwal shift), 6= Izin (master izin, p aproval izin, laporan izin), 7= Lembur (master lembur, p aproval lembur, laporan lembur), 8= Aktivitas, 9= Informasi Gaji, 10= Reimbursement, 11= Payroll',
  `komponen_mobile` varchar(255) NOT NULL COMMENT '1=izin, 2=lembur, 3=shift, 4=remburse, 5=info gaji, 6=aktivitas, 7=berita, 8=payroll',
  `max_karyawan` int(11) NOT NULL DEFAULT 0,
  `max_cabang` varchar(250) NOT NULL DEFAULT '-',
  `id_company` varchar(255) NOT NULL,
  PRIMARY KEY (`id_tb_paket`),
  KEY `idx_idpaket` (`id_paket`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tb_paket_bkp` */

/*Table structure for table `tb_transaksi` */

DROP TABLE IF EXISTS `tb_transaksi`;

CREATE TABLE `tb_transaksi` (
  `id_transaksi` varchar(20) NOT NULL COMMENT 'id_company + yyyy + 2 digit',
  `id_company` int(11) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `tgl_aktif` date DEFAULT NULL COMMENT 'tgl_berakhir',
  `id_tb_paket` int(11) DEFAULT NULL,
  `masa_layanan` int(11) DEFAULT NULL COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan',
  `sub_total` varchar(15) NOT NULL DEFAULT '0',
  `diskon` varchar(15) NOT NULL DEFAULT '0',
  `ppn` varchar(15) NOT NULL DEFAULT '0',
  `materai` int(11) NOT NULL DEFAULT 0,
  `tagihan` varchar(15) NOT NULL DEFAULT '0',
  `opsi` int(11) NOT NULL DEFAULT 1 COMMENT '1=beli; 2=perpanjang; 3=ubah',
  `status` int(11) NOT NULL COMMENT '1=belum bayar; 2=waiting; 3=aktif',
  `tarif` int(11) NOT NULL DEFAULT 0,
  `dp` int(11) NOT NULL DEFAULT 0,
  `jenis_hutang_piutang` enum('0','1') NOT NULL DEFAULT '0',
  `hutang_piutang` int(11) NOT NULL DEFAULT 0,
  `keterangan` text DEFAULT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_transaksi`),
  KEY `tb_transaksi` (`id_company`,`opsi`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tb_transaksi` */

/*Table structure for table `token_auto_login` */

DROP TABLE IF EXISTS `token_auto_login`;

CREATE TABLE `token_auto_login` (
  `id_company` int(11) NOT NULL,
  `token` varchar(100) NOT NULL,
  `waktu` datetime DEFAULT NULL,
  `tgl_input` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='tabel untuk menyimpan token fitur auto login';

/*Data for the table `token_auto_login` */

/*Table structure for table `tujuan_menggunakan` */

DROP TABLE IF EXISTS `tujuan_menggunakan`;

CREATE TABLE `tujuan_menggunakan` (
  `id` tinyint(1) NOT NULL,
  `tujuan` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tujuan_menggunakan` */

/*Table structure for table `user_dashboard` */

DROP TABLE IF EXISTS `user_dashboard`;

CREATE TABLE `user_dashboard` (
  `id_user` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `nama` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `level` int(11) DEFAULT NULL COMMENT '1=admin; 2=marketing; 3=apps; 4=finance;',
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=latin1;

/*Data for the table `user_dashboard` */

/*Table structure for table `usergroup` */

DROP TABLE IF EXISTS `usergroup`;

CREATE TABLE `usergroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) NOT NULL,
  `urutan` int(11) NOT NULL DEFAULT 1,
  `urutan_payroll` tinyint(2) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `usergroup` */

insert  into `usergroup`(`id`,`level`,`urutan`,`urutan_payroll`) values 
(1,'Administrator',1,1),
(2,'Kepala Departemen',5,1),
(3,'Pegawai',7,1),
(4,'Direksi',3,1),
(5,'Kepala Cabang',4,1),
(6,'Admin Finance',2,1),
(7,'Supervisi',6,1);

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id_user` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4digit nomor urut',
  `username` varchar(50) NOT NULL,
  `password` varchar(100) NOT NULL DEFAULT '2bdbce3554458f3211dd08fdd30d86f1a180dce4',
  `password_2` varchar(100) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `device_id` varchar(255) NOT NULL,
  `lock_device` enum('0','1') NOT NULL DEFAULT '0',
  `token_fcm` varchar(255) NOT NULL,
  `lock_facerecognition` enum('0','1') DEFAULT '0',
  `matrix_facerecognition` text DEFAULT NULL,
  `foto_facerecognition` text DEFAULT NULL,
  `kamera` enum('0','1','2') NOT NULL DEFAULT '2',
  `login` tinyint(4) NOT NULL DEFAULT 0,
  `versi_aplikasi` varchar(8) NOT NULL DEFAULT '',
  `id_company` varchar(11) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_user`),
  KEY `user` (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `users` */

insert  into `users`(`id_user`,`username`,`password`,`password_2`,`id_karyawan`,`device_id`,`lock_device`,`token_fcm`,`lock_facerecognition`,`matrix_facerecognition`,`foto_facerecognition`,`kamera`,`login`,`versi_aplikasi`,`id_company`,`tgl_input`,`tgl_update`) values 
('C2311010001','e_admin','2bdbce3554458f3211dd08fdd30d86f1a180dce4','593596','C231101001','','0','','0',NULL,NULL,'1',1,'','C231101','2022-10-04 15:16:11','0000-00-00 00:00:00'),
('C2311012022100001','e_kedep','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2311012','','0','','0',NULL,NULL,'1',0,'','C231101','2022-10-04 16:26:21','0000-00-00 00:00:00'),
('C2311012022100002','e_staff','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2311013','','0','','0',NULL,NULL,'1',0,'','C231101','2022-10-04 16:26:21','0000-00-00 00:00:00'),
('C2311012022100003','e_direksi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2311014','','0','','0',NULL,NULL,'1',0,'','C231101','2022-10-04 16:26:21','0000-00-00 00:00:00'),
('C2311012022100004','e_kacab','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2311015','','0','','0',NULL,NULL,'1',0,'','C231101','2022-10-04 16:26:21','0000-00-00 00:00:00'),
('C2311012022100005','e_finance','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2311016','','0','','0',NULL,NULL,'1',0,'','C231101','2022-10-04 16:26:21','0000-00-00 00:00:00'),
('C2311012022100006','e_supervisi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2311017','','0','','0',NULL,NULL,'1',0,'','C231101','2022-10-04 16:26:21','0000-00-00 00:00:00'),
('D2311010001','de_admin','2bdbce3554458f3211dd08fdd30d86f1a180dce4','593596','D231101001','','0','','0',NULL,NULL,'1',1,'','D231101','2022-10-04 15:16:11','0000-00-00 00:00:00'),
('D2311012022100005','de_finance','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2311016','','0','','0',NULL,NULL,'1',0,'','D231101','2022-10-04 16:13:41','0000-00-00 00:00:00'),
('D2311012022100006','de_kedep','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2311012','','0','','0',NULL,NULL,'1',0,'','D231101','2022-10-04 16:22:31','0000-00-00 00:00:00'),
('D2311012022100007','de_staff','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2311013','','0','','0',NULL,NULL,'1',0,'','D231101','2022-10-04 16:22:31','0000-00-00 00:00:00'),
('D2311012022100008','de_direksi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2311014','','0','','0',NULL,NULL,'1',0,'','D231101','2022-10-04 16:22:31','0000-00-00 00:00:00'),
('D2311012022100009','de_kacab','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2311015','','0','','0',NULL,NULL,'1',0,'','D231101','2022-10-04 16:22:31','0000-00-00 00:00:00'),
('D2311012022100010','de_supervisi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2311017','','0','','0',NULL,NULL,'1',0,'','D231101','2022-10-04 16:22:31','0000-00-00 00:00:00');

/*Table structure for table `v_aplikasi` */

DROP TABLE IF EXISTS `v_aplikasi`;

CREATE TABLE `v_aplikasi` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `version_code` varchar(50) NOT NULL,
  `version_name` varchar(50) NOT NULL,
  `keterangan_update` text NOT NULL,
  `aktif` enum('0','1') NOT NULL DEFAULT '0',
  `force_update` enum('0','1') NOT NULL DEFAULT '0',
  `link_update` text NOT NULL,
  `link_update_android` varchar(255) NOT NULL,
  `link_update_ios` varchar(255) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `v_aplikasi` */

/*Table structure for table `wilayah` */

DROP TABLE IF EXISTS `wilayah`;

CREATE TABLE `wilayah` (
  `kode` varchar(13) NOT NULL,
  `nama` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `wilayah` */

/*Table structure for table `wizard` */

DROP TABLE IF EXISTS `wizard`;

CREATE TABLE `wizard` (
  `data_lokasi` enum('0','1') NOT NULL DEFAULT '0',
  `akun_kedep` enum('0','1') NOT NULL DEFAULT '0',
  `akun_staff` enum('0','1') NOT NULL DEFAULT '0',
  `tambah_akun` enum('0','1') NOT NULL DEFAULT '0',
  `selesai` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `wizard` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
