<script type="text/javascript">
    $(function() {
        dropdown_departemen();

        $("#form_template #cabang").select2({
            placeholder: "Semua Cabang",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });

        $(".btn_unduh").click(function(){
            let loading = Ladda.create(this);
            loading.start();

            let id_cabang     = ($("#form_template #cabang").val()) ? $("#form_template #cabang").val() : '-';
            let id_departemen = ($("#form_template #departemen").val()) ? $("#form_template #departemen").val() : '-';
            let urlExcel = "<?= route('payroll.data.komponen.import.unduh.template', ['id_cabang' => '"+id_cabang+"', 'id_departemen' => '"+id_departemen+"']) ?>";

            $.get(urlExcel, function (data) {
                if (!data) {
                    $('#tampil_form #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Pendapatan dan potongan belum diatur</font>");
                    loading.stop();
                }else{
                    downloadFile(urlExcel, $(".btn_unduh")[0], true);
                }
            });

        });
    });

    function change_dropdown_cabang(){
        $("#form_template #departemen").val('').trigger('change');
        dropdown_departemen();
    }

    function dropdown_departemen(){
        let id_cabang    = ($("#form_template #cabang").val() == null)?"0":$("#form_template #cabang").val();

        $("#form_template #departemen").select2({

            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>'+'/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_template" class="card-body" disabled>
    <div class="form-group">
        <label>CABANG</label>
        <select id="cabang" class="form-control" style="width: 100%;" onchange="change_dropdown_cabang(this)" required>
        </select>
    </div>

    <div class="form-group">
        <label>DEPARTEMEN</label>
        <select id="departemen" class="form-control" style="width: 100%;">
        </select>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div id="message" class="col-md-7 text-left"></div>
        <div class="col-md-5 text-right">
            <button class="btn_unduh ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
