

<script type="text/javascript">

    $(function() {

        $(document).on('click','.btn_detail',function(){
            var id_aktivitas = $(this).attr("id");
            $('#modal_detail_aktivitas').modal('show');

            for (var i=0; i<markers.length; i++) {
                markers[i].setMap(null);
            }

            markers = []; // Reset the markers array
            lat_longs_map = []; // Reset the lat_longs_map array
            beaches = []; // Reset the beaches array

            $.get("<?= route("laporan.aktivitas.detail") ?>"+"/"+id_aktivitas, function(data){

                // SET MAPS
                arr = [];
                arr.push(data.lat);
                arr.push(data.long);
                arr.push(data.title);
                arr.push(data.index);
                beaches.push(arr);

                setMarkers(beaches);
                fitMapToBounds_map();

                // SET DETAIL AKTIVITAS
                $("#nama_karyawan").text(data.nama_karyawan);
                $("#jabatan").text(data.jabatan);
                $("#waktu").text(data.waktu);
                $("#keterangan").text(data.keterangan);
                $("#foto_aktivitas").attr("src", data.foto_aktivitas);
            },"json");

        });
    });

    var map;
    var lat_longs_map = new Array();
    var markers = []; // Create a marker array to hold your markers
    var beaches = [];
    var mapCentre;

    function setMarkers(locations) {
        for (var i = 0; i < locations.length; i++) {
            var beach = locations[i];
            var myLatLng = new google.maps.LatLng(beach[0], beach[1]);
            var marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
                animation: google.maps.Animation.DROP,
                title: beach[2],
                zIndex: beach[3]
            });

            // Push marker to markers array
            markers.push(marker);

            // Push marker to lat_longs_map array
            lat_longs_map.push(marker.getPosition());

        }
    }

    function initialize() {
        var varcenter = new google.maps.LatLng(-0.4183772,117.4237542);
        var varZoom = 5.4;
        var mapOptions = {
            zoom: varZoom,
            center: varcenter,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        }
        map = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);

        setMarkers(beaches);
        fitMapToBounds_map();
    }

    function fitMapToBounds_map() {
        var bounds = new google.maps.LatLngBounds();

        if (lat_longs_map.length > 0) {
            for (var i=0; i<lat_longs_map.length; i++) {
                bounds.extend(lat_longs_map[i]);
            }
            map.fitBounds(bounds);
            map.setZoom(18)
        }
    }
    initialize();
</script>
<div class="row">
    <div class="col-md-12">
        <div class="float-md-right">
            <button type="button" id="btn_download" class="btn btn-info" tglmulai="<?= $tgl_mulai ?>" tglselesai="<?= $tgl_selesai ?>" idkaryawan="0" idcabang="0" iddepartemen="0">
                <i class="fa fa-download"></i> Download</button>
        </div>
    </div>
</div>
<div class="row mt-1">
    <div class="col-md-12">
        <table id="list_data" class="table table-striped" style="width:100%">
            <thead>
                <tr class="bg-tr">
                    <th class="text-center">NO</th>
                    <th class="text-left">WAKTU</th>
                    <th class="text-left">NAMA</th>
                    <th class="text-center">LATITUDE LONGITUDE</th>
                    <th class="text-left">KETERANGAN</th>
                    <th class="text-center">AKSI</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>


<!-- START TAMPIL MODAL -->
<div id="modal_detail_aktivitas" class="modal fade in" data-keyboard="false" data-backdrop="static" aria-hidden="true">
    <div class="modal-dialog" style="max-width: 80%;">
        <div id="tampil_form" class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Detail Aktivitas</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <div class="col-md-6">
                        <label>Nama</label>
                        <h5 id="nama_karyawan"></h5>
                    </div>
                    <div class="col-md-6">
                        <label>Waktu</label>
                        <h5 id="waktu"></h5>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-6">
                        <label>Jabatan, Cabang, Departemen</label>
                        <h5 id="jabatan"></h5>
                    </div>
                    <div class="col-md-6">
                        <label>Keterangan</label>
                        <h5 id="keterangan"></h5>
                    </div>
                </div>
                <hr>
                <div class="row mt-2">
                    <div class="col-md-6 text-center thumbnail">
                        <h5>LOKASI AKTIVITAS</h5>
                        <div id="map_canvas" style="width:100%; height:350px;"></div>
                    </div>
                    <div class="col-md-6 text-center thumbnail">
                        <h5>FOTO AKTIVITAS</h5>
                        <img id="foto_aktivitas" class="portrait" style="max-height:350px">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-close"></i> Tutup</button>
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({
                        'searching'     : true,
                        'paging'        : true,
                        'lengthChange'  : true,
                        'ordering'      : true,
                        'info'          : true,
                        'scrollX'       :true,
                        'scrollCollapse': true,
                        'language'    :{
                                        'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                        'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                        'searchPlaceholder': 'Keterangan'
                                        },
                        "processing"  : true,
                        "serverSide"  : true,
                        "order"       : [],

                        "ajax"        : {
                                            "url": "<?= route('laporan.aktivitas.listdata') ?>",
                                            "type": "GET", 
                                            "data": {
                                                "tgl_mulai"     : '<?= $tgl_mulai ?>',
                                                "tgl_selesai"   : '<?= $tgl_selesai ?>',
                                                "id_karyawan"   : '<?= $id_karyawan ?>',
                                                "id_cabang"     : '<?= $id_cabang ?>',
                                                "id_departemen" : '<?= $id_departemen ?>'
                                            },
                                            "complete" : function(data){
                                                    reconfigure(data);
                                                }
                                        },

                        "aoColumnDefs": [
                                            { "aTargets": [0], "bSortable": false},
                                            { "aTargets": [3], "bSortable": false},
                                            { "aTargets": [-1], "bSortable": false }
                                        ],
                        "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(1)', nRow).css({'text-align':'left','width':'100px'});
                            $('td:eq(2)', nRow).css({'text-align':'left','width':'200px'});
                            $('td:eq(3)', nRow).css({'text-align':'center','width':'200px'});
                            $('td:eq(5)', nRow).css({'text-align':'center','width':'50px'});
                        }

                });
    })
</script>