<!-- AutoNumeric -->
<script src="<?=base_url('assets/js/')?>/autoNumeric.js"></script>
<script type="text/javascript">

    $(document).on("click","#btn_update",function(e){
        e.preventDefault();
        $('#message').html("");
        var loading = Ladda.create(this);

        if($("#gaji_pokok").val()==""){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Gaji Pokok belum diisi</font>");
            $("#gaji_pokok").focus();
            return false;
        }
        
        loading.start();

        var param = new FormData();
        param.append('id',$("#id").val());
        param.append('gaji_pokok',$("#gaji_pokok").val());
        param.append('t_jabatan',$("#t_jabatan").val());
        param.append('t_transport',$("#t_transport").val());
        param.append('t_makan',$("#t_makan").val());
        param.append('t_istri',$("#t_istri").val());
        param.append('t_anak',$("#t_anak").val());
        param.append('lembur',$("#lembur").val());
        param.append('komisi',$("#komisi").val());
        param.append('t_lain',$("#t_lain").val());
        param.append('ttl_tunjangan',$("#ttl_tunjangan_input").val());
        param.append('ttl_penerimaan',$("#ttl_penerimaan_input").val());
        param.append('tbp_bpjs_tk',$("#tbp_bpjs_tk").val());
        param.append('tbp_bpjs_kesehatan',$("#tbp_bpjs_kesehatan").val());
        param.append('tbp_lain',$("#tbp_lain").val());
        param.append('p_absensi',$("#p_absensi").val());
        param.append('p_keterlambatan',$("#p_keterlambatan").val());
        param.append('p_koperasi',$("#p_koperasi").val());
        param.append('p_asuransi_kesehatan',$("#p_asuransi_kesehatan").val());
        param.append('p_bpjs_tk',$("#p_bpjs_tk").val());
        param.append('p_bpjs_kesehatan',$("#p_bpjs_kesehatan").val());
        param.append('p_lain',$("#p_lain").val());
        param.append('ttl_potongan',$("#ttl_potongan_input").val());
        param.append('gaji_diterima',$("#gaji_diterima_input").val());

        $.ajax({
            type: 'POST',
            url: "<?= route('informasi.gaji.update') ?>",
            data: param,
            dataType:'JSON',
            contentType: false,
            processData: false,
            cache: false,
            success: function(result) {
                if(result.success == true){
                    $('#message').show();
                    $('#message').html(result.message);
                }
                loading.stop();
            },
            error:function(){
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    function hitung_gaji(){
        var gaji_pokok              = replaceIdr($("#gaji_pokok").val());
        var t_jabatan               = replaceIdr($("#t_jabatan").val());
        var t_transport             = replaceIdr($("#t_transport").val());
        var t_makan                 = replaceIdr($("#t_makan").val());
        var t_istri                 = replaceIdr($("#t_istri").val());
        var t_anak                  = replaceIdr($("#t_anak").val());
        var lembur                  = replaceIdr($("#lembur").val());
        var komisi                  = replaceIdr($("#komisi").val());
        var t_lain                  = replaceIdr($("#t_lain").val());
        var tbp_bpjs_tk             = replaceIdr($("#tbp_bpjs_tk").val());
        var tbp_bpjs_kesehatan      = replaceIdr($("#tbp_bpjs_kesehatan").val());
        var tbp_lain                = replaceIdr($("#tbp_lain").val());
        var p_absensi               = replaceIdr($("#p_absensi").val());
        var p_keterlambatan         = replaceIdr($("#p_keterlambatan").val());
        var p_koperasi              = replaceIdr($("#p_koperasi").val());
        var p_asuransi_kesehatan    = replaceIdr($("#p_asuransi_kesehatan").val());
        var p_bpjs_tk               = replaceIdr($("#p_bpjs_tk").val());
        var p_bpjs_kesehatan        = replaceIdr($("#p_bpjs_kesehatan").val());
        var p_lain                  = replaceIdr($("#p_lain").val());

        var ttl_tunjangan = t_jabatan+t_transport+t_makan+t_istri+t_anak+lembur+komisi+t_lain;
        var ttl_penerimaan = gaji_pokok + ttl_tunjangan;

        var ttl_tbp = tbp_bpjs_tk + tbp_bpjs_kesehatan + tbp_lain;

        var ttl_potongan = p_absensi + p_keterlambatan + p_koperasi + p_asuransi_kesehatan + p_bpjs_tk + p_bpjs_kesehatan + p_lain;

        var gaji_diterima = ttl_penerimaan - ttl_potongan;

        $("#ttl_tunjangan_input").val(ttl_tunjangan);
        $("#ttl_penerimaan_input").val(ttl_penerimaan);
        $("#ttl_potongan_input").val(ttl_potongan);
        $("#gaji_diterima_input").val(gaji_diterima);
        
        $("#ttl_penerimaan").html(idr(ttl_penerimaan));
        $("#ttl_potongan").html(idr(ttl_potongan));
        $("#gaji_diterima").html(idr(gaji_diterima));
    }

    function idr(nStr){
        nStr += '';
        x = nStr.split('.');
        x1 = x[0];
        x2 = x.length > 1 ? '.' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + '.' + '$2');
        }
        return x1 + x2;
    }

    function replaceIdr(str){
        if(str == ""){
            str = 0;
        }else{
            str = str.replace(/\./g,'')
        }

        return parseInt(str);
    }

</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Informasi</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div id="form_input" class="card-body">
            <div class="row text-bold-600">
                <div class="col-md-2"><label>Nomor Induk Karyawan</label></div>
                <div class="col-md-4"><label>: <?= ((isset($data))? $data->nik :'') ?></label></div>
                <div class="col-md-2"><label>Cabang</label></div>
                <div class="col-md-4"><label>: <?= ((isset($data))? $data->kode_cabang.' - '.$data->nama_cabang :'') ?></label></div>
            </div>
            <div class="row text-bold-600">
                <div class="col-md-2"><label>Nama Karyawan</label></div>
                <div class="col-md-4"><label>: <?= ((isset($data))? $data->nama_karyawan :'') ?></label></div>
                <div class="col-md-2"><label>Departemen</label></div>
                <div class="col-md-4"><label>: <?= ((isset($data))? $data->kode_departemen.' - '.$data->nama_departemen :'') ?></label></div>
            </div>
            <div class="row text-bold-600">
                <div class="col-md-2"><label>Periode Gaji</label></div>
                <div class="col-md-4"><label>: <?= ((isset($data))? $data->periode:'') ?></label></div>
                <div class="col-md-2"><label>Jabatan</label></div>
                <div class="col-md-4"><label>: <?= ((isset($data))? $data->kode_jabatan.' - '.$data->nama_jabatan :'') ?></label></div>
            </div>
            <hr>
            <br>
            <input type="hidden" id="id" value="<?= ((isset($data))? md5($data->id):'') ?>">
            <input type="hidden" id="ttl_tunjangan_input" value="<?= ((isset($data))? $data->ttl_tunjangan:'') ?>">
            <input type="hidden" id="ttl_penerimaan_input" value="<?= ((isset($data))? $data->ttl_penerimaan:'') ?>">
            <input type="hidden" id="ttl_potongan_input" value="<?= ((isset($data))? $data->ttl_potongan:'') ?>">
            <input type="hidden" id="gaji_diterima_input" value="<?= ((isset($data))? $data->gaji_diterima:'') ?>">
            <div class="row">
                <div class="col-md-4">
                    <div class="row">
                        <div class="col-md-12 text-bold-600 font-size-large">PENDAPATAN</div>
                    </div>
                    <hr>
                    <div class="row form-group">
                        <div class="col-md-8 ">Gaji Pokok</div>
                        <div class="col-md-4">
                            <input type="text" id="gaji_pokok" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->gaji_pokok:'') ?>">
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-8 ">Tunjangan Jabatan</div>
                        <div class="col-md-4">
                        <input type="text" id="t_jabatan" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->t_jabatan :'') ?>">
                        </div>
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Tunjangan Transport</div>
                        <div class="col-md-4">
                            <input type="text" id="t_transport" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->t_transport :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Tunjangan Makan</div>
                        <div class="col-md-4">
                            <input type="text" id="t_makan" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->t_makan :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Tunjangan Istri</div>
                        <div class="col-md-4">
                            <input type="text" id="t_istri" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->t_istri :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Tunjangan Anak</div>
                        <div class="col-md-4">
                            <input type="text" id="t_anak" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->t_anak :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Lembur</div>
                        <div class="col-md-4">
                            <input type="text" id="lembur" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->lembur :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Komisi</div>
                        <div class="col-md-4">
                            <input type="text" id="komisi" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->komisi :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Lain - Lain</div>
                        <div class="col-md-4">
                            <input type="text" id="t_lain" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->t_lain :'') ?>">
                        </div>    
                    </div>
                    <hr>
                    <div class="row mt-2 font-weight-bold" style="font-size:15px">
                        <div class="col-md-8">TOTAL PENADAPATAN</div>
                        <div class="col-md-4 text-right">
                            <span class='pull-left'>Rp</span>
                            <span id="ttl_penerimaan"><?= ((isset($data))? number_format($data->ttl_penerimaan,0,",","."):'0') ?></span>,00
                        </div>
                    </div>
                    
                </div>
                <div class="col-md-4">
                    <div class="row">
                        <div class="col-md-12 text-bold-600 font-size-large">TUNJANGAN DIBIAYAI PERUSAHAAN</div>
                    </div>
                    <hr>
                    <div class="row mt-1">
                        <div class="col-md-8 ">BPJS Ketenagakerjaan</div>
                        <div class="col-md-4">
                            <input type="text" id="tbp_bpjs_tk" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->tbp_bpjs_tk :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">BPJS Kesehatan</div>
                        <div class="col-md-4">
                            <input type="text" id="tbp_bpjs_kesehatan" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->tbp_bpjs_kesehatan :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Lain - Lain</div>
                        <div class="col-md-4">
                            <input type="text" id="tbp_lain" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->tbp_lain :'') ?>">
                        </div>    
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="row">
                        <div class="col-md-12 text-bold-600 font-size-large">POTONGAN</div>
                    </div>
                    <hr>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Absensi</div>
                        <div class="col-md-4">
                            <input type="text" id="p_absensi" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->p_absensi :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Keterlambatan</div>
                        <div class="col-md-4">
                            <input type="text" id="p_keterlambatan" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->p_keterlambatan :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Koperasi</div>
                        <div class="col-md-4">
                            <input type="text" id="p_koperasi" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->p_koperasi :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Asuransi Kesehatan</div>
                        <div class="col-md-4">
                            <input type="text" id="p_asuransi_kesehatan" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->p_asuransi_kesehatan :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">BPJS Ketenagakerjaan</div>
                        <div class="col-md-4">
                            <input type="text" id="p_bpjs_tk" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->p_bpjs_tk :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">BPJS Kesehatan</div>
                        <div class="col-md-4">
                            <input type="text" id="p_bpjs_kesehatan" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->p_bpjs_kesehatan :'') ?>">
                        </div>    
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-8 ">Lain - Lain</div>
                        <div class="col-md-4">
                            <input type="text"  id="p_lain" class="form-control text-right numeric" onkeyup="hitung_gaji()" value="<?= ((isset($data))? $data->p_lain :'') ?>">
                        </div>    
                    </div>
                    <hr>
                    <div class="row mt-2 font-weight-bold" style="font-size:15px">
                        <div class="col-md-8">TOTAL POTONGAN</div>
                        <div class="col-md-4 text-right">
                            <span class='pull-left'>Rp</span>
                            <span id="ttl_potongan"><?= ((isset($data))? number_format($data->ttl_potongan,0,",","."):'0') ?></span>,00
                        </div>
                    </div>
                    <div class="row mt-1 font-weight-bold" style="font-size:15px">
                        <div class="col-md-8">GAJI DITERIMA</div>
                        <div class="col-md-4 text-right">
                            <span class='pull-left'>Rp</span>
                            <span id="gaji_diterima"><?= ((isset($data))? number_format($data->gaji_diterima,0,",","."):'0') ?></span>,00
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <label id="message"></label>
                    <a href="<?= route('informasi.gaji.home') ?>">
                        <button type="button" class="btn btn-secondary" id="btn_kembali"><i class="fa fa-arrow-left"></i> KEMBALI</button>
                    </a>
                    <button type="button" id="btn_update" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(".numeric").autoNumeric('init', {
        aSep: '.', 
        aDec: ',',
        aForm: true,
        vMax: '999999999',
        vMin: '0'
    });
</script>