<?php

/**
 * Welcome to Luthier-CI!
 *
 * This is your main route file. Put all your HTTP-Based routes here using the static
 * Route class methods
 *
 * Examples:
 *
 *    Route::get('foo', 'bar@baz');
 *      -> Route::['foo']['GET','bar/baz';
 *
 *    Route::post('bar', 'baz@fobie', [ 'namespace' => 'cats' ]);
 *      -> Route::['bar']['POST','cats/baz/foobie';
 *
 *    Route::get('blog/{slug}', 'blog@post');
 *      -> Route::['blog/{id}','blog/post'
 */

Route::get('/', function(){
    redirect(route('login'));
})->name('homepage');

Route::set('404_override', function(){
    show_404();
    // redirect(route('page.not.found'));
});

Route::set('translate_uri_dashes',FALSE);

Route::get('image','Image@index');
Route::get('imagebiodata','Image@image_bodata');
Route::get('syarat-dan-ketentuan', 'Syarat_ketentuan@index');

Route::get('auto_login/{username?}/{token?}','Auto_login@index');
Route::group('login', function(){
    Route::get('','Auth@index')->name('login');
    Route::post('proses','Auth@login');
    Route::get('captcha','Auth@captcha');
});
Route::get('logout','Auth@logout');

//Route::get('menu','Akses_menu@index');

Route::group('api', function(){
    Route::post('registrasi/cabang','Cabang@registrasi');
    Route::group('notif',function(){
        Route::get('receive/{par}', 'Socket_send@receive_notification');
        Route::get('send/{target?}/{id_room?}','Socket_send@notif_izin');
    });

});

Route::get('halaman-tidak-ditemukan','Page_not_found@index')->name('page.not.found');

Route::group('support',function(){
	Route::get('','Support@index');
	Route::get('login','Support@login');
	Route::get('logout','Support@logout');
	Route::get('select2_company','Support@select2_company');
	Route::get('detail_company','Support@detail_company');
	Route::get('save','Support@save');
});

$args = ['foo' => 'bar'];
// $this->middleware->run('AuthMiddleware', $args);
Route::get('test/{id?}',function(){
    echo "routing";
},['namespace' => 'foo', 'middleware' => 'Staff:1,2,3']);

Route::get('test2',function(){
    echo "routing";
},['namespace' => 'foo', 'middleware' => 'Staff']);

Route::group('wizard', ['middleware' => ['Otentikasi_wizard']], function() {
    Route::get('','Wizard@index');
    Route::group('notifikasi', function() {
        Route::get('email','Wizard_notifikasi@kirim_email')->name('wizard.notifikasi.email');
        Route::get('whatsapp','Wizard_notifikasi@kirim_whatsapp')->name('wizard.notifikasi.whatsapp');
    });
    Route::get('select2_departemen','Wizard_kepala_departemen@select2_departemen');
    Route::get('select2_departemen_staff','Wizard_staff@select2_departemen');
    Route::get('cek_username','Wizard_kepala_departemen@cek_username');
    Route::group('kepala_departemen', function() {
        Route::get('insert','Wizard_kepala_departemen@insert');
    });
    Route::group('lokasi', function() {
        Route::get('','Wizard_lokasi@index');
        Route::post('insert','Wizard_lokasi@insert');
        Route::post('update','Wizard_lokasi@update');
    });
    Route::group('akun', function() {
        Route::group('kepala-departemen', function() {
        Route::get('','Wizard_kepala_departemen@index')->name('wizard.akun.kepala_departemen.home');
        Route::get('tambah','Wizard_kepala_departemen@tambah_akun')->name('wizard.akun.kepala_departemen.tambah');
        Route::post('insert','Wizard_kepala_departemen@insert')->name('wizard.akun.kepala_departemen.insert');
        Route::post('update','Wizard_kepala_departemen@update')->name('wizard.akun.kepala_departemen.update');
        });
        Route::group('staff', function() {
        Route::get('','Wizard_staff@index')->name('wizard.akun.staff.home');
        Route::get('tambah','Wizard_staff@tambah_akun')->name('wizard.akun.staff.tambah');
        Route::post('insert','Wizard_staff@insert')->name('wizard.akun.staff.insert');
        Route::post('update','Wizard_staff@update')->name('wizard.akun.staff.update');
        });
    });
    Route::group('akun', function() {
        Route::get('tambah','Wizard_tambah_akun@tambah')->name('wizard.akun.tambah');
        Route::get('pilih','Wizard_tambah_akun@pilih')->name('wizard.akun.pilih');
    });
    Route::get('selesai','Wizard_tambah_akun@index')->name('wizard.selesai');
    Route::get('berhasil','Wizard@berhasil')->name('wizard.berhasil');
    Route::get('dashboard','Wizard@dashboard')->name('wizard.dashboard');
});

Route::group('', ['middleware' => ['Otentikasi_login']], function()
{

    Route::get('new-token-req', 'Auth@token_req_new')->name('new.token.req');

    Route::get('ganti-password','Auth@ganti_password')->name("ganti.password");
    Route::post('gantipassword/proses','Auth@ganti_password_save')->name("ganti.password.proses");

    Route::group('dropdown', function(){
        Route::get('jabatan','Dropdown_menu@jabatan')->name('dropdown.jabatan');
        Route::get('jabatan/by/{cabang?}/{departemen?}','Dropdown_menu@jabatan_by_departemen')->name('dropdown.jabatan.by.departemen');
        Route::get('cabang','Dropdown_menu@cabang')->name('dropdown.cabang');
        Route::get('departemen','Dropdown_menu@departemen')->name('dropdown.departemen');
        Route::get('departemen/by/cabang/{cabang?}','Dropdown_menu@departemen_by_cabang')->name('dropdown.departemen.by.cabang');
        Route::get('supervisi/{id_cabang?}/{id_departemen?}','Dropdown_menu@supervisi')->name('dropdown.supervisi');
        Route::get('karyawan','Dropdown_menu@karyawan')->name('dropdown.karyawan');
        Route::get('karyawan/enc','Dropdown_menu@karyawan_encrypt')->name('dropdown.karyawan.encrypt');
        Route::get('karyawan/aktif/{id_cabang?}','Dropdown_menu@karyawanAktif')->name('dropdown.karyawan.aktif');
        Route::get('lokasi-absensi','Dropdown_menu@lokasi_absensi')->name('dropdown.lokasiabsensi');
        Route::get('provinsi','Dropdown_menu@provinsi')->name('dropdown.provinsi');
        Route::get('kota/{id_prov?}','Dropdown_menu@kota')->name('dropdown.kota');
        Route::get('kecamatan/{id_kota?}','Dropdown_menu@kecamatan')->name('dropdown.kecamatan');
        Route::get('kelurahan/{id_kecamatan?}','Dropdown_menu@kelurahan')->name('dropdown.kelurahan');
        Route::get('jam-kerja/{id_cabang?}','Dropdown_menu@getJamKerja')->name('dropdown.jamkerja');
        Route::get('jam-kerja-karyawan','Dropdown_menu@getJamKerjaKaryawan')->name('dropdown.jamkerjakaryawan');
        Route::get('jam-shift','Dropdown_menu@getJamShift')->name('dropdown.jamshift');
        Route::get('nama-shift/{id_cabang?}','Dropdown_menu@getNamaShift')->name('dropdown.shift.nama');
        Route::get('jenis-izin','Dropdown_menu@getJenisIzin')->name('dropdown.jenisizin');
        Route::get('akun-reimbursement','Dropdown_menu@get_akun')->name('dropdown.akun.reimbursement');

        // Dropdown PPH
        Route::get('karyawan-pph/{periode?}','Dropdown_menu@karyawan_pph')->name('dropdown.karyawan.pph');
        Route::get('cabang-pph/{periode?}','Dropdown_menu@cabang_pph')->name('dropdown.cabang.pph');
        Route::get('departemen-pph/{periode?}/{cabang?}','Dropdown_menu@departemen_pph')->name('dropdown.departemen.pph');

    });

    Route::group('notification', function(){
        Route::get('notif-izin/{param?}','Dashboard@notif_izin');
        Route::get('notif-lembur/{param?}','Dashboard@notif_lembur');
        Route::get('notif-reimbursement/{param?}','Dashboard@notif_reimbursement');
    });

    Route::group('dashboard',['middleware' => 'Auth_menu:1,2,4,5,7'], function(){
        Route::group('absensi', function(){

            Route::get('layanan','Dashboard@dataLayanan')->name('dashboard.layanan');

            Route::group('ttl-karyawan', function(){
                Route::get('genre/{id_cabang?}/{id_departemen?}','dashboards/Total_karyawan@ttlkaryawanByGenre')->name('dashboard.absensi.ttl.karyawan.genre');
                Route::group('dropdown', function(){
                    Route::get('cabang','dashboards/Total_karyawan@dropdown_cabang')->name('dashboard.absensi.ttl.karyawan.dropdown.cabang');
                    Route::get('departemen/{id_cabang?}','dashboards/Total_karyawan@dropdown_departemen')->name('dashboard.absensi.ttl.karyawan.dropdown.departemen');
                });
            });

            Route::group('grafik', function(){
                Route::group('data-karyawan', function(){
                    Route::get('data/{id_cabang?}/{id_departemen?}','dashboards/Data_karyawan@dataKaryawan')->name('dashboard.absensi.grafik.data.karyawan.data');
                    Route::get('form/{tahun?}/{id_cabang?}/{id_departemen?}','dashboards/Data_karyawan@form')->name('dashboard.absensi.grafik.data.karyawan.form');
                    Route::post('data-tabel/{tahun?}/{id_cabang?}/{id_departemen?}','dashboards/Data_karyawan@dataTable')->name('dashboard.absensi.grafik.data.karyawan.data.tabel');
                    Route::group('dropdown', function(){
                        Route::get('cabang','dashboards/Data_karyawan@dropdown_cabang')->name('dashboard.absensi.grafik.data.karyawan.dropdown.cabang');
                        Route::get('departemen/{id_cabang?}','dashboards/Data_karyawan@dropdown_departemen')->name('dashboard.absensi.grafik.data.karyawan.dropdown.departemen');
                    });
                });
                Route::group('joint_vs_termination', function(){
                    Route::get('data/{tahun?}/{id_cabang?}/{id_departemen?}','dashboards/Joint_vs_termination@JoinVsTermination')->name('dashboard.absensi.grafik.joint.termination.data');
                    Route::get('form/{jenis?}/{tahun?}/{bulan?}/{id_cabang?}/{id_departemen?}','dashboards/Joint_vs_termination@form')->name('dashboard.absensi.grafik.joint.termination.form');
                    Route::post('data-tabel/{jenis?}/{tahun?}/{bulan?}/{id_cabang?}/{id_departemen?}','dashboards/Joint_vs_termination@dataTable')->name('dashboard.absensi.grafik.joint.termination.data.tabel');
                    Route::group('dropdown', function(){
                        Route::get('tahun','dashboards/Joint_vs_termination@dropdown_tahun')->name('dashboard.absensi.grafik.joint.termination.dropdown.tahun');
                        Route::get('cabang','dashboards/Joint_vs_termination@dropdown_cabang')->name('dashboard.absensi.grafik.joint.termination.dropdown.cabang');
                        Route::get('departemen/{id_cabang?}','dashboards/Joint_vs_termination@dropdown_departemen')->name('dashboard.absensi.grafik.joint.termination.dropdown.departemen');
                    });
                });

                Route::group('keterlambatan', function(){
                    Route::get('data/{id_cabang?}/{tgl_mulai?}/{tgl_selesai?}','dashboards/Keterlambatan@data')->name('dashboard.absensi.grafik.keterlambatan.data');
                    Route::group('dropdown', function(){
                        Route::get('cabang','dashboards/Keterlambatan@dropdown_cabang')->name('dashboard.absensi.grafik.keterlambatan.dropdown.cabang');
                    });
                });

            });

            Route::get('','dashboard@index')->name('dashboard.absensi');
            Route::get('lst/data/{jenis?}','dashboard@dashboard_list')->name('dashboard.list.data');

            Route::get('list_cabang_selected','dashboard@list_cabang_selected');
            Route::get('data/diagram/pie/{id_cabang?}/{id_shift?}','Dashboard@data_pie')->name('dashboard.absensi.data.diagram.pie');
            Route::get('data/diagram/pie/detail/{jenis?}/{id_cabang?}/{id_shift?}','Dashboard@data_pie_detail')->name('dashboard.absensi.data.diagram.pie.detail');

            Route::group('detail', function(){
                Route::get('data/{id_cabang?}/{id_shift?}','Dashboard_absensi@index')->name('dashboard.absensi.detail.data');
                Route::get('list','Dashboard_absensi@list_data');
                Route::get('list_absensi','Dashboard_absensi@list_absensi');
                Route::get('list_absensi_selected','Dashboard_absensi@list_absensi_selected');
                Route::get('excel','Dashboard_absensi@excel');
                Route::get('view-data/{cabang?}/{departemen?}/{jadwal?}/{status?}','Dashboard_absensi@view_data');
                Route::get('list-data/{cabang?}/{departemen?}/{jadwal?}/{status?}','Dashboard_absensi@list_data')->name('dashboard.absensi.detail.list.data');
                Route::get('lokasi/{jenis?}/{id?}','Dashboard_absensi@lokasi');
                Route::get('data_dashboard/{id_cabang?}/{id_departemen?}/{id_shift?}/{status?}','Dashboard_absensi@data_dashboard');
                // Route::get('get-departemen/{id}','Dashboard_absensi@get_departemen');
            });
        });

        Route::group('kepegawaian', function(){
            Route::get('','Kepegawaian@index')->name('dashboard.kepegawaian');
            Route::get('diagram/status-karyawan/{id?}','Kepegawaian@data_kepegawaian')->name("dashboard.kepegawaian.diagram.status");
            Route::get('diagram/pendidikan/{id_cabang?}','Kepegawaian@data_pendidikan')->name("dashboard.kepegawaian.diagram.pendidikan");
            Route::get('data/kontrak-berakhir','Kepegawaian@daftar_kontrak')->name("dashboard.kepegawaian.data.kontrak.berakhir");
            Route::get('data/kontrak-berakhir/list','Kepegawaian@list_data')->name("dashboard.kepegawaian.data.kontrak.list");;
            Route::get('data/kontrak-berakhir/download','Kepegawaian@download')->name('dashboard.kepegawaian.kontrak.berakhir.download');
        });
    });

    Route::group('master',function(){

        Route::group('cabang',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Cabang@index');
                Route::get('list_data','Cabang@list_data');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('form/tambah','Cabang@form');
                Route::get('form/edit/{id}','Cabang@form');
                Route::get('form/hapus/{id}','Cabang@form');
                Route::post('save','Cabang@save');
                Route::post('delete','Cabang@delete');
                Route::get('getCabang','Cabang@getCabangByName');
            });
        });

        Route::group('lokasi',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4,5'],function(){
                Route::get('','Lokasi@index')->name('master.lokasi.home');
                Route::get('list_data','Lokasi@ajax_list');
                Route::get('maps/json/{id_cabang?}','Lokasi@maps')->name('master.lokasi.maps.json');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('tambah','Lokasi@tambah')->name('master.lokasi.tambah');
                Route::get('edit/{id}','Lokasi@edit');
                Route::post('delete','Lokasi@delete');
                Route::post('save','Lokasi@insert');
                Route::post('update','Lokasi@update');
            });
        });

        Route::group('departemen',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4,5'],function(){
                Route::get('','Departemen@index');
                Route::get('list_data','Departemen@list_data');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('form/tambah','Departemen@form');
                Route::get('form/edit/{id}','Departemen@form');
                Route::get('form/hapus/{id}','Departemen@form');
                Route::post('save','Departemen@save');
                Route::post('delete','Departemen@delete');
            });
        });

        Route::group('jabatan',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4,5'],function(){
                Route::get('','Jabatan@index');
                Route::get('list_data','Jabatan@list_data');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('form/tambah','Jabatan@form');
                Route::get('form/edit/{id}','Jabatan@form');
                Route::get('form/hapus/{id}','Jabatan@form');
                Route::post('save','Jabatan@save');
                Route::post('delete','Jabatan@delete');
            });
        });

        Route::group('shift',function(){
            Route::group('',['middleware' => 'Auth_menu:1,2,4,5,7'],function(){
                Route::get('','Shift@index');
                Route::get('list_data','Shift@list_data')->name('master.shift.listdata');
            });
            Route::group('',['middleware' => 'Auth_menu:1,5'],function(){
                Route::get('form/tambah','Shift@form')->name('master.shift.form.tambah');
                Route::get('form/edit/{id?}','Shift@form')->name('master.shift.form.edit');
                Route::get('form/hapus/{id?}','Shift@form')->name('master.shift.form.hapus');
                Route::post('save','Shift@save')->name('master.shift.save');
                Route::post('delete','Shift@delete')->name('master.shift.delete');
            });
        });

        Route::group('karyawan',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4,2,5,7'],function(){
                Route::get('','Karyawan@index');
                Route::get('tabs/{tabs?}','Karyawan@tabs')->name('master.karyawan.tabs');
                Route::get('data/tabs/content/jabatan/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{status?}/{id_karyawan?}','Karyawan@data_tabs_jabatan')->name('master.karyawan.tabs.content.jabatan');
                Route::get('data/tabs/content/pengguna-aktif/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{id_karyawan?}','Karyawan@data_tabs_pengguna_aktif')->name('master.karyawan.tabs.content.pengguna.aktif');
                Route::get('data/tabs/content/pendidikan/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{pendidikan?}/{id_karyawan?}','Karyawan@data_tabs_pendidikan')->name('master.karyawan.tabs.content.pendidikan');
                Route::get('data/tabs/content/lokasi/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{lock_lokasi?}/{id_karyawan?}','Karyawan@data_tabs_lokasi')->name('master.karyawan.tabs.content.lokasi');
                Route::get('data/tabs/content/device/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{lock_device?}/{id_karyawan?}','Karyawan@data_tabs_device')->name('master.karyawan.tabs.content.device');
                Route::get('data/tabs/content/facerecognition/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{lock_facerecognition?}/{id_karyawan?}','Karyawan@data_tabs_facerecognition')->name('master.karyawan.tabs.content.facerecognition');
                Route::get('data/tabs/content/camera/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{camera?}/{id_karyawan?}','Karyawan@data_tabs_camera')->name('master.karyawan.tabs.content.camera');
                Route::get('detail/{id?}','Karyawan@detail')->name('master.karyawan.detail');
                Route::get('export-pdf/{id}','Karyawan@export_pdf');
                Route::get('view-pdf/{id}','Karyawan@view_pdf');
                Route::get('download/excel/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{status?}/{id_karyawan?}','Karyawan@download')->name('master.karyawan.download.excel');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::post('delete','Karyawan@delete')->name('master.karyawan.delete');
                Route::get('form/tambah','Karyawan@form')->name('master.karyawan.tambah');
                Route::get('home/import','Karyawan_import@index')->name("karyawan.import.home");
                Route::get('unduh/template','Karyawan_import@download_template')->name('karyawan.import.download.template');
                Route::post('excel','Karyawan_import@import_data_excel')->name('karyawan.import.excel');
                Route::get('view-data','Karyawan_import@view_data')->name('karyawan.import.viewdata');
                Route::post('list-data','Karyawan_import@list_data')->name('karyawan.import.listdata');
                Route::delete('delete/all','Karyawan_import@delete_all_temp')->name('karyawan.import.deleteall');
                Route::get('form/temp/edit/{id?}','Karyawan_import@form_edit')->name("karyawan.import.form.edit");
                Route::post('delete/karyawan/import','Karyawan_import@delete')->name('karyawan.import.delete');
                Route::post('save','Karyawan_import@save')->name('karyawan.import.save');
                Route::post('publish/all','Karyawan_import@publish_all')->name('karyawan.import.publishall');
            });


            Route::group('data-diri', function(){
                Route::group('',['middleware' => 'Auth_menu:1,4,2,5,7'],function(){
                    Route::get('form','Data_diri@index')->name('master.karyawan.datadiri.form');
                    Route::get('detail/{id_karyawan?}','Data_diri@detail_datadiri')->name('master.karyawan.datadiri.detail');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/edit/{id?}','Data_diri@edit')->name('master.karyawan.datadiri.form.edit');
                    Route::get('edit/{id}','Karyawan@data_diri_edit')->name('master.karyawan.datadiri.edit');
                    Route::post('save','Data_diri@save')->name('master.karyawan.datadiri.save');

                });
            });

            Route::group('keluarga', function(){
                Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                    Route::get('home/{id_karyawan?}','Data_keluarga@main')->name('master.karyawan.keluarga.home');
                    Route::get('data/{id_karyawan?}','Data_keluarga@list_data')->name('master.karyawan.keluarga.data');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/tambah/{id_karyawan?}','Data_keluarga@form')->name('master.karyawan.keluarga.form.tambah');
                    Route::get('form/edit/{id_karyawan?}/{id_keluarga?}','Data_keluarga@form')->name('master.karyawan.keluarga.form.edit');
                    Route::get('form/delete/{id_karyawan?}/{id_keluarga?}','Data_keluarga@form')->name('master.karyawan.keluarga.form.delete');
                    Route::post('save/','Data_keluarga@save')->name('master.karyawan.keluarga.save');
                    Route::post('delete/','Data_keluarga@delete')->name('master.karyawan.keluarga.delete');
                });
            });

            Route::group('riwayat-pendidikan', function(){
                Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                    Route::get('home/{id_karyawan?}','Riwayat_pendidikan@index')->name('master.karyawan.riwayatpendidikan.home');
                    Route::get('data/{id_karyawan?}','Riwayat_pendidikan@list_data')->name('master.karyawan.riwayatpendidikan.data');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/tambah/{id_karyawan?}','Riwayat_pendidikan@form')->name('master.karyawan.riwayatpendidikan.form.tambah');
                    Route::get('form/edit/{id_karyawan?}/{id_pendidikan?}','Riwayat_pendidikan@form')->name('master.karyawan.riwayatpendidikan.form.edit');
                    Route::get('form/delete/{id_karyawan?}/{id_pendidikan?}','Riwayat_pendidikan@form')->name('master.karyawan.riwayatpendidikan.form.delete');
                    Route::post('save','Riwayat_pendidikan@save')->name('master.karyawan.riwayatpendidikan.save');
                    Route::post('delete','Riwayat_pendidikan@delete')->name('master.karyawan.riwayatpendidikan.delete');
                });
            });

            Route::group('pengalaman-kerja', function(){
                Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                    Route::get('home/{id_karyawan?}','Pengalaman_kerja@data')->name('master.karyawan.pengalamankerja.home');
                    Route::get('list-data/{id_karyawan?}','Pengalaman_kerja@list_data')->name('master.karyawan.pengalamankerja.listdata');
                    Route::post('list-datatables/{id_karyawan?}','Pengalaman_kerja@list_datatables')->name('master.karyawan.pengalamankerja.listdatatables');
                    Route::get('form/detail/{id_riwayat_pekerjaan?}','Pengalaman_kerja@detail')->name('master.karyawan.pengalamankerja.form.detail');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/tambah/{id_karyawan?}','Pengalaman_kerja@form')->name('master.karyawan.pengalamankerja.form.tambah');
                    Route::get('form/edit/{id_karyawan?}/{id_riwayat_pekerjaan?}','Pengalaman_kerja@form')->name('master.karyawan.pengalamankerja.form.edit');;
                    Route::post('save','Pengalaman_kerja@save')->name('master.karyawan.pengalamankerja.save');
                    Route::post('delete','Pengalaman_kerja@delete')->name('master.karyawan.pengalamankerja.delete');
                });
            });

            Route::group('karir-pekerjaan', function(){
                Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                    Route::get('home/{id_karyawan?}','Karir_pekerjaan@index')->name('master.karyawan.karirpekerjaan.home');
                    Route::get('data/{id_karyawan?}','Karir_pekerjaan@list_data')->name('master.karyawan.karirpekerjaan.data');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/tambah/{id_karyawan?}','Karir_pekerjaan@form')->name('master.karyawan.karirpekerjaan.form.tambah');
                    Route::get('form/edit/{id_karyawan?}/{id_karir_pekerjaan?}','Karir_pekerjaan@form')->name('master.karyawan.karirpekerjaan.form.edit');
                    Route::get('form/delete/{id_karyawan?}/{id_karir_pekerjaan?}','Karir_pekerjaan@form')->name('master.karyawan.karirpekerjaan.form.delete');
                    Route::post('save','Karir_pekerjaan@save')->name('master.karyawan.karirpekerjaan.save');
                    Route::post('delete','Karir_pekerjaan@delete')->name('master.karyawan.karirpekerjaan.delete');
                });
            });

            Route::group('sertifikat', function(){
                Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                    Route::get('home/{id_karyawan?}','Data_sertifikat@index')->name('master.karyawan.sertifikat.home');
                    Route::get('data/{id_karyawan?}','Data_sertifikat@list_data')->name('master.karyawan.sertifikat.data');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/tambah/{id_karyawan?}','Data_sertifikat@form')->name('master.karyawan.sertifikat.form.tambah');
                    Route::get('form/edit/{id_karyawan?}/{id_sertifikat?}','Data_sertifikat@form')->name('master.karyawan.sertifikat.form.edit');
                    Route::get('form/delete/{id_karyawan?}/{id_sertifikat?}','Data_sertifikat@form')->name('master.karyawan.sertifikat.form.delete');
                    Route::post('save','Data_sertifikat@save')->name('master.karyawan.sertifikat.save');
                    Route::post('delete','Data_sertifikat@delete')->name('master.karyawan.sertifikat.delete');
                });
            });

            Route::group('akun', function(){
                Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                    Route::get('home/{id_karyawan?}','Data_akun@index')->name('master.karyawan.akun.home');
                    Route::get('data/{id_karyawan?}','Data_akun@list_data')->name('master.karyawan.akun.data');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/edit/{id_karyawan?}/{id_akun?}','Data_akun@form')->name('master.karyawan.akun.form.edit');
                    Route::post('save','Data_akun@save')->name('master.karyawan.akun.save');
                    Route::post('deviceid/reset','Data_akun@reset_deviceid')->name('master.karyawan.akun.reset.deviceid');
                    Route::post('facerecognition/reset','Data_akun@reset_facerecognition')->name('master.karyawan.akun.reset.facerecognition');
                    Route::post('kamera/save','Data_akun@save_camera')->name('master.karyawan.akun.kamera.save');
                });
            });

            Route::group('kelengkapan-file', function(){
                Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                    Route::get('home/{id_karyawan?}','Data_kelengkapan_file@index')->name('master.karyawan.kelengkapanfile.home');
                    Route::get('data/{id_karyawan?}','Data_kelengkapan_file@list_data')->name('master.karyawan.kelengkapanfile.data');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/tambah/{id_karyawan?}','Data_kelengkapan_file@form')->name('master.karyawan.kelengkapanfile.form.tambah');
                    Route::get('form/edit/{id_karyawan?}/{id_file?}','Data_kelengkapan_file@form')->name('master.karyawan.kelengkapanfile.form.edit');
                    Route::get('form/delete/{id_karyawan?}/{id_file?}','Data_kelengkapan_file@form')->name('master.karyawan.kelengkapanfile.form.delete');
                    Route::post('save','Data_kelengkapan_file@save')->name('master.karyawan.kelengkapanfile.save');
                    Route::post('delete','Data_kelengkapan_file@delete')->name('master.karyawan.kelengkapanfile.delete');
                });
            });

            Route::group('payroll', function(){
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('home/{id_karyawan?}','karyawan_detail/Payroll@index')->name('master.karyawan.payroll.home');
                    Route::get('form/{id}/{id_karyawan}','karyawan_detail/Payroll@form')->name('master.karyawan.payroll.form');
                    Route::post('save','karyawan_detail/Payroll@save')->name('master.karyawan.payroll.save');
                });
            });
        });

        Route::group('jenis-izin',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Jenis_izin@index');
                Route::get('list_data','Jenis_izin@list_data')->name('master.jenisizin.listdata');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('form/tambah','Jenis_izin@form')->name('master.jenisizin.form.tambah');
                Route::get('form/edit/{id_izin?}','Jenis_izin@form')->name('master.jenisizin.form.edit');
                Route::get('form/hapus/{id_izin?}','Jenis_izin@form')->name('master.jenisizin.form.hapus');
                Route::post('save','Jenis_izin@save')->name('master.jenisizin.save');
                Route::post('delete','Jenis_izin@delete')->name('master.jenisizin.delete');
            });
        });

    });

    //PENGATURAN
    Route::group('pengaturan',function(){
        Route::group('perusahaan',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4,6'],function(){
                Route::get('','Pengaturan_perusahaan@index');
                Route::get('invoice-pdf/{id}','Pengaturan_perusahaan@invoice_pdf');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('logo/form/edit/{id_company?}','Pengaturan_perusahaan@form')->name('pengaturan.perusahaan.logo.form.edit');
                Route::post('logo/save','Pengaturan_perusahaan@save_profil')->name('pengaturan.perusahaan.logo.save');
            });
        });
        Route::group('umum',function(){
            Route::get('','Pengaturan_umum@index',['middleware' => 'Auth_menu:1,4'])->name('pengaturan.umum.home');
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::post('save','Pengaturan_umum@save')->name('pengaturan.umum.save');
                Route::post('save/cuti','Pengaturan_umum@reset_cuti')->name('pengaturan.umum.save.cuti');
            });
        });

        Route::group('jam-kerja',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Jadwal_kerja@index')->name('pengaturan.jamkerja.home');
                Route::get('data','Jadwal_kerja@list_data')->name('pengaturan.jamkerja.listdata');
                Route::get('detail/{id_cabang?}','Jadwal_kerja@detail')->name('pengaturan.jamkerja.detail');
                Route::post('jadwal','Jadwal_kerja@jam_kerja')->name('pengaturan.jamkerja.jadwal');
            });
            Route::post('update','Jadwal_kerja@update',['middleware' => 'Auth_menu:1'])->name('pengaturan.jamkerja.update');
        });

        Route::group('shift',function(){
            Route::group('',['middleware' => 'Auth_menu:1,2,4,5,7'],function(){
                Route::get('','Pengaturan_shift@index')->name("pengaturan.shift.home");
                Route::get('form/{jenis?}/{id?}','Pengaturan_shift@form')->name('pengaturan.shift.form');
                Route::post('edit','Pengaturan_shift@edit')->name('pengaturan.shift.edit');
                Route::post('delete','Pengaturan_shift@delete')->name('pengaturan.shift.delete');
                Route::post('save','Pengaturan_shift@save');

                Route::get('tambah','Pengaturan_shift@form');
                Route::get('edit/{id}','Pengaturan_shift@edit');

                Route::post('update','Pengaturan_shift@save_lawas');
                Route::post('import','Pengaturan_shift@import');
                Route::get('data/view/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Pengaturan_shift@view_data')->name('pengaturan.shift.data.view');
                Route::get('data/list/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Pengaturan_shift@list_data')->name('pengaturan.shift.data.list');
            });

            Route::group('import',['middleware' => 'Auth_menu:1,2,4,5,7'],function(){
                Route::get('home','Pengaturan_shift_import@index')->name("pengaturan.shift.import.home");
                Route::get('view-data','Pengaturan_shift_import@view_data')->name('pengaturan.shift.import.viewdata');
                Route::post('list-data','Pengaturan_shift_import@list_data')->name('pengaturan.shift.import.listdata');
                Route::get('unduh/template/{tgl_mulai?}/{tgl_selesai?}/{id_cabang?}/{id_departemen?}','Pengaturan_shift_import@download_template')->name('pengaturan.shift.import.unduh.tempate');
                Route::post('excel','Pengaturan_shift_import@import_data_excel')->name('pengaturan.shift.import.excel');
                Route::get('form/edit/{id?}','Pengaturan_shift_import@form_edit')->name('pengaturan.shift.import.form.edit');
                Route::get('form/template-import','Pengaturan_shift_import@form_template_import')->name('pengaturan.shift.import.form.templateimport');
                Route::post('update','Pengaturan_shift_import@update')->name('pengaturan.shift.import.update');
                Route::post('delete','Pengaturan_shift_import@delete_temp')->name('pengaturan.shift.import.delete');
                Route::post('publish/all','Pengaturan_shift_import@publish_all')->name('pengaturan.shift.import.publishall');
                Route::delete('delete/all','Pengaturan_shift_import@delete_all_temp')->name('pengaturan.shift.import.deleteall');
            });
        });

        Route::group('kepala-cabang',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Kepala_cabang@index')->name("pengaturan.kepalacabang.home");
                Route::get('data','Kepala_cabang@list_data')->name("pengaturan.kepalacabang.data");
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('form/edit/{id?}','Kepala_cabang@form')->name("pengaturan.kepalacabang.form.edit");
                Route::post('update','Kepala_cabang@update')->name("pengaturan.kepalacabang.update");
            });
        });

        Route::group('kepala-departemen',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Kepala_departemen@index')->name("pengaturan.kepaladepartemen.home");
                Route::get('data','Kepala_departemen@list_data')->name("pengaturan.kepaladepartemen.data");
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('form/edit/{id_karyawan?}','Kepala_departemen@form')->name("pengaturan.kepaladepartemen.form.edit");
                Route::post('update','Kepala_departemen@update')->name("pengaturan.kepaladepartemen.update");
            });
        });
        Route::group('adm-reimbursement',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('home','pengaturan/Adm_reimbursement@index')->name("pengaturan.adm.reimbursement.home");
                Route::get('data','pengaturan/Adm_reimbursement@list_data')->name("pengaturan.adm.reimbursement.data");
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('form/tambah','pengaturan/Adm_reimbursement@form')->name("pengaturan.adm.reimbursement.form.tambah");
                Route::get('form/edit/{id?}','pengaturan/Adm_reimbursement@form')->name("pengaturan.adm.reimbursement.form.edit");
                Route::get('form/hapus/{id?}','pengaturan/Adm_reimbursement@form_delete')->name("pengaturan.adm.reimbursement.form.hapus");
                Route::post('save','pengaturan/Adm_reimbursement@save')->name("pengaturan.adm.reimbursement.save");
                Route::post('delete','pengaturan/Adm_reimbursement@delete')->name("pengaturan.adm.reimbursement.delete");
            });
        });

        Route::group('atasan-khusus',function(){
            Route::get('','Atasan_khusus@index');
            Route::post('list-data','Atasan_khusus@list_data');
            Route::get('form/tambah','Atasan_khusus@form');
            Route::get('form/edit/{id}','Atasan_khusus@form');
            Route::get('form/hapus/{id}','Atasan_khusus@form');
            Route::post('save','Atasan_khusus@save');
            Route::post('delete','Atasan_khusus@delete');
            Route::get('get-atasan/{id}','Atasan_khusus@get_atasan');
        });

        Route::group('izin',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Pengaturan_izin@index')->name('pengaturan.izin.home');
                Route::get('data','Pengaturan_izin@list_data')->name('pengaturan.izin.data');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::post('save','Pengaturan_izin@save')->name('pengaturan.izin.save');
                Route::get('get-atasan/{id}','Pengaturan_izin@get_atasan');
            });
        });

        Route::group('lembur',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Pengaturan_lembur@index')->name('pengaturan.lembur.home');
                Route::get('data','Pengaturan_lembur@list_data')->name('pengaturan.lembur.data');
            });
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::post('save','Pengaturan_lembur@save')->name('pengaturan.lembur.save');
                Route::get('get-atasan/{id}','Pengaturan_lembur@get_atasan');
            });
        });

        Route::group('reimbursement',['middleware' => 'Auth_menu:1,4,6'],function(){
            Route::get('','Pengaturan_reimbursement@index');
            Route::get('data','Pengaturan_reimbursement@list_data')->name('pengaturan.reimbursement.data');
            Route::get('get-atasan/{id}','Pengaturan_reimbursement@get_atasan');
            Route::post('save','Pengaturan_reimbursement@save')->name('pengaturan.reimbursement.save');
        });

        Route::group('hari-libur',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Kalender@index');
                Route::get('list_data','Kalender@list_data');
                Route::get('view/thumbnail','Kalender@kalender_data')->name("pengaturan.harilibur.view.thumbnail");
                Route::get('view/list','Kalender@view_data');
            });
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('export/{id}','Kalender@export');
                Route::get('form/tambah','Kalender@form');
                Route::get('form/edit/{id}','Kalender@form');
                Route::get('form/hapus/{id}','Kalender@form');
                Route::post('save','Kalender@save');
                Route::post('update','Kalender@save');
                Route::post('delete','Kalender@delete');
                Route::post('delete-holiday','Kalender@delete_holiday');
                Route::get('cek-tanggal','Kalender@cek_tanggal');
                Route::post('import','Kalender@import');
            });
        });

        Route::group('notif',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Pengaturan_notif@index');
                Route::get('list_data','Pengaturan_notif@list_data')->name('pengaturan.notif.listdata');
            });
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('form/tambah','Pengaturan_notif@form')->name('pengaturan.notif.form.tambah');
                Route::get('form/edit/{id?}','Pengaturan_notif@form')->name('pengaturan.notif.form.edit');
                Route::get('form/hapus/{id?}','Pengaturan_notif@form')->name('pengaturan.notif.form.hapus');
                Route::post('save','Pengaturan_notif@save')->name('pengaturan.notif.save');
                Route::post('delete','Pengaturan_notif@delete')->name('pengaturan.notif.delete');
                // Route::post('save','Pengaturan_reimbursement@save')->name('pengaturan.reimbursement.save');
                // Route::get('get-atasan/{id}','Pengaturan_reimbursement@get_atasan');
            });
        });
    });
    //END PENGATURAN

    // START KELOLA ABSENSI
    Route::group('absensi',function(){
        Route::get('home','Data_absensi@index')->name('laporan.absensi.home');
        Route::get('dropdown/cabang','Data_absensi@list_cabang')->name('laporan.absensi.dropdown.cabang');
        Route::get('dropdown/departemen/{id?}','Data_absensi@list_departemen')->name('laporan.absensi.dropdown.departemen');
        Route::get('dropdown/karyawan','Data_absensi@list_karyawan')->name('laporan.absensi.dropdown.karyawan');
        Route::get('data/download','Data_absensi@download')->name('laporan.absensi.download');
        Route::get('data/view','Data_absensi@view_data')->name('laporan.absensi.data.view');
        Route::get('data/list','Data_absensi@list_data')->name('laporan.absensi.data.list');
        Route::get('lokasi/{jenis?}/{tanggal?}/{karyawan?}','Data_absensi@lokasi');
        Route::get('form','Data_absensi@form');
        Route::group('',['middleware' => 'Auth_menu:1'],function(){
            Route::get('form/edit/{id_karyawan?}/{tanggal?}','Data_absensi@form');
            Route::post('save','Data_absensi@save');
            Route::post('update','Data_absensi@update');
            Route::post('delete/{id_karyawan?}/{tanggal?}','Data_absensi@delete');
        });
        Route::get('absensi/list/cabang_selected','Data_absensi@list_cabang_selected');
    });

    Route::group('rekap',function(){
        Route::group('absensi',function(){
            Route::get('data','Rekap_absensi@index');
            Route::get('list/cabang','Rekap_absensi@list_cabang');
            Route::get('list/departemen/{id?}','Rekap_absensi@list_departemen');
            Route::get('data/download/{tgl_mulai?}/{tgl_selesai?}/{id_cabang?}/{id_departemen?}/{jenis?}','Rekap_absensi@download');
            Route::get('data/view/{tgl_mulai?}/{tgl_selesai?}/{id_cabang?}/{id_departemen?}','Rekap_absensi@view_data')->name('rekap.absensi.data.view');
            Route::post('list/data/{tgl_mulai?}/{tgl_selesai?}/{id_cabang?}/{id_departemen?}','Rekap_absensi@list_data');
        });
    });

    Route::group('pengajuan',function(){
        Route::group('lembur',function(){
            Route::get('','Pengajuan_lembur@index');
            Route::get('approve_data','Pengajuan_lembur@approve_data');

            Route::get('detail_lembur/{id}','Pengajuan_lembur@detail_lembur');
            Route::get('detail-lembur-mulai/{id}','Pengajuan_lembur@detail_lembur_mulai');
            Route::get('detail-lembur-selesai/{id}','Pengajuan_lembur@detail_lembur_selesai');

            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('tambah','Pengajuan_lembur@form');
                Route::get('edit/{id}','Pengajuan_lembur@edit');
                Route::get('save','Pengajuan_lembur@save');
                Route::get('update','Pengajuan_lembur@update');
                Route::post('delete','Pengajuan_lembur@delete');
                Route::get('import','Pengajuan_lembur@import');
            });

            Route::get('data/view/{tgl_mulai?}/{tgl_selesai?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Pengajuan_lembur@view_data')->name('pengajuan.lembur.data.view');
            Route::get('data/list/{tgl_mulai?}/{tgl_selesai?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Pengajuan_lembur@list_data')->name('pengajuan.lembur.data.list');
            Route::get('download/excel/{tgl_mulai?}/{tgl_selesai?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Pengajuan_lembur@download')->name('pengajuan.lembur.data.download.excel');

            Route::get('verifikasi/{id}','Pengajuan_lembur@modal');
            Route::get('verifikasi/spv/{id}','Pengajuan_lembur@modal');
            Route::get('verifikasi/kedep/{id}','Pengajuan_lembur@modal');
            Route::get('verifikasi/kacab/{id}','Pengajuan_lembur@modal');
            Route::get('verifikasi/hrd/{id}','Pengajuan_lembur@modal');
            Route::get('verifikasi/direksi/{id}','Pengajuan_lembur@modal');

            Route::post('approve','Pengajuan_lembur@approve');
            Route::post('approve-spv','Pengajuan_lembur@approve_spv');
            Route::post('approve-kedep','Pengajuan_lembur@approve_kedep');
            Route::post('approve-kacab','Pengajuan_lembur@approve_kacab');
            Route::post('approve-hrd','Pengajuan_lembur@approve_hrd');
            Route::post('approve-direksi','Pengajuan_lembur@approve_direksi');

            Route::get('get-jenis','Pengajuan_lembur@get_jenis');
            Route::get('get-jenis-form','Pengajuan_lembur@get_jenis_form');
            Route::get('get-cabang','Pengajuan_lembur@get_cabang');
            Route::get('get-departemen/{id_cabang}','Pengajuan_lembur@get_departemen');
            Route::get('get-karyawan/{id_cabang}/{id_departemen}','Pengajuan_lembur@get_karyawan');

            Route::get('data-lembur/{id}','Pengajuan_lembur@data_lembur');
        });

        Route::group('izin',function(){
            Route::get('','Pengajuan_izin@index');
            Route::get('approve_data','Pengajuan_izin@approve_data');
			Route::get('get_holidays','Pengajuan_izin@get_holidays');
            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('tambah','Pengajuan_izin@form');
                Route::get('edit/{id}','Pengajuan_izin@edit');
				Route::post('save','Pengajuan_izin@save');
                Route::post('update','Pengajuan_izin@update');
                Route::post('delete','Pengajuan_izin@delete');
                Route::get('import','Pengajuan_izin@import');
			});
			Route::get('detail/{id}','Pengajuan_izin@detail');
			Route::get('detail_izin/{id}','Pengajuan_izin@detail_izin');

            Route::get('data/view/{tgl_mulai?}/{tgl_selesai?}/{jenis?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Pengajuan_izin@view_data')->name('pengajuan.izin.data.view');
            Route::get('data/list/{tgl_mulai?}/{tgl_selesai?}/{jenis?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Pengajuan_izin@list_data')->name('pengajuan.izin.data.list');

            Route::get('modal/verifikasi/{level_verifikasi?}/{id_izin?}','Pengajuan_izin@modal_verifikasi')->name('pengajuan.izin.modal.verifikasi');
            Route::get('verifikasi/spv/{id}','Pengajuan_izin@modal_spv');

            Route::post('approve','Pengajuan_izin@approve_izin')->name('pengajuan.izin.approve');

            Route::get('get-jenis','Pengajuan_izin@get_jenis');
            Route::get('get-jenis-form','Pengajuan_izin@get_jenis_form');
            Route::get('get-cabang','Pengajuan_izin@get_cabang');
            Route::get('get-departemen/{id_cabang}','Pengajuan_izin@get_departemen');
            Route::get('get-karyawan/{id_cabang}/{id_departemen}','Pengajuan_izin@get_karyawan');
        });
    });

    Route::group('laporan',function(){
        Route::group('aktivitas',function(){
            Route::get('','Laporan_aktivitas@index');
            Route::get('detail/{id?}','Laporan_aktivitas@detail')->name('laporan.aktivitas.detail');
            Route::get('download/excel/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Laporan_aktivitas@download_excel')->name('laporan.aktivitas.download.excel');
            Route::get('data/tabel/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/','Laporan_aktivitas@data_tabel')->name('laporan.aktivitas.data.tabel');
            Route::get('data/maps/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/','Laporan_aktivitas@data_maps')->name('laporan.aktivitas.data.maps');
            Route::get('data/maps/lokasi/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/','Laporan_aktivitas@lokasi_aktivitas')->name('laporan.aktivitas.data.maps.lokasi');

            Route::get('list-data/ajax','Laporan_aktivitas@list_data')->name('laporan.aktivitas.listdata');
            Route::get('list-data/ajax/rekap','Laporan_aktivitas@rekap_aktifitas')->name('laporan.aktivitas.listrekap');
            Route::post('delete','Laporan_aktivitas@delete')->name('laporan.aktivitas.delete');
        });
    });
    // //LAPORAN

    // //INFORMASI
    Route::group('informasi',function(){

        Route::group('berita',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Berita@index')->name('informasi.berita.home');
                Route::get('list-data','Berita@list_data')->name('informasi.berita.listdata');
                Route::get('detail/{id?}','Berita@detail')->name('informasi.berita.detail');
            });

            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::post('save','Berita@save')->name('informasi.berita.save');
                Route::post('delete','Berita@delete')->name('informasi.berita.delete');
                Route::get('form/tambah','Berita@form')->name('informasi.berita.form.tambah');
                Route::get('form/edit/{id?}','Berita@form')->name('informasi.berita.form.edit');
            });
        });

        Route::group('pengumuman',function(){
            Route::group('',['middleware' => 'Auth_menu:1,4'],function(){
                Route::get('','Pengumuman@index')->name('informasi.pengumuman.home');
                Route::get('data','Pengumuman@list_data')->name('informasi.pengumuman.data');
                Route::get('detail/{id?}','Pengumuman@detail')->name('informasi.pengumuman.detail');
            });

            Route::group('',['middleware' => 'Auth_menu:1'],function(){
                Route::get('form/tambah','Pengumuman@form')->name('informasi.pengumuman.form.tambah');
                Route::get('form/edit/{id?}','Pengumuman@form')->name('informasi.pengumuman.form.edit');
                Route::post('save','Pengumuman@save')->name('informasi.pengumuman.save');
                Route::post('delete','Pengumuman@delete')->name('informasi.pengumuman.delete');
            });
        });

        // //GAJI
        Route::group('gaji',function(){
            Route::group('',['middleware' => 'Auth_menu:4,6'],function(){
                Route::get('','Informasi_gaji@index')->name('informasi.gaji.home');
                Route::get('list-data/{periode?}/{id_karyawan?}/{kode_cabang?}/{kode_departemen?}','Informasi_gaji@list_data')->name('informasi.gaji.listdata');
                Route::get('download/{periode}/{cabang}/{departemen}','Informasi_gaji@download');
                Route::get('detail/{id?}','Informasi_gaji@detail')->name("informasi.gaji.detail");
            });

            Route::group('',['middleware' => 'Auth_menu:6'],function(){
                Route::get('edit/{id?}','Informasi_gaji@edit')->name("informasi.gaji.edit");
                Route::post('update','Informasi_gaji@update')->name("informasi.gaji.update");
                Route::post('delete','Informasi_gaji@delete')->name("informasi.gaji.delete");
                Route::get('form/publish/{id?}','Informasi_gaji@form_publish')->name("informasi.gaji.form.publish");
                Route::post('publish-unpublish','Informasi_gaji@publish_unpublish')->name("informasi.gaji.publishunpublish");
                Route::post('unpublish','Informasi_gaji@unpublish')->name("informasi.gaji.unpublish");
                Route::post('publis-all','Informasi_gaji@publish_all')->name("informasi.gaji.publishall");
                Route::post('unpublish-all','Informasi_gaji@unpublish_all')->name("informasi.gaji.unpublishall");

                Route::group('import',function(){
                    Route::get('home','Informasi_gaji_temp@index')->name('informasi.gaji.import.home');
                    Route::get('list-data','Informasi_gaji_temp@list_data')->name('informasi.gaji.import.listdata');
                    Route::get('unduh/template-gaji/{periode?}/{cabang?}/{departemen?}','Template_informasi_gaji@download')->name('informasi.gaji.unduh.templateimport');
                    Route::post('excel','Informasi_gaji_temp@import_data_excel')->name('informasi.gaji.import.excel');
                    Route::get('form/edit/{id?}','Informasi_gaji_temp@form_edit')->name('informasi.gaji.import.form.edit');
                    Route::get('form/template-import','Informasi_gaji_temp@form_template_import')->name('informasi.gaji.form.templateimport');
                    Route::post('update','Informasi_gaji_temp@update')->name('informasi.gaji.import.update');
                    Route::post('delete','Informasi_gaji_temp@delete_temp')->name('informasi.gaji.import.delete');
                    Route::post('save-all','Informasi_gaji_temp@save_all')->name('informasi.gaji.import.saveall');
                    Route::post('delete-all','Informasi_gaji_temp@delete_all')->name('informasi.gaji.import.deleteall');
                });
            });

            Route::group('dropdown',function(){
                Route::get('cabang','Informasi_gaji@dropdown_cabang')->name("informasi.gaji.dropdown.cabang");
                Route::get('departemen/{kode_cabang?}','Informasi_gaji@dropdown_departemen')->name("informasi.gaji.dropdown.departemen");
                Route::get('karyawan','Informasi_gaji@dropdown_karyawan')->name("informasi.gaji.dropdown.karyawan");
            });

        // //GAJI
        });
    });
    // //INFORMASi

    // //REIMBURSEMENT
    Route::group('reimburse',function(){
        Route::group('',['middleware' => 'Auth_reimbursement'],function(){

            Route::group('plafon',function(){
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('home','Jenis_plafon@index')->name('master.jenisplafon.home');
                    Route::get('list-data','Jenis_plafon@list_data')->name('master.jenisplafon.listdata');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/tambah','Jenis_plafon@form')->name('master.jenisplafon.form.tambah');
                    Route::get('form/edit/{id?}','Jenis_plafon@form')->name('master.jenisplafon.form.edit');
                    Route::get('form/hapus/{id?}','Jenis_plafon@form')->name('master.jenisplafon.form.hapus');
                    Route::post('save','Jenis_plafon@save')->name('master.jenisplafon.save');
                    Route::post('delete','Jenis_plafon@delete')->name('master.jenisplafon.delete');
                });
            });

            Route::group('akun',function(){
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('home','Akun_reimburse@index')->name('master.akun.home');
                    Route::get('list-data','Akun_reimburse@list_data')->name('master.akun.listdata');
                });
                Route::group('',['middleware' => 'Auth_menu:1'],function(){
                    Route::get('form/tambah','Akun_reimburse@form')->name('master.akun.form.tambah');
                    Route::get('form/edit/{id?}','Akun_reimburse@form')->name('master.akun.form.edit');
                    Route::get('form/hapus/{id?}','Akun_reimburse@form')->name('master.akun.form.hapus');
                    Route::post('save','Akun_reimburse@save')->name('master.akun.save');
                    Route::post('delete','Akun_reimburse@delete')->name('master.akun.delete');
                });
            });
        });

        Route::group('pengajuan',function(){
            Route::get('','Data_reimburse@index')->name('reimburse.pengajuan.home');
            Route::get('/{pengajuan?}','Data_reimburse@index')->name('reimburse.pengajuan.saya');
            Route::get('data/{tipe?}','Data_reimburse@data')->name('reimburse.data');
            Route::post('list-data','Data_reimburse@list_data')->name('reimburse.list.data');
            Route::get('detail/{saya?}/{no_pengajuan?}','Data_reimburse@detail')->name('reimburse.detail');
            Route::get('simpan','Data_reimburse@simpan');

            Route::get('approve_data','Data_reimburse@approve_data');
            Route::get('tambah','Data_reimburse@form');
            Route::get('edit/{id?}','Data_reimburse@edit');
            Route::get('detail/{id?}','Data_reimburse@detail');
            Route::get('detail-lembur-selesai/{id?}','Data_reimburse@detail_lembur_selesai');
            Route::post('save','Data_reimburse@save')->name('reimburse.save');
            Route::post('update','Data_reimburse@update');
            Route::post('delete','Data_reimburse@delete');
            Route::get('import','Data_reimburse@import');
            Route::get('export/{id?}','Data_reimburse@export');
        });

        Route::group('dropdown',function(){
            Route::get('cabang','Data_reimburse@dropdown_cabang')->name("reimburse.dropdown.cabang");
            Route::get('departemen/{id_cabang?}','Data_reimburse@dropdown_departemen')->name("reimburse.dropdown.departemen");
            Route::get('karyawan','Data_reimburse@dropdown_karyawan')->name('reimburse.dropdown.karyawan');
        });

        Route::group('laporan',function(){
            Route::get('data','Laporan_reimburse@index')->name('reimburse.laporan.home');
            Route::get('data/download/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/{jenis?}','Laporan_reimburse@download');
            Route::get('data/view-data/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Laporan_reimburse@view_data');
            Route::get('list/data/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Laporan_reimburse@list_data');
            Route::get('dropdown/cabang','Laporan_reimburse@dropdown_cabang')->name("reimbursement.laporan.dropdown.cabang");
            Route::get('dropdown/departement/{id_cabang?}','Laporan_reimburse@dropdown_departemen')->name("reimbursement.laporan.dropdown.departement");
            Route::get('dropdown/karyawan','Laporan_reimburse@dropdown_karyawan')->name("reimbursement.laporan.dropdown.karyawan");
        });


    });
    // //REIMBURSEMENT

    # BEGIN PAYROLL
    Route::group('payroll', ['middleware' => ['Auth_menu:1', 'Auth_payroll']], function() {
        Route::group('pengaturan', function() {
            Route::group('umum',function(){
                Route::get('','payroll/pengaturan/Pot_absensi@index')->name("payroll.pengaturan.potongan.absensi.home");
                Route::post('list_data','payroll/pengaturan/Pot_absensi@list_data')->name("payroll.pengaturan.potongan.absensi.data");

                Route::get('form/edit','payroll/pengaturan/Pot_absensi@form')->name("payroll.pengaturan.potongan.absensi.form.update");
                Route::post('save','payroll/pengaturan/Pot_absensi@save')->name("payroll.pengaturan.potongan.absensi.save");
                Route::post('update-flag','payroll/pengaturan/Pot_absensi@update_flag')->name("payroll.pengaturan.potongan.absensi.update_flag");
                Route::post('update-pph','payroll/pengaturan/Pot_absensi@update_pot_pph')->name("payroll.pengaturan.potongan.absensi.update.pph");
            });
        });

        Route::group('master', function() {
            Route::group('gapok',function(){
                Route::get('','payroll/Master_gapok@index')->name("payroll.master.gapok.home");
                Route::post('list_data','payroll/Master_gapok@list_data')->name("payroll.master.gapok.data");

                Route::get('form/tambah','payroll/Master_gapok@form')->name("payroll.master.gapok.form.tambah");
                Route::get('form/edit/{id?}','payroll/Master_gapok@form')->name("payroll.master.gapok.form.edit");
                Route::get('form/hapus/{id?}','payroll/Master_gapok@form')->name("payroll.master.gapok.form.hapus");
                Route::post('save','payroll/Master_gapok@save')->name("payroll.master.gapok.save");
                Route::post('update','payroll/Master_gapok@update')->name("payroll.master.gapok.update");
                Route::post('delete','payroll/Master_gapok@delete')->name("payroll.master.gapok.delete");
                Route::group('import', function() {
                    Route::get('', 'payroll/gapok/Import@index')->name('payroll.master.gapok.import');
                    Route::get('form/template-import','payroll/gapok/Import@form_template_import')->name('payroll.master.gapok.import.form.templateimport');
                    Route::get('unduh/excel/{id_cabang?}/{id_departemen?}','payroll/gapok/Import@download_template')->name('payroll.master.gapok.import.unduh.templateimport');
                    Route::post('excel','payroll/gapok/Import@import_data_excel')->name('payroll.master.gapok.import.excel');
                    Route::get('list-data','payroll/gapok/Import@list_data')->name('payroll.master.gapok.import.listdata');
                    Route::delete('delete/all','payroll/gapok/Import@delete_all_temp')->name('payroll.master.gapok.import.deleteall');
                    Route::post('publish/all','payroll/gapok/Import@publish_all')->name('payroll.master.gapok.import.publishall');
                    Route::get('form/{id}','payroll/gapok/Import@form')->name('payroll.master.gapok.import.form');
                    Route::post('delete', 'payroll/gapok/Import@delete')->name('payroll.master.gapok.import.delete');
                    Route::post('save', 'payroll/gapok/Import@save')->name('payroll.master.gapok.import.save');
                });
            });

            Route::group('komponen', ['namespace' => 'payroll'], function(){

                Route::get('pendapatan','Master_komponen@index_pendapatan')->name("payroll.master.komponen.pendapatan");
                Route::get('potongan','Master_komponen@index_potongan')->name("payroll.master.komponen.potongan");
                Route::get('list_data/{master}','Master_komponen@list_data')->name("payroll.master.komponen.data");

                Route::get('form/tambah/{master}','Master_komponen@form')->name("payroll.master.komponen.form.tambah");
                Route::get('form/edit/{master}/{id?}','Master_komponen@form')->name("payroll.master.komponen.form.edit");
                Route::get('form/hapus/{master}/{id?}','Master_komponen@form')->name("payroll.master.komponen.form.hapus");
                Route::post('save/{master}','Master_komponen@save')->name("payroll.master.komponen.save");
                Route::post('update/{master}','Master_komponen@update')->name("payroll.master.komponen.update");
                Route::post('delete/{master}/{bulan?}','Master_komponen@delete')->name("payroll.master.komponen.delete");
                Route::post('order','Master_komponen@update_order')->name("payroll.master.komponen.order");
            });
        });

        Route::group('tunjangan', function() {
            Route::group('tetap', function() {
                // home
                Route::get('','payroll/tunjangan/Tetap@index')->name('payroll.tunjangan.tetap.home');
                Route::post('datatable/{id_karyawan?}','payroll/tunjangan/Tetap@list_data')->name('payroll.tunjangan.tetap.datatable');
                Route::get('form/tambah','payroll/tunjangan/Tetap@form')->name('payroll.tunjangan.tetap.form.tambah');

                // detail
                Route::get('detail/{id_karyawan?}','payroll/tunjangan/Tetap@detail')->name('payroll.tunjangan.tetap.detail');
                Route::post('datatable/detail/{id_karyawan?}','payroll/tunjangan/Tetap@list_data_detail')->name('payroll.tunjangan.tetap.datatable.detail');
                Route::get('form/tambah_item','payroll/tunjangan/Tetap@form_detail')->name('payroll.tunjangan.tetap.form.tambah.item');
                Route::get('form/edit_item/{id?}','payroll/tunjangan/Tetap@form_detail')->name('payroll.tunjangan.tetap.form.edit');
                Route::get('form/delete_item/{id?}','payroll/tunjangan/Tetap@form_detail')->name('payroll.tunjangan.tetap.form.delete');
                Route::post('save','payroll/tunjangan/Tetap@save')->name('payroll.tunjangan.tetap.save');
                Route::post('delete','payroll/tunjangan/Tetap@delete')->name('payroll.tunjangan.tetap.delete');
            });
            Route::group('tidak-tetap', function() {
                // home
                Route::get('','payroll/tunjangan/TidakTetap@index')->name('payroll.tunjangan.tidak.tetap.home');
                Route::post('datatable/{id_karyawan?}/{bulan?}','payroll/tunjangan/TidakTetap@list_data')->name('payroll.tunjangan.tidak.tetap.datatable');
                Route::get('form/tambah','payroll/tunjangan/TidakTetap@form')->name('payroll.tunjangan.tidak.tetap.form.tambah');

                // detail
                Route::get('detail/{id_karyawan?}/{bulan?}','payroll/tunjangan/TidakTetap@detail')->name('payroll.tunjangan.tidak.tetap.detail');
                Route::post('datatable/detail/{id_karyawan?}/{bulan?}','payroll/tunjangan/TidakTetap@list_data_detail')->name('payroll.tunjangan.tidak.tetap.datatable.detail');
                Route::get('form/tambah_item','payroll/tunjangan/TidakTetap@form_detail')->name('payroll.tunjangan.tidak.tetap.form.tambah.item');
                Route::get('form/edit_item/{id?}','payroll/tunjangan/TidakTetap@form_detail')->name('payroll.tunjangan.tidak.tetap.form.edit');
                Route::get('form/delete_item/{id?}','payroll/tunjangan/TidakTetap@form_detail')->name('payroll.tunjangan.tidak.tetap.form.delete');
                Route::post('save','payroll/tunjangan/TidakTetap@save')->name('payroll.tunjangan.tidak.tetap.save');
                Route::post('delete','payroll/tunjangan/TidakTetap@delete')->name('payroll.tunjangan.tidak.tetap.delete');
            });
        });

        Route::group('potongan', function() {
            Route::group('tetap', function() {
                // home
                Route::get('','payroll/potongan/Tetap@index')->name('payroll.potongan.tetap.home');
                Route::post('datatable/{id_karyawan?}','payroll/potongan/Tetap@list_data')->name('payroll.potongan.tetap.datatable');
                Route::get('form/tambah','payroll/potongan/Tetap@form')->name('payroll.potongan.tetap.form.tambah');

                // detail
                Route::get('detail/{id_karyawan?}','payroll/potongan/Tetap@detail')->name('payroll.potongan.tetap.detail');
                Route::post('datatable/detail/{id_karyawan?}','payroll/potongan/Tetap@list_data_detail')->name('payroll.potongan.tetap.datatable.detail');
                Route::get('form/tambah_item','payroll/potongan/Tetap@form_detail')->name('payroll.potongan.tetap.form.tambah.item');
                Route::get('form/edit_item/{id?}','payroll/potongan/Tetap@form_detail')->name('payroll.potongan.tetap.form.edit');
                Route::get('form/delete_item/{id?}','payroll/potongan/Tetap@form_detail')->name('payroll.potongan.tetap.form.delete');
                Route::post('save','payroll/potongan/Tetap@save')->name('payroll.potongan.tetap.save');
                Route::post('delete','payroll/potongan/Tetap@delete')->name('payroll.potongan.tetap.delete');
            });

            Route::group('tidak-tetap', function() {
                // home
                Route::get('','payroll/potongan/TidakTetap@index')->name('payroll.potongan.tidak.tetap.home');
                Route::post('datatable/{id_karyawan?}/{bulan?}','payroll/potongan/TidakTetap@list_data')->name('payroll.potongan.tidak.tetap.datatable');
                Route::get('form/tambah','payroll/potongan/TidakTetap@form')->name('payroll.potongan.tidak.tetap.form.tambah');

                // detail
                Route::get('detail/{id_karyawan?}/{bulan?}','payroll/potongan/TidakTetap@detail')->name('payroll.potongan.tidak.tetap.detail');
                Route::post('datatable/detail/{id_karyawan?}/{bulan?}','payroll/potongan/TidakTetap@list_data_detail')->name('payroll.potongan.tidak.tetap.datatable.detail');
                Route::get('form/tambah_item','payroll/potongan/TidakTetap@form_detail')->name('payroll.potongan.tidak.tetap.form.tambah.item');
                Route::get('form/edit_item/{id?}','payroll/potongan/TidakTetap@form_detail')->name('payroll.potongan.tidak.tetap.form.edit');
                Route::get('form/delete_item/{id?}','payroll/potongan/TidakTetap@form_detail')->name('payroll.potongan.tidak.tetap.form.delete');
                Route::post('save','payroll/potongan/TidakTetap@save')->name('payroll.potongan.tidak.tetap.save');
                Route::post('delete','payroll/potongan/TidakTetap@delete')->name('payroll.potongan.tidak.tetap.delete');
            });

        });

        Route::group('data-komponen', ['namespace' => 'payroll/data_komponen'], function() {
            Route::get('','Data_komponen@index')->name('payroll.data.komponen.home');
            Route::get('list-data/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Data_komponen@list_data')->name('payroll.data.komponen.datatable');
            Route::get('form','Data_komponen@form')->name('payroll.data.komponen.form');
            Route::post('update','Data_komponen@update')->name('payroll.data.komponen.update');

            Route::group('import',function(){
                Route::get('home','Data_komponen_import@index')->name("payroll.data.komponen.import.home");
                Route::get('view-data','Data_komponen_import@view_data')->name('payroll.data.komponen.import.viewdata');
                Route::get('list-data','Data_komponen_import@list_data')->name('payroll.data.komponen.import.listdata');
                Route::get('unduh/template/{id_cabang?}/{id_departemen?}','Data_komponen_import@download_template')->name('payroll.data.komponen.import.unduh.template');
                Route::post('excel','Data_komponen_import@import_data_excel')->name('payroll.data.komponen.import.excel');
                Route::get('form/template-import','Data_komponen_import@form_template_import')->name('payroll.data.komponen.import.form.templateimport');
                Route::post('publish/all','Data_komponen_import@publish_all')->name('payroll.data.komponen.import.publishall');
                Route::delete('delete/all','Data_komponen_import@delete_all_temp')->name('payroll.data.komponen.import.deleteall');
            });
        });

        Route::group('data-komponen-tidak-tetap', ['namespace' => 'payroll/data_komponen_tdk_tetap'], function() {
            Route::get('','Data_komponen@index')->name('payroll.data.komponen.tdk.tetap.home');
            Route::get('dropdown-cabang','Data_komponen@cabang')->name('payroll.data.komponen.tdk.tetap.dropdown.cabang');
            Route::get('dropdown-departemen/{id_cabang?}','Data_komponen@departemen_by_cabang')->name('payroll.data.komponen.tdk.tetap.dropdown.departemen');
            Route::get('view-data/{bulan}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Data_komponen@view_data')->name('payroll.data.komponen.tdk.tetap.viewdata');
            Route::get('list-data/{bulan}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Data_komponen@list_data')->name('payroll.data.komponen.tdk.tetap.datatable');
            Route::get('form','Data_komponen@form')->name('payroll.data.komponen.tdk.tetap.form');
            Route::post('update','Data_komponen@update')->name('payroll.data.komponen.tdk.tetap.update');

            Route::group('import',function(){
                Route::get('home','Data_komponen_import@index')->name("payroll.data.komponen.tdk.tetap.import.home");
                Route::get('view-data','Data_komponen_import@view_data')->name('payroll.data.komponen.tdk.tetap.import.viewdata');
                Route::get('list-data','Data_komponen_import@list_data')->name('payroll.data.komponen.tdk.tetap.import.listdata');
                Route::get('dropdown-komponen','Data_komponen_import@dropdown_komponen')->name('payroll.data.komponen.tdk.tetap.dropdown.komponen');
                Route::get('unduh/template/{bulan}/{id_cabang?}/{id_departemen?}','Data_komponen_import@download_template')->name('payroll.data.komponen.tdk.tetap.import.unduh.template');
                Route::post('excel','Data_komponen_import@import_data_excel')->name('payroll.data.komponen.tdk.tetap.import.excel');
                Route::get('form/template-import','Data_komponen_import@form_template_import')->name('payroll.data.komponen.tdk.tetap.import.form.templateimport');
                Route::post('publish/all','Data_komponen_import@publish_all')->name('payroll.data.komponen.tdk.tetap.import.publishall');
                Route::delete('delete/all','Data_komponen_import@delete_all_temp')->name('payroll.data.komponen.tdk.tetap.import.deleteall');
            });
        });

        Route::group('bpjs', function() {
            Route::get('', 'payroll/bpjs/Bpjs@index')->name('payroll.bpjs');
            Route::get('config', 'payroll/bpjs/Bpjs_config@index')->name('payroll.bpjs.config');
            Route::get('form/{jenis}/{name?}', 'payroll/bpjs/Bpjs_config@form')->name('payroll.bpjs.config.form');
            Route::post('save/{jenis}', 'payroll/bpjs/Bpjs_config@save')->name('payroll.bpjs.config.save');
            Route::get('input-nominal/{name}', 'payroll/bpjs/Bpjs_config@input_nominal')->name('payroll.bpjs.config.input-nominal');
            Route::post('save-nominal', 'payroll/bpjs/Bpjs_config@save_nominal')->name('payroll.bpjs.config.save-nominal');
            Route::group('master', function() {
                Route::get('', 'payroll/bpjs/Bpjs_master@index')->name('payroll.bpjs.master');
                Route::get('list_data', 'payroll/bpjs/Bpjs_master@list_data')->name('payroll.bpjs.master.list-data');
                Route::get('form/{jenis}/{id?}', 'payroll/bpjs/Bpjs_master@form');
                Route::get('get-data', 'payroll/bpjs/Bpjs_master@get_data')->name('payroll.bpjs.master.get-data');
                Route::post('save', 'payroll/bpjs/Bpjs_master@save')->name('payroll.bpjs.master.save');
                Route::post('delete', 'payroll/bpjs/Bpjs_master@delete')->name('payroll.bpjs.master.delete');
                Route::group('import', function() {
                    Route::get('', 'payroll/bpjs/Import@index')->name('payroll.bpjs.master.import');
                    Route::get('list-data','payroll/bpjs/Import@list_data')->name('payroll.master.bpjs.import.listdata');
                    Route::get('form/template-import','payroll/bpjs/Import@form_template_import')->name('payroll.master.bpjs.import.form.templateimport');
                    Route::get('unduh/excel/{id_cabang?}/{id_departemen?}','payroll/bpjs/Import@download_template')->name('payroll.master.bpjs.import.unduh.templateimport');
                    Route::post('excel','payroll/bpjs/Import@import_data_excel')->name('payroll.master.bpjs.import.excel');
                    Route::delete('delete/all','payroll/bpjs/Import@delete_all_temp')->name('payroll.master.bpjs.import.deleteall');
                    Route::get('form/{id}', 'payroll/bpjs/Import@form');
                    Route::post('save', 'payroll/bpjs/Import@save')->name('payroll.master.bpjs.import.save');
                    Route::post('delete', 'payroll/bpjs/Import@delete')->name('payroll.master.bpjs.import.delete');
                    Route::post('publish/all','payroll/bpjs/Import@publish_all')->name('payroll.master.bpjs.import.publishall');
                });
            });
        });

        Route::group('gaji', function() {
            Route::get('','payroll/gaji/Gaji@index')->name('payroll.gaji.home');
            Route::get('view/{periode}/{cabang}/{departemen}/{karyawan}', 'payroll/gaji/Gaji@view')->name('payroll.gaji.view');
            Route::get('datatable/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','payroll/gaji/Gaji@list_data')->name('payroll.gaji.datatable');
            Route::get('form/hitung','payroll/gaji/Gaji@form')->name('payroll.gaji.form.hitung');
            Route::get('form/delete/{id?}','payroll/gaji/Gaji@form')->name('payroll.gaji.form.delete');
            Route::get('form/publish/{key?}','payroll/gaji/Gaji@form_publish')->name('payroll.gaji.form.publish');

            Route::get('detail/{id?}/{bulan?}','payroll/gaji/Gaji@detail')->name('payroll.gaji.detail');
            Route::post('hitung','payroll/gaji/Gaji@hitung_gaji')->name('payroll.gaji.hitung');
            Route::post('publishunpublish','payroll/gaji/Gaji@publish_unpublish')->name('payroll.gaji.publishunpublish');
            Route::post('publis-all','payroll/gaji/Gaji@publish_all')->name("payroll.gaji.publishall");
            Route::post('unpublish-all','payroll/gaji/Gaji@unpublish_all')->name("payroll.gaji.unpublishall");
            Route::post('delete','payroll/gaji/Gaji@delete')->name('payroll.gaji.delete');
            Route::get('download/excel/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','payroll/gaji/Gaji@download_excel')->name('payroll.gaji.download.excel');
            Route::get('download/slip/{token}', 'payroll/gaji/Gaji@download_pdf')->name('payroll.gaji.download.slip');
            Route::get('download/excel/bank/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','payroll/gaji/Gaji@download_excel_bank')->name('payroll.gaji.download.excel.bank');

        });

        Route::group('laporan-pph', function() {
            Route::get('','payroll/laporan_pph/Laporan_pph@index')->name('payroll.laporan.pph.home');
            Route::get('view-data/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','payroll/laporan_pph/Laporan_pph@view_data')->name('payroll.laporan.pph.view.data');
            Route::get('list-data/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','payroll/laporan_pph/Laporan_pph@list_data')->name('payroll.laporan.pph.list.data');
            Route::get('download/excel/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','payroll/laporan_pph/Laporan_pph@download_excel')->name('payroll.laporan.pph.download.excel');
        });

    });
    # END PAYROLL

    Route::group('quick-setup',['middleware' => 'Auth_menu:1'], function() {
        Route::get('','Quick_setup@index');
        Route::group('cabang', function() {
            Route::get('','Quick_setup_cabang@index')->name('quick-setup.cabang');
            Route::post('list_data','Quick_setup_cabang@list_data')->name('quick-setup.cabang.list_data');
            Route::post('save','Quick_setup_cabang@save')->name('quick-setup.cabang.save');
            Route::post('update','Quick_setup_cabang@update')->name('quick-setup.cabang.update');
            Route::post('delete','Quick_setup_cabang@delete')->name('quick-setup.cabang.delete');
            Route::get('detail/{id_cabang?}/{id_lokasi_kantor?}','Quick_setup_cabang@detail')->name('quick-setup.cabang.detail');
        });
        Route::group('departemen', function() {
            Route::get('','Quick_setup_departemen@index')->name('quick-setup.departemen');
            Route::post('list_data','Quick_setup_departemen@list_data')->name('quick-setup.departemen.list_data');
            Route::post('save','Quick_setup_departemen@save')->name('quick-setup.departemen.save');
            Route::post('update','Quick_setup_departemen@update')->name('quick-setup.departemen.update');
            Route::post('delete','Quick_setup_departemen@delete')->name('quick-setup.departemen.delete');
            Route::get('detail/{id_departemen?}','Quick_setup_departemen@detail')->name('quick-setup.departemen.detail');
        });
        Route::group('kepala', function() {
            Route::group('cabang', function() {
                Route::get('','Quick_setup_kepala_cabang@index')->name('quick-setup.kepala.cabang');
                Route::get('cek_nik/{id_karyawan?}','Quick_setup_kepala_cabang@cek_nik')->name('quick-setup.kepala.cabang.cek_nik');
                Route::post('list_data','Quick_setup_kepala_cabang@list_data')->name('quick-setup.kepala.cabang.list_data');
                Route::post('save','Quick_setup_kepala_cabang@save')->name('quick-setup.kepala.cabang.save');
                Route::post('update','Quick_setup_kepala_cabang@update')->name('quick-setup.kepala.cabang.update');
                Route::post('delete','Quick_setup_kepala_cabang@delete')->name('quick-setup.kepala.cabang.delete');
                Route::get('detail/{id_karyawan?}','Quick_setup_kepala_cabang@detail')->name('quick-setup.kepala.cabang.detail');
            });
            Route::group('departemen', function() {
                Route::get('','Quick_setup_kepala_departemen@index')->name('quick-setup.kepala.departemen');
                Route::post('list_data','Quick_setup_kepala_departemen@list_data')->name('quick-setup.kepala.departemen.list_data');
                Route::post('save','Quick_setup_kepala_departemen@save')->name('quick-setup.kepala.departemen.save');
                Route::post('update','Quick_setup_kepala_departemen@update')->name('quick-setup.kepala.departemen.update');
                Route::get('detail/{id_karyawan?}','Quick_setup_kepala_departemen@detail')->name('quick-setup.kepala.departemen.detail');
            });
        });
        Route::group('staff', function() {
            Route::get('','Quick_setup_staff@index')->name('quick-setup.staff');
            Route::post('list_data','Quick_setup_staff@list_data')->name('quick-setup.staff.list_data');
            Route::post('save','Quick_setup_staff@save')->name('quick-setup.staff.save');
        });
    });

    // END KELOLA ABSENSI
});

Route::get('payroll/gaji/download/pdf/{token}', 'payroll/gaji/Gaji@download_pdf');
