<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_absen_dep_m extends CI_Model {
    var $table = 'r_absensi';

    function get_datatables($tanggal_mulai, $tanggal_selesai, $cabang, $departemen){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $cabang, $departemen);
        if($_POST['length'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($tanggal_mulai, $tanggal_selesai, $cabang, $departemen){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $cabang, $departemen);
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all($tanggal_mulai, $tanggal_selesai, $cabang, $departemen){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $cabang, $departemen);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($tanggal_mulai, $tanggal_selesai, $cabang, $departemen){
        
        $this->db->select("DATE_FORMAT(tgl_absen, '%d/%m/%Y') as tanggal, absen_masuk, absen_ist_mulai, absen_ist_selesai, absen_pulang, 
            id_karyawan, tgl_absen, nama_karyawan, nama_departemen, kode_absensi, jenis_absen", FALSE)->from($this->table);
        $this->db->where('tgl_absen >=', $tanggal_mulai);   
        $this->db->where('tgl_absen <=', $tanggal_selesai); 
        $this->db->where('id_cabang', $cabang);  
        
        if ($departemen != "null") {
            $this->db->where('id_departemen', $departemen);  
        }

        $this->db->group_by('tgl_absen');
        $column_order = array('','tgl_absen','nama_karyawan','nama_departemen','kode_absensi','absen_masuk','absen_ist_mulai','absen_ist_selesai','absen_pulang','');
        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else{
            $order_by = array("tgl_absen"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

   
}