<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Import extends MY_Controller {
  public function __construct() {
    parent::__construct();
    $this->load->model('payroll/gapok/import_m', 'model');
    $this->load->library(['PHPExcel/Excel', 'PHPExcel/PHPExcel', 'Uploadfile']);
	$this->id_karyawan = $this->session->userdata('id_karyawan');
	$this->nama_user   = $this->session->userdata('nama_user');
	$this->id_company  = $this->session->userdata('id_company');
  }

  public function index(){
    $data['judul']   = 'Import Data Gapok';
    $data['aktif']   = 'master_gapok';
    $data['menu']    = $this->load->view('main_menu', $data, true);
    $data['script']  = $this->load->view('payroll/gapok_import/script', $data, true);
    $data['content'] = $this->load->view('payroll/gapok_import/home', $data, true);
    $this->load->view('main_template', $data, false);
  }

  public function form_template_import(){
		$this->load->view('payroll/gapok_import/form_template_import');
	}

  function download_template($id_cabang, $id_departemen){

    if($id_cabang != "-") {
      $nama_cabang = $this->db->select("nama")
                  ->from("master_cabang")
                  ->where("id_cabang",$id_cabang)
                  ->where("id_company",$this->id_company)
                  ->get()
                  ->row("nama");
      $nama_cabang = " Cabang ".$nama_cabang;
    } else {
      $nama_cabang = " Semua Cabang";
    }

		if($id_departemen != "-") {
			$nama_departemen = $this->db->select("nama")
								->from("master_departemen")
								->where("id_departemen",$id_departemen)
								->where("id_company",$this->id_company)
								->get()
								->row("nama");
      $nama_departemen = " Departemen ".$nama_departemen;
		}else{
      $nama_departemen = "";
    }

		$data['header']   = $header;
		$data['nama']     = "Template Import Data Gapok".$nama_cabang.$nama_departemen;
		$data_karyawan    = $this->model->getDataKaryawan($id_cabang, $id_departemen);
		$data['data']     = $data_karyawan;
		$output           = true;
		$data['is_excel'] = true;
		$sb_view = $this->load->view('payroll/gapok_import/download', $data, $output);

		$param = [
			'download' => true,
			'cLength'    => 9,
			'file_name'    => strtoupper($data['nama']),
			'paper_size'	=> 'A4',
			'font-size'		=> 12,
			// 'pagebreak'		=> false,
			'page_margin'	=> ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
			'orientation'	=> 'potrait',
      		'header'    => [
				'1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'3' => ['merge' => true]
			],
			'freezecolumn'	   => ['G5'],
			'thead'        => ['4'],
			'tbody'        => [
				'start' => '4',
				'height'	=> 15,
				'wrap' => ['B', 'C'],
				'column' => [
					'A'    => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
					'B'    => ['width' => 10, 'align' => 'center', 'valign' => 'middle','format'=>'text'],
					'C'    => ['width' => 40],
					'D'    => ['width' => 20],
					'E'    => ['width' => 20],
					'G'    => ['width' => 20,'format'=>'text', 'rupiah' => true],
					'H'    => ['width' => 20,'format'=>'text', 'rupiah' => true],
					'I'    => ['width' => 0,'format'=>'text'],
					'J'    => ['width' => 0,'format'=>'text']
				],
			],
		];
		$this->excel->generateExcel($sb_view, $param);

	}

	public function import_data_excel() {
		if(!empty($_FILES['file']['name'])) {
            $fileUpload['fname']    = 'file';
            $fileUpload['location'] = 'template_master_gapok';
            $fileUpload['allowed']  = 'xls|xlsx';
            $fileUpload['compress_image']  = false;

            $upload = $this->uploadfile->doUpload($fileUpload);
			if($upload["success"] == true){
				$dir_file = $this->config->item('base_upload').$upload['url'];
			}else{
				$message = ["message"=>$upload["message"]];
				return __response_save(false,$message);
			}
        }else{
			$message = ["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal import</font>'];
			return __response_save(false,["message"=>$message]);
        }

        try{
            $inputFileType = PHPExcel_IOFactory::identify($dir_file);
            $objReader 	   = PHPExcel_IOFactory::createReader($inputFileType);
            $objPHPExcel   = $objReader->load($dir_file);
        }catch(Exception $e){
			$message = ["message"=>'Error loading file "' . pathinfo($dir_file, PATHINFO_BASENAME) . '": ' . $e->getMessage()];
			return __response_save(false,["message"=>$message]);
        }

		$master_gapok  = $this->model->masterGapok();
		$highestRow    = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
		$data_insert   = array();
		// $highestColumm++;
		for ($row = 5; $row < $highestRow; $row++) {
			$gapok 		 		= $objPHPExcel->setActiveSheetIndex(0)->getCell("G".$row)->getValue();
			$lembur_per_jam 	= $objPHPExcel->setActiveSheetIndex(0)->getCell("H".$row)->getValue();
			$id_karyawan 		= $objPHPExcel->setActiveSheetIndex(0)->getCell("I". $row)->getValue();
			$id_cabang   		= $objPHPExcel->setActiveSheetIndex(0)->getCell("J". $row)->getValue();
			if(empty($gapok)){
				$flag = '2';
			}elseif(in_array($id_karyawan, $master_gapok)) {
				$flag = '3';
			} else {
				$flag = '1';
			}

			if(!empty($id_karyawan)){
				$data = array(
							"id_karyawan" 		=> $id_karyawan,
							"id_cabang"	  		=> $id_cabang,
							"nominal" 	  		=> $gapok,
							"lembur_per_jam" 	=> $lembur_per_jam,
							"flag" 		  		=> $flag,
							"user_input"  		=> $this->id_karyawan,
							"id_company"  		=> $this->id_company);

				$data_insert[] = $data;
			}

		}


		$this->db->trans_start();
		$this->db->where("id_company",$this->id_company);
		$this->db->where("user_input",$this->id_karyawan);
		$this->db->delete("payroll_gapok_m_temp");
		$this->db->insert_batch('payroll_gapok_m_temp', $data_insert);
		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$message = ["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal diimport</font>'];
			return __response_save(false,$message);
		}else{
			unlink($dir_file);
			$this->db->trans_commit();
			$message = ["message"=>'<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Data berhasil diimport</font>'];
			return __response_save(true,$message);
		}
	}

	public function list_data() {
		$this->load->helper('numeric');

		$list = $this->model->get_datatables();
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nama_lengkap."<br><span class='font-size-xsmall'>".$field->nik."</span>";
			$row[] = $field->nama_cabang."<br><span class='font-size-xsmall'>".$field->kode_cabang."</span>";
			$row[] = dec_to_num($field->nominal);
			$row[] = dec_to_num($field->lembur_per_jam);
			$btn_edit  = '<a href="#" class="text-warning" title="EDIT"> <i id="'.md5($field->id_karyawan.$this->id_company).'" class="btn_edit fa fa-edit (alias) "> </i></a>';
			$btn_hapus = '<a href="#" class="text-danger" title="HAPUS"><i id="'.md5($field->id_karyawan.$this->id_company).'" class="btn_delete fa fa-trash"></i></a>';
			$row[] =$btn_edit.' '.$btn_hapus;
			$row[] = $field->flag;

			$data[] = $row;
		}

		$output = array("draw"            => $_GET['draw'],
						"recordsTotal"    => $this->model->count_all(),
						"recordsFiltered" => $this->model->count_filtered(),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function delete_all_temp(){
		$this->db->where("id_company",$this->id_company);
		$this->db->where("user_input",$this->id_karyawan);
		$delete = $this->db->delete("payroll_gapok_m_temp");
		return __response_delete($delete);
	}

	public function publish_all(){
		$data_gapok_ready   = $this->model->masterGapokReady();
		$data_insert 		= [];
		$data_log    		= [];
		$data_update_temp   = [];
		$data_update		= [];
		$data_gapok_update	= [];

		$id_karyawan_update = [];
		$gapok_update = [];

		$tunj_tetap_update = [];
		$pot_tetap_update = [];

		$data_gapok = $this->model->getDataGapokTemp();

		foreach($data_gapok as $rows){
			if($rows->flag == 1) {
				array_push($data_insert, [
					'id_company'  		=> $this->id_company,
					'id_karyawan' 		=> $rows->id_karyawan,
					'nominal' 	  		=> $rows->nominal,
					'lembur_per_jam' 	=> $rows->lembur_per_jam,
					'user_input'  		=> $this->id_karyawan." - ".$this->nama_user,
				]);

				array_push($data_log, [
					'id_company'   => $this->id_company,
					'id_karyawan'  => $rows->id_karyawan,
					'action'	   => 'tambah',
					'nominal_lama' => '0',
					'nominal_baru' => $rows->nominal,
					'user_input'   => $this->id_karyawan." - ".$this->nama_user
				]);

				$id_karyawan_update[] = $rows->id_karyawan;
				$gapok_update[$rows->id_karyawan]['nominal_update'] = $rows->nominal;

			} elseif($rows->flag == 3) {
				if(
						$data_gapok_ready[$rows->id_karyawan]['nominal'] != $rows->nominal	||
						$data_gapok_ready[$rows->id_karyawan]['lembur_per_jam'] != $rows->lembur_per_jam
				) {
					array_push($data_update, [
						'id_karyawan' 		=> $rows->id_karyawan,
						'user_update' 		=> $rows->id_karyawan." - ".$rows->nama_user,
						'tgl_update'  		=> date('Y-m-d H:i:s'),
						'nominal'	  		=> $rows->nominal,
						'lembur_per_jam' 	=> $rows->lembur_per_jam,
					]);

					array_push($data_log, [
						'id_company'   => $this->id_company,
						'id_karyawan'  => $rows->id_karyawan,
						'action'	   => 'edit',
						'nominal_lama' => $data_gapok_ready[$rows->id_karyawan]['nominal'],
						'nominal_baru' => $rows->nominal,
						'user_input'   => $this->id_karyawan." - ".$this->nama_user
					]);
				}

				$id_karyawan_update[] = $rows->id_karyawan;
				$gapok_update[$rows->id_karyawan]['nominal_update'] = $rows->nominal;
			}

			array_push($data_update_temp, [
				'id_karyawan' => $rows->id_karyawan,
				'flag'		  => 4
			]);
		}

		if(count($id_karyawan_update) > 0){
			$tunj_tetap_update  = $this->_get_tunj_tetap_update($gapok_update, $id_karyawan_update);
			$pot_tetap_update   = $this->_get_pot_tetap_update($gapok_update, $id_karyawan_update);
		}

		$this->db->trans_start();
		if(count($data_insert) > 0) {
			$this->db->insert_batch('payroll_gapok_m', $data_insert);
		}
		if(count($data_update) > 0) {
			$this->db->where('id_company', $this->id_company);
			$this->db->update_batch('payroll_gapok_m', $data_update, 'id_karyawan');
		}
		if(count($data_log) > 0) {
			$this->db->insert_batch('payroll_gapok_log', $data_log);
		}
		if(count($data_update_temp) > 0) {
			$this->db->where('id_company', $this->id_company);
			$this->db->update_batch('payroll_gapok_m_temp', $data_update_temp, 'id_karyawan');
		}

		# Update Tunjangan Tetap
		if(count($tunj_tetap_update) > 0) {
			$this->db->where("id_company",$this->id_company);
			$this->db->update_batch('payroll_tunj_tetap_m', $tunj_tetap_update, 'concat(id_karyawan,id_item,id_company)');
		}

		# Update Potongan Tetap
		if(count($pot_tetap_update) > 0) {
			$this->db->where("id_company",$this->id_company);
			$this->db->update_batch('payroll_pot_tetap_m', $pot_tetap_update, 'concat(id_karyawan,id_item,id_company)');
		}

		$this->db->trans_complete();

		if($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$message = ["message"=>'<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal diimport</font>'];
			return __response_save(false,["message"=>$message]);
		}else{
			$this->db->trans_commit();
			$message = ["message"=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Data berhasil diimport</font>'];
			return __response_save(true,["message"=>$message]);
		}
	}

	public function form($id=null){
		$data['data'] = $this->model->getDataById($id);
		$this->load->view('payroll/gapok_import/form',$data);
	}

	public function save() {
		$id 			= $this->input->post('id');
		$flag 	 		= $this->input->post('flag');
		$nominal 		= $this->input->post('nominal');
		$lembur_per_jam = $this->input->post('lembur_per_jam');

		$cekData 		= $this->model->cekDataExist($id);

		$this->db->set('nominal', $nominal);
		$this->db->set('lembur_per_jam', $lembur_per_jam);
		if($flag == '2' and $nominal > 0) {
			if($cekData > 0) {
				$this->db->set('flag', '3');
			} else {
				$this->db->set('flag', '1');
			}
		} elseif($nominal == 0) {
			$this->db->set('flag', '2');
		}
		$this->db->where("md5(CONCAT(id_karyawan, id_company)) = '$id'", NULL, TRUE);
		$update = $this->db->update('payroll_gapok_m_temp');
		__response_update($update);
	}

	public function delete() {
		$id = $this->input->post('id');
		$this->db->where("md5(CONCAT(id_karyawan, id_company)) = '$id'", NULL, TRUE);
		$delete = $this->db->delete("payroll_gapok_m_temp");
		__response_delete($delete);
	}


	#  Function Update Tunjangan
	private function _get_tunj_tetap_update($gapok_update=[], $id_karyawan=[]){
		$get_tunj_tetap = $this->db->select("   id_karyawan,
												id_item,
												gapok_rp,
												gapok_persen,
												nominal_tunjangan")
									->from('payroll_tunj_tetap_m')
									->where_in('id_karyawan', $id_karyawan)
									->where('flag_persentase_gapok', "1")
									->get()
									->result();

		$tunj_tetap_update = array();
		foreach($get_tunj_tetap as $tunj_tetap){
			$gapok = $gapok_update[$tunj_tetap->id_karyawan]['nominal_update'];

			$data_tunj = array( 'concat(id_karyawan,id_item,id_company)' => $tunj_tetap->id_karyawan.$tunj_tetap->id_item.$this->id_company,
								'id_item'             => $tunj_tetap->id_item,
								'gapok_rp'            => $gapok,
								'gapok_persen'        => $tunj_tetap->gapok_persen,
								'nominal_tunjangan'   => ($gapok*$tunj_tetap->gapok_persen)/100,
								'user_update'         => $this->nik_karyawan. ' - ' .$this->nm_karyawan,
								'tgl_update'          => date("Y-m-d H:i:s"),
			);

			$tunj_tetap_update[] = $data_tunj;
		}

		return $tunj_tetap_update;
	}

	#  Function Update Potongan
	private function _get_pot_tetap_update($gapok_update=[], $id_karyawan=[]){
		$get_pot_tetap = $this->db->select("   id_karyawan,
												id_item,
												gapok_rp,
												gapok_persen,
												nominal_potongan")
									->from('payroll_pot_tetap_m')
									->where_in('id_karyawan', $id_karyawan)
									->where('flag_persentase_gapok', "1")
									->get()
									->result();

		$pot_tetap_update = array();
		foreach($get_pot_tetap as $pot_tetap){
			$gapok = $gapok_update[$pot_tetap->id_karyawan]['nominal_update'];

			$data_pot = array( 	'concat(id_karyawan,id_item,id_company)' => $pot_tetap->id_karyawan.$pot_tetap->id_item.$this->id_company,
								'id_item'            => $pot_tetap->id_item,
								'gapok_rp'          => $gapok,
								'gapok_persen'      => $pot_tetap->gapok_persen,
								'nominal_potongan'  => ($gapok*$pot_tetap->gapok_persen)/100,
								'user_update'       => $this->nik_karyawan. ' - ' .$this->nm_karyawan,
								'tgl_update'        => date("Y-m-d H:i:s"),
			);

			$pot_tetap_update[] = $data_pot;
		}

		return $pot_tetap_update;
	}

}
