<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Data_komponen extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/data_komponen_tdk_tetap/Data_komponen_m', 'model');
    }

    public function index()
    {
        $data['judul']   = 'Data Komponen Tidak Tetap';
        $data['aktif']   = 'data_komponen_tdk_tetap';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/data_komponen_tdk_tetap/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view_data($bulan, $id_karyawan = 'all', $id_cabang = 'all', $id_departemen = 'all')
    {
        $data['list_pendapatan'] = json_decode($this->model->list_komponen_pendapatan($bulan), true)['pendapatan'];
        $data['list_potongan']   = json_decode($this->model->list_komponen_potongan($bulan), true)['potongan'];
        $data['bulan']           = $bulan;
        $data['id_karyawan']     = $id_karyawan;
        $data['id_cabang']       = $id_cabang;
        $data['id_departemen']   = $id_departemen;
        $this->load->view('payroll/data_komponen_tdk_tetap/list_data', $data);
    }

    public function list_data($bulan, $id_karyawan = 'all', $id_cabang = 'all', $id_departemen = 'all')
    {
        // decode URI
        $id_cabang     = urldecode($id_cabang);
        $id_departemen = urldecode($id_departemen);

        $list          = $this->model->get_datatables($id_karyawan, $id_cabang, $id_departemen);
        $get_pend      = json_decode($this->model->tambah_pendapatan($bulan, $id_karyawan, $id_cabang, $id_departemen), true);
        $get_pot       = json_decode($this->model->tambah_potongan($bulan, $id_karyawan, $id_cabang, $id_departemen), true);
        $data          = array();
        $bulan         = date('Y-m', strtotime('01-' . $bulan));
        $no            = $_GET['start'];
        $cek_data      = false;
        // jika ada data pendapatan / potongan
        if (count($get_pend) > 0 || count($get_pot) > 0) {
            foreach ($list as $field) {
                $no++;
                $row   = array();
                $row[] = $no;
                $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";

                $total_pendapatan = 0;
                if (count($get_pend[$field->id_karyawan]) > 0) {
                    $cek_data = true;
                    // show cabang, departemen, jabatan
                    $row[] = $get_pend[$field->id_karyawan][0]['cabang'];
                    $row[] = $get_pend[$field->id_karyawan][0]['departemen'];
                    $row[] = $get_pend[$field->id_karyawan][0]['jabatan'];
                    foreach ($get_pend[$field->id_karyawan] as $komponen) {
                        $pendapatan = $komponen['nominal_tunjangan'];
                        $nominalWithButton = '
                        <div class="nominal-with-button">
                            <span>' . number_format($komponen['nominal_tunjangan'], 0, ',', '.') . '</span>
                            <button class="btn-link border-0 text-warning" data-toggle="modal" data-target="#modal-nominal" data-item="' . md5($komponen['id_karyawan'] . $komponen['id_item'] . $bulan . $this->id_company) . '" data-komponen="pendapatan" data-nominal="' . number_format($komponen['nominal_tunjangan'], 0, ',', '.') . '" data-nm_komponen="' . $komponen['nm_tunjangan'] . '"><i class="fa fa-edit (alias) "></i></button>
                        </div>';
                        $row[] = $nominalWithButton;
                        $total_pendapatan += $pendapatan;
                    }
                    $row[] = number_format($total_pendapatan, 0, ',', '.');
                }

                $total_potongan = 0;
                if (count($get_pot[$field->id_karyawan]) > 0) {
                    $cek_data = true;
                    // show cabang, departemen, jabatan jika tidak ada data pendapatan
                    if (empty($get_pend[$field->id_karyawan])) {
                        $row[] = $get_pot[$field->id_karyawan][0]['cabang'];
                        $row[] = $get_pot[$field->id_karyawan][0]['departemen'];
                        $row[] = $get_pot[$field->id_karyawan][0]['jabatan'];
                    }
                    foreach ($get_pot[$field->id_karyawan] as $komponen) {
                        $potongan = $komponen['nominal_potongan'];
                        $nominalWithButton = '
                        <div class="nominal-with-button">
                            <span>' . number_format($komponen['nominal_potongan'], 0, ',', '.') . '</span>
                            <button class="btn-link border-0 text-warning" data-toggle="modal" data-target="#modal-nominal" data-item="' . md5($komponen['id_karyawan'] . $komponen['id_item'] . $bulan . $this->id_company) . '" data-komponen="potongan" data-nominal="' . number_format($komponen['nominal_potongan'], 0, ',', '.') . '" data-nm_komponen="' . $komponen['nm_potongan'] . '"><i class="fa fa-edit (alias) "></i></button>
                        </div>';
                        $row[] = $nominalWithButton;
                        $total_potongan += $potongan;
                    }
                    $row[] = number_format($total_potongan, 0, ',', '.');
                }

                $data[] = $row;
            }
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => ($cek_data == true) ? $this->model->count_all($id_karyawan, $id_cabang, $id_departemen) : 0,
            "recordsFiltered" => ($cek_data == true) ? $this->model->count_filtered($id_karyawan, $id_cabang, $id_departemen) : 0,
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form()
    {
        $this->load->view('payroll/data_komponen_tdk_tetap/form');
    }

    public function update()
    {
        $id_item         = $this->input->post('item');
        $master_komponen = $this->input->post('komponen');
        $nominal         = $this->input->post('nominal');

        if ($master_komponen == 'pendapatan') {
            $komponen = 'nominal_tunjangan';
        } else if ($master_komponen == 'potongan') {
            $komponen = 'nominal_potongan';
        } else {
            return __response_update(false);
        }

        $data = array(
            'user_update' => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
            'tgl_update' => date('Y-m-d H:i:s'),
            $komponen => str_replace('.', '', $nominal)
        );

        $this->model->update($data, $master_komponen, $id_item);
    }

    public function cabang()
    {
        $search = $this->input->get("q");

        if ($this->level_user == "5") { # KEPALA CABANG
            if ($this->multi_cabang == true) {
                $this->db->where_in('id_cabang', $this->id_cabang_arr);
            } else {
                $this->db->where('id_cabang', $this->id_cabang);
            }
        }

        $this->db->select('nama, id_cabang, kode');
        $this->db->where('id_company', $this->id_company);
        $this->db->group_start();
        $this->db->like('nama', $search);
        $this->db->or_like('kode', $search);
        $this->db->group_end();
        $this->db->order_by('id_cabang', 'ASC');

        $result = $this->db->get('master_cabang')->result();
        $json = [];

        foreach ($result as $rows) {
            $json[] = [
                'id'         => $rows->kode,
                'kodecabang' => $rows->kode,
                'namacabang' => $rows->nama,
                'text'       => $rows->kode . " - " . $rows->nama
            ];
        }
        echo json_encode($json);
    }

    public function departemen_by_cabang($id_cabang = null)
    {
        // decode URI
        $id_cabang = urldecode($id_cabang);

        $search    = $this->input->get("q");

        if ($this->level_user == "2") { # KEPALA DEPARTEMEN
            if ($this->multi_departemen == true) {
                $this->db->where_in('data_karyawan.id_departemen', $this->id_departemen_arr);
            } else {
                $this->db->where('data_karyawan.id_departemen', $this->id_departemen);
            }
        }

        $this->db->select('master_departemen.id_departemen, master_departemen.kode, master_departemen.nama');
        $this->db->join('data_karyawan', 'data_karyawan.id_departemen = master_departemen.id_departemen');
        $this->db->join('master_cabang', 'data_karyawan.id_cabang = master_cabang.id_cabang');
        $this->db->where('master_departemen.id_company', $this->id_company);
        $this->db->where('master_cabang.kode', $id_cabang);

        $this->db->group_start();
        $this->db->like('master_departemen.nama', $search);
        $this->db->or_like('master_departemen.kode', $search);
        $this->db->group_end();
        $this->db->order_by('master_departemen.kode', 'ASC');
        $this->db->group_by('master_departemen.id_departemen');
        $this->db->from('master_departemen');

        $result = $this->db->get()->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = [
                'id'             => $rows->kode,
                'kodedepartemen' => $rows->kode,
                'namadepartemen' => $rows->nama,
                'text'           => $rows->kode . " - " . $rows->nama
            ];
        }
        echo json_encode($json);
    }
}
