<?php
$array_bulan_short = $this->lang->line('array_bulan');
$months = str_replace(["[", "]", "'"], "", $array_bulan_short);
$months_array = explode(", ", $months);
?>
<div class="position-relative pull-right" style="top: -2.5em;">
    <button id="view-diagram" type="button" class="ml-1 btn btn-warning ladda-button" data-style="expand-left">
        <i class="fa fa-bar-chart"></i> View Diagram
    </button>
</div>
<div class="table-responsive mt-4">
    <div class="pull-right ml-1">
        <button id="download" type="button" class="btn btn-primary ladda-button" disabled data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th rowspan="2" class="text-center align-middle">NO</th>
                <th rowspan="2" class="text-center align-middle">NAMA</th>
                <?php
                foreach ($months_array as $value) {
                    echo '<th colspan="2" class="text-center text-uppercase">' . $value . '</th>';
                }
                ?>
            </tr>
            <tr>
                <?php
                foreach ($months_array as $value) {
                    echo '<th class="text-center">TARGET</th>';
                    echo '<th class="text-center">REALISASI</th>';
                }
                ?>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td></td>
            </tr>
        </tbody>
    </table>
</div>

<script>
    $(function() {
        list_data = $('#list_data').DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'fixedColumns': {
                leftColumns: 2
            },
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama karyawan'
                <?php else : ?> 'searchPlaceholder': 'Employees Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.report.realisasi.nominal.list.data') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                    d.tahun       = $(".filter #tahun").val();
                    d.id_group    = !$(".filter #id_group").val()?'all':$(".filter #id_group").val();
                    d.id_karyawan = !$(".filter #id_karyawan").val()?'all':$(".filter #id_karyawan").val();
                },
                "complete": function(data) {
                    $("#download").prop("disabled", false);
                    reconfigure(data);
                    screenUp(200);
                }
            },
            "aoColumnDefs": [{
                render: function(data, type, full, meta) {
                    return "<div style='text-wrap:wrap !important; width:200px'>" + data + "</div>";
                },
                targets: 1
            }],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                for (var i = 2; i <= 26; i++) {
                    $('td:eq(' + i + ')', nRow).css({
                        'text-align': 'right'
                    });
                }

                // START FOOTER
                if (aData[26] == "colspan-t-realisasi") {
                    $("td:eq(1)", nRow).css({
                        'display': 'none'
                    }); // $("td:eq(1)", nRow).remove();
                    $(nRow).children('td:eq(0)').attr('colspan', 2);

                    $('td:eq(0)', nRow).css({
                        'background-color': '#1c77d4',
                        'color': '#fff',
                        'border-top': '1px solid #fff',
                        'border-right': '1px solid #fff'
                    });
                    for (var i = 2; i <= 26; i++) {
                        $('td:eq(' + i + ')', nRow).css({
                            'background-color': '#ccedff',
                            'color': '#000',
                            'border-top': '1px solid #fff',
                            'border-right': '1px solid #fff'
                        });
                    }

                } else if (aData[26] == "colspan-t-tahunan-bulanan") {
                    var td_genap = "td:eq(0),td:eq(2),td:eq(4),td:eq(6),td:eq(8),td:eq(10),td:eq(12),td:eq(14),td:eq(16),td:eq(18),td:eq(20),td:eq(22),td:eq(24)";
                    var td_ganjil = "td:eq(1),td:eq(3),td:eq(5),td:eq(7),td:eq(9),td:eq(11),td:eq(13),td:eq(15),td:eq(17),td:eq(19),td:eq(21),td:eq(23),td:eq(25)";

                    $(nRow).children(td_genap).attr('colspan', 2);
                    $(td_ganjil, nRow).css({
                        'display': 'none'
                    });
                    $(td_genap, nRow).css({
                        'text-align': 'center'
                    });

                    $('td:eq(0)', nRow).css({
                        'background-color': '#1c77d4',
                        'color': '#fff',
                        'border-top': '1px solid #fff',
                        'border-right': '1px solid #fff'
                    });
                    for (var i = 2; i <= 26; i++) {
                        $('td:eq(' + i + ')', nRow).css({
                            'background-color': '#ccedff',
                            'color': '#000',
                            'border-top': '1px solid #fff',
                            'border-right': '1px solid #fff'
                        });
                    }
                }
                // END FOOTER
            },
        });

        $("#download").click(function() {
            let tahun       = $(".filter #tahun").val();
            let id_group    = !$(".filter #id_group").val()?'all':$(".filter #id_group").val();
            let nm_group    = !$(".filter #id_group").val()?'Semua Group':$(".filter #id_group").select2('data')[0]['nm-group'];
            let id_karyawan = !$(".filter #id_karyawan").val()?'all':$(".filter #id_karyawan").val();
            let nm_karyawan = !$(".filter #id_karyawan").val()?'Semua Sales':$(".filter #id_karyawan").select2('data')[0]['nm-karyawan'];
            urlExcel = "<?= route('sales_activity.report.realisasi.nominal.download') ?>"+'?tahun='+tahun+'&id_group='+id_group+'&nm_group='+nm_group+'&id_karyawan='+id_karyawan+'&nm_karyawan='+nm_karyawan;
            downloadFile(urlExcel, this);
        });

        $("#view-diagram").click(function() {
            list_datatable("diagram", this);
        });
    });
</script>
