<style>
    th {vertical-align: middle !important;}
    table.dataTable td {vertical-align: top !important;}
</style>
<div class="btn-group mb-1">
    <button id="excel" class="btn btn-primary text-white download ladda-button" data-style="expand-left"><i class="fa fa-file-excel-o"></i> DOWNLOAD LAPORAN PPH 21</button>
</div>

<div class="table-responsive">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th rowspan="2" class="text-center">NO</th>
                <th rowspan="2" class="text-left">&nbsp;&nbsp;BULAN&nbsp;&nbsp;</th>
                <th rowspan="2" class="text-left">&nbsp;NAMA KARYAWAN&nbsp;</th>
                <th rowspan="2" class="text-center">NOMOR KTP</th>
                <th rowspan="2" class="text-center">NPWP</th>
                <th rowspan="2" class="text-left" id="th_jabatan">JABATAN</th>
                <th rowspan="2" class="text-center">TGGN</th>
                <th rowspan="2" class="text-center">LOKAL/<br>EXPAT</th>
                <th rowspan="2" class="text-center">MULAI<br>KERJA<br>BULAN<br>KE</th>
                <th rowspan="2" class="text-center">AKHIR<br>KERJA<br>BULAN<br>KE</th>
                <?php
                    if (count($komponen_tunj_tetap->result()) > 0) {
                        echo '<th colspan="'.(count($komponen_tunj_tetap->result())+4).'" class="align-middle text-center">PENGHASILAN BRUTO</th>';
                    }else{
                        echo '<th colspan="4" class="align-middle text-center">PENGHASILAN BRUTO</th>';
                    }
                    if (count($komponen_pot_tetap->result()) > 0) {
                        echo '<th colspan="'.(count($komponen_pot_tetap->result())+3).'" class="align-middle text-center">PENGURANGAN</th>';
                    }else{
                        echo '<th colspan="3" class="align-middle text-center">PENGURANGAN</th>';
                    }
                ?>
                <th rowspan="2" class="text-center">JUMLAH PH NETO<br>SETAHUN/<br>DISETAHUNKAN</th>
                <th rowspan="2" class="text-center">PTKP</th>
                <th rowspan="2" class="text-center">PKP<br>SETAHUN/<br>DISETAHUNKAN</th>
                <th rowspan="2" class="text-center">PPH 21 SEBULAN<br></th>
            </tr>
            <tr class="bg-tr">
                <th>GAPOK</th>
                <?php
                    if (count($komponen_tunj_tetap->result()) > 0) {
                        foreach($komponen_tunj_tetap->result() as $row) {
                            echo '<th>'.strtoupper($row->nm_komponen).'</th>';
                        }
                    }
                    echo '<th>BPJS KES</th>';
                    echo '<th>BPJS TK</th>';
                    echo '<th>JUMLAH</th>';
                    if (count($komponen_pot_tetap->result()) > 0) {
                        foreach($komponen_pot_tetap->result() as $row) {
                            echo '<th>'.strtoupper($row->nm_komponen)."</th>";
                        }
                    }
                    echo '<th>BPJS KES</th>';
                    echo '<th>BPJS TK</th>';
                    echo '<th>JUMLAH</th>';
                ?>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    $(function() {
        $("#excel").click(function() {
            let urlExcel = "<?= route('payroll.laporan.pph.download.excel', ['bulan' => $bulan, 'id_cabang' => $id_cabang, 'id_departemen' => $id_departemen, 'id_karyawan' => $id_karyawan]) ?>";
            downloadFile(urlExcel, this);
        });

        // LIST DATA
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function ( e, settings, techNote, message ) {
            if(confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')){
                window.location.reload();
            }
        }).DataTable({
            'searching'   : false,
            'paging'      : true,
            'lengthChange': true,
            'ordering'    : false,
            'info'        : true,
            'scrollX'     : true,
            'autoWidth'   : false,
            'fixedColumns': { leftColumns: 3 },
            'language'    :{
                'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': 'Kode/Nama'
            },
            "processing"  : true,
            "serverSide"  : true,
            "order"       : [],

            "ajax"        : {
                "url": "<?= route('payroll.laporan.pph.list.data', ['bulan' => $bulan, 'id_cabang' => $id_cabang, 'id_departemen' => $id_departemen, 'id_karyawan' => $id_karyawan]) ?>",
                "type": "GET",
                "data"  : function (d) {
                    delete d.columns;
                },
                "complete" : function(data){
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [
                { "aTargets": [0], "bSortable": false },
            ],
            "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                $('td:eq(0)', nRow).css({'text-align':'center', 'width':'10px'});
                $('td:eq(1)', nRow).css({'text-align':'center'});
                $('td:eq(2)', nRow).css({'text-align':'left'});
                $('td:eq(3)', nRow).css({'text-align':'left'});
                $('td:eq(4)', nRow).css({'text-align':'left'});
                $('td:eq(5)', nRow).css({'text-align':'left'});
                $('td:eq(6)', nRow).css({'text-align':'center'});
                $('td:eq(7)', nRow).css({'text-align':'center'});
                $('td:eq(8)', nRow).css({'text-align':'center'});
                $('td:eq(9)', nRow).css({'text-align':'center'});
                $('td:eq(10)', nRow).css({'text-align':'center'});

                var start_kolom = 10;
                var jml_kolom = 20;
                for(i=start_kolom; i<=(parseInt(jml_kolom)+start_kolom); i++){
                    $('td:eq('+i+')', nRow).css({'text-align':'right'});
                }
            }
        });
        // END LIST DATA
    });
</script>
