<table id="list_data_aspek_kedisiplinan" class="table table-striped table-bordered">
    <thead style="font-family: Poppins SemiBold;">
        <tr>
            <th width=20%>Keterangan</th>
            <th width=20% class="_center">Jumlah</th>
            <th width=20% class="_center">Bobot</th>
            <th width=20% class="_center">Poin</th>
            <th width=20% class="_center">Skor</th>
        </tr>
    </thead>
    <tbody></tbody>
    <tfoot>
        <tr height=50>
            <th class="align-middle" colspan=4 style="font-family: 'Poppins Bold';">Total</th>
            <th class="align-middle" style="font-family: 'Poppins Bold';">0</th>
        </tr>
    </tfoot>
</table>
<script>
    $(function() {
        list_data = $('#list_data_aspek_kedisiplinan').DataTable({
            searching: false,
            ordering : false,
            paging   : false,
            info     : false,
            scrollX  : false,
            language : {
                url: '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>'
            },
            columnDefs: [
                { targets: '_center', className: "text-center" },
            ],
            processing: true,
            serverSide: true,
            ajax      : {
                url : '<?= route("kpi.approval.detail.aspek-kedisiplinan.list-data") ?>',
                data: function(d) {
                    delete d.columns;
                    delete d.search;
                    
                    d.karyawan = $('#karyawan').val();
                    d.tahun    = $('#tahun').val();
                    d.bulan    = $('#bulan').val();
                },
                complete: function(data) {
                    var pembungkus = $(".div_pembungkus_js_menu_context")
                    if(pembungkus == null || pembungkus == undefined){
                        // jalankan selanjutnya
                    }else{
                        var outerHeight = $('.body_laporan').outerHeight();
                        outerHeight = outerHeight * 80 / 100;
                        pembungkus.css('height', outerHeight);
                    }
                },
            },
            footerCallback: function(row, data) {console.log(data);
                var total = 0;
                data.forEach(function(item) {
                    total = total + parseFloat(item[4]);
                });
                this.api().column(4).footer().innerHTML = total.toFixed(2);
            }
        });
    });
</script>