<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Master_gapok_m extends CI_Model {
    private $table = 'payroll_gapok_m';

    public function __construct(){
		parent::__construct();
	}

    function get_datatables(){
        $this->_get_datatables_query();
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->db->select("id_karyawan")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query(){
        $this->db->select("
                            dk.nama_lengkap AS nm_karyawan,
                            dk.nik,
                            mc.kode AS kd_cabang,
                            mc.nama AS nm_cabang,
                            pg.id_karyawan,
                            pg.nominal,
                            pg.lembur_per_jam")
                 ->from($this->table." as pg")
                 ->join("data_karyawan as dk","dk.id_karyawan = pg.id_karyawan")
                 ->join("master_cabang as mc","mc.id_cabang = dk.id_cabang")
                 ->where("dk.id_company", $this->id_company);

        $column_search = array('dk.nik','dk.nama_lengkap');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','dk.nik','dk.nama_lengkap');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("pg.tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $this->db->select("dk.nama_lengkap AS nm_karyawan,
                            dk.nik,
                            mc.kode AS kd_cabang,
                            mc.nama AS nm_cabang,
                            pg.id_karyawan,
                            pg.nominal,
                            pg.lembur_per_jam");
        $this->db->join("data_karyawan AS dk","dk.id_karyawan = pg.id_karyawan");
        $this->db->join("master_cabang AS mc","mc.id_cabang = dk.id_cabang");
        $this->db->from($this->table." AS pg");
        $this->db->where("md5(pg.id_karyawan)", $id);
        $this->db->where("pg.id_company",$this->id_company);
        $query = $this->db->get();
        return $query->row();
    }

    // ACTION SAVE
    public function save($data){
        $cek_data = $this->db->select("id_karyawan")
                            ->where("md5(id_karyawan)", $data['id_karyawan'])
                            ->where("id_company", $this->id_company)
                            ->from($this->table)
                            ->get()
                            ->num_rows();

        if($cek_data > 0){
            return  __response_duplicate();
        }else{
            $id_karyawan = $this->db->select("id_karyawan")
                                ->where("md5(id_karyawan)", $data['id_karyawan'])
                                ->where("id_company", $this->id_company)
                                ->from('data_karyawan')
                                ->get()->row()->id_karyawan;

            $gapok              = $data['nominal'];
            $id_karyawan_update = $data['id_karyawan'];
            $tunj_tetap_update  = $this->_get_tunj_tetap_update($gapok, $id_karyawan_update);
            $pot_tetap_update   = $this->_get_pot_tetap_update($gapok, $id_karyawan_update);

            $this->db->trans_start();

            # Insert Data Gapok
            $data["id_karyawan"]    = $id_karyawan;
            $data["id_company"]     = $this->id_company;
            $data["user_input"]     = $this->nik_karyawan. ' - ' .$this->nm_karyawan;
            $this->db->insert($this->table, $data);

            # Update Tunjangan Tetap
            if(count($tunj_tetap_update) > 0) {
                $this->db->where("id_company",$this->id_company);
                $this->db->update_batch('payroll_tunj_tetap_m', $tunj_tetap_update, 'concat(id_karyawan,id_item,id_company)');
            }

            # Update Potongan Tetap
            if(count($pot_tetap_update) > 0) {
                $this->db->where("id_company",$this->id_company);
                $this->db->update_batch('payroll_pot_tetap_m', $pot_tetap_update, 'concat(id_karyawan,id_item,id_company)');
            }

            $this->db->trans_complete();

            if($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return __response_save(false);
            }else{
                $this->db->trans_commit();
                return __response_save(true);
            }
        }
    }

    // ACTION UPDATE
    public function update($data){
		$id_karyawan = $this->input->post('id_karyawan');
        $gapok       = $data['nominal'];

        $tunj_tetap_update  = $this->_get_tunj_tetap_update($gapok, $id_karyawan);
        $pot_tetap_update   = $this->_get_pot_tetap_update($gapok, $id_karyawan);
        // echo '<pre>'.print_r($tunj_tetap_update, true).'</pre>';         die();

        $this->db->trans_start();

        # Update Gapok
        $data["user_update"]    = $this->nik_karyawan. ' - ' .$this->nm_karyawan;
        $data["tgl_update"]     = date("Y-m-d H:i:s");
        $this->db->update($this->table, $data, ["md5(id_karyawan)" => $id_karyawan]);

        # Update Tunjangan Tetap
		if(count($tunj_tetap_update) > 0) {
			$this->db->where("id_company",$this->id_company);
			$this->db->update_batch('payroll_tunj_tetap_m', $tunj_tetap_update, 'concat(id_karyawan,id_item,id_company)');
		}

		# Update Potongan Tetap
		if(count($pot_tetap_update) > 0) {
			$this->db->where("id_company",$this->id_company);
			$this->db->update_batch('payroll_pot_tetap_m', $pot_tetap_update, 'concat(id_karyawan,id_item,id_company)');
		}

        $this->db->trans_complete();

        if($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        }else{
            $this->db->trans_commit();
            return __response_update(true);
        }
    }

    // ACTION DELETE
    public function delete($id=null){
        $gapok = "0";
        $action = "delete";
        $tunj_tetap_update  = $this->_get_tunj_tetap_update($gapok, $id);
        $pot_tetap_update   = $this->_get_pot_tetap_update($gapok, $id);

        $this->db->trans_start();

        # Delete data Gapok
        $this->db->where("id_company",$this->id_company);
        $this->db->where('md5(id_karyawan)', $id);
        $this->db->delete($this->table);

       # Update Tunjangan Tetap
		if(count($tunj_tetap_update) > 0) {
			$this->db->where("id_company",$this->id_company);
			$this->db->update_batch('payroll_tunj_tetap_m', $tunj_tetap_update, 'concat(id_karyawan,id_item,id_company)');
		}

		# Update Potongan Tetap
		if(count($pot_tetap_update) > 0) {
			$this->db->where("id_company",$this->id_company);
			$this->db->update_batch('payroll_pot_tetap_m', $pot_tetap_update, 'concat(id_karyawan,id_item,id_company)');
		}

        $this->db->trans_complete();

        if($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_delete(false);
        }else{
            $this->db->trans_commit();
            return __response_delete(true);
        }
    }

    # Function Update Tunjangan
    private function _get_tunj_tetap_update($gapok="0", $id_karyawan="0"){
        $get_tunj_tetap = $this->db->select("   id_karyawan,
                                                id_item,
                                                gapok_rp,
                                                gapok_persen,
                                                nominal_tunjangan")
                                    ->from('payroll_tunj_tetap_m')
                                    ->where('MD5(id_karyawan)', $id_karyawan)
                                    ->where('flag_persentase_gapok', "1")
                                    ->get()
                                    ->result();

        $tunj_tetap_update = array();
        foreach($get_tunj_tetap as $tunj_tetap){
            $data_tunj = array( 'concat(id_karyawan,id_item,id_company)' => $tunj_tetap->id_karyawan.$tunj_tetap->id_item.$this->id_company,
                                'id_item'             => $tunj_tetap->id_item,
                                'gapok_rp'            => $gapok,
                                'gapok_persen'        => $tunj_tetap->gapok_persen,
                                'nominal_tunjangan'   => ($gapok*$tunj_tetap->gapok_persen)/100,
                                'user_update'         => $this->nik_karyawan. ' - ' .$this->nm_karyawan,
                                'tgl_update'          => date("Y-m-d H:i:s"),
            );

            $tunj_tetap_update[] = $data_tunj;
        }

        return $tunj_tetap_update;
    }

    #  Function Update Potongan
    private function _get_pot_tetap_update($gapok="0", $id_karyawan="0"){
        $get_pot_tetap = $this->db->select("   id_karyawan,
                                                id_item,
                                                gapok_rp,
                                                gapok_persen,
                                                nominal_potongan")
                                    ->from('payroll_pot_tetap_m')
                                    ->where('MD5(id_karyawan)', $id_karyawan)
                                    ->where('flag_persentase_gapok', "1")
                                    ->get()
                                    ->result();

        $pot_tetap_update = array();
        foreach($get_pot_tetap as $pot_tetap){
            $data_pot = array(  'concat(id_karyawan,id_item,id_company)' => $pot_tetap->id_karyawan.$pot_tetap->id_item.$this->id_company,
                                'id_item'            => $pot_tetap->id_item,
                                'gapok_rp'          => $gapok,
                                'gapok_persen'      => $pot_tetap->gapok_persen,
                                'nominal_potongan'  => ($gapok*$pot_tetap->gapok_persen)/100,
                                'user_update'       => $this->nik_karyawan. ' - ' .$this->nm_karyawan,
                                'tgl_update'        => date("Y-m-d H:i:s"),
            );

            $pot_tetap_update[] = $data_pot;
        }

        return $pot_tetap_update;
    }

}
