<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Informasi_gaji_m extends CI_Model
{

    public function get_gapok_by_id($id_karyawan, $md5 = true)
    {
        $where_id = 'id_karyawan';
        if ($md5) $where_id = 'md5(id_karyawan)';
        return $this->db->select('nominal')
            ->from('payroll_gapok_m')
            ->where($where_id, $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()->row()->nominal;
    }

    public function get_tunj_tetap_by_id($id_karyawan, $id_item = '')
    {
        if ($id_item) $this->db->where('md5(id_item)', $id_item);

        return $this->db->select('id_item, nm_tunjangan, flag_persentase_gapok, gapok_persen, nominal_tunjangan')
            ->from('payroll_tunj_tetap_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->order_by('no_urut', 'asc')
            ->get();
    }

    public function get_ttl_tunj_tetap_by_id($id_karyawan)
    {
        return $this->db->select_sum('nominal_tunjangan')
            ->from('payroll_tunj_tetap_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()->row()->nominal_tunjangan;
    }

    public function get_pot_bpjs_kes_by_id($id_karyawan)
    {
        return $this->db->select('pot_kry_rp')
            ->from('payroll_bpjs_kes_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()->row()->pot_kry_rp;
    }

    public function get_tunj_bpjs_kes_by_id($id_karyawan)
    {
        return $this->db->select('tunj_perus_rp')
            ->from('payroll_bpjs_kes_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()->row()->tunj_perus_rp;
    }

    public function get_pot_bpjs_tk_by_id($id_karyawan)
    {
        return $this->db->select('pot_jht_kry_rp, flag_jht, pot_jp_kry_rp, flag_jp')
            ->from('payroll_bpjs_tk_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()
            ->row();
    }

    public function get_pot_tetap_by_id($id_karyawan)
    {
        return $this->db->select('id_item, nm_potongan, flag_persentase_gapok, gapok_persen, nominal_potongan')
            ->from('payroll_pot_tetap_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->order_by('no_urut', 'asc')
            ->get();
    }

    public function get_ttl_pot_bpjs_tk_by_id($id_karyawan)
    {
        return $this->db->select('(pot_jht_kry_rp+pot_jp_kry_rp) as total', FALSE)
            ->from('payroll_bpjs_tk_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()->row()->total;
    }

    public function get_ttl_tunj_bpjs_tk_by_id($id_karyawan)
    {
        return $this->db->select('(tunj_jht_perus_rp+tunj_jkk_rp+tunj_jp_perus_rp+tunj_jkm_rp) as total', FALSE)
            ->from('payroll_bpjs_tk_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()->row()->total;
    }

    public function get_ttl_pot_tetap_by_id($id_karyawan)
    {
        return $this->db->select_sum('nominal_potongan')
            ->from('payroll_pot_tetap_m')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->order_by('no_urut', 'asc')
            ->get()->row()->nominal_potongan;
    }

    /**
     * Update atau insert data gapok
     * function ini juga digunakan saat tambah data karyawan
     *
     * @param [type] $table => nama tabel
     * @param [type] $value => nominal gapok
     * @param [type] $value_old => nominal gapok sebelumnya
     * @param [type] $id_karyawan => tanpa md5
     * @param boolean $return => jika false, maka tanpa return message dan transaksi
     * @return void
     */
    public function update_gapok($table, $value, $value_old, $id_karyawan, $return = true)
    {
        // cek apakah data sudah ada
        $data_exist = $this->db->select('id_karyawan')
            ->where('id_company', $this->id_company)
            ->where('id_karyawan', $id_karyawan)
            ->get($table);

        if ($return) $this->db->trans_begin();

        // reusable variable
        $user = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
        $user_company = [
            'id_company'  => $this->id_company,
            'id_karyawan' => $id_karyawan
        ];

        if ($data_exist->num_rows() > 0) {
            // update gapok
            $data = [
                'nominal'     => $value,
                'user_update' => $user,
                'tgl_update'  => date('Y-m-d H:i:s')
            ];
            $this->db->update($table, $data, $user_company);

            // untuk update gapok log
            $action_value = [
                'action'       => 'edit',
                'nominal_lama' => $value_old,
            ];
        } else {
            // insert gapok
            $data = [
                'nominal'     => $value,
                'user_input'  => $user
            ];
            $this->db->insert($table, array_merge($user_company, $data));

            // untuk update gapok log
            $action_value = [
                'action'       => 'tambah',
                'nominal_lama' => 0,
            ];
        }

        // update gapok log
        $data = [
            'nominal_baru' => $value,
            'user_input'   => $user,
        ];
        $this->db->insert(str_replace('_m', '_log', $table), array_merge($user_company, $data, $action_value));

        // update komponen tunj tetap
        $this->update_tunj_tetap($id_karyawan, $value);

        // update komponen pot tetap
        $this->update_pot_tetap($id_karyawan, $value);

        if ($return) {
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return __response_update(false);
            } else {
                $this->db->trans_commit();
                return __response_update(true);
            }
        }
    }

    public function update_komponen($table, $value, $id_karyawan, $gapok, $id_item, $action = 'update')
    {
        // check existing id_item
        $data_exist = $this->db->select('id_item, jenis_master')
            ->from('payroll_komponen_m')
            ->where('md5(id_item)', $id_item)
            ->get();
        if ($data_exist->num_rows() == 0) {
            return __response_update(false);
        }

        // reusable variable
        $id_item      = $data_exist->row()->id_item;
        $jenis_master = ($data_exist->row()->jenis_master == 'potongan') ? 'potongan' : 'tunjangan';
        $user         = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
        $user_company = [
            'id_company'  => $this->id_company,
            'id_karyawan' => $id_karyawan
        ];

        $this->db->trans_begin();

        // update nominal tunjangan
        if ($action == 'delete') {
            $this->db->set('nominal_' . $jenis_master, 0);
        } else if ($action == 'add') {
            $this->db->set('nominal_' . $jenis_master, $gapok . '*(gapok_persen/100)', FALSE);
        } else {
            $this->db->set('nominal_' . $jenis_master, $value);
        }
        $data = [
            'gapok_rp'          => $gapok,
            'user_update'       => $user,
            'tgl_update'        => date('Y-m-d H:i:s')
        ];
        $this->db->update($table, $data, array_merge(['id_item' => $id_item], $user_company));

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            return __response_update(true);
        }
    }

    private function update_tunj_tetap($id_karyawan, $value)
    {
        $CI = &get_instance();
        $CI->load->model('Data_diri_m');

        $cek_tunj_tetap = $this->Data_diri_m->cek_tunj_tetap($id_karyawan);
        if ($cek_tunj_tetap > 0) {
            $this->db->set('nominal_tunjangan', $value . '*(gapok_persen/100)', FALSE);
            $this->db->set('gapok_rp', $value);
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_karyawan', $id_karyawan);
            $this->db->where('flag_persentase_gapok', '1');
            $this->db->where('nominal_tunjangan > 0');
            $this->db->update('payroll_tunj_tetap_m');
        } else {
            $CI->Data_diri_m->insert_tunj_tetap($id_karyawan);
        }
    }

    private function update_pot_tetap($id_karyawan, $value)
    {
        $CI = &get_instance();
        $CI->load->model('Data_diri_m');

        $cek_pot_tetap = $this->Data_diri_m->cek_pot_tetap($id_karyawan);
        if ($cek_pot_tetap > 0) {
            $this->db->set('nominal_potongan', $value . '*(gapok_persen/100)', FALSE);
            $this->db->set('gapok_rp', $value);
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_karyawan', $id_karyawan);
            $this->db->where('flag_persentase_gapok', '1');
            $this->db->where('nominal_potongan > 0');
            $this->db->update('payroll_pot_tetap_m');
        } else {
            $CI->Data_diri_m->insert_pot_tetap($id_karyawan);
        }
    }
}
