<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Target_tahunan extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/pengaturan/Target_tahunan_m');
    }

    public function list_data(){
        $tahun      = $this->input->get('tahun');
        $data_group = $this->fungsi->get_data_group();
        $list       = $this->Target_tahunan_m->get_datatables($tahun);

        $data          = array();
        $total_nominal = array();
        for ($i=1; $i <= 12; $i++) {
            $row   = array();
            $row[] = $i;
            $row[] = $this->fungsi->konversi_bulan($i);
            
            if(empty($data_group)){
                $row[] = "-";
            }else{
                foreach($data_group AS $group){
                    $id_bulan = sprintf("%02d", $i);
                    $nominal = $list['data'][$group->id_group_m][$tahun][$id_bulan]['nominal'];
    
                    if(empty($nominal)){
                        $row[] = "0";
                    }else{
                        $row[] = number_format($nominal, 0, ", ", ".");
                    }
                }
            }
            

            $data[] = $row;
        }

        // FOOTER TOTAL
        $row   = array();
        $row[] = "";
        $row[] = "<b style='font-size:18px'>TOTAL TARGET</b>";
        if(empty($data_group)){
            $row[] = "<b style='font-size:18px'>-</b>";
        }else{
            foreach($data_group AS $group){
                $total_nominal = $list['total_nominal'][$group->id_group_m][$tahun];
    
                if(empty($total_nominal)){
                    $row[] = "<b style='font-size:18px'>0</b>";
                }else{
                    $row[] = "<b style='font-size:18px'>". number_format($total_nominal, 0, ", ", "."). "</b>";
                }
            }
        }

        $data[] = $row;

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => 12,
            "recordsFiltered" => 12,
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($tahun = null){
        $data = [];
        if($tahun != null){
			$data['data_group']  = $this->fungsi->get_data_group();
			$data['data_target'] = $this->Target_tahunan_m->get_datatables($tahun);
			$data['tahun']       = $tahun;
		}

		$this->load->view('sales_activity/pengaturan/target_tahunan/form',$data);
    }

    public function save(){
        $ttl_array_nominal = $this->input->post('ttl_array_nominal');
        $array_id_group    = $this->input->post('array_id_group');
        $tahun             = $this->input->post('tahun');

        $data_insert = [];
        foreach($ttl_array_nominal as $value){
            $nominal = str_replace('.', '', $value['nominal']);
            $nominal = preg_replace('/[^0-9]/', '', $nominal);

            $data = array(
                'tahun'      => $value['tahun'],
                'bulan'      => $value['bulan'],
                'id_group_m' => $value['id_group_m'],
                'nominal'    => $nominal,
                'id_company' => $this->id_company,
                'tgl_input'  => date("Y-m-d H:i:s"),
                'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            $data_insert[] = $data;
        }

        $this->db->trans_start();
        // delete
        $this->db->where('id_company', $this->id_company);
        $this->db->where('tahun', $tahun);
        $this->db->where_in('id_group_m', $array_id_group);
        $this->db->delete('sales_target_tahunan_p');

        // insert
        $this->db->insert_batch('sales_target_tahunan_p', $data_insert);

        $this->db->trans_complete();
        if ($this->db->trans_status() === TRUE) {
            $this->db->trans_commit();
            return  __response_save(true);
        } else {
            $this->db->trans_rollback();
            return  __response_save(false);
        }
    }

    public function onchange_filter_tahun(){
        $query = $this->db->select("tahun")
                            ->from('sales_target_tahunan_p')
                            ->where("id_company", $this->id_company)
                            ->where("tahun", $this->input->get('tahun'))
                            ->where("id_group_m !=", "")
                            ->get()
                            ->num_rows();

        $result = [];
        if($query > 0){
            $result = [ "success" => true,
                        "jumlah" => $query];
        }else{
            $result = [ "success" => true,
                        "jumlah" => 0];
        }
        
        echo json_encode($result);
    }
}