<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Nilai_individu extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('kpi/user/approval/nilai_individu_m', 'model');
    }

    public function index()
    {
        $this->load->view('kpi/user/approval/detail/table/nilai_individu');
    }

    public function list_data()
    {
        $this->load->model(['kpi/user/team/detail_m', 'karyawan_m']);
        $this->load->helper('kpi/kpi');

        $status = $this->detail_m->getDataTrx()->row()->status;
        $idJabatan = $this->karyawan_m->getDataById(md5(htmlentities($this->input->get('karyawan'))))->id_jabatan;
        $notes = [];
        if(belumDisetujui($status)) {
            $list = $this->model->getAspekMaster($idJabatan);
            $data = array();
            $total = 0;
            foreach($list as $index => $bobot) {
                $row    = array();
                $row[]  = $index;
                $nilai  = $this->nilai($index, $bobot);
                $row[]  = $nilai['aktual'];
                $row[]  = $bobot.'%';
                $row[]  = $nilai['skor'];
                $total += $nilai['skor'];

                $data[] = $row;
            }
            $dataSkor = json_encode($this->model->skorMaster());
            $grade    = $this->model->getGrade($total, $dataSkor);
            $predikat = $grade['grade']." - ".$grade['remark'];
        } else {
            $list = $this->model->get_datatables();
            $data  = array();
            foreach ($list->result() as $field) {
                foreach($this->model->jenis() as $value) {
                    $row = array();
                        
                    $row[] = $field->{$value.'_nm'};
                    $row[] = $field->{$value.'_aktual'};
                    $row[] = $field->{$value.'_bobot'}.'%';
                    $row[] = $field->{$value.'_skor'};
        
                    $data[] = $row;
                }
            }
            $dataSkor  = $list->row()->grade;
            $predikat  = $list->row()->skor_predikat." - ".$list->row()->remark;
            $dataNotes = $this->detail_m->getDataTrx()->row();
            $notes[]   = $dataNotes->ctt_exiting_role;
            $notes[]   = $dataNotes->ctt_career_development;
            $notes[]   = $dataNotes->ctt_diterima;
        }

		$output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => count($data),
            "recordsFiltered" => count($data),
            "data"            => $data,
            "dataSkor"        => $dataSkor,
            "predikat"        => $predikat,
            "notes"           => $notes,
            "diterima"        => $status == '9' ? true : false
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    private function nilai($aspek, $bobot) {
        $this->load->model('kpi/user/team/detail_m');
        $this->load->model('kpi/user/approval/aspek_kedisiplinan_m');
        $this->load->model('kpi/user/approval/aspek_kepribadian_m');

        if($aspek == 'Aspek Kedisiplinan') {
            $result['aktual'] = $this->aspek_kedisiplinan_m->totalSkorBelumDisetujui();
            $result['skor']   = round(($result['aktual'] * $bobot) / 100, 2);
        } elseif($aspek == 'Aspek Kinerja') {
            $result['aktual'] = $this->detail_m->totalSkorBelumDisetujui();
            $result['skor']   = round(($result['aktual'] * $bobot) / 100, 2);
        } elseif($aspek == 'Aspek Kepribadian') {
            $result['aktual'] = $this->aspek_kepribadian_m->totalSkorBelumDisetujui();
            $result['skor']   = round(($result['aktual'] * $bobot) / 100, 2);
        } else {
            $result['aktual'] = 0;
            $result['skor']   = 0;
        }
        return $result;
    }
}