<script>
    $(function() {
        // adjust height of detail sections based on drawer height
        $("#content-detail-aktivitas").height($("#drawer").height() + $("#drawer").offset().top - $("#content-detail-aktivitas").offset().top - 24);

        $("#add-activity").on("click", function() {
            $("#modal_form .modal-dialog").removeClass("modal-lg");
            $("#tampil_form").load("<?= route('sales_activity.kanban.detail.aktivitas.form', ['id' => $id]) ?>", function() {
                $("#modal_form").modal("show");
                $("#modal_form .title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
            });
        });

        $(".card-activity").on("click", function(e) {
            var card_po_or_fail = $(this).data("jenispo");

            if(card_po_or_fail != null){
                var id_pipeline_main_log = $(this).data("id");
                $("#tampil_form").load("<?= route('sales_activity.kanban.detail.aktivitas.preview', ['id' => '"+ id_pipeline_main_log +"', 'po_or_fail' => '"+ card_po_or_fail +"']) ?>", function() {
                    $("#modal_form").modal("show");
                    $("#modal_form .title").text("Detail Aktivitas");
                });

            }else{
                const id = ($(this).data("id") + "_" + $(this).data("time").replace(" ", "_")).replaceAll(":", "-");
                $("#modal_form .modal-dialog").removeClass("modal-lg");
                if ($(this).data("action") === "edit" && $(this).data("id") === "<?= $this->id_karyawan ?>") {
                    $("#tampil_form").load("<?= route('sales_activity.kanban.detail.aktivitas.form', ['id' => $id, 'aktivitas' => '"+ id +"']) ?>", function() {
                        $("#modal_form").modal("show");
                        $("#modal_form .title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                    });
                } else {
                    $("#tampil_form").load("<?= route('sales_activity.kanban.detail.aktivitas.preview', ['id' => '"+ id +"']) ?>", function() {
                        $("#modal_form").modal("show");
                        $("#modal_form .title").text("Detail Aktivitas");
                    });
                }
            }

        });

        $("#reload-activity").on("click", function() {
            $(this).prop("disabled", true);
            $("#detail-aktivitas").load("<?= route('sales_activity.kanban.detail.aktivitas', ['id' => $id]) ?>", function() {
                $(this).prop("disabled", false);
            });
        });
    });
</script>

<style>
    #detail-aktivitas ::-webkit-scrollbar {
        width: 4px;
    }

    #detail-aktivitas ::-webkit-scrollbar-track {
        background-color: #f1f1f1;
    }

    #detail-aktivitas ::-webkit-scrollbar-thumb {
        background-color: #888;
    }

    .card-activity {
        border: 1px solid #d8d8d8;
        display: flex;
        flex-direction: column;
        isolation: isolate;
        position: relative;
        overflow: hidden;
        --gradient: linear-gradient(to bottom, #2eadff, #3d83ff, #7e61ff);

        & .card-activity-header {
            font-size: smaller;
            padding-left: 0.5rem;
            z-index: 5;
        }

        & .card-activity-title,
        .card-activity-body {
            padding-left: 0.5rem;
            z-index: 5;
        }
    }

    .card-activity:before {
        position: absolute;
        content: "";
        border-radius: 0.25rem !important;
        inset: 0.0625rem;
        background: #f6f8fa;
        z-index: 2
    }

    .card-activity:after {
        position: absolute;
        content: "";
        width: 0.25rem;
        inset: 0.65rem auto 0.65rem 0.5rem;
        border-radius: 0.125rem;
        background: var(--gradient);
        transition: transform 300ms ease;
        z-index: 4;
    }

    .card-activity:hover {
        cursor: pointer;

        &:after {
            transform: scaleX(1.5);
        }
    }
</style>

<h6 class="font-weight-bold" style="padding: 0.6rem 1rem;">Aktivitas</h6>
<button type="button" id="reload-activity" title="Refresh activity" class="btn btn-link btn-sm position-absolute pull-right" style="top: 0; right: 1rem;"><i style="font-size: 14px;" class="fa fa-refresh"></i></button>
<hr>
<div id="content-detail-aktivitas" class="pr-1" style="overflow-x: hidden;overflow-y: auto;">
    <?php
    $lock_add_activity = false;
    if ($pipeline->status == 'approve') {
        if ($pipeline->jenis == 'lost') {
            $lock_add_activity = true;
        }
    }
    $last_group = '';
    foreach ($aktivitas as $data) {
        if (empty($data->kategori)) { ?>
            <div class="mb-1">
                <div class="d-flex flex-row justify-content-between text-light" style="font-size: smaller;">
                    <label>Dibuat oleh <span class="text-biru"><?= ($data->user_id == $this->id_karyawan) ? 'Anda' : ltrim(explode('-', $data->user)[1]) ?></span></label>
                    <span class="text-right">
                        <?php
                        if (!empty($data->waktu)) {
                            if ($this->code_lang == 'id') {
                                echo indo_date(strtotime($data->waktu), 'd M  Y') . ' ' . date('H:i', strtotime($data->waktu));
                            } else {
                                echo date('d M  Y', strtotime($data->waktu)) . ' ' . date('H:i', strtotime($data->waktu));
                            }
                        } else {
                            echo '-';
                        }
                        ?>
                    </span>
                </div>
                <div>
                    <?php if ($data->aktivitas == 'Move') : ?>
                        <label class="font-weight-bold"><i class="text-warning"><?= $data->aktivitas ?></i> <?= $data->tahapan_sebelum ?> <i class="fa fa-long-arrow-right"></i> <?= $data->tahapan_sekarang ?></label>
                    <?php else : ?>
                        <label class="font-weight-bold"><i style="color: #1c77d4"><?= $data->aktivitas ?></i> <?= $data->tahapan_sekarang ?></label>
                    <?php endif; ?>
                    <?php if ($data->status == 'pengajuan') : ?>
                        <span class="badge badge-warning ml-1">
                            <?= $this->lang->line($data->status) ?>
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        <?php } else { ?>
            <div class="mb-1">
                <?php if ($data->kategori != $last_group) : ?>
                    <h6 class="font-weight-bold"><?= $data->kategori ?></h6>
                    <hr>
                <?php endif; ?>
                <div data-id="<?= $data->user_id ?>" data-time="<?= $data->waktu ?>" data-action="<?= ($data->status == 'pengajuan') ? 'edit' : 'preview' ?>" class="card-activity d-flex flex-column rounded divider-light w-100 p-1 mb-2">
                    <div class="card-activity-header d-flex flex-row justify-content-between text-light">
                        <label>Dibuat oleh <span class="text-biru"><?= ($data->user_id == $this->id_karyawan) ? 'Anda' : ltrim(explode('-', $data->user)[1]) ?></span></label>
                        <span class="text-right"><?= indo_date(strtotime($data->waktu), 'd M  Y') . ' ' . date('H:i', strtotime($data->waktu)) ?></span>
                    </div>
                    <div class="card-activity-title">
                        <label class="font-weight-bold"><?= $data->aktivitas ?></label>
                        <?php if ($data->status == 'pengajuan') : ?>
                            <?php if ($this->id_karyawan == $data->user_id) : ?>
                                <i class="fa fa-edit text-warning"></i>
                            <?php endif; ?>
                            <span class="badge badge-warning ml-1"><?= $this->lang->line($data->status) ?></span>
                        <?php elseif ($data->status == 'tolak') : ?>
                            <span class="badge badge-danger ml-1"><?= $this->lang->line('ditolak') ?></span>
                        <?php endif; ?>
                    </div>
                    <span class="card-activity-body"><?= htmlspecialchars($data->keterangan) ?></span>
                </div>
            </div>
    <?php
        }
        $last_group = $data->kategori;
    }
    ?>

    <!-- KETERANGAN WONT LOST -->
    <?php
        if(!empty($keterangan_wont_lost)):
            $id_pipeline_main_log = $keterangan_wont_lost->id_pipeline_main_log;
            $keterangan_po_fail   = $keterangan_wont_lost->keterangan;
            $tanggal_po_fail      = $keterangan_wont_lost->tgl_update;
            $title_po_fail        = $keterangan_wont_lost->title;

            if ($pipeline->jenis == "lost") {
                $style_po_lost = 'style="--gradient: linear-gradient(to bottom, #ff4e50, #ff6a5b, #ff9999);"';
            } else {
                $style_po_lost = 'style="--gradient: linear-gradient(to bottom, #28a745, #4caf50, #81c784);"';
            }

    ?>
            <div data-id="<?= $id_pipeline_main_log ?>" data-jenispo="<?= $pipeline->nama_tahapan ?>" data-action="preview" class="card-activity d-flex flex-column rounded divider-light w-100 p-1 mb-2" <?= $style_po_lost ?>>
                <div class="card-activity-header d-flex flex-row justify-content-between text-light">
                    <label>Dibuat oleh <span class="text-biru"><?= ($data->user_id == $this->id_karyawan) ? 'Anda' : ltrim(explode('-', $data->user)[1]) ?></span></label>
                    <span class="text-right"><?= indo_date(strtotime($tanggal_po_fail), 'd M  Y') . ' ' . date('H:i', strtotime($tanggal_po_fail)) ?></span>
                </div>
                <div class="card-activity-title">
                    <label class="font-weight-bold"><?= $pipeline->jenis == "lost" ? "Failed" : "PO"; ?></label>
                </div>
                <span class="card-activity-body"><?= !empty($keterangan_po_fail) ? htmlspecialchars($keterangan_po_fail) : "-" ?></span>
            </div>
    <?php
        endif;
    ?>

</div>
<?php if (($data->user_id === $this->id_karyawan)) : ?>
    <button <?= ($lock_add_activity ? 'disabled style="cursor: not-allowed"' : 'id="add-activity"') ?> type="button" class="btn btn-biru w-100 my-1 text-white text-center"><i class="fa fa-plus"></i> Tambah Aktivitas</button>
<?php endif; ?>
