<script type="text/javascript">
    $(function() {
        $("#btn_approve").on("click", function(e) {
            e.preventDefault();
            verify_approval(this, "<?= route('sales_activity.approval_activity.verification.approve.mass') ?>");
        });

        $("#btn_reject").on('click', function(e) {
            e.preventDefault();
            verify_approval(this, "<?= route('sales_activity.approval_activity.verification.reject.mass') ?>");
        });
    });

    function verify_approval(e, route) {
        var loading = Ladda.create(e);

        var param = {};
        param.selected_data = <?= $list ?>;

        $.ajax({
            type: "POST",
            url: route,
            data: param,
            dataType: "JSON",
            beforeSend: function() {
                loading.start();
                $("#modal_form button").prop("disabled", true);
            },
            success: function(result) {
                loading.stop();
                $("#modal_form button").prop("disabled", false);
                if (result.success == true) {
                    showMsg(result.message);
                    reset_selected_rows();
                    list_data.ajax.reload();
                } else {
                    showMsg(result.message, true, 2000);
                }
            },
            error: function() {
                loading.stop();
                $("#modal_form button").prop("disabled", false);
                showMsg("error", false);
            }
        });
    }
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div class="card-body font-weight-bold">
    <span class="badge badge-warning" style="width: 45px;"><?= count(json_decode($list)) ?></span>
    <span> <?= $content ?></span>
</div>

<div class="card-footer">
    <div class="w-100 text-right">
        <button id="btn_reject" class="btn btn-danger text-white w-25 ladda-button" data-style="zoom-in"><i class="fa fa-times"></i> <?= $this->lang->line('button_form_tolak') ?></button>
        <button id="btn_approve" class="btn btn-primary w-25 ladda-button" data-style="zoom-in"><i class="fa fa-check"></i> <?= $this->lang->line('button_form_approve') ?></button>
    </div>
</div>
