<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-10 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">PKWT</li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <input type="hidden" id="id_template" name="id_template" value="<?= isset($data) ? (isset($data->id_template) ? md5($data->id_template) : '') : '' ?>">
            <input type="hidden" id="lokasi_template" value="<?= isset($data) ? $data->lokasi_template : '' ?>">
            <div class="row mt-1">
                <div class="col-md-12">
                    <label>Nama Template <span class="text-danger">*</span></label>
                    <input type="text" name="nama" id="nama" class="form-control" value="<?= isset($data) ? $data->nama : '' ?>">
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-12">
                    <label>Template <span class="text-danger">*</span></label>
                    <textarea id="content" class="form-control"><?= isset($data) ? $data->template : '' ?></textarea>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col"><label id="message"></label></div>
            </div>
            <div class="row mt-2">
                <div class="col-md-6">
                    <div class="d-inline"><a href="#" class="btn btn-primary" onclick="preview();" title="PREVIEW"> <i class="fa fa-file (alias) "> </i> PREVIEW</a></div>
                    <div class="d-inline" style="font-family: Poppins Bold;">&nbsp;* pastikan anda sudah menyimpan perubahan</div>
                </div>
                <div class="col-md-6 text-right">
                    <a href="<?= route('pkwt.master.template') ?>" class="btn btn-secondary"><i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?></a>
                    <?= '<button type="button" id="btn_simpan" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> ' . $this->lang->line('button_form_simpan') . '</button>'; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function preview() {
        const id_template = $("#id_template").val() == '' ? null : $("#id_template").val();
        window.open('<?= route('pkwt.master.template.preview', ['id' => "'+id_template+'"]) ?>', '_blank').focus();
    }

    CKEDITOR.replace('content', {
        height: 300,
    });
    CKEDITOR.config.toolbarGroups = [
		{ name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
		{ name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
		{ name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
		{ name: 'forms', groups: [ 'forms' ] },
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
		{ name: 'colors', groups: [ 'colors' ] },
		{ name: 'tools', groups: [ 'tools' ] },
		{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },
		{ name: 'links', groups: [ 'links' ] },
		{ name: 'insert', groups: [ 'insert' ] },
		{ name: 'styles', groups: [ 'styles' ] },
		{ name: 'others', groups: [ 'others' ] },
		{ name: 'about', groups: [ 'about' ] }
	];

    CKEDITOR.config.removeButtons = 'Iframe,ExportPdf,Print,Form,Checkbox,Radio,TextField,Textarea,Select,Button,ImageButton,HiddenField,Flash,Link,Unlink,Anchor,About,Scayt,Language,BidiRtl,BidiLtr' + "<?= ENVIRONMENT == 'production' ? ',Source,Preview,Save,NewPage' : '' ?>";

    $(document).on("click", "#btn_simpan", function(e) {
        e.preventDefault();
        $('label#message').html("");
        var loading = Ladda.create(this);

        var html_content = CKEDITOR.instances.content.getData();
        var content = html_content.replace(/\&nbsp;/g, ' ');
        var content = encodeURIComponent(content);

        if ($("#nama").val() == "") {
            $('label#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama template belum diisi</font>");
            $("#nama").focus();
            return false;
        } else if (content == "") {
            if ($("#content").val() == "") {
                $('label#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Template belum diisi</font>");
                $("#content").focus();
                return false;
            }
        }

        loading.start();
        var param = new FormData();
        param.append('id_template', $("#id_template").val());
        param.append('nama', $("#nama").val());
        param.append('template', content);
	    param.append('lokasi_template', $('#lokasi_template').val());
        $.ajax({
            type: 'POST',
            url: "<?= route('pkwt.master.template.save') ?>",
            data: param,
            dataType: 'JSON',
            contentType: false,
            processData: false,
            cache: false,
            success: function(result) {
                if (result.success == true) {
                    $('#tampil_form').load('<?= route("pkwt.master.template.form.parameter", ["id" => "'+result.id_template+'"]) ?>', () => $('#modal_form').modal('show'));
                    if(result.type == 'save') {
                        $('#id_template').val(result.id_template);
                        $('#lokasi_template').val(result.lokasi_template);
                    }
                    setTimeout(() => $('label#message').html(''), 3000);
                }
                loading.stop();
                $('label#message').show();
                $('label#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('label#message').show();
                $('label#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    });

    $(document).on("click", ".btn_save_parameter", function(e) {
        e.preventDefault();
        $('#message_parameter').html("");
        var loading = Ladda.create(this);
        loading.start();
        $.post('<?= route("pkwt.master.template.save.parameter") ?>', $('form').serialize()+"&id_template="+$('#id_template').val(), function(result) {
            loading.stop();
            $('#message_parameter').html(result.message);
        }, 'json');
    });
</script>
