<div class="row">
    <div class="col-md-12 mt-2">
        <h6>Personal Skor</h6>
    </div>
</div>
<table width=100% id="list_data_nilai_individu" class="table table-striped table-bordered">
    <thead style="font-family: Poppins SemiBold;">
        <tr>
            <th width="25%">Keterangan</th>
            <th width="25%" class="_center">Aktual</th>
            <th width="25%" class="_center">Bobot</th>
            <th class="_center">Skor</th>
        </tr>
    </thead>
    <tbody></tbody>
    <tfoot style="font-size: 12px;">
        <tr>
            <th class="text-center text-white" colspan=3 style="font-family: 'Poppins Bold';background-color: #1c77d4;">Total Nilai</th>
            <th class="text-center" style="font-family: 'Poppins Bold';background-color: rgb(204, 237, 255); border-color: white;">-</th>
        </tr>
        <tr>
            <th class="text-center text-white" colspan=3 style="font-family: 'Poppins Bold';background-color: #1c77d4;">Predikat</th>
            <th class="text-center" style="font-family: 'Poppins Bold';background-color: rgb(204, 237, 255); border-color: white;">-</th>
        </tr>
    </tfoot>
</table>
<div class="row">
    <div class="col-md-12 mt-2">
        <h6>Predikat</h6>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <table id="skor" class="table table-striped table-bordered text-center">
            <thead style="font-family: 'Poppins Bold'; background-color: #1c77d4; color: white;">
                <tr>
                    <th width=30%>Poin</th>
                    <th width=15%>Grade</th>
                    <th>Keterangan</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
    <div class="col-md-6">
        <div id="notes" style="display: none;">
            <div class="form-group mb-4">
                <label for="forExistingRole">Saran pengembangan untuk posisi saat ini</label>
                <p id="forExistingRole" style="font-family: Poppins SemiBold;"></p>
            </div>
            <div class="form-group mb-4">
                <label for="careerDevelopment">Saran untuk pengembangan karir</label>
                <p id="careerDevelopment" style="font-family: Poppins SemiBold;"></p>
            </div>
            <div class="form-group mb-4">
                <label for="emplyComment">Komentar karyawan</label>
                <p id="divEmplyComment" style="font-family: Poppins SemiBold;"></p>
            </div>
            <div id="div_status" class="form-group mb-4" style="display: none;">
                <label for="status">Status</label>
                <p style="font-family: Poppins SemiBold;">Diterima karyawan</p>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div id="div_setujui" class="col-md-12"></div>
</div>
<script>
    $(function() {
        list_data = $('#list_data_nilai_individu').DataTable({
            searching: false,
            ordering : false,
            paging   : false,
            info     : false,
            scrollX  : false,
            language : {
                url: '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>'
            },
            columnDefs: [
                { targets: '_center', className: "text-center" },
            ],
            processing: true,
            serverSide: true,
            ajax      : {
                url : '<?= route("kpi.approval.detail.nilai-individu.list-data") ?>',
                data: function(d) {
                    delete d.columns;
                    delete d.search;
                    
                    d.karyawan = $('#karyawan').val();
                    d.tahun    = $('#tahun').val();
                    d.bulan    = $('#bulan').val();
                },
                complete: function(data) {
                    var pembungkus = $(".div_pembungkus_js_menu_context")
                    if(pembungkus == null || pembungkus == undefined){
                        // jalankan selanjutnya
                    }else{
                        var outerHeight = $('.body_laporan').outerHeight();
                        outerHeight = outerHeight * 80 / 100;
                        pembungkus.css('height', outerHeight);
                    }
                },
            },
            drawCallback: function(setting) {
                predikatValue = this.api().table().footer().rows[1].innerHTML.split("colspan=\"1\">-");
                this.api().table().footer().rows[1].innerHTML = predikatValue[0] + " colspan=\"1\">" + setting.json.predikat + "</th>";
                tableSkor(setting.json.dataSkor);
                if(setting.json.notes.length > 0) {
                    $('#notes').show();
                    setting.json.notes.forEach((item, index) => {
                        if(index == 0) {
                            $('#forExistingRole').html(item.replaceAll("\n", "<br>"));
                        } else if(index == 1) {
                            $('#careerDevelopment').html(item.replaceAll("\n", "<br>"));
                        } else if(index == 2) {
                            $('#divEmplyComment').html(item.replaceAll("\n", "<br>"));
                        }
                    });
                }
                const diterima = setting.json.diterima;
                if(diterima) {
                    $('#div_status').show();
                } else {
                    $('#div_status').hide();
                }
            },
            footerCallback: function(row, data) {
                let total = 0;
                data.forEach((item) => total = total + parseFloat(item[3]));
                this.api().column(3).footer().innerHTML = total.toFixed(2);
            }
        });
    });

    function tableSkor(data) {
        const temp = JSON.parse(data);
        if(temp != null) {
            temp.forEach(function(value) {
                var poin = value.batas_bawah+" - "+value.batas_atas;
                $('table#skor tbody').append("<tr><td>"+poin+"</td><td>"+value.grade+"</td><td>"+value.keterangan+"</td></tr>");
            });
        }
    }

    function setujui() {
        $('#tampil_form').load('<?= route("kpi.approval.detail.form") ?>', function() {
            $('.title').text("Kebutuhan Pengembangan");
            $('#tampil_form button.btn-primary').addClass("btn_setujui");
            $('#modal_form').modal('show');
        });
    }

    $(document).off('click', '.btn_setujui');
    $(document).on('click', '.btn_setujui', function() {
        $('#tampil_form #message, .card-body #message').html('');
        
        if($("#existingRole").val() == "") {
            $("#tampil_form #message").html('<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> Saran untuk pengembangan saat ini belum diisi</font>');
            return false;
        } else if($("#careerDev").val() == "") {
            $("#tampil_form #message").html('<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> Saran untuk pengembangan karir belum diisi</font>');
            return false;
        }

        const id      = $('a.active').attr('id');
        var   data    = "";
        const dataTrx = "&karyawan="+$('#karyawan').val()+"&tahun="+$('#tahun').val()+"&bulan="+$('#bulan').val()+"&existingRole="+$("#existingRole").val()+"&careerDev="+$("#careerDev").val();
        if(id == "aspek_kepribadian") {
            data = $('form').serialize()+"&tab="+id+dataTrx;
        } else {
            data = "tab="+id+dataTrx;
        }
        
        const l = Ladda.create(this);
        l.start();

        $.post('<?= route("kpi.approval.detail.setujui") ?>', data, function(result) {
            l.stop();
            $('#tampil_form #message').html(result.message);
            if(result.success) {
                button('setujui');
                $('textarea').prop('disabled', true);
                $('.btn_setujui').prop('disabled', true);
                if(id == "aspek_kepribadian") {
                    button('draft');
                } else if(id == "nilai_individu") {
                    nilai_individu();
                }
            } else {
                if(result.tab !== undefined) {
                    if(result.tab == "aspek_kinerja") {
                        aspek_kinerja();
                    } else if(result.tab == "aspek_kepribadian") {
                        aspek_kepribadian();
                    }
                }
            }
        }, 'json');
    });
</script>