<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Data_diri_pengajuan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('karyawan/Data_diri_pengajuan_m', 'model');
        $this->load->model('data_diri_m');
        $this->load->model('notif_kepegawaian_m', 'notif');
        $this->load->helper('approval');
    }

    public function index($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'data_diri_pengajuan';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['notif_status']    = $this->notif_status->data_diri($id_karyawan_md5);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    function data($id_karyawan_md5)
    {
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['tab_aktif']       = 'pengajuan';
        $data['data_sebelumnya'] = $this->data_diri_m->getDataById($id_karyawan_md5);
        $data['data']            = $this->model->get_data($id_karyawan_md5);
        $data['tab']             = $this->load->view('karyawan/data_diri/tab', $data, true);
        $this->load->view('karyawan/data_diri/pengajuan/home', $data);
    }

    function approve()
    {
        $id_karyawan_md5 = $this->input->get('id_karyawan');
        $id_karyawan     = $this->fungsi->decrypt_idkaryawan($id_karyawan_md5);

        $this->db->trans_start();
        $approve = $this->model->approve($id_karyawan_md5, '2');
        if ($approve) {
            $this->logger->create_log('data_diri_pengajuan', 'approve', $this->db->last_query() . ", id_karyawan = $id_karyawan");
            $insert_history = $this->model->insert_history($id_karyawan_md5);
            if ($insert_history) {
                $id_history = $this->db->insert_id();
                notif_approval('detail_data_diri', $id_karyawan, ucwords(data_diri_action()), $this->lang->line('disetujui'), $id_history);
                notif_kepegawaian($id_karyawan, 'data_diri', $id_history, 'update', 'setuju');
                $this->logger->create_log('data_diri_pengajuan', 'approve insert histori', $this->db->last_query() . ", id_karyawan = $id_karyawan");
                $update_data_diri = $this->model->update_data_diri($id_karyawan_md5);
                if ($update_data_diri) {
                    $this->logger->create_log('data_diri_pengajuan', 'approve update data diri', $this->db->last_query() . ", id_karyawan = $id_karyawan");
                }
                $this->notif->update_flag_baca('data_diri', $id_karyawan, $id_karyawan);
            }
            $this->model->delete($id_karyawan_md5);
        }
        $this->db->trans_complete();
        $status = $this->db->trans_status();

        __response_approve($status);
    }

    function revisi()
    {
        $id_karyawan_md5 = $this->input->get('id_karyawan');
        $id_karyawan     = $this->fungsi->decrypt_idkaryawan($id_karyawan_md5);
        $keterangan      = $this->input->get('keterangan');
        $approve         = $this->model->approve($id_karyawan_md5, '3', $keterangan);
        if ($approve) {
            notif_approval('detail_data_diri', $id_karyawan, ucwords(data_diri_action()), $this->lang->line('revisi') . ' ' . $keterangan, $id_karyawan);
            notif_kepegawaian($id_karyawan, 'data_diri', $id_karyawan, 'update', 'revisi');
            $this->logger->create_log('data_diri_pengajuan', 'revisi', $this->db->last_query());
            $this->notif->update_flag_baca('data_diri', $id_karyawan, $id_karyawan);
        }
        __response_revisi($approve);
    }

    function form($jenis)
    {
        if ($jenis == 'approve') {
            $this->load->view('karyawan/data_diri/pengajuan/form_approve');
        } else {
            $this->load->view('karyawan/data_diri/pengajuan/form_revisi');
        }
    }
}
