<script type="text/javascript">
    $(function() {
        list_data_m_jenis_perusahaan = $('#list_data_m_jenis_perusahaan').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama'
                <?php else : ?> 'searchPlaceholder': 'Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.master.jenis.perusahaan.list.data') ?>",
                "type": "GET",
                "data"  : function (d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({'text-align': 'center', 'width': '10px'});
                $('td:eq(2)', nRow).css({'text-align': 'center', 'width': '10px'});
            }
        });
    });
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Master <?= $this->lang->line('jenis_perusahaan') ?></h5>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <button type="button" class="btn btn_tambah_m_jenis_perusahaan btn-success pull-right">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
        </button>
    </div>
</div> 
<hr>

<div class="table-responsive mt-2">
    <table id="list_data_m_jenis_perusahaan" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle" width="20">NO</th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('jenis_perusahaan') ?></th>
                <th class="text-center align-middle text-uppercase" width="50"><?= $this->lang->line('aksi') ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
