<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Import_m extends CI_Model {
    var $table = 'payroll_pend_tetap_temp';

    public function __construct(){
        parent::__construct();    }

    function get_datatables(){
        $this->_get_datatables_query();
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("dk.nama_lengkap AS nm_karyawan,
                        dk.nik,
                        mc.kode AS kd_cabang,
                        mc.nama AS nm_cabang,
                        pend_tetap.id,
                        pend_tetap.id_karyawan,
                        pend_tetap.nominal,
                        pend_tetap.status,
                        pend_tetap.nm_pendapatan");
        $this->db->from($this->table." AS pend_tetap");
        $this->db->join("data_karyawan AS dk","dk.id_karyawan = pend_tetap.id_karyawan", "LEFT");
        $this->db->join("master_cabang AS mc","mc.id_cabang = dk.id_cabang", "LEFT");
        $this->db->where("pend_tetap.id_company",$this->id_company);

        $column_search = array('dk.nama_lengkap','dk.nik');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = [];

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("nm_cabang"=>"ASC", "nik"=>"ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $this->db->select("dk.nama_lengkap AS nm_karyawan,
                        dk.nik,
                        mc.kode AS kd_cabang,
                        mc.nama AS nm_cabang,
                        pend_tetap.id,
                        pend_tetap.id_karyawan,
                        pend_tetap.status,
                        pend_tetap.nm_pendapatan,
                        pend_tetap.nominal");
        $this->db->from($this->table." AS pend_tetap");
        $this->db->join("data_karyawan AS dk","dk.id_karyawan = pend_tetap.id_karyawan", "LEFT");
        $this->db->join("master_cabang AS mc","mc.id_cabang = dk.id_cabang", "LEFT");
        $this->db->where("md5(pend_tetap.id)", $id);
        $this->db->where("pend_tetap.id_company",$this->id_company);
        $query = $this->db->get();
        return $query->row();
    }

    public function getDataByIdKaryawan($id_karyawan=null){
        $this->db->select("nama_lengkap AS nm_karyawan, nik, id_karyawan");
        $this->db->from("data_karyawan");
        $this->db->where("md5(id_karyawan)", $id_karyawan);
        $this->db->where("id_company",$this->id_company);
        $query = $this->db->get();
        return $query->row();
    }
    
    public function update($data){
        $key = $this->input->post('key');

        $this->db->trans_start();
        $this->db->where(array(
                                'md5(id)'       =>$key,
                                'id_company'    =>$this->id_company
                                ));
        $this->db->update($this->table, $data);
        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return  __response_update(false);
        }else{
            $this->db->trans_commit();
            return  __response_update(true);
        }
    }

    public function delete($id=null){
        $this->db->where(array('md5(id)'=>$id));
        $delete =$this->db->delete('informasi_gaji');
        return  __response_delete($delete);
    }

    public function getId($tabel = null){
        if ($tabel == null) {
            $tabel = $this->table;
        }
		$curent_month = date('ym');
        $select = $this->db->select('MAX(id) as id')
                           ->from($tabel)
                           ->where('id_company', $this->id_company)
                           ->get()
                           ->row();
        
        if(!empty($select->id)){
            $last_id = substr($select->id,-4);
			$next_id = $last_id+1;
			$nextid = $this->id_company.$curent_month.sprintf("%04d", $next_id);
		}else{
			$nextid = $this->id_company.$curent_month.'0001';
		}

		return $nextid;
	}

    public function data_karyawan(){
        $this->db->select("id_karyawan, nik");
        $this->db->where("id_company", $this->id_company);

        $dk = $this->db->get("data_karyawan")->result();
        
        $result = [];
        foreach($dk as $row){
            $result[$row->nik] = $row->id_karyawan;
        }
        
        return $result;
    }

    // get data yang sama antar table pend_tetap dan pend_tatap_temp 
    public function get_nm_pendapatan(){
        $this->db->select("dk.nik, pt.id_karyawan, pt.nm_pendapatan");
        $this->db->from("payroll_pend_tetap as pt");
        $this->db->where("pt.id_company", $this->id_company);
        $this->db->join("data_karyawan AS dk","dk.id_karyawan = pt.id_karyawan", "LEFT");
        // $np = $this->db->get_compiled_select();

        // $this->db->select('a.nik, a.id_karyawan, a.nm_pendapatan');
        // $this->db->from('('.$np.') as a');
        // $this->db->join("payroll_pend_tetap_temp as ptt","ptt.id_karyawan = a.id_karyawan", "LEFT");
        // // $this->db->like('ptt.nm_pendapatan','a.nm_pendapatan','both', FALSE);
        // $this->db->where('ptt.nm_pendapatan',"a.nm_pendapatan", FALSE);

        $result = $this->db->get()->result();
        
        return $result;
    }

}
