<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Import_m extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->id_company  = $this->session->userdata('id_company');
        $this->id_karyawan = $this->session->userdata('id_karyawan');
        $this->nama_user   = $this->session->userdata('nama_user');
    }

    public function getDataKaryawan($id_cabang = "-", $id_departemen = "-")
    {

        if ($id_cabang != "-") {
            $this->db->where("data_karyawan.id_cabang", $id_cabang);
        }

        if ($id_departemen != "-") {
            $this->db->where("data_karyawan.id_departemen", $id_departemen);
        }


        $this->db->select("data_karyawan.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            gapok.nominal,
                            bpjs_kes.ttl_gaji_terdaftar,
                            data_karyawan.jml_anak");
        $this->db->from("data_karyawan");
        $this->db->join("master_cabang", "master_cabang.id_cabang = data_karyawan.id_cabang");
        $this->db->join("master_departemen", "master_departemen.id_departemen = data_karyawan.id_departemen", "LEFT");
        $this->db->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan");
        $this->db->join('payroll_gapok_m gapok', 'gapok.id_karyawan = data_karyawan.id_karyawan', 'left');
        $this->db->join('payroll_bpjs_kes_m bpjs_kes', 'bpjs_kes.id_karyawan = data_karyawan.id_karyawan', 'left');
        $this->db->where("data_karyawan.id_company", $this->id_company);
        $this->db->where_in("data_karyawan.status", ["1", "2", "3"]);
        $this->db->where_not_in("master_jabatan.level_user", ["1", "6"]);
        $this->db->order_by("master_departemen.kode ASC, master_jabatan.kode_jabatan ASC, data_karyawan.nik ASC");

        $query = $this->db->get()->result();
        return $query;
    }

    public function master_bpjs_kes()
    {
        $this->db->select("id_karyawan");
        $this->db->from("payroll_bpjs_kes_m");
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get()->result();
        $data  = [];
        foreach ($query as $row) {
            array_push($data, $row->id_karyawan);
        }

        return $data;
    }

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query()
    {
        $this->db->select("
            data_karyawan.id_karyawan,
            data_karyawan.nama_lengkap,
            data_karyawan.nik,
            data_karyawan.no_bpjs_kes,
            data_karyawan.no_bpjs_tk,
            payroll_bpjs_kes_temp.jml_anak,
            payroll_bpjs_kes_temp.tunj_perus_rp as bpjs_kes_tunj_perus_rp,
            payroll_bpjs_kes_temp.pot_kry_rp as bpjs_kes_pot_kry_rp,
            payroll_bpjs_kes_temp.flag_import,
            payroll_bpjs_tk_temp.tunj_jht_perus_rp as bpjs_tk_tunj_jht_perus_rp,
            payroll_bpjs_tk_temp.ttl_gaji_terdaftar,
            payroll_bpjs_tk_temp.pot_jht_kry_rp as bpjs_tk_pot_jht_kry_rp,
            payroll_bpjs_tk_temp.tunj_jkk_rp as bpjs_tk_tunj_jkk_rp,
            payroll_bpjs_tk_temp.tunj_jkm_rp as bpjs_tk_tunj_jkm_rp,
            payroll_bpjs_tk_temp.tunj_jp_perus_rp as bpjs_tk_tunj_jp_perus_rp,
            payroll_bpjs_tk_temp.pot_jp_kry_rp as bpjs_tk_pot_jp_kry_rp,
            payroll_bpjs_tk_temp.ttl_pot_karyawan,
            payroll_bpjs_tk_temp.ttl_tunj_dibiayai_perus
        ");
        $this->db->from("payroll_bpjs_kes_temp");
        $this->db->join("data_karyawan", "data_karyawan.id_karyawan = payroll_bpjs_kes_temp.id_karyawan");
        $this->db->join("payroll_bpjs_tk_temp", "data_karyawan.id_karyawan = payroll_bpjs_tk_temp.id_karyawan");
        $this->db->where("payroll_bpjs_kes_temp.id_company", $this->id_company);
        $this->db->where("payroll_bpjs_kes_temp.user_input", $this->id_karyawan);

        $column_search = array(
            'data_karyawan.nama_lengkap',
            'data_karyawan.nik',
            'data_karyawan.no_bpjs_kes',
            'data_karyawan.no_bpjs_tk',
            'payroll_bpjs_kes_temp.jml_anak',
            'payroll_bpjs_kes_temp.tunj_perus_rp',
            'payroll_bpjs_kes_temp.pot_kry_rp',
            'payroll_bpjs_tk_temp.tunj_jht_perus_rp',
            'payroll_bpjs_tk_temp.ttl_gaji_terdaftar',
            'payroll_bpjs_tk_temp.pot_jht_kry_rp',
            'payroll_bpjs_tk_temp.tunj_jkk_rp',
            'payroll_bpjs_tk_temp.tunj_jkm_rp',
            'payroll_bpjs_tk_temp.tunj_jp_perus_rp',
            'payroll_bpjs_tk_temp.pot_jp_kry_rp',
            'payroll_bpjs_tk_temp.ttl_pot_karyawan',
            'payroll_bpjs_tk_temp.ttl_tunj_dibiayai_perus'
        );
        $i             = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array(
            'data_karyawan.nik',
            'payroll_bpjs_tk_temp.ttl_gaji_terdaftar',
            'data_karyawan.no_bpjs_kes',
            'payroll_bpjs_kes_temp.jml_anak',
            'payroll_bpjs_kes_temp.tunj_perus_rp',
            'payroll_bpjs_kes_temp.pot_kry_rp',
            'data_karyawan.no_bpjs_tk',
            'payroll_bpjs_tk_temp.tunj_jht_perus_rp',
            'payroll_bpjs_tk_temp.pot_jht_kry_rp',
            'payroll_bpjs_tk_temp.tunj_jkk_rp',
            'payroll_bpjs_tk_temp.tunj_jkm_rp',
            'payroll_bpjs_tk_temp.tunj_jp_perus_rp',
            'payroll_bpjs_tk_temp.pot_jp_kry_rp',
            'payroll_bpjs_tk_temp.ttl_pot_karyawan',
            'payroll_bpjs_tk_temp.ttl_tunj_dibiayai_perus'
        );

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $this->db->order_by("data_karyawan.nik ASC");
        }
    }

    public function delete_bpjs_kes_temp_all()
    {
        // $this->db->where('user_input', $this->id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->delete('payroll_bpjs_kes_temp');
    }

    public function delete_bpjs_tk_temp_all()
    {
        // $this->db->where('user_input', $this->id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->delete('payroll_bpjs_tk_temp');
    }

    public function delete_bpjs_kes_temp($id)
    {
        $this->db->where('md5(id_karyawan)', $id);
        $this->db->where('id_company', $this->id_company);
        $this->db->delete('payroll_bpjs_kes_temp');
    }

    public function delete_bpjs_tk_temp($id)
    {
        $this->db->where('md5(id_karyawan)', $id);
        $this->db->where('id_company', $this->id_company);
        $this->db->delete('payroll_bpjs_tk_temp');
    }

    public function get_data_bpjs_kes($id_karyawan)
    {
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get('payroll_bpjs_kes_temp')->row();
    }

    public function get_data_bpjs_tk($id_karyawan)
    {
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get('payroll_bpjs_tk_temp')->row();
    }

    public function update($id_karyawan)
    { //md5
        $this->db->trans_start();
        $this->update_bpjs_kes_temp($id_karyawan);
        $this->update_bpjs_tk_temp($id_karyawan);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    private function cek_bpjs_kes($id_karyawan)
    {
        // md5
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->count_all_results('payroll_bpjs_kes_m');
    }

    private function update_bpjs_kes_temp($id_karyawan)
    {
        $tunj_perus_rp = $this->input->post('bpjs_kes_tunj_perus_rp');
        $pot_kry_rp    = $this->input->post('bpjs_kes_pot_kry_rp');
        $gaji_daftar   = num_to_dec($this->input->post('gaji_daftar'));
        $cek_bpjs_kes  = $this->cek_bpjs_kes($id_karyawan);

        $data = array(
            'flag'               => $this->input->post('bpjs_kes_flag'),
            'jml_anak'           => $this->input->post('jml_anak'),
            'ttl_gaji_terdaftar' => $gaji_daftar,
            'tunj_perus_persen'  => $this->input->post('bpjs_kes_tunj_perus'),
            'pot_kry_persen'     => $this->input->post('bpjs_kes_pot_kry')
        );

        if ($tunj_perus_rp != false) {
            $data['tunj_perus_rp'] = num_to_dec($tunj_perus_rp);
        }
        if ($pot_kry_rp != false) {
            $data['pot_kry_rp'] = num_to_dec($pot_kry_rp);
        }
        if ($gaji_daftar != 0) {
            if ($cek_bpjs_kes > 0) {
                $data['flag_import'] = '3';
            } else {
                $data['flag_import'] = '1';
            }
        } else {
            $data['flag_import'] = '2';
        }

        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->update('payroll_bpjs_kes_temp', $data);
    }

    private function update_bpjs_tk_temp($id_karyawan)
    {
        $ttl_gaji_terdaftar      = num_to_dec($this->input->post('gaji_daftar'));
        $tunj_jht_perus_rp       = $this->input->post('bpjs_tk_tunj_jht_perus_rp');
        $pot_jht_kry_rp          = $this->input->post('bpjs_tk_pot_jht_kry_rp');
        $tunj_jkk_rp             = $this->input->post('bpjs_tk_tunj_jkk_rp');
        $tunj_jp_perus_rp        = $this->input->post('bpjs_tk_tunj_jp_perus_rp');
        $pot_jp_kry_rp           = $this->input->post('bpjs_tk_pot_jp_kry_rp');
        $tunj_jkm_rp             = $this->input->post('bpjs_tk_tunj_jkm_rp');
        $ttl_pot_karyawan        = num_to_dec($this->input->post('ttl_pot_kry'));
        $ttl_tunj_dibiayai_perus = num_to_dec($this->input->post('ttl_tunj_dibiayai_perus'));

        $data = array(
            'ttl_gaji_terdaftar'      => $ttl_gaji_terdaftar,
            'tunj_jht_perus_persen'   => $this->input->post('bpjs_tk_tunj_jht_perus'),
            'pot_jht_kry_persen'      => $this->input->post('bpjs_tk_pot_jht_kry'),
            'flag_jht'                => $this->input->post('bpjs_tk_flag_jht'),
            'tunj_jkk_persen'         => $this->input->post('bpjs_tk_tunj_jkk'),
            'flag_jkk'                => $this->input->post('bpjs_tk_flag_jkk'),
            'tunj_jp_perus_persen'    => $this->input->post('bpjs_tk_tunj_jp_perus'),
            'pot_jp_kry_persen'       => $this->input->post('bpjs_tk_pot_jp_kry'),
            'flag_jp'                 => $this->input->post('bpjs_tk_flag_jp'),
            'tunj_jkm_persen'         => $this->input->post('bpjs_tk_tunj_jkm'),
            'flag_jkm'                => $this->input->post('bpjs_tk_flag_jkm'),
            'ttl_pot_karyawan'        => $ttl_pot_karyawan,
            'ttl_tunj_dibiayai_perus' => $ttl_tunj_dibiayai_perus
        );
        if ($tunj_jht_perus_rp != false) {
            $data['tunj_jht_perus_rp'] = num_to_dec($tunj_jht_perus_rp);
        }
        if ($pot_jht_kry_rp != false) {
            $data['pot_jht_kry_rp'] = num_to_dec($pot_jht_kry_rp);
        }
        if ($tunj_jkk_rp != false) {
            $data['tunj_jkk_rp'] = num_to_dec($tunj_jkk_rp);
        }
        if ($tunj_jp_perus_rp != false) {
            $data['tunj_jp_perus_rp'] = num_to_dec($tunj_jp_perus_rp);
        }
        if ($pot_jp_kry_rp != false) {
            $data['pot_jp_kry_rp'] = num_to_dec($pot_jp_kry_rp);
        }
        if ($tunj_jkm_rp != false) {
            $data['tunj_jkm_rp'] = num_to_dec($tunj_jkm_rp);
        }
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->update('payroll_bpjs_tk_temp', $data);
    }

    public function get_data_bpjs_temp()
    {
        $this->db->select('
            bpjs_kes.id_karyawan,
            bpjs_kes.flag,
            bpjs_kes.jml_anak,
            bpjs_kes.ttl_gaji_terdaftar,
            bpjs_kes.tunj_perus_persen,
            bpjs_kes.tunj_perus_rp,
            bpjs_kes.pot_kry_persen,
            bpjs_kes.pot_kry_rp,
            bpjs_kes.flag_import,
            bpjs_tk.ttl_gaji_terdaftar,
            bpjs_tk.tunj_jht_perus_persen,
            bpjs_tk.tunj_jht_perus_rp,
            bpjs_tk.pot_jht_kry_persen,
            bpjs_tk.pot_jht_kry_rp,
            bpjs_tk.flag_jht,
            bpjs_tk.tunj_jkk_persen,
            bpjs_tk.tunj_jkk_rp,
            bpjs_tk.flag_jkk,
            bpjs_tk.tunj_jp_perus_persen,
            bpjs_tk.tunj_jp_perus_rp,
            bpjs_tk.pot_jp_kry_persen,
            bpjs_tk.pot_jp_kry_rp,
            bpjs_tk.flag_jp,
            bpjs_tk.tunj_jkm_persen,
            bpjs_tk.tunj_jkm_rp,
            bpjs_tk.flag_jkm,
            bpjs_tk.ttl_pot_karyawan,
            bpjs_tk.ttl_tunj_dibiayai_perus
        ');

        $this->db->from('payroll_bpjs_kes_temp bpjs_kes');
        $this->db->join('payroll_bpjs_tk_temp bpjs_tk', 'bpjs_kes.id_karyawan = bpjs_tk.id_karyawan', 'left');
        $this->db->where("bpjs_kes.id_company", $this->id_company);
        $this->db->where_in('flag_import', ['1', '3']);
        $this->db->where("bpjs_kes.user_input", $this->id_karyawan);
        return $this->db->get()->result();
    }

}
