<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends MY_Controller {

    public function index()
    {
        $this->load->view('kpi/user/saya/home');
    }

    public function list_data() {
        $this->load->model('kpi/user/saya/home_m');
        $this->load->helper('kpi/kpi');

		$listBulan   = $this->listBulan();
		$dataTrx     = $this->home_m->getDataTrx();
		$dataByBulan = array_column($dataTrx, 'bulan');
		$data        = array();
		foreach ($listBulan as $key => $bulan) {
			$row = array();

            $findData = $this->findData($dataTrx, $dataByBulan, $key);
			$row[] = $bulan;
			$row[] = !empty($findData) ?  $this->aksi($findData) : '';
			$row[] = !empty($findData) ?  statusActual($findData['status']) : '';
			$row[] = !empty($findData) ?  ($findData['tgl_pengajuan'] != '0000-00-00' ? indo_date($findData['tgl_pengajuan'], 'd F Y') : '-') : '';

			$data[] = $row;
		}

		$output = array(
			"draw"            => $_GET['draw'],
			"recordsTotal"    => 12,
			"recordsFiltered" => 12,
			"data"            => $data
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    private function findData($data, $dataByBulan, $key) {
        if(in_array($key, $dataByBulan)) {
            return $data[array_keys($dataByBulan, $key)[0]];
        } else {
            return [];
        }
    }

    private function listBulan() {
        return [
            '1' => 'Januari',
            '2' => 'Februari',
            '3' => 'Maret',
            '4' => 'April',
            '5' => 'Mei',
            '6' => 'Juni',
            '7' => 'Juli',
            '8' => 'Agustus',
            '9' => 'September',
            '10' => 'Oktober',
            '11' => 'November',
            '12' => 'Desember'
        ];
    }

    private function aksi($data) {
        $tglSekarang = date('Y-m-d');
        $id          = md5($data['id_karyawan'].$data['tahun'].$data['bulan']);
        $periodeAktual = "<b>Periode pengisian aktual KPI<br>".indo_date($data['periode_mulai'])." s/d ".indo_date($data['periode_selesai'])."</b>";
        if($data['status'] == '4') {
            return "<a id='$id' class='btn_detail_saya btn btn-success text-white'><i class='fa fa-check'></i> Terima KPI</a>";
        } else {
            if($tglSekarang >= $data['periode_mulai'] && $tglSekarang <= $data['periode_selesai'] && $data['id_karyawan'] == $this->id_karyawan) {
                // jika periode actual
                if($data['status'] == '6') {
                    return "<a id='$id' class='btn_detail_saya text-primary set_planning'><i class='fa fa-paper-plane-o'></i> Isi Actual</a>";
                } elseif($data['status'] == '7') {
                    return "<a id='$id' class='btn_detail_saya text-warning draf'><i class='fa fa-pencil-square-o'></i> Edit</a>";
                } else {
                    return "<a id='$id' class='btn_detail_saya text-primary'><i class='fa fa-info-circle'></i></a>";
                }
            } else {
                if(in_array($data['status'], ['6', '7'])) {
                    return $periodeAktual;
                } else {
                    return "<a id='$id' class='btn_detail_saya text-primary'><i class='fa fa-info-circle'></i></a>";
                }
            }
        }
    }
}