<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Karyawan_import extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(array('Karyawan_import_m'));
        $this->load->library(array('PHPExcel/Excel', 'PHPExcel/PHPExcel', 'Uploadfile'));
        $this->load->helper('download');
    }

    public function index()
    {
        $data['judul'] = 'Import ' . $this->lang->line('menu_karyawan');
        $data['aktif'] = 'karyawan';

        $max_karyawan = $this->db->select("SUM(master_company.custom_jumlah_karyawan + tb_paket.max_karyawan) AS max_jml_karyawan")
            ->from("master_company")
            ->join("tb_paket", "tb_paket.id_tb_paket = master_company.id_tb_paket")
            ->where("master_company.id_company", $this->id_company)
            ->get()
            ->row("max_jml_karyawan");
        $data['max_karyawan'] = $max_karyawan;

        $jumlah_karyawan_aktif = $this->db->select("data_karyawan.id_karyawan")
            ->from("data_karyawan")
            ->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan")
            ->where_in("data_karyawan.status", ["1", "2", "3", "4"])
            ->where_not_in("master_jabatan.level_user", ["1", "6"])
            ->where("data_karyawan.id_company", $this->id_company)
            ->get()
            ->num_rows();
        $data['jumlah_karyawan_aktif'] = $jumlah_karyawan_aktif;

        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('karyawan/import/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view_data()
    {
        $this->load->view('karyawan/import/list_data');
    }

    public function download_template()
    {
        // Load plugin PHPExcel nya
        include APPPATH . 'third_party/PHPExcel/PHPExcel.php';

        // Panggil class PHPExcel nya
        $excel = new PHPExcel();
        // Settingan awal fil excel
        $excel->getProperties()->setCreator('Absenku')
            ->setLastModifiedBy('Absenku')
            ->setTitle($this->lang->line('template_import_data_karyawan'))
            ->setSubject($this->lang->line('template_import_data_karyawan'))
            ->setDescription($this->lang->line('template_import_data_karyawan') . " Absenku Profesioanal");
        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel
        $style_header = array(
            'font' => array('bold' => true), // Set font nya jadi bold
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
                'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
            ),
        );
        // Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
        $style_row = array(
            'alignment' => array(
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
            'borders' => array(
                'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
                'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
                'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
                'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
            )
        );

        $excel->setActiveSheetIndex(0)->setCellValue('A1', strtoupper($this->lang->line('template_import_data_karyawan'))); // Set kolom A1 dengan tulisan ""
        $excel->getActiveSheet()->mergeCells('A1:V1'); // Set Merge Cell pada kolom A1 sampai E1
        $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE); // Set bold kolom A1
        $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(14);; // Set font size
        $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); // Set text center untuk kolom A1

        //header
        $excel->setActiveSheetIndex(0)->setCellValue('A3', "NO");
        $excel->setActiveSheetIndex(0)->setCellValue('B3', strtoupper($this->lang->line('nomor_induk_karyawan')));
        $excel->setActiveSheetIndex(0)->setCellValue('C3', strtoupper($this->lang->line('nama_karyawan')));
        $excel->setActiveSheetIndex(0)->setCellValue('D3', strtoupper($this->lang->line('gelar_depan')));
        $excel->setActiveSheetIndex(0)->setCellValue('E3', strtoupper($this->lang->line('gelar_belakang')));
        $excel->setActiveSheetIndex(0)->setCellValue('F3', strtoupper($this->lang->line('kode_jabatan')));
        $excel->setActiveSheetIndex(0)->setCellValue('G3', strtoupper($this->lang->line('kode_cabang')));
        $excel->setActiveSheetIndex(0)->setCellValue('H3', strtoupper($this->lang->line('kode_departemen')));
        $excel->setActiveSheetIndex(0)->setCellValue('I3', "STATUS(" . strtoupper($this->lang->line('kontrak')) . "/" . strtoupper($this->lang->line('tetap')) . ")");
        $excel->setActiveSheetIndex(0)->setCellValue('J3', strtoupper($this->lang->line('tgl_aktif_bekerja')) . "(DD-MM-YYYY)");
        $excel->setActiveSheetIndex(0)->setCellValue('K3', strtoupper($this->lang->line('tgl_berhenti_bekerja')) . "(DD-MM-YYYY)");
        $excel->setActiveSheetIndex(0)->setCellValue('L3', "JOIN DATE(DD-MM-YYYY)");
        $excel->setActiveSheetIndex(0)->setCellValue('M3', "USERNAME");
        $excel->setActiveSheetIndex(0)->setCellValue('N3', "PASSWORD");
        $excel->setActiveSheetIndex(0)->setCellValue('O3', strtoupper($this->lang->line('jatah_cuti')));
        $excel->setActiveSheetIndex(0)->setCellValue('P3', strtoupper($this->lang->line('jenis_kelamin_lp')));
        $excel->setActiveSheetIndex(0)->setCellValue('Q3', strtoupper($this->lang->line('tempat_lahir')));
        $excel->setActiveSheetIndex(0)->setCellValue('R3', strtoupper($this->lang->line('tgl_lahir')) . "(DD-MM-YYYY)");
        $excel->setActiveSheetIndex(0)->setCellValue('S3', strtoupper($this->lang->line('alamat')));
        $excel->setActiveSheetIndex(0)->setCellValue('T3', strtoupper($this->lang->line('agama')));
        $excel->setActiveSheetIndex(0)->setCellValue('U3', strtoupper($this->lang->line('no_telp')));
        $excel->setActiveSheetIndex(0)->setCellValue('V3', strtoupper($this->lang->line('email')));
        $excel->setActiveSheetIndex(0)->setCellValue('W3', strtoupper($this->lang->line('no_ktp')));
        $excel->setActiveSheetIndex(0)->setCellValue('Z3', strtoupper($this->lang->line('keterangan')));

        //SET WIDTH
        $excel->getActiveSheet()->getColumnDimension('A')->setWidth("5");
        $excel->getActiveSheet()->getColumnDimension('B')->setWidth("25");
        $excel->getActiveSheet()->getColumnDimension('C')->setWidth("40");
        $excel->getActiveSheet()->getColumnDimension('D')->setWidth("13");
        $excel->getActiveSheet()->getColumnDimension('E')->setWidth("17");
        $excel->getActiveSheet()->getColumnDimension('F')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('G')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('H')->setWidth("18");
        $excel->getActiveSheet()->getColumnDimension('I')->setAutoSize(TRUE);
        $excel->getActiveSheet()->getColumnDimension('J')->setAutoSize(TRUE);
        $excel->getActiveSheet()->getColumnDimension('K')->setAutoSize(TRUE);
        $excel->getActiveSheet()->getColumnDimension('L')->setWidth("25");
        $excel->getActiveSheet()->getColumnDimension('M')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('N')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('O')->setAutoSize(TRUE);
        $excel->getActiveSheet()->getColumnDimension('P')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('Q')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('R')->setWidth("27");
        $excel->getActiveSheet()->getColumnDimension('S')->setWidth("30");
        $excel->getActiveSheet()->getColumnDimension('T')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('U')->setAutoSize(TRUE);
        $excel->getActiveSheet()->getColumnDimension('V')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('W')->setWidth("35");
        $excel->getActiveSheet()->getColumnDimension('Z')->setAutoSize(TRUE);
        //header

        //style
        $excel->getActiveSheet()->getStyle('Z3')->getFont()->setBold(TRUE);
        $excel->getActiveSheet()->getStyle('Z3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $excel->getActiveSheet()->getStyle('Z3:Z6')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('ffe699');
        $excel->getActiveSheet()->getStyle('B3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('C3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('F3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('G3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('H3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('I3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('J3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('K3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('L3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('M3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('N3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');


        $excel->setActiveSheetIndex(0)->setCellValue('A4', 1);
        $excel->setActiveSheetIndex(0)->setCellValue('A5', 2);
        $excel->setActiveSheetIndex(0)->setCellValue('A6', 3);
        $excel->setActiveSheetIndex(0)->setCellValue('A7', 4);
        $excel->setActiveSheetIndex(0)->setCellValue('A8', 5);
        $excel->setActiveSheetIndex(0)->setCellValue('A9', 6);
        $excel->setActiveSheetIndex(0)->setCellValue('A10', 7);
        $excel->setActiveSheetIndex(0)->setCellValue('A11', 8);
        $excel->setActiveSheetIndex(0)->setCellValue('A12', 9);
        $excel->setActiveSheetIndex(0)->setCellValue('A13', 10);

        $excel->getActiveSheet()->getStyle('A4:A13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $excel->setActiveSheetIndex(0)->setCellValue('Z4', $this->lang->line('import_karyawan_aturan_1'));
        $excel->setActiveSheetIndex(0)->setCellValue('Z5', $this->lang->line('import_karyawan_aturan_2'));
        $excel->setActiveSheetIndex(0)->setCellValue('Z6', $this->lang->line('import_karyawan_aturan_3'));

        # FORMAT TEXT
        $range = 'B4:W13';
        $excel->getActiveSheet()
            ->getStyle($range)
            ->getNumberFormat()
            ->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

        # BORDER SEMUA KOLOM
        $excel->getActiveSheet()
            ->getStyle("A3:W3")
            ->applyFromArray($style_header);

        $excel->getActiveSheet()
            ->getStyle("A3:W13")
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );
        $excel->getActiveSheet()
            ->getStyle("Z3:Z6")
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );

        // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
        $excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
        // Set orientasi kertas jadi LANDSCAPE
        $excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        // Set judul file excel nya
        $excel->getActiveSheet(0)->setTitle("TEMPLATE DATA KARYAWAN");
        $excel->setActiveSheetIndex(0);

        $filename = strtoupper($this->lang->line('template_import_data_karyawan'));
        // Proses file excel
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename=' . $filename . '.xlsx'); // Set nama file excel nya
        header('Cache-Control: max-age=0');
        $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $write->save('php://output');
    }

    public function list_data()
    {
        $list      = $this->Karyawan_import_m->get_datatables();
        $cek_level = $this->Karyawan_import_m->cek_level_list_data();
        $data      = array();
        $no        = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $level = $cek_level[$field->id_jabatan];

            $row[] = $no;

            if ($field->nik == "" || $field->nik == NULL) {
                $class = "badge badge-danger";
                $nik   = $this->lang->line('data_kosong');
                $row[] = "<div class='" . $class . "'>" . $nik . "</div>";
            } else {
                $cek_nik_nama = $this->db->select("nik, nama_lengkap")
                    ->from("data_karyawan")
                    ->where("nik", $field->nik)
                    ->where("id_karyawan", $field->id_karyawan)
                    ->where("id_company", $this->id_company)
                    ->get();

                if ($cek_nik_nama->num_rows() > 0) {
                    $class = "badge badge-warning";
                    $nik   = $this->lang->line('nik') . " <b>" . $field->nik . "</b> " . $this->lang->line('sudah_ada') . " <br> " . $this->lang->line('dan') . " " . $this->lang->line('sudah_digunakan_oleh') . " <b>" . $cek_nik_nama->row()->nama_lengkap . "</b>";
                    $row[] = "<div class='" . $class . "'>" . $nik . "</div>";
                } else {
                    $nik = $field->nik;
                    $row[] = $nik;
                }
            }

            if ($field->nama_lengkap == "" || $field->nama_lengkap == NULL) {
                $class = "badge badge-danger";
                $nama_lengkap = $this->lang->line('data_kosong');
                $row[] = "<div class='" . $class . "'>" . $nama_lengkap . "</div>";
            } else {
                $nama_lengkap = $field->nama_lengkap;
                $row[] = $nama_lengkap;
            }

            $row[] = $field->gelar_depan;
            $row[] = $field->gelar_belakang;

            if ($field->kode_jabatan == "" || $field->kode_jabatan == NULL) {
                $class = "badge badge-danger";
                $kode_jabatan = $this->lang->line('data_kosong');
                $row[] = "<div class='" . $class . "'>" . $kode_jabatan . "</div>";
            } else {
                $kode_jabatan = $field->kode_jabatan;
                $nama_jabatan = $field->nama_jabatan;
                $row[] = $kode_jabatan . " - " . $nama_jabatan;
            }

            if ($field->kode_cabang == "" || $field->kode_cabang == NULL) {
                $class = "badge badge-danger";
                $kode_cabang = $this->lang->line('data_kosong');
                $row[] = "<div class='" . $class . "'>" . $kode_cabang . "</div>";
            } else {
                $kode_cabang = $field->kode_cabang;
                $nama_cabang = $field->nama_cabang;
                $row[] = $kode_cabang . " - " . $nama_cabang;
            }

            if ($field->kode_departemen == "" || $field->kode_departemen == NULL) {
                if (in_array($level, ["5", "4", "6"])) {
                    $class              = "";
                    $kode_departemen    = "";
                    $row[]              = $class . $kode_departemen;
                } else {
                    $class              = "badge badge-danger";
                    $kode_departemen    = $this->lang->line('data_kosong');
                    $row[]              = "<div class='" . $class . "'>" . $kode_departemen . "</div>";
                }
            } else {
                $kode_departemen    = $field->kode_departemen;
                $nama_departemen    = $field->nama_departemen;
                $row[]              = $kode_departemen . " - " . $nama_departemen;
            }


            if ($field->status == "" || $field->status == NULL) {
                $class  = "badge badge-danger";
                $status = $this->lang->line('data_kosong');
                $row[]  = "<div class='" . $class . "'>" . $status . "</div>";

                if ($field->tgl_aktif_bekerja == '' || $field->tgl_aktif_bekerja == NULL || $field->tgl_aktif_bekerja == '1970-01-01') {
                    $class = "badge badge-danger";
                    $tgl_aktif_bekerja = $this->lang->line('data_kosong');
                    $row[] = "<div class='" . $class . "'>" . $tgl_aktif_bekerja . "</div>";
                } else {
                    $tgl_aktif_bekerja = date('d-m-Y', strtotime($field->tgl_aktif_bekerja));
                    $row[] = $tgl_aktif_bekerja;
                }

                if ($field->tgl_berhenti_bekerja == '' || $field->tgl_berhenti_bekerja == NULL || $field->tgl_berhenti_bekerja == '1970-01-01') {
                    $class = "badge badge-danger";
                    $tgl_berhenti_bekerja = $this->lang->line('data_kosong');
                    $row[] = "<div class='" . $class . "'>" . $tgl_berhenti_bekerja . "</div>";
                } else {
                    $tgl_berhenti_bekerja = date('d-m-Y', strtotime($field->tgl_berhenti_bekerja));
                    $row[] = $tgl_berhenti_bekerja;
                }
            } else if ($field->status == 1) {
                $status = $this->lang->line('kontrak');
                $row[] = $status;

                if ($field->tgl_aktif_bekerja == '' || $field->tgl_aktif_bekerja == NULL || $field->tgl_aktif_bekerja == '1970-01-01') {
                    $class = "badge badge-danger";
                    $tgl_aktif_bekerja = $this->lang->line('data_kosong');
                    $row[] = "<div class='" . $class . "'>" . $tgl_aktif_bekerja . "</div>";
                } else {
                    $tgl_aktif_bekerja = date('d-m-Y', strtotime($field->tgl_aktif_bekerja));
                    $row[] = $tgl_aktif_bekerja;
                }

                if ($field->tgl_berhenti_bekerja == '' || $field->tgl_berhenti_bekerja == NULL || $field->tgl_berhenti_bekerja == '1970-01-01') {
                    $class = "badge badge-danger";
                    $tgl_berhenti_bekerja = $this->lang->line('data_kosong');
                    $row[] = "<div class='" . $class . "'>" . $tgl_berhenti_bekerja . "</div>";
                } else {
                    $tgl_berhenti_bekerja = date('d-m-Y', strtotime($field->tgl_berhenti_bekerja));
                    $row[] = $tgl_berhenti_bekerja;
                }
            } else if ($field->status == 2) {
                $status = $this->lang->line('tetap');
                $row[] = $status;

                if ($field->tgl_aktif_bekerja == '' || $field->tgl_aktif_bekerja == NULL || $field->tgl_aktif_bekerja == '1970-01-01') {
                    $class = "badge badge-danger";
                    $tgl_aktif_bekerja = $this->lang->line('data_kosong');
                    $row[] = "<div class='" . $class . "'>" . $tgl_aktif_bekerja . "</div>";
                } else {
                    $tgl_aktif_bekerja = date('d-m-Y', strtotime($field->tgl_aktif_bekerja));
                    $row[] = $tgl_aktif_bekerja;
                }

                if ($field->tgl_berhenti_bekerja == '' || $field->tgl_berhenti_bekerja == NULL || $field->tgl_berhenti_bekerja == '1970-01-01') {
                    $tgl_berhenti_bekerja = '-';
                    $row[] = $tgl_berhenti_bekerja;
                } else {
                    $tgl_berhenti_bekerja = date('d-m-Y', strtotime($field->tgl_berhenti_bekerja));
                    $row[] = $tgl_berhenti_bekerja;
                }
            }

            if ($field->join_date == '' || $field->join_date == NULL || $field->join_date == '1970-01-01') {
                $class = "badge badge-danger";
                $join_date = $this->lang->line('data_kosong');
                $row[] = "<div class='" . $class . "'>" . $join_date . "</div>";
            } else {
                $join_date = date('d-m-Y', strtotime($field->join_date));
                $row[] = $join_date;
            }


            if ($field->username == "" || $field->username == NULL) {
                $class = "badge badge-danger";
                $username = $this->lang->line('data_kosong');
                $row[] = "<div class='" . $class . "'>" . $username . "</div>";
            } else {
                $cek_username = $this->db->select("username")
                    ->from("users")
                    ->where("username", $field->username)
                    ->get()
                    ->num_rows();
                if ($cek_username > 0) {
                    $class = "badge badge-warning";
                    $username = "Username " . $field->username . " " . $this->lang->line('sudah_ada');
                    $row[] = "<div class='" . $class . "'>" . $username . "</div>";
                } else {
                    $username = $field->username;
                    $row[] = $username;
                }
            }

            $row[] = $field->jatah_cuti;
            $row[] = $this->fungsi->jkel($field->jenis_kelamin);
            $row[] = $field->tempat_lahir;

            if ($field->tgl_lahir == '' || $field->tgl_lahir == NULL || $field->tgl_lahir == '1970-01-01') {
                $tgl_lahir = '-';
                $row[] = $tgl_lahir;
            } else {
                $tgl_lahir = date('d-m-Y', strtotime($field->tgl_lahir));
                $row[] = $tgl_lahir;
            }

            $row[] = $field->alamat_domisili;
            $row[] = $field->agama;
            $row[] = $field->telepon;
            $row[] = $field->email;
            $row[] = $field->no_ktp;

            $btn_edit  = '<a href="' . route('karyawan.import.form.edit') . '/' . md5($field->id_temp) . '" id="' . md5($field->id_temp) . '" class="text-warning btn_edit" title="EDIT"><i class="fa fa-edit"></i></a>';
            $btn_hapus = '<a href="#" title="Delete" class="text-danger"><i class="btn_form_hapus fa fa-trash" id="' . md5($field->id_temp) . '"></i></a>';

            $row[] = $btn_edit . '&nbsp;' . $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_POST['draw'],
            "recordsTotal"    => $this->Karyawan_import_m->count_all(),
            "recordsFiltered" => $this->Karyawan_import_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function import_data_excel()
    {
        if (!empty($_FILES['file']['name'])) {
            $tahunbulan                   = date('Ym');
            $fileUpload['fname']          = 'file';
            $fileUpload['location']       = 'template_data_karyawan/' . $tahunbulan;
            $fileUpload['allowed']        = 'xls|xlsx';
            $fileUpload['compress_image'] = false;

            $upload = $this->uploadfile->doUpload($fileUpload);
            if ($upload["success"] == true) {
                $dir_file = $this->config->item('base_upload') . $upload['url'];
            } else {
                $message = ["message" => $upload["message"]];
                return __response_save(false, $message);
            }
        } else {
            $message = ["message" => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_gagal_import') . '</font>'];
            return __response_save(false, ["message" => $message]);
        }

        try {
            $inputFileType = PHPExcel_IOFactory::identify($dir_file);
            $objReader = PHPExcel_IOFactory::createReader($inputFileType);
            $objPHPExcel = $objReader->load($dir_file);
        } catch (Exception $e) {
            $message = ["message" => 'Error loading file "' . pathinfo($dir_file, PATHINFO_BASENAME) . '": ' . $e->getMessage()];
            return __response_save(false, ["message" => $message]);
        }

        $row = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
        $end = sizeof($row);

        $data_insert = array();
        $data = array();

        $master_jabatan    = $this->Karyawan_import_m->masterJabatan();
        $master_cabang     = $this->Karyawan_import_m->masterCabang();
        $master_departemen = $this->Karyawan_import_m->masterDepartemen();
        $cek_username      = $this->Karyawan_import_m->cek_username();
        $cek_nik           = $this->Karyawan_import_m->cek_nik();
        $cek_level         = $this->Karyawan_import_m->cek_level();

        $id_temp = $this->fungsi->getNextId('data_karyawan_temp', 'id_temp', $this->id_company, 5);

        if (
            $row[3]["A"] != "NO" or
            $row[3]["B"] != strtoupper($this->lang->line('nomor_induk_karyawan')) or
            $row[3]["C"] != strtoupper($this->lang->line('nama_karyawan')) or
            $row[3]["D"] != strtoupper($this->lang->line('gelar_depan')) or
            $row[3]["E"] != strtoupper($this->lang->line('gelar_belakang')) or
            $row[3]["F"] != strtoupper($this->lang->line('kode_jabatan')) or
            $row[3]["G"] != strtoupper($this->lang->line('kode_cabang')) or
            $row[3]["H"] != strtoupper($this->lang->line('kode_departemen')) or
            $row[3]["I"] != "STATUS(" . strtoupper($this->lang->line('kontrak')) . "/" . strtoupper($this->lang->line('tetap')) . ")" or
            $row[3]["J"] != strtoupper($this->lang->line('tgl_aktif_bekerja')) . "(DD-MM-YYYY)" or
            $row[3]["K"] != strtoupper($this->lang->line('tgl_berhenti_bekerja')) . "(DD-MM-YYYY)" or
            $row[3]["L"] != "JOIN DATE(DD-MM-YYYY)" or
            $row[3]["M"] != "USERNAME" or
            $row[3]["N"] != "PASSWORD" or
            $row[3]["O"] != strtoupper($this->lang->line('jatah_cuti')) or
            $row[3]["P"] != strtoupper($this->lang->line('jenis_kelamin_lp')) or
            $row[3]["Q"] != strtoupper($this->lang->line('tempat_lahir')) or
            $row[3]["R"] != strtoupper($this->lang->line('tgl_lahir')) . "(DD-MM-YYYY)" or
            $row[3]["S"] != strtoupper($this->lang->line('alamat')) or
            $row[3]["T"] != strtoupper($this->lang->line('agama')) or
            $row[3]["U"] != strtoupper($this->lang->line('no_telp')) or
            $row[3]["V"] != strtoupper($this->lang->line('email')) or
            $row[3]["W"] != strtoupper($this->lang->line('no_ktp'))
        ) {
            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_import_format_tidak_sesuai') . '</font>';
            return __response_save(false, array('message' => $message));
            unlink($upload);
        } else {
            for ($i = 4; $i <= $end; $i++) {
                // var_dump($row[$i]['AJ']);
                $nik                  = trim($row[$i]['B']);
                $nama_lengkap         = trim($row[$i]['C']);
                $gelar_depan          = (isset($row[$i]['D']) && $row[$i]['D'] != NULL) ? trim($row[$i]['D']) : '';
                $gelar_belakang       = (isset($row[$i]['E']) && $row[$i]['E'] != NULL) ? trim($row[$i]['E']) : '';
                $kode_jabatan         = trim($row[$i]['F']);
                $kode_cabang          = trim($row[$i]['G']);
                $kode_departemen      = trim($row[$i]['H']);
                $status_karyawan      = trim($row[$i]['I']);
                $tgl_aktif_bekerja    = $row[$i]['J'];
                $tgl_berhenti_bekerja = $row[$i]['K'];
                $join_date            = $row[$i]['L'];
                $username             = trim($row[$i]['M']);
                $password             = trim($row[$i]['N']);
                $jatah_cuti           = (isset($row[$i]['O']) && $row[$i]['O'] != NULL) ? $row[$i]['O'] : '0';
                $jenis_kelamin        = (isset($row[$i]['P']) && $row[$i]['P'] != NULL) ? trim($row[$i]['P']) : '';
                $tempat_lahir         = (isset($row[$i]['Q']) && $row[$i]['Q'] != NULL) ? trim($row[$i]['Q']) : '';
                $tgl_lahir            = (isset($row[$i]['R']) && $row[$i]['R'] != NULL) ? $row[$i]['R'] : '';
                $alamat               = (isset($row[$i]['S']) && $row[$i]['S'] != NULL) ? trim($row[$i]['S']) : '';
                $agama                = (isset($row[$i]['T']) && $row[$i]['T'] != NULL) ? ucfirst(strtolower($row[$i]['T'])) : '';
                $telepon              = (isset($row[$i]['U']) && $row[$i]['U'] != NULL) ? trim($row[$i]['U']) : '';
                $email                = (isset($row[$i]['V']) && $row[$i]['V'] != NULL) ? trim($row[$i]['V']) : '';
                $no_ktp               = (isset($row[$i]['W']) && $row[$i]['W'] != NULL) ? trim($row[$i]['W']) : '';
                if ($nik == "") {
                    // jika nik kosong lewat ke baris berikutnya
                    continue;
                }

                $id_karyawan = $this->id_company . preg_replace('/[^A-Za-z0-9\-]/', '', $nik);

                $level      = $cek_level[$kode_jabatan];
                $id_jabatan = $master_jabatan[$kode_jabatan];
                $id_cabang  = $master_cabang[$kode_cabang];
                $departemen = $master_departemen[$kode_departemen];

                if (in_array($level, ["5", "4", "6"])) {
                    $id_departemen = '';
                } else {
                    $id_departemen = $departemen;
                }

                if (empty($jenis_kelamin)) {
                    $jk = 'uknown';
                } else {
                    if ($jenis_kelamin == 'M' || $jenis_kelamin == 'm') {
                        $jk = 'L';
                    } else if ($jenis_kelamin == 'F' || $jenis_kelamin == 'f') {
                        $jk = 'P';
                    } else {
                        $jk = $jenis_kelamin;
                    }
                }

                if ($status_karyawan == 'Kontrak' || $status_karyawan == 'kontrak' || $status_karyawan == 'KONTRAK' || $status_karyawan == 'Contract' || $status_karyawan == 'contract' || $status_karyawan == 'CONTRACT') {
                    $status = '1';
                } else if ($status_karyawan == 'Tetap' || $status_karyawan == 'tetap' || $status_karyawan == 'TETAP' || $status_karyawan == 'Permanent' || $status_karyawan == 'permanent' || $status_karyawan == 'PERMANENT') {
                    $status = '2';
                } else {
                    $status = '';
                }

                $tgl_lahir            = date('Y-m-d', strtotime($tgl_lahir));
                $tgl_aktif_bekerja    = date('Y-m-d', strtotime($tgl_aktif_bekerja));
                $tgl_berhenti_bekerja = date('Y-m-d', strtotime($tgl_berhenti_bekerja));
                $tgl_gabung           = date('Y-m-d', strtotime($join_date));

                //cek nik
                $c_nik = $cek_nik[$id_karyawan];

                //cek username
                $c_username = $cek_username[$username];

                if ($nik == "" || $nik == NULL || $c_nik != '') {
                    $flag = '2';
                } else if ($nama_lengkap == "" || $nama_lengkap == NULL) {
                    $flag = '2';
                } else if ($kode_jabatan == "" || $kode_jabatan == NULL) {
                    $flag = '2';
                } else if ($kode_cabang == "" || $kode_cabang == NULL) {
                    $flag = '2';
                } else if ($tgl_gabung == '' || $tgl_gabung == NULL || $tgl_gabung == '1970-01-01') {
                    $flag = '2';
                } else if ($kode_departemen == "" || $kode_departemen == NULL) {
                    if (in_array($level, ["5", "4", "6"])) {
                        $flag = '1';
                    } else {
                        $flag = '2';
                    }
                } else if ($username == "" || $username == NULL || $c_username != '') {
                    $flag = '2';
                } else if ($status == "" || $status == NULL) {
                    $flag = '2';
                } else if ($status == 1) {
                    if ($tgl_aktif_bekerja == "" || $tgl_aktif_bekerja == NULL || $tgl_aktif_bekerja == '1970-01-01') {
                        $flag = '2';
                    } else {
                        $flag = '1';
                    }
                } else if ($status == 2) {
                    if ($tgl_aktif_bekerja == "" || $tgl_aktif_bekerja == NULL || $tgl_aktif_bekerja == '1970-01-01') {
                        $flag = '2';
                    } else {
                        $flag = '1';
                    }
                } else if ($password == "" || $password == NULL) {
                    $flag = '2';
                } else {
                    $flag = '1';
                }


                $data = array(
                    'id_temp'              => $id_temp,
                    'id_karyawan'          => $id_karyawan,
                    'nik'                  => $nik,
                    'nama_lengkap'         => $nama_lengkap,
                    'gelar_depan'          => $gelar_depan,
                    'gelar_belakang'       => $gelar_belakang,
                    'id_jabatan'           => $id_jabatan,
                    'id_cabang'            => $id_cabang,
                    'id_departemen'        => $id_departemen,
                    'status'               => $status,
                    'tgl_aktif_bekerja'    => $tgl_aktif_bekerja,
                    'tgl_berhenti_bekerja' => $tgl_berhenti_bekerja,
                    'join_date'            => $tgl_gabung,
                    'username'             => $username,
                    'password'             => sha1(sha1(md5($password))),
                    'jatah_cuti'           => $jatah_cuti,
                    'jenis_kelamin'        => $jk,
                    'tempat_lahir'         => $tempat_lahir,
                    'tgl_lahir'            => $tgl_lahir,
                    'alamat_domisili'      => $alamat,
                    'telepon'              => $telepon,
                    'email'                => $email,
                    'no_ktp'               => $no_ktp,
                    'agama'                => $agama,
                    'lock_lokasi'          => 1,
                    'flag'                 => $flag,
                    'user_input'           => $this->id_karyawan,
                    'id_company'           => $this->id_company
                );

                $data_insert[] = $data;

                $last_id = substr($id_temp, -5);
                $next_id = $last_id + 1;
                $id_temp = substr($id_temp, 0, -5) . sprintf("%05d", $next_id);
            }

            // print_r($data_insert);
            // exit;

            $data_existing = $this->Karyawan_import_m->getDataExisting_tem();
            if ($data_existing > 0) {
                $this->db->delete('data_karyawan_temp', array('id_company' => $this->id_company));
            }

            $this->db->trans_start();

            $this->db->insert_batch('data_karyawan_temp', $data_insert);

            $this->db->trans_complete();

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                $message = ["message" => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_gagal_import') . '</font>'];
                return __response_save(false, ["message" => $message]);
            } else {
                $this->db->trans_commit();
                $message = ["message" => '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>' . $this->lang->line('error_berhasil_import') . '</font>'];
                return __response_save(true, ["message" => $message]);
            }
        }
    }

    public function publish_all()
    {
        $get_data_temp = $this->db->select('*')
            ->from('data_karyawan_temp')
            ->where('id_company', $this->id_company)
            ->get()
            ->result();
        $cek_level = $this->Karyawan_import_m->cek_level_list_data();

        $data_insert       = array();
        $data_insert_user  = array();
        $data_insert_kacab = array();
        $data_insert_kedep = array();
        $data              = array();
        $paket_payroll = $this->session->userdata('paket_payroll');
        // jika paket payroll aktif
        if ($paket_payroll == '1') {
            $data_gapok          = [];
            $data_gapok_log      = [];
            $data_tunj_kehadiran = [];
            $data_tunj_tetap     = [];
            $data_pot_tetap      = [];
        }
        $id_user  = $this->fungsi->getNextId('users', 'id_user', $this->id_company, 4);
        $id_kacab = $this->fungsi->getNextId('p_kacab', 'id', $this->id_company, 3);
        $id_kedep = $this->fungsi->getNextId('p_kedep', 'id', $this->id_company, 3);

        $jml_berahasil_simpan = 0;
        $jml_gagal_simpan = 0;

        foreach ($get_data_temp as $rows) {
            if ($rows->flag == "1") {
                $data_existing = $this->Karyawan_import_m->getDataExisting($rows->id_karyawan);
                if ($data_existing == 0) {
                    $jml_berahasil_simpan++;

                    $level = $cek_level[$rows->id_jabatan];

                    $data = array(
                        'id_karyawan'          => $rows->id_karyawan,
                        'nik'                  => $rows->nik,
                        'nama_lengkap'         => $rows->nama_lengkap,
                        'gelar_depan'          => $rows->gelar_depan,
                        'gelar_belakang'       => $rows->gelar_belakang,
                        'id_jabatan'           => $rows->id_jabatan,
                        'id_cabang'            => $rows->id_cabang,
                        'id_departemen'        => $rows->id_departemen,
                        'status'               => $rows->status,
                        'tgl_aktif_bekerja'    => $rows->tgl_aktif_bekerja,
                        'tgl_berhenti_bekerja' => $rows->tgl_berhenti_bekerja,
                        'join_date'            => $rows->join_date,
                        'jatah_cuti'           => $rows->jatah_cuti,
                        'jenis_kelamin'        => $rows->jenis_kelamin,
                        'tempat_lahir'         => $rows->tempat_lahir,
                        'tgl_lahir'            => $rows->tgl_lahir,
                        'alamat_domisili'      => $rows->alamat_domisili,
                        'telepon'              => $rows->telepon,
                        'email'                => $rows->email,
                        'no_ktp'               => $rows->no_ktp,
                        'agama'                => $rows->agama,
                        'lock_lokasi'          => $rows->lock_lokasi,
                        'id_company'           => $this->id_company
                    );

                    $data_insert[] = $data;

                    $data_user = array(
                        'id_user'     => $id_user,
                        'username'    => $rows->username,
                        'password'    => $rows->password,
                        'id_karyawan' => $rows->id_karyawan,
                        'id_company'  => $this->id_company
                    );

                    if ($level == 5) {
                        $data_kacab = array(
                            "id"            => $id_kacab,
                            "id_karyawan"   => $rows->id_karyawan,
                            "id_cabang"     => $rows->id_cabang,
                            "flag"          => "1",
                            "id_company"    => $this->id_company
                        );

                        $last_id_kacab       = substr($id_kacab, -4);
                        $next_id_kacab       = $last_id_kacab + 1;
                        $id_kacab            = substr($id_kacab, 0, -4) . sprintf("%04d", $next_id_kacab);

                        $data_insert_kacab[] = $data_kacab;
                    }


                    if ($level == 2) {
                        $data_kedep = array(
                            "id"            => $id_kedep,
                            "id_karyawan"   => $rows->id_karyawan,
                            "id_cabang"     => $rows->id_cabang,
                            "id_departemen" => $rows->id_departemen,
                            "flag"          => "1",
                            "id_company"    => $this->id_company
                        );

                        $last_id_kedep       = substr($id_kedep, -4);
                        $next_id_kedep       = $last_id_kedep + 1;
                        $id_kedep            = substr($id_kedep, 0, -4) . sprintf("%04d", $next_id_kedep);

                        $data_insert_kedep[] = $data_kedep;
                    }

                    if ($paket_payroll == '1') {

                        $data_gapok[] = [
                            'nominal'     => 0,
                            'id_karyawan' => $rows->id_karyawan,
                            'id_company'  => $this->id_company,
                            'user_input'  => $this->nik . '-' . $this->nama_user
                        ];

                        $data_gapok_log[] = [
                            'id_company'   => $this->id_company,
                            'id_karyawan'  => $rows->id_karyawan,
                            'action'       => 'tambah',
                            'nominal_lama' => '0',
                            'nominal_baru' => '0',
                            'user_input'   => $this->nik . '-' . $this->nama_user
                        ];

                        $tunj_kehadiran_kosong = $this->Karyawan_import_m->insert_tunj_kehadiran_kosong($rows->id_karyawan, $data_tunj_kehadiran);
                        $data_tunj_kehadiran   = $tunj_kehadiran_kosong['data'];

                        $tunj_tetap_kosong = $this->Karyawan_import_m->insert_tunj_tetap_kosong($rows->id_karyawan, $data_tunj_tetap);
                        $data_tunj_tetap   = $tunj_tetap_kosong['data'];

                        $pot_tetap_kosong = $this->Karyawan_import_m->insert_pot_tetap_kosong($rows->id_karyawan, $data_pot_tetap);
                        $data_pot_tetap   = $pot_tetap_kosong['data'];
                    }

                    $last_id = substr($id_user, -4);
                    $next_id = $last_id + 1;
                    $id_user = substr($id_user, 0, -4) . sprintf("%04d", $next_id);

                    $data_insert_user[] = $data_user;
                } else {
                    $jml_gagal_simpan++;
                }
            } else {
                $jml_gagal_simpan++;
            }
        }

        $this->db->trans_start();

        $cek_limit =  $this->_cekLimitJumlahKaryawan();
        if ($cek_limit !== true) {
            return $cek_limit;
        }

        # MEMINDAHKAN DATA DARI TEMP KE DATA KARYAWAN
        if (count($data_insert) > 0) {
            $this->db->insert_batch('data_karyawan', $data_insert);
        }

        if (count($data_insert_user) > 0) {
            $this->db->insert_batch('users', $data_insert_user);
        }

        # INSERT KEPALA CABANG
        if (count($data_insert_kacab) > 0) {
            $this->db->insert_batch('p_kacab', $data_insert_kacab);
        }

        # INSERT KEPALA DEPARTEMEN
        if (count($data_insert_kedep) > 0) {
            $this->db->insert_batch('p_kedep', $data_insert_kedep);
        }

        if ($paket_payroll == '1') {
            if (count($data_gapok) > 0) {
                $this->db->insert_batch('payroll_gapok_m', $data_gapok);
            }

            if (count($data_gapok_log) > 0) {
                $this->db->insert_batch('payroll_gapok_log', $data_gapok_log);
            }

            if (count($data_tunj_kehadiran) > 0) {
                $this->db->insert_batch('payroll_tunj_kehadiran_m', $data_tunj_kehadiran);
            }

            if (count($data_tunj_tetap) > 0) {
                $this->db->insert_batch('payroll_tunj_tetap_m', $data_tunj_tetap);
            }

            if (count($data_pot_tetap) > 0) {
                $this->db->insert_batch('payroll_pot_tetap_m', $data_pot_tetap);
            }
        }

        # DELETE DATA TEMP YANG SUDAH DI PINDAH
        $this->db->where("flag", "1");
        $this->db->where("id_company", $this->id_company);
        $this->db->delete("data_karyawan_temp");

        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $message = ["message" => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('failed_save') . '</font>'];
            return __response_save(false, $message);
        } else {
            $this->db->trans_commit();
            $message = ["message" => '<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>' . $jml_berahasil_simpan . ' ' . $this->lang->line('success_save') . ' ' . $this->lang->line('dan') . ' ' . $jml_gagal_simpan . ' ' . $this->lang->line('failed_save') . '</font>'];
            return __response_save(true, $message);
        }
    }

    public function delete_all_temp()
    {
        $this->db->where("id_company", $this->id_company);
        $this->db->where("user_input", $this->id_karyawan);
        $delete = $this->db->delete("data_karyawan_temp");
        return __response_delete($delete);
    }

    public function delete()
    {
        $id = $this->input->post("id_temp");
        $this->db->where('MD5(id_temp)', $id);
        $this->db->where('id_company', $this->id_company);
        $delete = $this->db->delete('data_karyawan_temp');
        return  __response_delete($delete);
    }

    public function form_edit($id = null)
    {
        $data['judul']   = 'Ubah Karyawan Import';
        $data['aktif']   = 'karyawan';
        $data['data']    = $this->Karyawan_import_m->getDataById($id);
        $data['ref']     = $id;
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('karyawan/import/form', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function save()
    {
        $id_company        = $this->id_company;
        $id_temp           = $this->input->post('id_temp');
        $no_induk_karyawan = $this->input->post('no_induk_karyawan');
        $id_karyawan       = $this->id_company . preg_replace('/[^A-Za-z0-9\-]/', '', $no_induk_karyawan);
        $level_user        = $this->input->post('level_user');
        // $password_baru = $this->input->post('password_baru');

        // if($password_baru != "") {
        // 	$encrypt_password = sha1(sha1(md5($password_baru)));
        // }

        $data_pribadi = array(
            'id_karyawan'          => $id_karyawan,
            'nik'                  => $no_induk_karyawan,
            'nama_lengkap'         => $this->input->post('nama_lengkap'),
            'gelar_depan'          => $this->input->post('gelar_depan'),
            'gelar_belakang'       => $this->input->post('gelar_belakang'),
            'jenis_kelamin'        => $this->input->post('jenis_kelamin'),
            'agama'                => $this->input->post('agama'),
            'tempat_lahir'         => $this->input->post('tempat_lahir'),
            'tgl_lahir'            => date('Y-m-d', strtotime($this->input->post('tgl_lahir'))),
            'alamat_domisili'      => $this->input->post('alamat_domisili'),
            'telepon'              => $this->input->post('telepon'),
            'email'                => $this->input->post('email'),
            'no_ktp'               => $this->input->post('no_ktp'),
            'tgl_aktif_bekerja'    => date('Y-m-d', strtotime($this->input->post('tgl_aktif_bekerja'))),
            'tgl_berhenti_bekerja' => date('Y-m-d', strtotime($this->input->post('tgl_berhenti_bekerja'))),
            'join_date'            => date('Y-m-d', strtotime($this->input->post('join_date'))),
            'id_departemen'        => (($this->input->post('departemen') == "null") ? "" : $this->input->post('departemen')),
            'id_cabang'            => $this->input->post('cabang'),
            'id_jabatan'           => $this->input->post('jabatan'),
            'jatah_cuti'           => $this->input->post('jatah_cuti'),
            'status'               => $this->input->post('status'),
            'username'             => $this->input->post('username'),
            // 'password'             => $encrypt_password,
            'flag'                 => '1',
            'id_company'           => $this->id_company
        );

        // print_r($data_pribadi);
        // exit;

        $this->Karyawan_import_m->save($data_pribadi, $id_temp, $level_user);
    }

    private function _cekLimitJumlahKaryawan()
    {
        $max_karyawan = $this->db->select("SUM(master_company.custom_jumlah_karyawan + tb_paket.max_karyawan) AS max_jml_karyawan")
            ->from("master_company")
            ->join("tb_paket", "tb_paket.id_tb_paket = master_company.id_tb_paket")
            ->where("master_company.id_company", $this->id_company)
            ->get()
            ->row("max_jml_karyawan");

        $jumlah_karyawan_aktif = $this->db->select("data_karyawan.id_karyawan")
            ->from("data_karyawan")
            ->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan")
            ->where_in("data_karyawan.status", ["1", "2", "3", "4"])
            ->where_not_in("master_jabatan.level_user", ["1", "6"])
            ->where("data_karyawan.id_company", $this->id_company)
            ->get()
            ->num_rows();

        $jml_row = $this->db->where('id_company', $this->id_company)
            ->where('flag', 1)
            ->get('data_karyawan_temp')->num_rows();

        $total = $jumlah_karyawan_aktif + $jml_row;

        if ($total > $max_karyawan) {
            $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_limit_karyawan') . '</font>'];
            return __response_save(false, $message);
        } else {
            return true;
        }
    }
}
