<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color"><?= $judul ?></h5>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <button type="button" class="btn btn_tambah btn-success pull-right" onclick="tambah(this)">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
        </button>
    </div>
</div>
<hr>

<div class="table-responsive">
    <table id="list_data" class="table table-striped" style="width:100%">
        <thead>
            <tr>
                <th class="text-center">NO</th>
                <th class="text-left"><?= strtoupper($this->lang->line('nama_karyawan')); ?></th>
                <th class="text-left"><?= strtoupper($this->lang->line('adm_cabang')); ?></th>

                <?php
                    if(in_array($this->session->userdata('level_user'), array("1"))) {
                ?>
                        <th class="text-center"><?= $this->lang->line('aksi'); ?></th>
                <?php
                    }
                ?>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    'language'    :{
                                    <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                                        'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                                        'searchPlaceholder': 'NIK/Nama Karyawan'
                                    <?php else : ?> 'searchPlaceholder': 'ID/Employee Name'
                                    <?php endif; ?>
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                        "url": "<?= route('pengaturan.admin.reimburse.data') ?>",
                                        "type": "GET",
                                        "data"  : function (d) {
                                            delete d.columns;
                                        },
                                    },

                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false }

                                        <?php
                                            if (in_array($this->level_user, array("1"))) {
                                        ?>
                                                ,{ "aTargets": [2,3], "bSortable": false }
                                        <?php }?>
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(0)', nRow).css({'width':'10px'});

                            <?php
                                if (in_array($this->session->userdata('level_user'), array("1"))) {
                            ?>

                            $('td:eq(3)', nRow).css({'text-align':'center'});
                            $('td:eq(3)', nRow).css({'width':'100px'});

                            <?php }?>
                    }

        });
    });

    // START CRUD
    function tambah(e){
        $('#tampil_form').load("<?= route('pengaturan.admin.reimburse.form.tambah') ?>",function(){
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function edit(e){
        $('#tampil_form').load("<?= route('pengaturan.admin.reimburse.form.edit') ?>"+"/"+ $(e).attr('id'), function(){
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
            $(".btn_save").addClass("btn_save btn btn-warning");
            $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_perbarui') ?>');
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function hapus_form(e){
        $('#tampil_form').load("<?php echo route('pengaturan.admin.reimburse.form.hapus') ?>"+ "/" + $(e).attr('id'), function(){
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
            $('#form_input input[type=text]').prop("disabled",true);
            $("#jenis").prop("disabled", true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            $('.btn_hapus').attr('onClick','hapus_action(this)');
        });
    }

    function new_input(e){
        $("#form_input #id_karyawan").prop("disabled", false);
        $('#form_input #id_karyawan').val('').trigger('change');

        $("#form_input #id_cabang").prop("disabled", false);
        $('#form_input #id_cabang').val('').trigger('change');

        $('.btn_save').show();
        $('#btn_new_input').hide();
        $('#message').hide();
    }

    function simpan(e){
        // e.preventDefault();
        $('#message').html("");
        var loading = Ladda.create(e);

        if(!$("#id_karyawan").val()){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_karyawan') ?></font>");
            $("#id_karyawan").focus();
            return false;
        }

        loading.start();

        var param = 'id='+$("#id").val()+
                    '&id_karyawan='+$("#id_karyawan").val()+
                    '&id_cabang='+$("#id_cabang").val();
                    /*'&jenis='+$("#jenis").val();*/

        $.ajax({
            type: 'POST',
            url: "<?= route('pengaturan.admin.reimburse.save') ?>",
            data: param,
            dataType:'JSON',
            success: function(result) {
                if(result.success == true){
                    if(result.type == 'save'){
                        $("#form_input #id_karyawan").prop("disabled", true);
                        $("#form_input #id_cabang").prop("disabled", true);
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }
                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error:function(){
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }

    function hapus_action(e){
        var loading = Ladda.create(e);
        loading.start();
        var param = {};
        param.id=$("#id").val();
        $.ajax({
            type: 'POST',
            url: "<?php echo route('pengaturan.admin.reimburse.delete') ?>",
            data: param,
            dataType:'JSON',
            success: function(result){
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html(result.message);

            },
            error:function(){
                loading.stop();
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }
    // END CRUD
</script>