<script type="text/javascript">
    $(function() {
        $("#form_hitung #bulan").inputmask({
            'alias': 'datetime',
            'inputFormat': 'mm-yyyy'
        });
        $("#form_hitung #periode_mulai, #periode_selesai, #tgl_pemotong").inputmask({
            'alias': 'datetime',
            'inputFormat': 'dd-mm-yyyy'
        });

        $("#form_hitung #periode_mulai, #periode_selesai").datepicker({
            format: "dd-mm-yyyy",
            orientation: "bottom",
            todayHighlight: false,
            autoclose: true,
            endDate: new Date(new Date().setDate(new Date().getDate() - 1))
        });

        $("#form_hitung #tgl_pemotong").datepicker({
            format: "dd-mm-yyyy",
            orientation: "top",
            todayHighlight: true,
            autoclose: true
        });

        $("#form_hitung #bulan").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true,
            endDate: "today"
        });

        $("#form_hitung #id_cabang").select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            dropdownParent: $("#form_hitung"),
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });


        $("#form_hitung #id_departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            dropdownParent: $("#form_hitung"),
            ajax: {
                url: '<?= route("dropdown.departemen") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });

        $("#form_hitung #id_karyawan").select2({
            placeholder: "Semua Karyawan",
            allowClear: true,
            dropdownParent: $("#form_hitung"),
            ajax: {
                url: '<?= route("dropdown.karyawan.encrypt") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_hitung" class="card-body" disabled>
    <div class="form-group">
        <label>Gaji untuk bulan <span class="text-danger">*</span></label>
        <input type="text" id="bulan" class="form-control" autocomplete="off" placeholder="mm-yyyy" spellcheck="false">
    </div>

    <div class="row mt-2 mb-2">
        <div class="col-md-6">
            <label>Periode Mulai <span class="text-danger">*</span></label>
            <input type="text" id="periode_mulai" class="form-control" autocomplete="off" placeholder="dd-mm-yyyy" spellcheck="false">
        </div>
        <div class="col-md-6">
            <label>Periode Selesai <span class="text-danger">*</span></label>
            <input type="text" id="periode_selesai" class="form-control" autocomplete="off" placeholder="dd-mm-yyyy" spellcheck="false">
        </div>
    </div>

    <div class="form-group">
        <label>Cabang</label>
        <select id="id_cabang" class="form-control" style="width: 100%;">
        </select>
    </div>

    <div class="form-group">
        <label>Departemen</label>
        <select id="id_departemen" class="form-control" style="width: 100%;">
        </select>
    </div>

    <div class="form-group">
        <label>Karyawan</label>
        <select id="id_karyawan" class="form-control" style="width: 100%;">
        </select>
    </div>

    <?php if ($pengaturan_pph->aktif === '1') : ?>
        <div class="form-group mt-3">
            <h6 class="font-weight-bold" style="color: #1c77d4;">PPH21</h6>
            <hr>
            <label>Tanggal Pemotongan <i class="text-danger">*</i></label>
            <input type="text" name="tgl_pemotong" id="tgl_pemotong" class="form-control" autocomplete="off" placeholder="dd-mm-yyyy" spellcheck="false">
        </div>
    <?php endif; ?>
</div>
<div class="card-footer">
    <div class="w-100">
        <div id="progressbar" class="progress" style="height: 10px; display:none">
            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%"></div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right align-self-end">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_proses_hitung ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
